//----------------------------------------------------------------
//------------------    TAC Client Utility   ---------------------
//----------------------------------------------------------------
//
//	Please do not edit anything in this file.
//
//  The writers of this script take no responsibility for its use.
//
//
//----------------------------------------------------------------


exec("Tac\\TACPrefs.cs");
Include("presto\\Event.cs");
Include("presto\\HUD.cs");
Include("presto\\Install.cs");

Event::Attach(eventConnectionAccepted, "TACClient::Reset();");

function TACClient::Reset()
{
	$TACClient::APCObjectId = "none";
	remoteEval (2048, IsTAC, getManagerId(), $TACClient::PassengerHUD, $TACClient::PilotHUD);
}


function remoteRunTACClient()
{
	//if($TAC::Compliant)
		TACMainScript();
}


function TACMainScript()
{
	if($TACClient::TACChat)
		include("Tac\\TACChat.cs");


	if($TACClient::PilotViews)
	{
		Presto::EnableKey(PilotLeftView, play, "remoteEval (2048, LeftPilotView, getManagerId());","remoteEval (2048, PilotView, getManagerId());");
		Presto::EnableKey(PilotRearView, play, "remoteEval (2048, RearPilotView, getManagerId());","remoteEval (2048, PilotView, getManagerId());");
		Presto::EnableKey(PilotRightView, play, "remoteEval (2048, RightPilotView, getManagerId());","remoteEval (2048, PilotView, getManagerId());");
	}
}



function remoteUpdateHUDData(%clientId, %pilotname, %pass1name, %pass2name, %pass3name, %pass4name)
{
	//all Ids passed in for pilot and passengers are the players names
	$pilotname = %pilotname;
	$pass1name = %pass1name;
	$pass2name = %pass2name;
	$pass3name = %pass3name;
	$pass4name = %pass4name;

	HUD::Display(hudTACList, false);
	HUD::New(hudTACList, TACClient::UpdateListHUD, "100% 15% 140 120");
	HUD::Display(hudTACList);
}



function remotePilotHUD(%clientId, %vehicleId)
{
	//set apc name for apc chat menu
	$TACClient::APCObjectId = %vehicleId;

	//change to pilot HUD
	HUD::New(hudTACList, TACClient::UpdateListHUD, "100% 15% 140 120");
	HUD::Display(hudTACList);
}

function remotePassengerHUD(%clientId, %vehicleId)
{
	//set apc name for apc chat menu
	$TACClient::APCObjectId = %vehicleId;

	//change to passenger HUD
	HUD::New(hudTACList, TACClient::UpdateListHUD, "100% 15% 140 120");
	HUD::Display(hudTACList);
	HUD::New(hudTACAPCHealth, TACClient::UpdateAPCHealthHUD, "100% bottom(hudTACList) width(hudTACList) 30");
	HUD::Display(hudTACAPCHealth);
}

function remoteStandardHUD()
{
	//set apc name for apc chat menu
	$TACClient::APCObjectId = "none";

	//change to standard HUD
	HUD::Display(hudTACList, false);
	HUD::Display(hudTACAPCHealth, false);
}


function remoteDamageHUD(%clientId, %health)
{
	//health is imported as a percentage where 100 is 100% healthy
	$APCHealth = %health;
	HUD::Display(hudTACAPCHealth, false);
	HUD::New(hudTACAPCHealth, TACClient::UpdateAPCHealthHUD, "100% bottom(hudTACList) width(hudTACList) 30");
	HUD::Display(hudTACAPCHealth);
}

function TACClient::ResetHUD()
{
	//set apc name for apc chat menu
	$TACClient::APCObjectId = "none";

	//change to standard HUD
	HUD::Display(hudTACList, false);
	HUD::Display(hudTACAPCHealth, false);
}


//---------------------------------------------------------------------------------
//  APC Specific Chat Code

function Say::APC(%name, %msg)
{
	if (%msg == "")
		%msg = Say::GetText(%name);
	remoteEval(2048, say, "APC " @ $TACClient::APCObjectId, %msg @ "~w" @ Say::GetWav(%name) );
}


function Menu::AddAPCChat(%menu, %letter, %say, %text)
{
	if (%text != "")
		Menu::AddLetter(%menu, %letter, %text, "Say::APC("@%say@",\""@%text@"\");");
	else
		Menu::AddLetter(%menu, %letter, Say::GetText(%say), "Say::APC("@%say@");");
}

//---------------------------------------------------------------------------------
//  TAC Client HUDs

function TACClient::UpdateListHUD()
{
	HUD::AddTextLine(hudTACList, "Pilot:");
	HUD::AddTextLine(hudTACList, "  <f1>" @ $pilotname);
	HUD::AddTextLine(hudTACList);
	HUD::AddTextLine(hudTACList, "<f0>Passengers:");
	if($pass1name != "")
		HUD::AddTextLine(hudTACList, "  <f1>" @ $pass1name);
	if($pass2name != "")
		HUD::AddTextLine(hudTACList, "  <f1>" @ $pass2name);
	if($pass3name != "")
		HUD::AddTextLine(hudTACList, "  <f1>" @ $pass3name);
	if($pass4name != "")
		HUD::AddTextLine(hudTACList, "  <f1>" @ $pass4name);
}


function TACClient::UpdateAPCHealthHUD()
{
	HUD::AddTextLine(hudTACAPCHealth, "<jc>APC Health");
	HUD::AddTextLine(hudTACAPCHealth, "<jc><f2>" @ $APCHealth @"%");
}

