//=============================================================================================================================
// Server Parameters
$Server::HostName = "Nappy Server";	// Server Name
$Server::Port = "28001";			// Port used for client connections to server (usually 28001)
$Server::HostPublicGame = true;			// Server is shown in MasterServer List
$Server::Password = "";				// Password needed to join server
$AdminPassword = "nappyx";			// Local SuperAdmin password - CHANGE THIS
$Console::LogMode = "1"; 			// This will output everything from the console window to console.log


//=============================================================================================================================
// Server Info Parameters (<jc> = center justified, <f1> = tan font, <f2> = white font, <f3> = orange font, \n = new line)

// Server information listed on MasterServer List
$Server::Info = "Nappy \nAdmin: Admin\nEmail: admin@email.com\n<f1>\n\n";

// Information listed on server join screen					
$Server::MODInfo = "<jc><f1>\n<f2><jc>";

// Message of the day listed once connected to the server					
$Server::JoinMOTD = "<jc><f1>This is a Nappy Server\nVisit\nwww.nappybase.com\nfor Nappy Updates, Maps, Skins and much more.\n<f1>Rules:\n1. Have Fun!\n2. Respect Server Admins.\n<f2>And finally,\n<f1>Spank your mouse to start playing!<f3><jc>";


//=============================================================================================================================
// Telnet (Console) Parameters
// Server Administrators ie: TriCon, EZConsole, EZServer
// Available @ www.nappybase.com or original site
$TelnetPort="1234";				// Port for telnet connections
$TelnetPassword="password";			// Password for telnet connections


//=============================================================================================================================
// Server Connection Parameters
// PacketRate: 56K = 12, DSL/Cable = 13, T1 or higher = 15
// PacketSize: 56K = 200, DSL/Cable = 350, T1 or higher = 400
// Configure to your connection speed
$pref::PacketRate = 12;				// Packet rate for client connections
$pref::PacketSize = 200;			// Packet size for client connections
$pref::LastMission = "Broadside";		// This sets the first map in rotate when server launches (make sure it is spelled correctly)


//=============================================================================================================================
// Player Parameters
$Server::MaxPlayers = "10";			// Maximum number of client connections allowed
$Server::AutoAssignTeams = true;		// Server assigned teams
$Server::respawnTime = 1; 			// Number of seconds before a respawn is allowed
$Server::TimeLimit = 30;			// Mission time limit in minutes
$Server::warmupTime = 5;			// Time (in seconds) players are left standing before movement is allowed

//=============================================================================================================================
// Team Parameters
$Server::teamName[0] = "Team One";		// Team 1 Name
$Server::teamSkin[0] = "beagle";		// Team 1 Skin
$Server::teamName[1] = "Team Two";		// Team 2 Name
$Server::teamSkin[1] = "dsword";		// Team 2 Skin
$Server::teamName[2] = "Team Three";		// Team 3 Name
$Server::teamSkin[2] = "cphoenix";		// Team 3 Skin
$Server::teamName[3] = "Team Four";		// Team 4 Name
$Server::teamSkin[3] = "swolf";			// Team 4 Skin
$Server::teamName[4] = "Team Five";		// Team 5 Name
$Server::teamSkin[4] = "base";			// Team 5 Skin
$Server::teamName[5] = "Team Six";		// Team 6 Name
$Server::teamSkin[5] = "base";			// Team 6 Skin
$Server::teamName[6] = "Team Seven";		// Team 7 Name
$Server::teamSkin[6] = "base";			// Team 7 Skin
$Server::teamName[7] = "Team Eight";		// Team 8 Name
$Server::teamSkin[7] = "base";			// Team 8 Skin


//=============================================================================================================================
// Voting Parameters
$Server::MinVoteTime = 45;			// Time allotted for voting
$Server::VotingTime = 20;			// Length of votes if people are voting.
$Server::VoteWinMargin = 0.6999;		// Ratio of Yes to No votes needed to pass
$Server::VoteAdminWinMargin = 0.6999;		// Ratio of Yes to No votes needed to pass
$Server::MinVotes = 1;				// Minimum number of votes needed to pass
$Server::MinVotesPct = 0.5;			// Percentage of available votes needed to pass a vote
$Server::VoteFailTime = 30; 			// 30 seconds if your vote fails + $Server::MinVoteTime


//==============================================================================================================================
// Other Parameters
$Server::TeamDamageScale = 0;			// Team damage, 0 = Off, 1 = On
$Server::TourneyMode = false;			// Tournament mode