//================================================================
// Shredder
//================================================================

SoundData SoundFireShredder
{
   wavFileName = "mortar_fire.wav";
   profile = Profile3dNear;
};

SoundData SoundShredderReload
{
   wavFileName = "mortar_reload.wav";
   profile = Profile3dNearLoop;
};

SoundData ExplosionShredder
{
   wavFileName = "ricoche1.wav";
   profile     = Profile3dNear;
};

//================================================================

ExplosionData ShredderExp
{
   shapeName = "chainspk.dts";
   soundId   = ExplosionShredder;

   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 0.0;

   timeScale = 1.5;

   timeZero = 0.250;
   timeOne  = 0.850;

   colors[0]  = { 0.4, 0.4,  1.0 };
   colors[1]  = { 1.0, 1.0,  1.0 };
   colors[2]  = { 1.0, 0.95, 1.0 };
   radFactors = { 0.5, 1.0, 1.0 };
};

//================================================================

BulletData ProjShredder
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = ShredderExp;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.33;
   damageType         = $ShredderDamageType;

   aimDeflection      = 0.005;
   muzzleVelocity     = 1000.0;
   totalTime          = 1.5;
   inheritedVelocityScale = 1.0;
   isVisible          = false;

   tracerPercentage   = 2.0;
   tracerLength       = 50;
};


RocketData ProjShredder2
{
   bulletShapeName = "bullet.dts";
   explosionTag    = ShredderExp;

   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $ShredderDamageType;

   explosionRadius  = 1.0;
   kickBackStrength = 0.0;


   aimDeflection      = 0.1;
   muzzleVelocity   = 65.0;
   terminalVelocity = 80.0;
   acceleration     = 5.0;

   totalTime        = 6.5;
   liveTime         = 8.0;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   // rocket specific
   //trailType   = 1;
   //trailLength = 15;
   //trailWidth  = 0.3;

};
//================================================================
ItemData ShredderAmmo
{
	description = "Shredder Ammo";
   	heading = "xAmmunition";
	className = "Ammo";
	shapeFile = "plasammo";
	shadowDetailMask = 4;
	price = 0;
};


ItemImageData ChaingunImage
{
	shapeFile = "shotgun";
   	mountPoint = 0;


    	weaponType = 0; // Single Shot
   	ammoType = ShredderAmmo;
  	projectileType = undefinedproj;
   	accuFire = false;
   	reloadTime = 0.05;
   	fireTime = 0.25;
                        
   	lightType = 3;  // Weapon Fire
   	lightRadius = 2;
   	lightTime = 1;
   	lightColor = { 0.25, 0.25, 0.85 };

   	sfxActivate = SoundPickUpWeapon;
   	sfxFire     = SoundfireShredder;
	sfxReload = SoundShredderReload;
};

ItemData Chaingun
{
   	description = "Shredder";
	shapeFile = "shotgun";
	hudIcon = "Chain";
   	className = "Weapon";
   	heading = "bWeapons";
   	shadowDetailMask = 4;
	imageType = ChaingunImage;
	price = 0;
	showWeaponBar = true;
	showInventory = true;
  	//validateShape = true;
	//validateMaterials = true;
};

function ChaingunImage::onFire(%player, %slot) { %AmmoCount = Player::getItemCount(%player, $WeaponAmmo[Chaingun]);
 	if(%AmmoCount) { Player::decItemCount(%player,$WeaponAmmo[Chaingun],1);
 	%trans = GameBase::getMuzzleTransform(%player);
	%vel = Item::getVelocity(%player);
		Projectile::spawnProjectile("ProjShredder",%trans,%player,%vel);
		Projectile::spawnProjectile("ProjShredder",%trans,%player,%vel);
		Projectile::spawnProjectile("ProjShredder",%trans,%player,%vel);
		Projectile::spawnProjectile("ProjShredder",%trans,%player,%vel);
		Projectile::spawnProjectile("ProjShredder",%trans,%player,%vel);
 		Projectile::spawnProjectile("ProjShredder",%trans,%player,%vel);
 	}
	else Client::sendMessage(Player::getClient(%player), 0,"You Ran Out Of Ammo for the shredder"); 
	}




//=================================================================
echo("Item Loaded");