//----------------------------------------------------------------------------

//----------------------------------------------------------------------------

//----------------------------------------------------------------------------

// List of all items available to buy from inventory station
//Old INV List With fixed availabilities
$InvList[Blaster] = 0;
$InvList[Chaingun] = 0;
$InvList[Disclauncher] = 0;
$InvList[GrenadeLauncher] = 0;
$InvList[Mortar] = 0;
$InvList[PlasmaGun] = 0;
$InvList[LaserRifle] = 0;
$InvList[EnergyRifle] = 0;
$InvList[TargetingLaser] = 0;
$InvList[MineAmmo] = 0;
$InvList[Grenade] = 0;
$InvList[Beacon] = 1;

$InvList[BulletAmmo] = 0;
$InvList[PlasmaAmmo] = 0;
$InvList[DiscAmmo] = 0;
$InvList[GrenadeAmmo] = 0;
$InvList[MortarAmmo] = 0;
  
$InvList[EnergyPack] = 0;
$InvList[RepairPack] = 1;
$InvList[ShieldPack] = 1;
$InvList[SensorJammerPack] = 1;
$InvList[MotionSensorPack] = 1;
$InvList[PulseSensorPack] = 1;
$InvList[DeployableSensorJammerPack] = 1;
$InvList[CameraPack] = 1;
$InvList[TurretPack] = 0;
$InvList[AmmoPack] = 1;
$InvList[RepairKit] = 1;
$InvList[DeployableInvPack] = 1;
$InvList[DeployableAmmoPack] = 1;

//New INV List

//Weapons
$InvList[Knife] = 1;
$InvList[Knife2] = 1;
$InvList[SlipTip] = 1;
$InvList[Crysknife] = 1;
$InvList[Kindjal] = 1;
$InvList[Rapier] = 0;
$InvList[Saber] = 1;

$InvList[Pistol] = 1;
$InvList[Maula] = 1;
$InvList[Stunner] = 1;
$InvList[Rifle] = 1;
$InvList[SniperRifle] = 1;
$InvList[MGun] = 1;
$InvList[RLauncher] = 1;
$InvList[Flamethrower] = 1;
$InvList[Piller] = 1;

$InvList[Cutteray] = 1;
$InvList[SmallLas] = 1;
$InvList[RifleLas] = 1;
$InvList[HeavyLas] = 1;

$InvList[MountedArtillaryGun] = 0;
$InvList[MountedMachineGun] = 0;
$InvList[MechMachine1Gun] = 0;
$InvList[MechMachine2Gun] = 0;
$InvList[MechMachine3Gun] = 0;
$InvList[MechMachine4Gun] = 0;

//Clips
$InvList[PistolClip] = 1;
$InvList[MaulaClip] = 1;
$InvList[StunnerClip] = 1;
$InvList[RifleClip] = 1;
$InvList[MGunClip] = 1;
$InvList[SniperClip] = 1;
$InvList[CutterayCell] = 1;
$InvList[SmallLasCell] = 1;
$InvList[RifleLasCell] = 1;
$InvList[HeavyLasCell] = 1;
$InvList[RLauncherClip] = 1;

//Ammo
$InvList[PistolAmmo] = 0;
$InvList[MaulaAmmo] = 0;
$InvList[StunnerAmmo] = 0;
$InvList[RifleAmmo] = 0;
$InvList[MGunAmmo] = 0;
$InvList[SniperAmmo] = 0;
$InvList[RLauncherAmmo] = 0;
$InvList[FlamethrowerAmmo] = 1;
$InvList[PillerAmmo] = 0; // pillers use flamethrower ammo now
$InvList[CutterayAmmo] = 0;
$InvList[SmallLasAmmo] = 0;
$InvList[RifleLasAmmo] = 0;
$InvList[HeavyLasAmmo] = 0;

//Packs
$InvList[ExplosivePack] = 1;
$InvList[SuicidePack] = 1;
$InvList[FuelPack] = 1;
$InvList[SuspensorPack] = 1; 
$InvList[CamoPack] = 1; 
$InvList[GrapplePack] = 1; 

$InvList[PlasteelPack] = 1;
$InvList[SPentashieldPack] = 1;
$InvList[LPentashieldPack] = 1;
$InvList[HieregPack] = 1;
$InvList[ThumperPack] = 1; 
$InvList[DeployableGenPack] = 1;
$InvList[StationaryLasgunPack] = 1;
$InvList[RepeaterLasgunPack] = 1;
$InvList[RemoteLasgunPack] = 1;
$InvList[RemoteProjectileGunPack] = 1;
$InvList[HunterSeekerPlatformPack] = 1;
$InvList[StoneBurnerPack] = 1;
$InvList[SNukePack] = 1;
$InvList[MNukePack] = 1;
$InvList[LNukePack] = 1;
$InvList[GholaPack] = 1;
$InvList[MechGunPack] = 1; 
$InvList[MechArtillaryPack] = 1; 
$InvList[MechRocketPack] = 1; 
$InvList[MechFlamePack] = 1; 

//----------------------------------------------------------------------------

// List of all items available to buy from Remote Station
//Old list
$RemoteInvList[Blaster] = 0;
$RemoteInvList[Chaingun] = 0;
$RemoteInvList[Disclauncher] = 0;
$RemoteInvList[GrenadeLauncher] = 0;
$RemoteInvList[Mortar] = 0;
$RemoteInvList[PlasmaGun] = 0;
$RemoteInvList[LaserRifle] = 0;
$RemoteInvList[EnergyRifle] = 0;
$RemoteInvList[TargetingLaser] = 0;
$RemoteInvList[MineAmmo] = 0;
$RemoteInvList[Grenade] = 0;
$RemoteInvList[Beacon] = 0;

$RemoteInvList[BulletAmmo] = 0;
$RemoteInvList[PlasmaAmmo] = 0;
$RemoteInvList[DiscAmmo] = 0;
$RemoteInvList[GrenadeAmmo] = 0;
$RemoteInvList[MortarAmmo] = 0;
  
$RemoteInvList[EnergyPack] = 0;
$RemoteInvList[RepairPack] = 1;
$RemoteInvList[ShieldPack] = 1;
$RemoteInvList[SensorJammerPack] = 1;
$RemoteInvList[MotionSensorPack] = 1;
$RemoteInvList[PulseSensorPack] = 1;
$RemoteInvList[DeployableSensorJammerPack] = 1;
$RemoteInvList[CameraPack] = 1;
$RemoteInvList[TurretPack] = 0;
$RemoteInvList[AmmoPack] = 1;
$RemoteInvList[RepairKit] = 1;

//New list

//Weapons
$RemoteInvList[Knife] = 1;
$RemoteInvList[Knife2] = 1;
$RemoteInvList[SlipTip] = 1;
$RemoteInvList[Crysknife] = 1;
$RemoteInvList[Kindjal] = 1;
$RemoteInvList[Rapier] = 0;
$RemoteInvList[Saber] = 1;

$RemoteInvList[Pistol] = 1;
$RemoteInvList[Maula] = 1;
$RemoteInvList[Stunner] = 1;
$RemoteInvList[Rifle] = 1;
$RemoteInvList[MGun] = 1;
$RemoteInvList[SniperRifle] = 1;
$RemoteInvList[RLauncher] = 1;
$RemoteInvList[Flamethrower] = 1;

$RemoteInvList[Cutteray] = 1;
$RemoteInvList[SmallLas] = 1;
$RemoteInvList[RifleLas] = 1;

$RemoteInvList[MountedArtillaryGun] = 0;
$RemoteInvList[MountedMachineGun] = 0;

$RemoteInvList[MechMachine1Gun] = 0;
$RemoteInvList[MechMachine2Gun] = 0;
$RemoteInvList[MechMachine3Gun] = 0;
$RemoteInvList[MechMachine4Gun] = 0;

//Clips
$RemoteInvList[PistolClip] = 1;
$RemoteInvList[MaulaClip] = 1;
$RemoteInvList[StunnerClip] = 1;
$RemoteInvList[RifleClip] = 1;
$RemoteInvList[MGunClip] = 1;
$RemoteInvList[SniperClip] = 1;
$RemoteInvList[CutterayCell] = 1;
$RemoteInvList[SmallLasCell] = 1;
$RemoteInvList[RifleLasCell] = 1;
$RemoteInvList[HeavyLasCell] = 1;
$RemoteInvList[RLauncherClip] = 1;

//Ammo
$RemoteInvList[PistolAmmo] = 0;
$RemoteInvList[MaulaAmmo] = 0;
$RemoteInvList[StunnerAmmo] = 0;
$RemoteInvList[RifleAmmo] = 0;
$RemoteInvList[MGunAmmo] = 0;
$RemoteInvList[SniperAmmo] = 0;
$RemoteInvList[RLauncherAmmo] = 0;
$RemoteInvList[FlamethrowerAmmo] = 1;
$RemoteInvList[PillerAmmo] = 0; // Pillers use flamethrower ammo now
$RemoteInvList[CutterayAmmo] = 0;
$RemoteInvList[SmallLasAmmo] = 0;
$RemoteInvList[RifleLasAmmo] = 0;
$RemoteInvList[HeavyLasAmmo] = 0;

//Packs
$RemoteInvList[ExplosivePack] = 1;
$RemoteInvList[SuicidePack] = 1;
$RemoteInvList[FuelPack] = 1;
$RemoteInvList[SuspensorPack] = 1;
$RemoteInvList[CamoPack] = 1;
$RemoteInvList[GrapplePack] = 1;
$RemoteInvList[PlasteelPack] = 1;
$RemoteInvList[SPentashieldPack] = 1;
$RemoteInvList[LPentashieldPack] = 1;
$RemoteInvList[StationaryLasgunPack] = 1;
$RemoteInvList[RepeaterLasgunPack] = 1;
$RemoteInvList[RemoteLasgunPack] = 1;
$RemoteInvList[RemoteProjectileGunPack] = 1;
$RemoteInvList[ThumperPack] = 1; 

//----------------------------------------------------------------------------

// List of all items available to buy from Vehicle station
$VehicleInvList[ScoutVehicle] = 0;
$VehicleInvList[LAPCVehicle] = 0;
$VehicleInvList[HAPCVehicle] = 0;

$VehicleInvList[BasicThopterVehicle] = 0;
$VehicleInvList[VulcanThopterVehicle] = 0;
$VehicleInvList[LasgunThopterVehicle] = 0;
$VehicleInvList[ArtillaryThopterVehicle] = 0;
$VehicleInvList[CarryallVehicle] = 0;
$VehicleInvList[RollerVehicle] = 0;
$VehicleInvList[TrackerVehicle] = 0;
$VehicleInvList[CrawlerVehicle] = 0;

//New vehicle lists
$OrnithopterInvList[BasicThopterVehicle] = 1;
$OrnithopterInvList[VulcanThopterVehicle] = 1;
$OrnithopterInvList[LasgunThopterVehicle] = 1;
$OrnithopterInvList[ArtillaryThopterVehicle] = 1;
$OrnithopterInvList[CarryallVehicle] = 1;

$GroundCarInvList[RollerVehicle] = 1;
$GroundCarInvList[TrackerVehicle] = 1;
$GroundCarInvList[CrawlerVehicle] = 1;
//----------------------------------------------------------------------------

//Old
$DataBlockName[ScoutVehicle] = Scout;
$DataBlockName[LAPCVehicle] = LAPC;
$DataBlockName[HAPCVehicle] = HAPC;

//New
$DataBlockName[BasicThopterVehicle] = BasicThopter;
$DataBlockName[VulcanThopterVehicle] = VulcanThopter;
$DataBlockName[LasgunThopterVehicle] = LasgunThopter;
$DataBlockName[ArtillaryThopterVehicle] = ArtillaryThopter;
$DataBlockName[CarryallVehicle] = Carryall;

$DataBlockName[RollerVehicle] = Roller;
$DataBlockName[TrackerVehicle] = Tracker;
$DataBlockName[CrawlerVehicle] = Crawler;

//Old
$VehicleToItem[Scout] = ScoutVehicle;
$VehicleToItem[LAPC] = LAPCVehicle;
$VehicleToItem[HAPC] = HAPCVehicle;

//New
$VehicleToItem[BasicThopter] = BasicThopterVehicle;
$VehicleToItem[VulcanThopter] = VulcanThopterVehicle;
$VehicleToItem[LasgunThopter] = LasgunThopterVehicle;
$VehicleToItem[ArtillaryThopter] = ArtillaryThopterVehicle;
$VehicleToItem[Carryall] = CarryallVehicle;

$VehicleToItem[Roller] = RollerVehicle;
$VehicleToItem[Tracker] = TrackerVehicle;
$VehicleToItem[Crawler] = CrawlerVehicle;

//----------------------------------------------------------------------------
// Default station animations

function Station::onActivate(%this)
{
	//echo("Activate " @ %this);
	%obj = Station::getTarget(%this);
	if (%obj != -1) {
		GameBase::playSequence(%this,1,"activate");
		GameBase::setSequenceDirection(%this,1,1);
		%this.lastPlayer = %obj;
	}
	else 
		GameBase::setActive(%this,false);
}

function Station::onDeactivate(%this)
{
	//echo("Dectivate " @ %this);
	GameBase::stopSequence(%this,2);
	GameBase::setSequenceDirection(%this,1,0);
}

function Station::onEndSequence(%this,%thread)
{

	//echo("End sequence " @ %this);
 	if (%thread == 1 && GameBase::isActive(%this)) {
		GameBase::playSequence(%this,2,"use");
		return true;
	}
	%client = %this.target;
	if(%client == "") {
		%player = Station::getTarget(%this);
		%client = Player::getClient(%player);
	}
	if(%client != "") {
		if(Client::getGuiMode(%client) != 1)
			Client::setGuiMode(%client,1);
		
		%team = Client::getTeam(%client);
		if($TeamEnergy[%team] != "Infinite") {
			if(%this.clTeamEnergy != %client.TeamEnergy) {
				if(%client.teamEnergy < 0)
					Client::sendMessage(%client,0,"Your total mission purchases have come to " @ (%client.teamEnergy * -1) @ ".");
				else
					Client::sendMessage(%client,0,"You have increased the Team Energy by " @ %client.teamEnergy @ ".");
			}
			if((%client.teamEnergy -%client.EnergyWarning < $TeammateSpending) && ($TeammateSpending != 0) && !$TeamEnergyCheat) {
				TeamMessages(0, %team, "Teammate " @ Client::getName(%client) @ " has spent " @ (%client.teamEnergy *-1) @ " of the TeamEnergy"); 
				%client.EnergyWarning = %client.teamEnergy;
			}
			if($TeamEnergy[%team] < $WarnEnergyLow)  
				TeamMessages(0, %team, "TeamEnergy Low: " @ $TeamEnergy[%team]); 
		}
	}
	if(%this.target != "") {
		(Client::getOwnedObject(%this.target)).Station = "";
		%this.target = "";
	}
	if(GameBase::getDataName(%this) == VehicleStation && %this.vehiclePad.busy < getSimTime())
		VehiclePad::checkSeq(%this.vehiclePad, %this);
	if(GameBase::getDataName(%this) == OrnithopterStation && %this.OrnithopterPad.busy < getSimTime())
		OrnithopterPad::checkSeq(%this.OrnithopterPad, %this);
	if(GameBase::getDataName(%this) == GroundCarStation && %this.GroundCarPad.busy < getSimTime())
		GroundCarPad::checkSeq(%this.GroundCarPad, %this);
	%this.clTeamEnergy = "";
	return false;
}

function Station::onPower(%this,%power,%generator)
{
	if (%power) {
		GameBase::playSequence(%this,0,"power");
		GameBase::playSequence(%this,1);
	}
	else {
		GameBase::stopSequence(%this,0);
		GameBase::pauseSequence(%this,1);
		GameBase::pauseSequence(%this,2);
		Station::checkTarget(%this);
	}
}

function Station::onEnabled(%this)
{
	if (GameBase::isPowered(%this)) {		
		GameBase::playSequence(%this,0,"power");
		GameBase::playSequence(%this,1);
	}
}

function Station::checkTarget(%this)
{

	if(%this.target) {
		Client::setGuiMode(%this.target,1);
		GameBase::setActive(%this,false);
	}
}

function Station::onDisabled(%this)
{
	Station::weaponCheck(%this);
	GameBase::stopSequence(%this,0);
	GameBase::setSequenceDirection(%this,1,0);
	GameBase::pauseSequence(%this,1);
	GameBase::stopSequence(%this,2);
	Station::checkTarget(%this);
}

function Station::onDestroyed(%this)
{
	Station::weaponCheck(%this);
	StaticShape::objectiveDestroyed(%this);
	GameBase::stopSequence(%this,0);
	GameBase::stopSequence(%this,1);
	GameBase::stopSequence(%this,2);
	Station::checkTarget(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 2, 0.40, 
		0.1, 250, 100); 
}

function Station::weaponCheck(%this)
{
	if(%this.lastPlayer != "") {
		%player = %this.lastPlayer;
		%player.Station = "";
		if(Player::getMountedItem(%player,$WeaponSlot) == -1){
			if(%player.lastWeapon != "") {
				Player::useItem(%player,%player.lastWeapon);		 	
				%player.lastWeapon = "";
	  		}
		}											
	 	%this.lastPlayer = "";
  	}
}

function Station::getTarget(%this)
{
	if(GameBase::getLOSInfo(%this,1.5,"0 0 3.14")) {
	  	// GetLOSInfo sets the following globals:
	  	// 	los::position
	  	// 	los::normal
	  	// 	los::object
	  	%obj = getObjectType($los::object);
		dbecho(3, "STATION: LOS got " @ %obj);
	  	if (%obj == "Player") {
         if( Player::isAiControlled( $los::object ) != "True" ) {
			   return $los::object;
         }
		}
	}
	dbecho(3, "STATION: LOS Got None");
	return -1;
}	

function Station::onCollision(%this, %object)
{
	if(%this.target == ""){
		dbecho(3, "STATION: Collision (" @ %this @ "," @ %object @ ")");
		%obj = getObjectType(%object);
		if (%obj == "Player" && isPlayerBusy(%object) == 0) {
  		 	%client = Player::getClient(%object);
 			if(Station::getTarget(%this) == %object && (GameBase::getTeam(%object) == GameBase::getTeam(%this) || GameBase::getTeam(%this) == -1 || $FaceDancerIsSwitched[%client])) {
				if($FaceDancerIsSwitched[%client] && (GameBase::getDataName(%this) == InventoryStation || GameBase::getDataName(%this) == DeployableInvStation))
				{
					Client::sendMessage(%client,0,"You cannot use inventory stations while impersonating.");
				}
				else if (GameBase::getDamageState(%this) == "Enabled") {
					if (GameBase::isPowered(%this)) { 
						if(%this.enterTime == "")
							%this.enterTime = getSimTime();
						GameBase::setActive(%this,true);
					}
					else 
						Client::sendMessage(%client,0,"Unit is not powered");
				}
				else 
					Client::sendMessage(%client,0,"Unit is disabled");
			}
			else if(Station::getTarget(%this) == %object)
   	   		{
				%curTime = getSimTime();
				if(%curTime - %object.stationDeniedStamp > 3.5 && GameBase::getDamageState(%this) == "Enabled") {
					Client::clearItemShopping(%client);
					Station::onDeactivate(%this);
					Station::onEndSequence(%this,1);
					if(Client::getGuiMode(%client) != 1)
						Client::setGuiMode(%client,1);
					%object.stationDeniedStamp = %curTime;
					Client::sendMessage(%client,0,"--ACCESS DENIED-- Wrong Team ~waccess_denied.wav");
				}
			}
		}
	}
}

function Station::itemsToResupply(%player)
{
	%cnt = 0;
	%cnt = %cnt + AmmoStation::resupply(%player,"",RepairPatch,1);
	%cnt = %cnt + AmmoStation::resupply(%player,"",RepairKit,1);
//	%cnt = %cnt + AmmoStation::resupply(%player,Pistol,PistolAmmo,2);
//	%cnt = %cnt + AmmoStation::resupply(%player,Maula,MaulaAmmo,1);
//	%cnt = %cnt + AmmoStation::resupply(%player,Stunner,StunnerAmmo,1);
//	%cnt = %cnt + AmmoStation::resupply(%player,Rifle,RifleAmmo,5);
//	%cnt = %cnt + AmmoStation::resupply(%player,MGun,MGunAmmo,5);
//	%cnt = %cnt + AmmoStation::resupply(%player,SniperRifle,SniperAmmo,1);
//	%cnt = %cnt + AmmoStation::resupply(%player,RLauncher,RLauncherAmmo,1);
//	%cnt = %cnt + AmmoStation::resupply(%player,Flamethrower,FlamethrowerAmmo,30);
//	%cnt = %cnt + AmmoStation::resupply(%player,Piller,PillerAmmo,1);
//	%cnt = %cnt + AmmoStation::resupply(%player,Cutteray,CutterayAmmo,5);
//	%cnt = %cnt + AmmoStation::resupply(%player,SmallLas,SmallLasAmmo,5);
//	%cnt = %cnt + AmmoStation::resupply(%player,RifleLas,RifleLasAmmo,5);
//	%cnt = %cnt + AmmoStation::resupply(%player,HeavyLas,HeavyLasAmmo,5);

	%cnt = %cnt + AmmoStation::resupply(%player,Pistol,PistolClip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,Maula,MaulaClip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,Stunner,StunnerClip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,Rifle,RifleClip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,MGun,MGunClip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,SniperRifle,SniperClip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,Cutteray,CutterayCell,1);
	%cnt = %cnt + AmmoStation::resupply(%player,SmallLas,SmallLasCell,1);
	%cnt = %cnt + AmmoStation::resupply(%player,RifleLas,RifleLasCell,1);
	%cnt = %cnt + AmmoStation::resupply(%player,HeavyLas,HeavyLasCell,1);
	%cnt = %cnt + AmmoStation::resupply(%player,RLauncher,RLauncherClip,1);
	return %cnt;
}

//----------------------------------------------------------------------------
// Deployable stations

function DeployableStation::onActivate(%this)
{
	//echo("Activate " @ %this);
	%obj = Station::getTarget(%this);
	if (%obj != -1) {
		GameBase::playSequence(%this,1,"activate");
		GameBase::setSequenceDirection(%this,1,1);
		%this.lastPlayer = %obj;
	}
	else 
		GameBase::setActive(%this,false);
}


function DeployableStation::onEndSequence(%this,%thread)
{
   if(!%thread) {
		%this.deployed = 1;
		GameBase::playSequence(%this,2,"power");
	}
}

function DeployableStation::deploy(%this)
{
	GameBase::playSequence(%this,0,"deploy");
}

function DeployableStation::onDeactivate(%this)
{
	//echo("Dectivate " @ %this);
	GameBase::stopSequence(%this,1);
}

function DeployableStation::onEnabled(%this)
{
	GameBase::playSequence(%this,2,"power");
}

function DeployableStation::onDisabled(%this)
{
	GameBase::stopSequence(%this,2);
	GameBase::stopSequence(%this,1);
	Station::checkTarget(%this);
}

function DeployableStation::onDestroyed(%this)
{
	DeployableStation::onDisabled(%this);
	%stationName = GameBase::getDataName(%this);

	if(%stationName == DeployableInvStation) 
    	$TeamItemCount[GameBase::getTeam(%this) @ "DeployableInvPack"]--;
	else if( %stationName == DeployableAmmoStation) 
	  	$TeamItemCount[GameBase::getTeam(%this) @ "DeployableAmmoPack"]--;
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 2, 0.30, 
		0.1, 200, 100); 
	Station::weaponCheck(%this);
}


function DeployableStation::onCollision(%this, %object)
{
	//echo("Collision (" @ %this @ ",	" @ %object @ ")");
	%obj = getObjectType(%object);
	if (%obj == "Player" && isPlayerBusy(%object) == 0) 
	{
  	 	%client = Player::getClient(%object);
		if(GameBase::getTeam(%object) == GameBase::getTeam(%this) || GameBase::getTeam(%this) == -1) 
		{
			if (GameBase::getDamageState(%this) == "Enabled") 
			{
				if(%this.enterTime == "") 
					%this.enterTime = getSimTime();
				GameBase::setActive(%this,true);
			}
			else 
				Client::sendMessage(%client,0,"Unit is disabled");
		}
      		else if(Station::getTarget(%this) == %object) 
		{
			%curTime = getSimTime();
			if(%curTime - %object.stationDeniedStamp > 3.5 && GameBase::getDamageState(%this) == "Enabled") 
			{
				%object.stationDeniedStamp = %curTime;
				Client::sendMessage(%client,0,"--ACCESS DENIED-- Wrong Team ~waccess_denied.wav");
			}
		}
	}
}




//----------------------------------------------------------------------------


StaticShapeData DeployableHunterSeekerStation
{
	description = "HunterSeeker Platform";
	shapeFile = "cmdpnl";
	className = "DeployableStation";
	visibleToSensor = true;
	sequenceSound[0] = {"activate", SoundActivateCommandStation };
	sequenceSound[1] = {"power", SoundCommandStationPower };
	sequenceSound[2] = {"use", SoundUseCommandStation };
	maxDamage = 1.0;
	debrisId = flashDebrisMedium;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	castLOS = true;
	supression = false;
	supressable = false;
	explosionId = flashExpLarge;
};

function DeployableHunterSeekerStation::onAdd(%this)
{
	schedule("DeployableStation::deploy(" @ %this @ ");",1,%this);
	if (GameBase::getMapName(%this) == "") 
		GameBase::setMapName (%this, "HunterSeeker Platform");
	%this.Energy = 3000;
	%this.deployed = 1;
}

function DeployableHunterSeekerStation::onDestroyed(%this)
{
	%turret = %this.comstation;
	%data = GameBase::getDataName(%turret);
	GameBase::setDamageLevel(%turret, %data.maxDamage);
}



function DeployableHunterSeekerStation::onEndSequence(%this,%thread)
{
	//echo("End Seq ",%thread);
	(Client::getOwnedObject(%this.target)).Station = "";
	%this.target = "";
	if (Station::onEndSequence(%this,%thread)) 
		DeployableHunterSeekerStation::onResupply(%this);
}

function DeployableHunterSeekerStation::onResupply(%this)
{
	if (GameBase::isActive(%this)) {
		%player = Station::getTarget(%this);
		if (%player != -1 && %this.lastPlayer == %player) {
			%client = Player::getClient(%player);
			if (%this.target != %client) {
				%this.target = %client;
				%player.CommandTag = 1;
				
				HunterSeekerStationCheck(%this, %player);
				%player.station = %this;
			}
			schedule("DeployableHunterSeekerStation::onResupply(" @ %this @ ");",0.5,%this);
			return;
		}
		GameBase::setActive(%this,false);
	}
	if (%this.target) {
		(Client::getOwnedObject(%this.target)).CommandTag = "";
		checkControlUnmount(%this.target);
	}
	(Client::getOwnedObject(%this.target)).Station = "";
	%this.target = "";
}

function HunterSeekerStationCheck(%this, %player)
{
	%client = Player::getClient(%player);
	bottomprint(%client, "<jc>Press JUMP to fire.", 3);
	%player.CommandTag = 1;
	%player.HSStation = %this;
	%this.comstation.controller = %client;
	Client::takeControl(%client, %this.comstation);
	Client::setControlObject(%client, %this.comstation);
	
}

function DeployableHunterSeekerTurret::jump(%this,%mom)
{
			
	%rot = GameBase::getRotation(%this);
	%pos = GameBase::getPosition(%this);
	//%vec = Vector::getFromRot(%rot, 8);
	%pos = ""@getWord(%pos,0)@" "@getWord(%pos,1)@" "@getWord(%pos,2)+1@"";
	//%newvec = ""@getWord(%vec, 0)+getWord(%pos, 0)@" "@getWord(%vec, 1)+getWord(%pos, 1)@" "@getWord(%vec, 2)+getWord(%pos, 2)@"";
	%HS = newObject("","Flier","HunterSeeker", true);
	addToSet("MissionCleanup", %HS);
	GameBase::setTeam(%HS, GameBase::getTeam(%cl));
	GameBase::setPosition(%HS, %pos);
	GameBase::setRotation(%HS, %rot);
	//schedule("Client::setControlObject("@%cl@","@%HS@");", 0.25, %HS);
	Client::takeControl(%this.controller, %HS);
	Client::SetControlObject(%this.controller, %HS);
	//$FiringTOW[%cl] = 1;
	//schedule("$FiringTOW["@%cl@"] = 0;", 30);
}

//----------------------------------------------------------------------------

StaticShapeData AmmoStation
{
   description = "Ammo Supply Unit";
	shapeFile = "ammounit";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateAmmoStation };
	sequenceSound[1] = { "power", SoundAmmoStationPower };
	sequenceSound[2] = { "use", SoundUseAmmoStation };
	maxDamage = 1.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
   explosionId = flashExpLarge;
};

function AmmoStation::onEndSequence(%this,%thread)
{
	//echo("End Seq ",%thread);
	%player = Station::getTarget(%this);
	if(%this.clTeamEnergy == "")
		%this.clTeamEnergy = (Player::getClient(%player)).TeamEnergy;
	if (Station::onEndSequence(%this,%thread)) {    
		%weapon = Player::getMountedItem(%player,$WeaponSlot);
		if(%weapon != -1) {
			%player.lastWeapon = %weapon;
			Player::unMountItem(%player,$WeaponSlot);
		}
		AmmoStation::onResupply(%this);
	}
}									
											
function AmmoStation::onResupply(%this)
{
	if (GameBase::isActive(%this)) {
		%player = Station::getTarget(%this);
		if (%player != -1 && %this.lastPlayer == %player) {
			// Hardcoded here for the ammo types
			%cnt = Station::itemsToResupply(%player);
			if(getSimTime() - %this.enterTime > 11)
				%cnt = 0;
			if (%cnt != 0) {
				%player.waitThrowTime = getSimTime();
				schedule("AmmoStation::onResupply(" @ %this @ ");",0.5,%this);
				return;
			}
			%player.Station = "";
			%client = Player::getClient(%player);
			%this.target = "";
			Client::sendMessage(%client,0,"Resupply Complete");
			Client::setInventoryText(%client, "<f1><jc>TEAM ENERGY: " @ $TeamEnergy[Client::getTeam(%client)]);

			if(Player::getMountedItem(%player,$WeaponSlot) == -1){
				if(%player.lastWeapon != "") {
					Player::useItem(%player,%player.lastWeapon);		 	
					%player.lastWeapon = "";
	  			}
			}			
		}
		else if(%this.target != "") {
			%player = Client::getOwnedObject(%this.target);
			%player.Station = "";
			if(Player::getMountedItem(%player,$WeaponSlot) == -1){
				if(%player.lastWeapon != "") {
					Player::useItem(%player,%player.lastWeapon);		 	
					%player.lastWeapon = "";
	  			}
			}		
			%this.target = "";
		}
		else {
			%this.lastPlayer.Station = "";
			if(Player::getMountedItem(%this.lastPlayer,$WeaponSlot) == -1){
				if(%this.lastPlayer.lastWeapon != "") {
					Player::useItem(%this.lastPlayer,%this.lastPlayer.lastWeapon);		 	
					%this.lastPlayer.lastWeapon = "";
	  			}
			}
			%this.target = "";
		}
		GameBase::setActive(%this,false);
		%this.enterTime="";
	}
}
		 											
function AmmoStation::resupply(%player,%weapon,%item,%delta)
{
	%delta = checkResources(%player,%item,%delta,1);		
	if(%delta > 0) {						
		if(%item == RepairPatch) {
			teamEnergyBuySell(%player,%item.price * %delta * -1);
			GameBase::repairDamage(%player,0.06);
		 	return %delta;
		}
		else if (%item == MineAmmo || %item == Grenade || %item == RepairKit) {
			teamEnergyBuySell(%player,%item.price * %delta * -1);
			Player::incItemCount(%player,%item,%delta);
		 	return %delta;
		}
		else if (Player::getItemCount(%player,%weapon)) {
			teamEnergyBuySell(%player,%item.price * %delta * -1);
			Player::incItemCount(%player,%item,%delta);
//			if(player::Getarmor(%player) == SoldierArmor
		 	return %delta;
		}
	}
	return 0;
}

//----------------------------------------------------------------------------
StaticShapeData DeployableAmmoStation
{
   description = "Remote Ammo Unit";
	shapeFile = "ammounit_remote";
   validateShape = false;
   validateMaterials = true;
	className = "DeployableStation";
	maxDamage = 0.25;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	sequenceSound[1] = { "use", SoundUseAmmoStation };
	sequenceSound[2] = { "power", SoundAmmoStationPower };

	visibleToSensor = true;
	shadowDetailMask = 4;
	castLOS = true;
	supression = false;
	supressable = false;
	mapFilter = 4;
	mapIcon = "M_station";
	debrisId = flashDebrisSmall;
	damageSkinData = "objectDamageSkins";
   explosionId = flashExpMedium;
};


function DeployableAmmoStation::onAdd(%this)
{
	schedule("DeployableStation::deploy(" @ %this @ ");",1,%this);
	if (GameBase::getMapName(%this) == "") 
		GameBase::setMapName (%this, "R-Ammo Station");
	%this.Energy = $RemoteAmmoEnergy;
}

function DeployableAmmoStation::onActivate(%this)
{
	if(%this.deployed == 1) {
		GameBase::playSequence(%this,1,"use");
		//echo("Activate " @ %this);
		schedule("AmmoStation::onResupply(" @ %this @ ");",0.5,%this);
		%this.lastPlayer = Station::getTarget(%this);
		%player = %this.lastPlayer; 
		%player.Station = %this;
		%this.target = Player::getClient(Station::getTarget(%this));
		%weapon = Player::getMountedItem(%player,$WeaponSlot);
		if(%weapon != -1) {
			%player.lastWeapon = %weapon;
			Player::unMountItem(%player,$WeaponSlot);
		}
	}
	else 
		GameBase::setActive(%this,false);	
}


//----------------------------------------------------------------------------

StaticShapeData DeployableInvStation
{
	description = "Remote Inv Unit";
	shapeFile = "invent_remote";
   validateShape = false;
   validateMaterials = true;
	className = "DeployableStation";
	maxDamage = 0.25;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	sequenceSound[1] = { "use", SoundUseAmmoStation };
	sequenceSound[2] = { "power", SoundInventoryStationPower };			
	visibleToSensor = true;
	shadowDetailMask = 4;
	castLOS = true;
	supression = false;
	supressable = false;
	mapFilter = 4;
	mapIcon = "M_station";
	debrisId = flashDebrisMedium;
	damageSkinData = "objectDamageSkins";
   explosionId = flashExpSmall;
//	triggerRadius = 1.5;
};


function DeployableInvStation::onAdd(%this)
{
	schedule("DeployableStation::deploy(" @ %this @ ");",1,%this);
	if (GameBase::getMapName(%this) == "") 
		GameBase::setMapName (%this, "R-Inv Station");
	%this.Energy = $RemoteInvEnergy;
}

function DeployableInvStation::onActivate(%this)
{
	if(%this.deployed == 1) {
		GameBase::playSequence(%this,1,"use");
		//echo("Activate " @ %this);
 		InventoryStation::onResupply(%this,"RemoteInvList");
		%this.lastPlayer = Station::getTarget(%this);
	}
	else
		GameBase::setActive(%this,false);
}


//----------------------------------------------------------------------------

StaticShapeData InventoryStation
{
   description = "Station Supply Unit";
	shapeFile = "inventory_sta";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
	maxDamage = 1.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	triggerRadius = 1.5;
   explosionId = flashExpLarge;
};

function InventoryStation::onEndSequence(%this,%thread)
{
	//echo("End Seq ",%thread);
	if (Station::onEndSequence(%this,%thread)) 
		InventoryStation::onResupply(%this,"InvList");
}

function InventoryStation::onResupply(%this,%InvShopList)
{
	dbecho(3, "STATION::Resupply");
	if (GameBase::isActive(%this)) {
		%player = Station::getTarget(%this);
		if (%player != -1 && %this.lastPlayer == %player) {
			%client = Player::getClient(%player);
			if (%this.target != %client) {
				%prevplayer = Client::getOwnedObject(%this.target);
				if(%prevplayer.Station == %this)
				{
					Client::clearItemShopping(%this.target);
					if(Client::getGuiMode(%this.target) != 1)
					Client::setGuiMode(%this.target,1);
				}
				%player.Station = %this;
				setupShoppingList(%client,%this,%InvShopList);
				updateBuyingList(%client);
				%this.target = %client;
				%this.clTeamEnergy = %client.TeamEnergy;

				%client.invo = %this;
				%client.ListType = %InvShopList;

		                if(!%client.noEnterInventory)
   					Client::setGuiMode(%client,$GuiModeInventory);
				Client::sendMessage(%client,0,"Station Access On");
				%player.ResupplyFlag = 1;
				%weapon = Player::getMountedItem(%player,$WeaponSlot);
				if(%weapon != -1) {
					%player.lastWeapon = %weapon;
					Player::unMountItem(%player,$WeaponSlot);
				}
			}
			%player.waitThrowTime = getSimTime();
			schedule("InventoryStation::onResupply(" @ %this @ ");",0.5,%this);
			if(%player.ResupplyFlag) 
			   %player.ResupplyFlag = resupply(%this);
			return;
		}
		GameBase::setActive(%this,false);
	}
	if (%this.target != "") {	   
		%player = Client::getOwnedObject(%this.target);
		Client::clearItemShopping(%this.target);
		Client::sendMessage(%this.target,0,"Station Access Off");
		Station::onEndSequence(%this);
		if(GameBase::getDataName(%player.Station) == DeployableInvStation) {
			Client::setInventoryText(%this.target, "<f1><jc>TEAM ENERGY: " @ $TeamEnergy[Client::getTeam(%this.target)]);
			if(Client::getGuiMode(%this.target) != 1)
				Client::setGuiMode(%this.target,1);
			%player.Station = "";
  			%this.target = "";
		}
		if(Player::getMountedItem(%player,$WeaponSlot) == -1){
			if(%player.lastWeapon != "") {
				Player::useItem(%player,%player.lastWeapon);		 	
				%player.lastWeapon = "";
	  		}
		}
	}
	%this.enterTime="";
}


function resupply(%this)
{
	if (GameBase::isActive(%this)) {
		%player = Station::getTarget(%this);
		if (%player != -1) {
			// Hardcoded here for the ammo types
			%cnt = Station::itemsToResupply(%player);
			if(getSimTime() - %this.enterTime > 11)
				%cnt = 0;
			%client = Player::getClient(%player);
			if (%cnt != 0) {
				updateBuyingList(%client);
				return 1;
			}
			Client::sendMessage(%client,0,"Resupply Complete");
			return 0;
		}
	}
	return 0;
}

//----------------------------------------------------------------------------
function setupShoppingList(%client,%station,%ListType)
{
	%armor = player::Getarmor(%client);
	Client::clearItemShopping(%client);
	%max = getNumItems();
	if(%ListType == "InvList") {
		for(%i = 0; %i < %max; %i++) {						
			%item = getItemData(%i);
			// Part of ifcheck below. 
			if($InvList[%item] != "" && $InvList[%item] && !%station.dontSell[%item] && $ItemMax[%armor,%item] > 0 && !$TeamRestrictedItem[$ServerNameToKeyName[client::getteam(%client)],%armor, %item]) 
				Client::setItemShopping(%client, %item);
			else if(%item.className == Armor && !%station.dontSell[%item] && $TeamArmor[$ServerNameToKeyName[client::getteam(%client)], %item] != 0)  {
				Client::setItemShopping(%client, %item);
			}
		}

	}
	else if(%ListType == "RemoteInvList") {
		for(%i = 0; %i < %max; %i++) {						
			%item = getItemData(%i);
			// Part of ifcheck below. 
			if($RemoteInvList[%item] != "" && $RemoteInvList[%item] && !%station.dontSell[%item] && $ItemMax[%armor,%item] > 0 && !$TeamRestrictedItem[$ServerNameToKeyName[client::getteam(%client)],%armor, %item]) 
				Client::setItemShopping(%client, %item);
	   }
	}
	else if(%ListType == "VehicleInvList") {
		for(%i = 0; %i < %max; %i++) {						
			%item = getItemData(%i);
			if($VehicleInvList[%item] != "" && $VehicleInvList[%item] && !%station.dontSell[%item] && $TeamVehicleMax[$ServerNameToKeyName[client::getteam(%client)], %item] != 0) 
				Client::setItemShopping(%client, %item);
		}
	}
	else if(%ListType == "OrnithopterInvList") {
		for(%i = 0; %i < %max; %i++) {						
			%item = getItemData(%i);
			if($OrnithopterInvList[%item] != "" && $OrnithopterInvList[%item] && !%station.dontSell[%item] && $TeamVehicleMax[$ServerNameToKeyName[client::getteam(%client)], %item] != 0)
				Client::setItemShopping(%client, %item);
		}
	}
	else if(%ListType == "GroundCarInvList") {
		for(%i = 0; %i < %max; %i++) {						
			%item = getItemData(%i);
			if($GroundCarInvList[%item] != "" && $GroundCarInvList[%item] && !%station.dontSell[%item] && $TeamVehicleMax[$ServerNameToKeyName[client::getteam(%client)], %item] != 0) 
				Client::setItemShopping(%client, %item);
		}
	}
	else
		return;			
}

function updateBuyingList(%client)
{
   Client::clearItemBuying(%client);
	%station = (Client::getOwnedObject(%client)).Station;
	%stationName = GameBase::getDataName(%station); 
	if(%stationName == DeployableInvStation || %stationName == DeployableAmmoStation) {
		%energy = %station.Energy;
   	Client::setInventoryText(%client, "<f1><jc>STATION ENERGY: " @ %energy );
	}
   else {
		%energy = $TeamEnergy[Client::getTeam(%client)];
		Client::setInventoryText(%client, "<f1><jc>TEAM ENERGY: " @ %energy);
	}
	%armor = Player::getArmor(%client);
	%max = getNumItems();
	for (%i = 0; %i < %max; %i++) {
		%item = getItemData(%i);
     		if(!%item.showInventory)
         		continue;
		if($ItemMax[%armor, %item] != "" && Client::isItemShoppingOn(%client,%i) && !$TeamRestrictedItem[$ServerNameToKeyName[client::getteam(%client)],%armor, %item]) {
			%extraAmmo = 0;
			if(Player::getMountedItem(%client,$BackpackSlot) == ammopack)
				%extraAmmo = $AmmoPackMax[%item];
			if($ItemMax[%armor, %item] + %extraAmmo > Player::getItemCount(%client,%item))	{
				if(%energy >= %item.price ) {
					if(%item.className == Weapon) {
						if(Player::getItemClassCount(%client,"Weapon") < $MaxWeapons[%armor]
							&& !(player::Getitemcount(%client,Rifle2) > 0 && %item == Rifle))
								Client::setItemBuying(%client, %item);
							
					}
					else { 
						if($TeamItemMax[%item] != "") {						
							if($TeamItemCount[GameBase::getTeam(%client) @ %item] < $TeamItemMax[%item])
								Client::setItemBuying(%client, %item);
						}
						else
							Client::setItemBuying(%client, %item);
					}
				}
		   }
		}
		else if(%item.className == Armor && %item != $ArmorName[%armor] && Client::isItemShoppingOn(%client,%i)
			&& ( ( $TeamArmorCount[$ServerNameToKeyName[client::getteam(%client)], %item] / Game::NumTeamPlayers(client::getteam(%client)) ) *100) < $TeamArmor[$ServerNameToKeyName[client::getteam(%client)], %item] ){
			Client::setItemBuying(%client, %item);

		}
		else if(%item.className == Vehicle && $TeamItemCount[client::getTeam(%client) @ %item] < $TeamItemMax[%item] && Client::isItemShoppingOn(%client,%i) && $TeamItemCount[client::getTeam(%client) @ %item] < $TeamVehicleMax[$ServerNameToKeyName[client::getteam(%client)], %item])
			Client::setItemBuying(%client, %item);
	}
}

//----------------------------------------------------------------------------
StaticShapeData CommandStation
{
   description = "Command Station";
	shapeFile = "cmdpnl";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateCommandStation };
	sequenceSound[1] = { "power", SoundCommandStationPower };
	sequenceSound[2] = { "use", SoundUseCommandStation };
	maxDamage = 1.0;
	debrisId = flashDebrisMedium;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	triggerRadius = 1.5;
   explosionId = flashExpLarge;
};

function CommandStation::onEndSequence(%this,%thread)
{
	//echo("End Seq ",%thread);
	(Client::getOwnedObject(%this.target)).Station = "";
	%this.target = "";
	if (Station::onEndSequence(%this,%thread)) 
		CommandStation::onResupply(%this);
}

function CommandStation::onResupply(%this)
{
	if (GameBase::isActive(%this)) {
		%player = Station::getTarget(%this);
		if (%player != -1 && %this.lastPlayer == %player) {
			%client = Player::getClient(%player);
			if (%this.target != %client) {
				%this.target = %client;
				%player.CommandTag = 1;
				Client::setGuiMode(%client,2);
				Client::sendMessage(%client,0,"Command Access On");
				%player.station = %this;
			}
			schedule("CommandStation::onResupply(" @ %this @ ");",0.5,%this);
			return;
		}
		GameBase::setActive(%this,false);
	}
	if (%this.target) {
		Client::sendMessage(%this.target,0,"Command Access Off");
		(Client::getOwnedObject(%this.target)).CommandTag = "";
		checkControlUnmount(%this.target);
	}
	(Client::getOwnedObject(%this.target)).Station = "";
	%this.target = "";
}


//----------------------------------------------------------------------------
StaticShapeData VehicleStation
{
   description = "Station Vehicle Unit";
	shapeFile = "vehi_pur_pnl";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
//   explosionId = DebrisExp;
	maxDamage = 1.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	triggerRadius = 1.5;
   explosionId = flashExpLarge;
};

function VehicleStation::onEndSequence(%this,%thread)
{
	//echo("End Seq ",%thread);
	if (Station::onEndSequence(%this,%thread)) 
		VehicleStation::onBuyingVechicle(%this);
}

function VehicleStation::onBuyingVechicle(%this)
{
	if (GameBase::isActive(%this)) {
		%player = Station::getTarget(%this);
		if (%player != -1 && %this.lastPlayer == %player) {
			%client = Player::getClient(%player);
			if (%this.target != %client) {
				setupShoppingList(%client,%this,"VehicleInvList");
				updateBuyingList(%client);
				%this.target = %client;
				%this.clTeamEnergy = %client.TeamEnergy;
				Client::setGuiMode(%client,4);
				Client::sendMessage(%client,0,"Station Access On");
				%player.Station = %this;
			 	%numItems = Group::objectCount(GetGroup(%this));
				for(%i = 0 ; %i<%numItems ; %i++) { 
					%obj = Group::getObject(GetGroup(%this), %i);
					%name = GameBase::getDataName(%obj); 
					if(%name == VehiclePad) { 
						%this.vehiclePad = %obj;
						GameBase::setActive(%this.vehiclePad,true);
						%i = %numItems;
					}
				}
			}
			schedule("VehicleStation::onBuyingVechicle(" @ %this @ ");",0.5,%this);
			return;
		}
		GameBase::setActive(%this,false);
	}
	if (%this.target) {	   
		Client::clearItemShopping(%this.target);
		Client::sendMessage(%this.target,0,"Station Access Off");
		Station::onEndSequence(%this);
	}
}


function VehicleStation::checkBuying(%client,%item)
{
	%player = Client::getOwnedObject(%client);
	%obj = %player.Station.vehiclePad;
	if(GameBase::isPowered(%obj) && GameBase::getDamageState(%obj) == "Enabled") {
		%markerPos = GameBase::getPosition(%obj);
  		%set = newObject("set",SimSet);
		%mask = $VehicleObjectType | $SimPlayerObjectType | $ItemObjectType;
		%objInWay = containerBoxFillSet(%set,%mask,%markerPos,6,5,14,1);
		%station = %player.Station;
		if(%objInWay == 1) {
			%object = Group::getObject(%set, 0);	
			%sName = GameBase::getDataName(%object);
			if(%sName.className == Vehicle) {
				if(GameBase::getControlClient(%object) == -1) {
					if(%station.fadeOut == "") {
						if(%item != $VehicleToItem[%sname]) {
							%object.fading = 1;
							%station.fadeOut=1;
							teamEnergyBuySell(%player,$VehicleToItem[%sName].price);
							$TeamItemCount[Client::getTeam(%client) @ ($VehicleToItem[%sName])]--;
							GameBase::startFadeOut(%object);
							schedule("deleteObject(" @ %object @ ");",2.5,%object);
							schedule(%object @ ".fading = \"\";",2.5,%object);
							schedule(%station @ ".fadeOut = \"\";",2.5,%station);
							%objInWay--;
						}
						else
							return 2;
					}
					else {
						Client::SendMessage(%client,0,"ERROR - Vehicle creation pad busy"); 
						return 0;
					}
				}
				else { 
					Client::SendMessage(%client,0,"ERROR - Vehicle in creation area is mounted");
					return 0;
				}
			} 
		}
		if(!%objInWay) {
			if (checkResources(%player,%item,1)) {
	    		%vehicle = newObject("",flier,$DataBlockName[%item],true);
				Gamebase::setMapName(%vehicle,%item.description);
            %vehicle.clLastMount = %client;
				addToSet("MissionCleanup", %vehicle);
			  	%vehicle.fading = 1;
				GameBase::setTeam(%vehicle,Client::getTeam(%client));
				if(%object.fading) { 
					schedule("GameBase::startFadeIn(" @ %vehicle @ ");",2.5,%vehicle);
					schedule("GameBase::setPosition(" @ %vehicle @ ",\"" @ %markerPos @ "\");",2.5,%vehicle);
					schedule("GameBase::setRotation(" @ %vehicle @ ",\"" @ GameBase::getRotation(%obj) @ "\");",2.5,%vehicle);
					schedule(%vehicle @ ".fading = \"\"; VehiclePad::checkSeq(" @ %obj @ "," @ %player.Station @ ");",5,%vehicle);
					%obj.busy = getSimTime() + 5;
				}
				else {
					GameBase::startFadeIn(%vehicle);
					GameBase::setPosition(%vehicle,%markerPos);
					GameBase::setRotation(%vehicle,GameBase::getRotation(%obj));
				 	schedule(%vehicle @ ".fading = \"\"; VehiclePad::checkSeq(" @ %obj @ "," @ %player.Station @ ");",3,%vehicle);
					%obj.busy = getSimTime() + 3;
				}
				deleteObject(%set);
				$TeamItemCount[Client::getTeam(%client) @ %item]++;
				return 1;
			}
		}
		else
			Client::SendMessage(%client,0,"ERROR - Object in vehicle creation area");
		deleteObject(%set);
	}	
	else
		Client::SendMessage(%client,0,"ERROR - Vehicle Pad Disabled");

	return 0;
}


StaticShapeData VehiclePad
{
   description = "Vehicle Pad";
	shapeFile = "vehi_pur_poles";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
	maxDamage = 1.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
   explosionId = flashExpLarge;
	damageSkinData = "objectDamageSkins";
};



function VehiclePad::onActivate(%this)
{
	GameBase::playSequence(%this,1,"use");
}

function VehiclePad::onDeactivate(%this)
{
	GameBase::stopSequence(%this,1);
}

function VehiclePad::onEnabled(%this)
{
}

function VehiclePad::onAdd(%this)
{
}

function VehiclePad::onCollision(%this, %object)
{
}

function VehiclePad::onPower(%this,%power,%generator)
{
	if(!%power)
		GameBase::setActive(%this,false);
}

function VehiclePad::checkSeq(%this, %station)
{
	if(%station.target == "")
		GameBase::setActive(%this,false);
}

//~~~~~~~~~~~~~~~~~~~~~~~THOPTER STATION~~~~~~~~~~~~~~~~~~~~~~~

StaticShapeData OrnithopterStation
{
   description = "Station Ornithopter Unit";
	shapeFile = "vehi_pur_pnl";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
//   explosionId = DebrisExp;
	maxDamage = 2.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	triggerRadius = 1.5;
   explosionId = flashExpLarge;
};

function OrnithopterStation::onEndSequence(%this,%thread)
{

	//echo("End Seq ",%thread);
	if (Station::onEndSequence(%this,%thread)) 
		OrnithopterStation::onBuyingOrnithopter(%this);
}

function OrnithopterStation::onBuyingOrnithopter(%this)
{
	if(GameBase::isActive(%this)) {
		%player = Station::getTarget(%this);
		if(%player != -1 && %this.lastPlayer == %player) {
			%client = Player::getClient(%player);
			if(%this.target != %client) {
				setupShoppingList(%client,%this,"OrnithopterInvList");
				updateBuyingList(%client);
				%this.target = %client;
				%this.clTeamEnergy = %client.TeamEnergy;
				Client::setGuiMode(%client,4);
				Client::sendMessage(%client,0,"Station Access On");
				%player.Station = %this;
			 	%numItems = Group::objectCount(GetGroup(%this));
				for(%i = 0 ; %i<%numItems ; %i++) { 
					%obj = Group::getObject(GetGroup(%this), %i);
					%name = GameBase::getDataName(%obj); 
					if(%name == OrnithopterPad) { 
						%this.OrnithopterPad = %obj;
						GameBase::setActive(%this.OrnithopterPad,true);
						%i = %numItems;
					}
				}
			}
			schedule("OrnithopterStation::onBuyingOrnithopter(" @ %this @ ");",0.5,%this);
			return;
		}
		GameBase::setActive(%this,false);
	}
	if(%this.target) {	   
		Client::clearItemShopping(%this.target);
		Client::sendMessage(%this.target,0,"Station Access Off");
		Station::onEndSequence(%this);
	}
}


function OrnithopterStation::checkBuying(%client,%item)
{
	%player = Client::getOwnedObject(%client);
	%obj = %player.Station.OrnithopterPad;
	if(GameBase::isPowered(%obj) && GameBase::getDamageState(%obj) == "Enabled") {
		%markerPos = GameBase::getPosition(%obj);
  		%set = newObject("set",SimSet);
		%mask = $VehicleObjectType | $SimPlayerObjectType | $ItemObjectType;
		%objInWay = containerBoxFillSet(%set,%mask,%markerPos,6,5,14,1);
		%station = %player.Station;
		if(%objInWay == 1) {
			%object = Group::getObject(%set, 0);	
			%sName = GameBase::getDataName(%object);
			if(%sName.className == Vehicle) {
				if(GameBase::getControlClient(%object) == -1) {
					if(%station.fadeOut == "") {
						if(%item != $VehicleToItem[%sname]) {
							%object.fading = 1;
							%station.fadeOut=1;
							teamEnergyBuySell(%player,$VehicleToItem[%sName].price);
							$TeamItemCount[Client::getTeam(%client) @ ($VehicleToItem[%sName])]--;
							GameBase::startFadeOut(%object);
							schedule("deleteObject(" @ %object @ ");",2.5,%object);
							schedule(%object @ ".fading = \"\";",2.5,%object);
							schedule(%station @ ".fadeOut = \"\";",2.5,%station);
							%objInWay--;
						}
						else
							return 2;
					}
					else {
						Client::SendMessage(%client,0,"ERROR - Ornithopter creation pad busy"); 
						return 0;
					}
				}
				else { 
					Client::SendMessage(%client,0,"ERROR - Ornithopter in creation area is mounted");
					return 0;
				}
			} 
		}
		if(!%objInWay) {
			if (checkResources(%player,%item,1)) {
	    			%vehicle = newObject("",flier,$DataBlockName[%item],true);
				Gamebase::setMapName(%vehicle,%item.description);
				%vehicle.clLastMount = %client;
				addToSet("MissionCleanup", %vehicle);
			  	%vehicle.fading = 1;
				GameBase::setTeam(%vehicle,Client::getTeam(%client));
				if(%object.fading) { 
					schedule("GameBase::startFadeIn(" @ %vehicle @ ");",2.5,%vehicle);
					schedule("GameBase::setPosition(" @ %vehicle @ ",\"" @ %markerPos @ "\");",2.5,%vehicle);
					schedule("GameBase::setRotation(" @ %vehicle @ ",\"" @ GameBase::getRotation(%obj) @ "\");",2.5,%vehicle);
					schedule(%vehicle @ ".fading = \"\"; VehiclePad::checkSeq(" @ %obj @ "," @ %player.Station @ ");",5,%vehicle);
					%obj.busy = getSimTime() + 5;
				}
				else {
					GameBase::startFadeIn(%vehicle);
					GameBase::setPosition(%vehicle,%markerPos);
					GameBase::setRotation(%vehicle,GameBase::getRotation(%obj));
				 	schedule(%vehicle @ ".fading = \"\"; OrnithopterPad::checkSeq(" @ %obj @ "," @ %player.Station @ ");",3,%vehicle);
					%obj.busy = getSimTime() + 3;
				}
				deleteObject(%set);
				$TeamItemCount[Client::getTeam(%client) @ %item]++;
				return 1;
			}
		}
		else
			Client::SendMessage(%client,0,"ERROR - Object in Ornithopter creation area");
		deleteObject(%set);
	}	
	else
		Client::SendMessage(%client,0,"ERROR - Ornithopter Pad Disabled");

	return 0;
}


StaticShapeData OrnithopterPad
{
   description = "Ornithopter Pad";
	shapeFile = "vehi_pur_poles";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
	maxDamage = 5.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
   explosionId = flashExpLarge;
	damageSkinData = "objectDamageSkins";
};



function OrnithopterPad::onActivate(%this)
{
	GameBase::playSequence(%this,1,"use");
}

function OrnithopterPad::onDeactivate(%this)
{
	GameBase::stopSequence(%this,1);
}

function OrnithopterPad::onEnabled(%this)
{
}

function OrnithopterPad::onAdd(%this)
{
}

function OrnithopterPad::onCollision(%this, %object)
{
}

function OrnithopterPad::onPower(%this,%power,%generator)
{
	if(!%power)
		GameBase::setActive(%this,false);
}

function OrnithopterPad::checkSeq(%this, %station)
{
	if(%station.target == "")
		GameBase::setActive(%this,false);
}

//~~~~~~~~~~~~~~~~~~~~~GROUNDCAR STATION~~~~~~~~~~~~~~~~~~~~~~~~

StaticShapeData GroundCarStation
{
   description = "Station GroundCar Unit";
	shapeFile = "vehi_pur_pnl";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
//   explosionId = DebrisExp;
	maxDamage = 2.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	triggerRadius = 1.5;
   explosionId = flashExpLarge;
};

function GroundCarStation::onEndSequence(%this,%thread)
{
	//echo("End Seq ",%thread);
	if (Station::onEndSequence(%this,%thread)) 
		GroundCarStation::onBuyingGroundCar(%this);
}

function GroundCarStation::onBuyingGroundCar(%this)
{
	if (GameBase::isActive(%this)) {
		%player = Station::getTarget(%this);
		if (%player != -1 && %this.lastPlayer == %player) {
			%client = Player::getClient(%player);
			if (%this.target != %client) {
				setupShoppingList(%client,%this,"GroundCarInvList");
				updateBuyingList(%client);
				%this.target = %client;
				%this.clTeamEnergy = %client.TeamEnergy;
				Client::setGuiMode(%client,4);
				Client::sendMessage(%client,0,"Station Access On");
				%player.Station = %this;
			 	%numItems = Group::objectCount(GetGroup(%this));
				for(%i = 0 ; %i<%numItems ; %i++) { 
					%obj = Group::getObject(GetGroup(%this), %i);
					%name = GameBase::getDataName(%obj); 
					if(%name == GroundCarPad) { 
						%this.GroundCarPad = %obj;
						GameBase::setActive(%this.GroundCarPad,true);
						%i = %numItems;
					}
				}
			}
			schedule("GroundCarStation::onBuyingGroundCar(" @ %this @ ");",0.5,%this);
			return;
		}
		GameBase::setActive(%this,false);
	}
	if (%this.target) {	   
		Client::clearItemShopping(%this.target);
		Client::sendMessage(%this.target,0,"Station Access Off");
		Station::onEndSequence(%this);
	}
}


function GroundCarStation::checkBuying(%client,%item)
{
	%player = Client::getOwnedObject(%client);
	%obj = %player.Station.GroundCarPad;
	if(GameBase::isPowered(%obj) && GameBase::getDamageState(%obj) == "Enabled") {
		%markerPos = GameBase::getPosition(%obj);
  		%set = newObject("set",SimSet);
		%mask = $VehicleObjectType | $SimPlayerObjectType | $ItemObjectType;
		%objInWay = containerBoxFillSet(%set,%mask,%markerPos,6,5,14,1);
		%station = %player.Station;
		if(%objInWay == 1) {
			%object = Group::getObject(%set, 0);	
			%sName = GameBase::getDataName(%object);
			if(%sName.className == Vehicle) {
				if(GameBase::getControlClient(%object) == -1) {
					if(%station.fadeOut == "") {
						if(%item != $VehicleToItem[%sname]) {
							%object.fading = 1;
							%station.fadeOut=1;
							teamEnergyBuySell(%player,$VehicleToItem[%sName].price);
							$TeamItemCount[Client::getTeam(%client) @ ($VehicleToItem[%sName])]--;
							GameBase::startFadeOut(%object);
							schedule("deleteObject(" @ %object @ ");",2.5,%object);
							schedule(%object @ ".fading = \"\";",2.5,%object);
							schedule(%station @ ".fadeOut = \"\";",2.5,%station);
							%objInWay--;
						}
						else
							return 2;
					}
					else {
						Client::SendMessage(%client,0,"ERROR - GroundCar creation pad busy"); 
						return 0;
					}
				}
				else { 
					Client::SendMessage(%client,0,"ERROR - GroundCar in creation area is mounted");
					return 0;
				}
			} 
		}
		if(!%objInWay) {
			if (checkResources(%player,%item,1)) {
				%vehicle = newObject("",flier,$DataBlockName[%item],true);
				Gamebase::setMapName(%vehicle,%item.description);
				%vehicle.clLastMount = %client;
				addToSet("MissionCleanup", %vehicle);
			  	%vehicle.fading = 1;
				GameBase::setTeam(%vehicle,Client::getTeam(%client));
				if(%object.fading) { 
					schedule("GameBase::startFadeIn(" @ %vehicle @ ");",2.5,%vehicle);
					schedule("GameBase::setPosition(" @ %vehicle @ ",\"" @ %markerPos @ "\");",2.5,%vehicle);
					schedule("GameBase::setRotation(" @ %vehicle @ ",\"" @ GameBase::getRotation(%obj) @ "\");",2.5,%vehicle);
					schedule(%vehicle @ ".fading = \"\"; VehiclePad::checkSeq(" @ %obj @ "," @ %player.Station @ ");",5,%vehicle);
					%obj.busy = getSimTime() + 5;
				}
				else {
					GameBase::startFadeIn(%vehicle);
					GameBase::setPosition(%vehicle,%markerPos);
					GameBase::setRotation(%vehicle,GameBase::getRotation(%obj));
				 	schedule(%vehicle @ ".fading = \"\"; GroundCarPad::checkSeq(" @ %obj @ "," @ %player.Station @ ");",3,%vehicle);
					%obj.busy = getSimTime() + 3;
				}
echo(%markerPos);
echo(gamebase::Getposition(%vehicle));
echo(%vehicle);
Schedule("echo(gamebase::Getposition("@%vehicle@"));",1);
				deleteObject(%set);
				$TeamItemCount[Client::getTeam(%client) @ %item]++;
				return 1;
			}
		}
		else
			Client::SendMessage(%client,0,"ERROR - Object in GroundCar creation area");
		deleteObject(%set);
	}	
	else
		Client::SendMessage(%client,0,"ERROR - GroundCar Pad Disabled");

	return 0;
}


StaticShapeData GroundCarPad
{
   description = "GroundCar Pad";
	shapeFile = "vehi_pur_poles";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
	maxDamage = 5.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
   explosionId = flashExpLarge;
	damageSkinData = "objectDamageSkins";
};



function GroundCarPad::onActivate(%this)
{
	GameBase::playSequence(%this,1,"use");
}

function GroundCarPad::onDeactivate(%this)
{
	GameBase::stopSequence(%this,1);
}

function GroundCarPad::onEnabled(%this)
{
}

function GroundCarPad::onAdd(%this)
{
}

function GroundCarPad::onCollision(%this, %object)
{
}

function GroundCarPad::onPower(%this,%power,%generator)
{
	if(!%power)
		GameBase::setActive(%this,false);
}

function GroundCarPad::checkSeq(%this, %station)
{
	if(%station.target == "")
		GameBase::setActive(%this,false);
}
