//Thanks to Mannkind for base scripting and for inspiration...


// BeaconDeploy is for beacons, PackDeploy is for packs.
$BeaconDeploy = "b";
$PackDeploy = "p";

// Begin Banner

if ($Presto::version >= 0.93)
{
	Presto::AddScriptBanner(BCN,"<jc><f2>Easy-Deploy\n" @
		"<f1><jc>This will move you to the\n" @
		"<f1><jc>right position if you try to\n" @
		"<f1><jc>deploy something but cannot.\n" @
		"<f1><jc>\n" @
		"<f1><jc>Base script from:<f2> Mannkind\n" @
		"<jc><f1>By<f2> Ziktar");
}

//line 20// End Banner

// The function to deploy beacon
function BeaconDeploy()
{
	use("Beacon");
	$BD = 1;
	$zOFFBY=0.4;
}

//The function when done deploying beacon
function BeaconDone()
{
	//$BD = 0;
}

// The function to deploy pack
function PacDeploy()
{
	use("BackPack");
	$PD = 1;
	$zOFFBY=0.4;
}

//The function when done deploying pack
function PacDone()
{
	//$PD = 0;
}

// The function to help the flag carrier
function EasyDeploy::OnClientMessage(%client, %msg)
{
	if($zOFFBY < 0.05) $zOFFBY = 0.4;
	if (%client != 0)
		return;
	%obj = 2048; //2048 is always _your_ object number...
	// Incase you try to deploy out of range you need to look down more
	if (%msg == "Deploy position out of range")
	{
		$zOFFBY=$zOFFBY/1.5;

		postAction(%obj, IDACTION_LOOKDOWN, 0.1);//line 60
		schedule("postAction(" @ %obj @ ", IDACTION_LOOKDOWN, 0);", $zOFFBY);
		if($BD == 1)
			schedule("use(\"Beacon\");",$zOFFBY);		
		if($PD == 1)
			schedule("use(\"BackPack\");", $zOFFBY);
	}
	// Incase you try to deploy, and an item is in the way, look to the right and up a little
	else	if (%msg == "Unable to deploy - Item in the way")
	{
		$zOFFBY=$zOFFBY/1.5;

		postAction(%obj, IDACTION_TURNRIGHT, 0.1);
		schedule("postAction(" @ %obj @ ", IDACTION_TURNRIGHT, 0);", $zOFFBY);

		postAction(%obj, IDACTION_LOOKUP, 0.07);
		schedule("postAction(" @ %obj @ ", IDACTION_LOOKUP, 0);", $zOFFBY);

		if($BD == 1)
			schedule("use(\"Beacon\");", $zOFFBY);
		if($PD == 1)
			schedule("use(\"BackPack\");", $zOFFBY);

	}
	// Incase you try to deploy, and you're in the way, you need to look up more
	else	if (%msg == "Unable to deploy - You're in the way")
	{
		$zOFFBY=$zOFFBY/1.5;

		postAction(%obj, IDACTION_LOOKUP, 0.1);
		schedule("postAction(" @ %obj @ ", IDACTION_LOOKUP, 0);", $zOFFBY);
		if($BD == 1)
			schedule("use(\"Beacon\");",$zOFFBY);
		if($PD == 1)
			schedule("use(\"BackPack\");", $zOFFBY);

	}
	else if (String::findSubStr(%msg, "deployed") != -1)
	{
		if($BD == 1) //if you just placed a beacon...
		{
			postAction(%obj, IDACTION_MOVEUP); //jump over it! useful when on the go...
		}

		$BD = 0;
		$PD = 0;
		$zOFFBY=0.4;
	}

}

//Uses Presto's Attach functions to moniter Client Messages
Event::Attach(eventClientMessage, EasyDeploy::OnClientMessage);

EditActionMap("actionMap.sae");
bindCommand(keyboard0, make, $PackDeploy, TO, "PacDeploy();");
bindCommand(keyboard0, break, $PackDeploy, TO, "PacDone();");
bindCommand(keyboard0, make, $BeaconDeploy, TO, "BeaconDeploy();");
bindCommand(keyboard0, break, $BeaconDeploy, TO, "BeaconDone();");
