// FILE:		FastINV.acs.cs
// VERSION:		1.04
// DATE:		5/14/2000
// AUTHOR:		Ben "VoOdOo" Smith
// EMAIL:		voodoo@yourmom.com
// WEBPAGE:		none. I'm getting one up real soon
//
//////////////////////////////////////////////////////////////////////////////
//--------------------------------- ABOUT: ---------------------------------//
//////////////////////////////////////////////////////////////////////////////
//
//	I got the idea from one of my teammates, [DRL] Boomer. I showed him
//	my kit.acs.cs script and he thought of an idea to make it
//	binded to his favorites keys. So here is the script.
//
//////////////////////////////////////////////////////////////////////////////
//------------------------------ DESCRIPTION: ------------------------------//
//////////////////////////////////////////////////////////////////////////////
//
//	This script replaces the "buy favs" key in Tribes. This buys your
//	favs and then buys 6 repair kits and uses them. Makes it so you can
//	get out of the Inventory Station faster.
//
//////////////////////////////////////////////////////////////////////////////
//------------------------------- FEATURES: --------------------------------//
//////////////////////////////////////////////////////////////////////////////
//
//	1. Buys your favs at Inventory Station
//	2. Buys 6 repair kits and uses them at Inventory Station
//	3. Exits the Inventory Station automatically after pushing one of
//	   the specifided buttons.
//	4. Pick what Fav you want to buy at INV station before you get to
//	   INV station.
//
//////////////////////////////////////////////////////////////////////////////
//---------------------------- VERSION HISTORY: ----------------------------//
//////////////////////////////////////////////////////////////////////////////
//
//	1.04	-Added a new feature: Pick what Favorite you want to buy at
//		 an INV station before you enter the INV station. To work
//		 this, just push one of the keys that buys your Favs at an
//		 INV station. It will set that one as the Fav to buy when
//		 you enter the next INV station. To change it just push
//		 another key that buys one of your Favs at an INV station.
//		 To disable auto buying, just push the key that auto-buying
//		 is set to.
//
//	1.03	-Added a new feature: Exits the Inventory Station
//		 automatically after pushing one of the specified buttons.
//		-Optimized code a little more allowing for faster
//		 transaction time.
//		-Made it a little more user-friendly by using "true" or
//		 "false" for defining variables instead of "0" and "1".
//		-Made it so it is compatible with my other scripts.
//
//	1.02	-Just optimized code by making it smaller and faster.
//
//	1.01	-Presto Pack 0.93 or greater is REQUIRED!!!
//		-If you pushed one of the specified buttons, it would say
//		 can't buy repair kit. Now this is fixed.
//
//	1.0	Initial version.
//
//////////////////////////////////////////////////////////////////////////////
//----------------------------- INSTALLATION: ------------------------------//
//////////////////////////////////////////////////////////////////////////////
//
//	Put VoOdOo_kit.cs into your:
//		...\tribes\config\VoOdOo
//	Then go to your:
//		...\tribes\config\
//	directory and open up your config.cs, delete these lines in it:
//	
//	bindCommand(keyboard0, make, "whatever", TO, "CmdInventoryGui::buyFavorites(1);");
//	bindCommand(keyboard0, make, "whatever", TO, "CmdInventoryGui::buyFavorites(2);");
//	bindCommand(keyboard0, make, "whatever", TO, "CmdInventoryGui::buyFavorites(3);");
//	bindCommand(keyboard0, make, "whatever", TO, "CmdInventoryGui::buyFavorites(4);");
//	bindCommand(keyboard0, make, "whatever", TO, "CmdInventoryGui::buyFavorites(5);");
//
//	where whatever = the key you use to buy your inv favorites
//	That's it. Good Luck in Tribes.
//
//	Default Keys:
//		A : Buys Inv Favs 1
//		S : Buys Inv Favs 2
//		D : Buys Inv Favs 3
//		X : Buys Inv Favs 4
//		C : Buys Inv Favs 5
//
// 	This script is configured by editing the area labeled:
//	USER CONFIGURATION SECTION
//
//////////////////////////////////////////////////////////////////////////////
//----------------------- USER CONFIGURATION SECTION -----------------------//
//////////////////////////////////////////////////////////////////////////////
//
// BUY FAVS AND REPAIR KITS KEY
// The key that buys your favs and buys and uses 6 repair kits
// Default is A,S,D,X,C. If you use a regular key, a-z, 1-0, put that 
// character in qoutes. For example, "h".
bindCommand(keyboard0, make, "a", TO, "FastINV::inAndOut(1);");
bindCommand(keyboard0, make, "s", TO, "FastINV::inAndOut(2);");
bindCommand(keyboard0, make, "d", TO, "FastINV::inAndOut(3);");
bindCommand(keyboard0, make, "x", TO, "FastINV::inAndOut(4);");
bindCommand(keyboard0, make, "c", TO, "FastINV::inAndOut(5);");
//
// EXIT INVENTORY STATION AFTER BUYING
// This will close the Inventory Station screen when you push one of your
// specified buttons.
$VoOdOoPref::exitInvAfterBuy = true;
//
//////////////////////////////////////////////////////////////////////////////
// DON'T EDIT PAST HERE UNLESS YOU'RE A SCRIPTER AND KNOW WHAT YOU'RE DOING //
//////////////////////////////////////////////////////////////////////////////
Include("Presto\\Event.cs");

Event::Attach(eventEnterStation, FastINV::buyStuff);
Event::Attach(eventExitStation, FastINV::buyStuff);

function FastINV::inAndOut($FastINV::buyFavNumber)
{
	if (!$FastINV::favRepairBuy) {
		if ($FastINV::buyOnINVEnter == $FastINV::buyFavNumber) {
			$FastINV::buyOnINVEnter = "";
			Schedule::Cancel("Client::centerPrint(\"\", 1);");
			Client::centerPrint(" Buying INV Favorites at INV on Enter is Turned Off", 1);
			Schedule::Add("Client::centerPrint(\"\", 1);", 1);
		}
		else {
			$FastINV::buyOnINVEnter = $FastINV::buyFavNumber;
			Schedule::Cancel("Client::centerPrint(\"\", 1);");
			Client::centerPrint(" Buying INV Favorites " @ $FastINV::buyFavNumber @ " at INV on Enter", 1);
			Schedule::Add("Client::centerPrint(\"\", 1);", 1);
		}
	}
	if ($FastINV::favRepairBuy) {
		CmdInventoryGui::buyFavorites($FastINV::buyFavNumber);
		remoteEval(2048, useItem, 39);
		remoteEval(2048, buyItem, 39);
		remoteEval(2048, useItem, 39);
		remoteEval(2048, buyItem, 39);
		remoteEval(2048, useItem, 39);
		remoteEval(2048, buyItem, 39);
		remoteEval(2048, useItem, 39);
		remoteEval(2048, buyItem, 39);
		remoteEval(2048, useItem, 39);
		remoteEval(2048, buyItem, 39);
		remoteEval(2048, useItem, 39);
		remoteEval(2048, buyItem, 39);
		if ($VoOdOoPref::exitInvAfterBuy) {
			remoteEval(2048, PlayMode);
			$FastINV::buyOnINVEnter = "";
			Schedule::Cancel("FastINV::inAndOut($FastINV::buyOnINVEnter);");
		}
	}
}

function FastINV::buyStuff()
{
	if ($FastINV::favRepairBuy) {
		$FastINV::favRepairBuy = false;
	}
	else {
		$FastINV::favRepairBuy = true;
		if ($FastINV::buyOnINVEnter != "") {
			Schedule::Add("FastINV::inAndOut($FastINV::buyOnINVEnter);", 0.1);
		}
	}
}

