// A little hud to display your current FPS.
// Version 1.01

include("presto\\HUD.cs");

// This defines how often (in seconds) the FPSHud should be updated.
// Keep in mind that Tribes only updates the framerate variable every
// so often.
$FPSHud::UpdateTime = 0.3;

// The position/dimensions (Presto-format) of the Hud
$FPSHud::Position = "0 60 64 16";

// Set this to the key that toggles FPSHud on/off
$FPSHud::ToggleKey = "control f";

function FPSHud::Update(%hud) {
	Hud::AddText(%hud, "<f1>" @ $ConsoleWorld::FrameRate);
	return $FPSHud::UpdateTime;
}

function FPSHud::Init() {
	if (!HUD::Exists(FPSHud)) {
		HUD::New(FPSHud, "FPSHud::Update", $FPSHud::Position);
		HUD::Display(FPSHud);
	} else {
		HUD::Move(FPSHud, $FPSHud::Position);
		HUD::Display(FPSHud);
	}
}

// Override ShowFps, since the HUD does the same thing anyway. Just 
// display the HUD.
function ShowFps() {
	HUD::Display(FPSHud);
}

event::attach(eventConnected, "FPSHud::Init");

bindkey(play, $FPSHud::ToggleKey, "HUD::ToggleDisplay(FPSHud);");