//
//
//    *----------------*
//    |  Tribes Racer  |
//    *----------------*
// 
//
//  Created by:
//		Nathan Sweet aka [HvC]NaTeDoGG
//                   author of HaVoC:  http://havoc.sirris.com
//
//  (c) 2000 All rights reserved.
//
//  Client side functions.  See below to set up your buttons!
//
// ---------------------------------------------------


$Racer::Shields = "k";
//Set this to the button you want to use to turn on your vehicle's
//shields.

$Racer::RearView = "j";
//Set this to the button you want to be your rearview mirror button. This
//allows you to look behind your vehicle.

$Enhanced = 0.004;
//Set this to the sensitivity you want while controlling vehicles, etc.
//Adjust the number if you find that it is too sensitive or not sensitive
//enough.

//Thats all you need to do.  Refer to the reademe file for more instructions.

//Nathan Sweet
//aka [HvC]NaTeDoGG





























//DO NOT EDIT BELOW THIS LINE

EditActionMap("playMap.sae");

bindCommand(keyboard0, make, $Racer::Shields, TO, "useBeacon();");
bindCommand(keyboard0, break, $Racer::Shields, TO, "");

bindCommand(keyboard0, make, $Racer::RearView, TO, "rearview();");
bindCommand(keyboard0, break, $Racer::RearView, TO, "rearview();");

$Normal = Client::getMouseSensitivity("playMap.sae");
if($Enhanced <= 0) $Enhanced = 0.004;
function remoteSetControls(%client, %flag) {
	if(%flag) {
		$Normal = Client::getMouseSensitivity("playMap.sae");
		setSensitivity($Enhanced);
		echo("Mouse sensitivity set to " @ $Enhanced @ " (enhanced).");
	} else {
		setSensitivity($Normal);
		echo("Mouse sensitivity set to " @ $Normal @ " (normal).");		
	}
}

$isRacer = false;
function remoteSetRacer(%cl) {
	$isRacer = true;
	echo("Racer scripts enabled.");
}

function useBeacon() {
	if($isRacer)
		remoteEval(2048, forceUse, "Beacon");
	else
		use("Beacon");
}

function rearview() {
	if($isRacer)
		remoteEval(2048, mirrorLook);
}

function setSensitivity(%sensitivity) {
    if(Client::getMouseXaxisFlip("playMap.sae")) {
        EditActionMap("playMap.sae");
        bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Scale, %sensitivity);
    } else {
        EditActionMap("playMap.sae");
        bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Flip, Scale, %sensitivity);
    }
	if(Client::getMouseYaxisFlip("playMap.sae")) {
        EditActionMap("playMap.sae");
        bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Scale, %sensitivity);
    } else {
        EditActionMap("playMap.sae");
        bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Flip, Scale, %sensitivity);
    }
}

function onExit()
{
	setSensitivity($Normal);

   if(isObject(playGui))
      storeObject(playGui, "config\\play.gui");

   saveActionMap("config\\config.cs", "actionMap.sae", "playMap.sae", "pdaMap.sae");

	//update the video mode - since it can be changed with alt-enter
	$pref::VideoFullScreen = isFullScreenMode(MainWindow);

	echo("exporting pref::* to prefs.cs");
   export("pref::*", "config\\ClientPrefs.cs", False);
   export("Server::*", "config\\ServerPrefs.cs", False);
   export("pref::lastMission", "config\\ServerPrefs.cs", True);
   BanList::export("config\\banlist.cs");
}

remoteEval(2048, isRacerServer);

function remoteResetRacer(%cl) {
	$isRacer = False;
	echo("Racer scripts disabled.");
}
