//===============================================================
// noPickup.cs  -- 6/15/00 --
//
// v0.9.0
//
// Author: Brett "Gnight" Burton (brett425@wa.freei.net)
//
// This script automatically throws unwanted weapons 
// automatically picked up (Such as the blaster). Useful when 
// searching for certian weapons among dead bodies. :)
//
// $AutoUse[xyz] is SERVER SIDE... YOY!! (sarcastic of course)
//
//===============================================================


// --- INCLUDES ---

include("presto\\event.cs");

// --- CONFIGURATION ---

// Here you can set what weapon will be mounted after we have dropped our shiat.
// If you set $noPickup::useSelectedWeapon to false, noPickup will select the best
// weapon in your arsenal. If it is set to true, will first try to use selected weapon,
// and if you don't have that weapon, will ready "best" weapon (see below).
$noPickup::useSelectedWeapon = true;
$noPickup::selectedWeapon = "Disc Launcher";

// These are used in nopickup::getbestweapon();
// You can rearrange (just rearange the numbers) these to suit your needs, 
// you will ready on of these when you drop a weapon and you don't have the 
// preselected weapon in your inventory. It will start at the top and work 
// it's way down. 
$noPickup::inventory[1] = "Mortar";
$noPickup::inventory[2] = "Disc Launcher";
$noPickup::inventory[3] = "Grenade Launcher";
$noPickup::inventory[4] = "Chaingun";
$noPickup::inventory[5] = "Laser Rifle";
$noPickup::inventory[6] = "Plasma Gun";
$noPickup::inventory[7] = "Blaster";
$noPickup::inventory[8] = "ELF Gun";

// --- CODE ---

function noPickup::init() {
	if (isFile("config\\GnightPrefs.cs")) Include("GnightPrefs.cs");
	
	if ($GnightPref::noPickup::enabledByDefault) $noPickup::activated = true;
	else $noPickup::activated = false;
	
	noPickup::setGuns();
	noPickup::setPacks();
	
	Event::Attach(ladderClientMessage, noPickup::ladderClientMessage);
	Event::Attach(eventWeaponReceived, "noPickup::scheduleDrop(0.1);");
	Event::Attach(eventPackReceived, "noPickup::scheduleDrop(0.1);");
	Event::Attach(eventClientChangeTeam, "noPickup::scheduleDrop(1);");
	Event::Attach(eventFirePressed, "noPickup::scheduleDrop(0.5);");
	
	$noPickup::version = "0.9.0";
}

function noPickup::setDefaults() {
	// Toggle on/off button
	$GnightPref::noPickup::toggle = "numpad7";
	
	// Activated by Default?
	$GnightPref::noPickup::enabledByDefault = true;
	
	// Key that forces noPickup::drop()
	$GnightPref::noPickup::forceDrop = "numpad8";
}

// Simple. Gets info set by the NewOpts weapon checkboxes and uses that info 
// to set the variables that I actually use to drop stuff. Same story for noPickup::setPacks()...
function noPickup::setGuns() {
	if ($GnightPref::noPickup::CheckBoxBlaster) $noPickup[1] = "Blaster";
	else $noPickup[1] = "";
	if ($GnightPref::noPickup::CheckBoxPlasma)  $noPickup[2] = "Plasma Gun";
	else $noPickup[2] = "";
	if ($GnightPref::noPickup::CheckBoxChain)   $noPickup[3] = "Chaingun";
	else $noPickup[3] = "";
	if ($GnightPref::noPickup::CheckBoxDisc)    $noPickup[4] = "Disc Launcher";
	else $noPickup[4] = "";
	if ($GnightPref::noPickup::CheckBoxGrenade) $noPickup[5] = "Grenade Launcher";
	else $noPickup[5] = "";
	if ($GnightPref::noPickup::CheckBoxLaser)   $noPickup[6] = "Laser Rifle";
	else $noPickup[6] = "";
	if ($GnightPref::noPickup::CheckBoxELF)     $noPickup[7] = "ELF Gun";
	else $noPickup[7] = "";
	if ($GnightPref::noPickup::CheckBoxMortar)  $noPickup[8] = "Mortar";
	else $noPickup[8] = "";
}

function noPickup::setPacks() {
	if ($GnightPref::noPickup::CheckBoxAmmo)   $noPickupPack[1] = "Ammo Pack";
	else $noPickupPack[1] = "";
	if ($GnightPref::noPickup::CheckBoxShield) $noPickupPack[2] = "Shield Pack";
	else $noPickupPack[2] = "";
	if ($GnightPref::noPickup::CheckBoxEnergy) $noPickupPack[3] = "Energy Pack";
	else $noPickupPack[3] = "";
	if ($GnightPref::noPickup::CheckBoxJammer) $noPickupPack[4] = "Sensor Jammer Pack";
	else $noPickupPack[4] = "";
	if ($GnightPref::noPickup::CheckBoxRepair) $noPickupPack[5] = "Repair Pack";
	else $noPickupPack[5] = "";
}

function noPickup::toggle() {
	if ($noPickup::activated) {
		$noPickup::activated = false;
		remoteBP(2048, "\t\tNo Pickup has been: <f1>Disabled", 3);
		return;
	}
	if (!$noPickup::activated) {
		$noPickup::activated = true;
		noPickup::drop();
		remoteBP(2048, "\t\tNo Pickup has been: <f1>Enabled", 3);
		return;
	}
}

function noPickup::forceDrop() {
	if (!$noPickup::activated) {
		$noPickup::activated = true;
		%enabled = true;
	}
	noPickup::drop();
	if (%enabled) $noPickup::activated = false;
}

function noPickup::ladderClientMessage(%msg) {	
	if (String::findSubStr(%msg, "Match started.") != -1) noPickup::scheduleDrop(0.1);

	return false;
}

function noPickup::scheduleDrop(%time) {
	schedule::add("noPickup::drop();", %time);
}

function noPickup::drop() {
	if ($noPickup::activated) {
	
		// Here is were we actually drop the stuff
		for (%i = 1; %i <= 8; %i++) {
			if ($noPickup[%i] != "" && getItemCount($noPickup[%i])) {
				drop($noPickup[%i]);
				$gainedBadWeapon = true;
			}
			if (getItemCount($noPickupPack[%i]) && $noPickupPack[%i] != "") {
				drop($noPickupPack[%i]);
			}
		}
		if ($noPickup::useSelectedWeapon == "true" && $gainedBadWeapon == "true") {
			if (getItemCount($noPickup::selectedWeapon)) use($noPickup::selectedWeapon);
			else schedule::add("noPickup::getBestWeapon();", 0.1);
			$gainedBadWeapon = false;
		} else schedule::add("noPickup::getBestWeapon();", 0.1);
	}
}

function noPickup::getBestWeapon() {
	if ($gainedBadWeapon) {
		for (%i = 1; %i >= 8; %i++) {
			if (getItemCount($noPickup::inventory[%i])) {
				use($noPickup::inventory[%i]);
				$gainedBadWeapon = false;
				return;
			}
		}
	}
}

noPickup::init();


// --- PRESTO BANNER ---

Presto::AddScriptBanner(noPickup,
	" <f2>noPickup <jr><f0>version " @ $noPickup::version @ " \n\n" @
	" <f1><jc>Select what you don't\nwant to pickup!\n\n" @
	" <f0>Now supports NewOpts!\n\n" @
	" <f0>Written by: <f1>Gnight\n" @
	" <f1>gnight@earthlink.net");


// --- NEWOPTS ---

function noPickup::onOpen() {}
	
function noPickup::onClose() {
	export("$GnightPref::*", "config\\GnightPrefs.cs", false);
	if ($GnightPref::noPickup::enabledByDefault) $noPickup::activated = true;
	else $noPickup::activated = false;
	noPickup::setGuns();
	noPickup::setPacks();
}

NewOpts::register("noPickup", "noPickup.gui", "noPickup::onOpen();", "noPickup::onClose();", TRUE);
			    
function noPickup::NewOptsHelp() {
	%pagename = "noPickup";

	%topic = "Author";
	%text = "noPickup written by Gnight\n" @ "<f0>(gnight@earthlink.net<f1>";
	NewOpts::registerHelp(%pagename, %topic, %text);

	%topic = "Enable by default checkbox";
	%text = "Check this if you want noPickup to be automagically activated when you join a game. If left unchecked you will have to manually turn noPickup on.";
	NewOpts::registerHelp(%pagename, %topic, %text);
	
	%topic = "Toggle Key";
	%text = "This is the button that toggles noPickup on and off. Useful if you have set noPickup to drop weapons that you _sometimes_ want to use.";
	NewOpts::registerHelp(%pagename, %topic, %text);

	%topic = "Force Key";
	%text = "This is the key that will force noPickup to drop all marked weapons even when noPickup is disabled.";
	NewOpts::registerHelp(%pagename, %topic, %text);

	%topic = "Weapon Checkboxes";
	%text = "Here you need to check all weapons that you do NOT want to pick up when noPickup is enabled.";
	NewOpts::registerHelp(%pagename, %topic, %text);
		
	%topic = "Pack Checkboxes";
	%text = "Here you need to check all backpacks that you do NOT want to pick up when noPickup is enabled.";
	NewOpts::registerHelp(%pagename, %topic, %text);
	
	%topic = "KNOWN BUGS";
	%text = "If you pick up an unwanted weapon when you are FIRING a weapon noPickup will not drop that weapon.";
	NewOpts::registerHelp(%pagename, %topic, %text);
}

noPickup::NewOptsHelp();


// --- KEY BINDING ---

bindkey(play, $GnightPref::noPickup::Toggle, "noPickup::toggle();");
bindkey(play, $GnightPref::noPickup::forceDrop, "noPickup::forceDrop();");





