// OMEGA.cs: Online Messaging - Easy Graphical Assiatant
// _____________________________________________________
// By: VKTR (jimmy@home.com)	v1.1

// Note : this USED to be two seperate scripts - EZAnimate and
// QuickSay, but they got integrated, slapped into a nice NewOpts
// interface, and given a new name.
// For reasons of keeping me sane, the function/variable "class" references
// have been left alone.

include("presto\\say.cs");

function EZAnimate::Animation(%index) {
	%sound = $EZAnimate::SndFile[$EZAnimate::Sound[%index]];
	%anim = $EZAnimate::Animnum[$EZAnimate::Animation[%index]];

	remoteEval(2048, PlayAnim, %anim);
	localmessage(%sound);
}

function EZAnimate::SetSound() {
	$EZAnimate::Sound[$EZAnimate::Selected] = FGCombo::GetSelected("EZAnimate::AnimSound");
}

function EZAnimate::SetAnim() {
	$EZAnimate::Animation[$EZAnimate::Selected] = FGCombo::GetSelected("EZAnimate::Anim");
}

// does EZAnimate stuff, as well as QuickSay stuff
function EZAnimate::AddDataToLists() {
	// Load data into ComboBoxes and init to Anim #1

	FGCombo::clear("EZAnimate::Selection");
	FGCombo::clear("QuickSay::Selection");
	for (%i = 1; %i <= 20; %i++) {
		FGCombo::AddEntry("EZAnimate::Selection", "Animation #" @ %i, %i-1);
		$EZAnimate::Sound[%i-1] = 0;
		$EZAnimate::Animation[%i-1] = 0;

		FGCombo::AddEntry("QuickSay::Selection", "Message #" @ %i, %i-1);
		$QuickSay::Sound[%i-1] = 0;
		$QuickSay::Text[%i-1] = "";
		$QuickSay::Team[%i-1] = false;
	}

	FGCombo::clear("EZAnimate::Anim");
	for (%i = 0; %i < $EZAnimate::NumAnims; %i++) {
		FGCombo::AddEntry("EZAnimate::Anim", $EZAnimate::AnimName[%i], %i);
	}

	FGCombo::clear("EZAnimate::AnimSound");
	FGCombo::clear("QuickSay::TextSound");
	for (%i = 0; %i < $EZAnimate::NumSounds; %i++) {
		FGCombo::AddEntry("EZAnimate::AnimSound", $EZAnimate::SndName[%i], %i);
		FGCombo::AddEntry("QuickSay::TextSound", $EZAnimate::SndName[%i], %i);
	}

	if (isFile("config\\OMEGAdata.cs"))
		exec("OMEGAdata.cs");

	$EZAnimate::Selected = 0;
	$QuickSay::Selected = 0;
}

function EZAnimate::RegisterAnimation(%name, %animnum) {
	if ($EZAnimate::NumAnims == "")
		$EZAnimate::NumAnims = 0;

	// Don't register duplicate animations :)
	if ($EZAnimate::NumAnims > 0)
		for (%i = 0; %i < $EZAnimate::NumAnims; %i++)
			if (($EZAnimate::AnimName[%i] == %name) || ($EZAnimate::AnimNum[%i] == %animnum))
				return;

	$EZAnimate::AnimName[$EZAnimate::NumAnims] = %name;
	$EZAnimate::AnimNum[$EZAnimate::NumAnims] = %animnum;
	$EZAnimate::NumAnims++;
}

function EZAnimate::RegisterSound(%name, %filename) {
	if ($EZAnimate::NumSounds == "")
		$EZAnimate::NumSounds = 0;

	// Don't register duplicate animations :)
	if ($EZAnimate::NumSounds > 0)
		for (%i = 0; %i < $EZAnimate::NumSounds; %i++)
			if (($EZAnimate::SndName[%i] == %name) || ($EZAnimate::SndFile[%i] == %filename))
				return;

	$EZAnimate::SndName[$EZAnimate::NumSounds] = %name;
	$EZAnimate::Sndfile[$EZAnimate::NumSounds] = %filename;
	$EZAnimate::NumSounds++;
}

function EZAnimate::OnOpen() {
	FGCombo::SetSelected("EZAnimate::Selection", $EZAnimate::Selected);

	FGCombo::SetSelected("EZAnimate::Anim", $EZAnimate::Animation[$EZAnimate::Selected]);
	FGCombo::SetSelected("EZAnimate::AnimSound", $EZAnimate::Sound[$EZAnimate::Selected]);
}

// re-used this function to write QuickSay info as well.
function EZAnimate::OnClose() {
	export("$EZAnimate::Animation*", "config\\OMEGAdata.cs", false);
	export("$EZAnimate::Sound*", "config\\OMEGAdata.cs", true);

	// QuickSay stuff
	export("$QuickSay::Sound*", "config\\OMEGAdata.cs", true);
	export("$QuickSay::Text*", "config\\OMEGAdata.cs", true);
	export("$QuickSay::Team*", "config\\OMEGAdata.cs", true);
}

function EZAnimate::SetSelectedAnim() {
	$EZAnimate::Selected = FGCombo::GetSelected("EZAnimate::Selection");

	// Same code anyway, so why not re-use it?
	EZAnimate::OnOpen();
}

NewOpts::register("OMEGA Animations", "Config\\VeKToR\\gui\\OMEGA_Anim.gui", "EZAnimate::OnOpen();", "EZAnimate::OnClose();", true);

// END EZAnimate code - begin QuickSay code

function QuickSay::Text(%index) {
	%sound = "~w" @ $EZAnimate::SndFile[$QuickSay::Sound[%index]];
	if ($QuickSay::Text[%index] == "")
		return;

	if ($QuickSay::Team[%index])
		%team = 1;
	else
		%team = 0;


	remoteEval(2048, Say, %team, $QuickSay::Text[%index] @ %sound);
}

function QuickSay::SetSound() {
	$QuickSay::Sound[$QuickSay::Selected] = FGCombo::GetSelected("QuickSay::TextSound");
}

function QuickSay::SetQuickText() {
	$QuickSay::Text[$QuickSay::Selected] = Control::GetValue("QuickSay::TextValue");
}

function QuickSay::SetTeam(%on) {
	$QuickSay::Team[$QuickSay::Selected] = %on;
}

function QuickSay::OnOpen() {
	FGCombo::SetSelected("QuickSay::Selection", $QuickSay::Selected);
	FGCombo::SetSelected("QuickSay::TextSound", $QuickSay::Sound[$QuickSay::Selected]);
	Control::SetValue("QuickSay::TeamMessage", $QuickSay::Team[$QuickSay::Selected]);
	Control::SetValue("Quicksay::TextValue", $QuickSay::Text[$QuickSay::Selected]);
}

function QuickSay::SetSelectedSay() {
	$QuickSay::Selected = FGCombo::GetSelected("QuickSay::Selection");

	QuickSay::OnOpen();
}

NewOpts::register("OMEGA Messages", "Config\\VeKToR\\gui\\OMEGA_Msg.gui", "QuickSay::OnOpen();", "EZAnimate::OnClose();", true);

include("VeKToR\\OMEGAHelp.cs");

// Sound Registration - taken from Presto's Say.cs (I need different info than his provides -
// ie a count and cross-reference between text name and filename). He should get all the
// credit for these sound definitions (as I was too lazy to look up the wavfiles and what
// they all say myself)

EZAnimate::RegisterSound("<NONE>", "");

// -------ATTACK SOUNDS-----
EZAnimate::RegisterSound("Attack!", "attack");
EZAnimate::RegisterSound("Attack! #2", "attac2");
EZAnimate::RegisterSound("Attack Enemy Base", "attbase");
EZAnimate::RegisterSound("Attack Enemy", "attenem");
EZAnimate::RegisterSound("Go on Offense", "gooff");
EZAnimate::RegisterSound("Going Offense", "ono");

// ------BASE INFO SOUNDS------
EZAnimate::RegisterSound("Is Base Clear?", "isbsclr");
EZAnimate::RegisterSound("Base Secure", "bsclr2");
EZAnimate::RegisterSound("Base Taken", "basetkn");
EZAnimate::RegisterSound("Enemy Attacking", "basundr");

// ------MISC CHAT-------
EZAnimate::RegisterSound("Thanks", "thanks");
EZAnimate::RegisterSound("No Problem", "noprob");
EZAnimate::RegisterSound("Hey!", "wshoot1");
EZAnimate::RegisterSound("Bye", "bye");
EZAnimate::RegisterSound("Hi", "hello");
EZAnimate::RegisterSound("Yes", "yes");
EZAnimate::RegisterSound("No", "no");
EZAnimate::RegisterSound("Sorry!", "sorry");
EZAnimate::RegisterSound("I don't know", "dontkno");
EZAnimate::RegisterSound("Hmm...", "color3");

// ------COMMAND SOUNDS-----
EZAnimate::RegisterSound("Acknowledged", "acknow");
EZAnimate::RegisterSound("Belay Order", "belay");
EZAnimate::RegisterSound("Board APC", "boarda");
EZAnimate::RegisterSound("Order Cancelled", "ordcan");
EZAnimate::RegisterSound("Objective Complete", "objcomp");
EZAnimate::RegisterSound("Destroy Generator", "desgen");
EZAnimate::RegisterSound("Destroy Turret", "destur");
EZAnimate::RegisterSound("Unable to Complete", "objxcmp");

// ------BATTLE ORDERS--------
EZAnimate::RegisterSound("Cease Fire!", "cease");
EZAnimate::RegisterSound("Cover Me!", "coverme");
EZAnimate::RegisterSound("Hit the Deck", "hitdeck");
EZAnimate::RegisterSound("Outta my Way", "outway");
EZAnimate::RegisterSound("Move Out!", "moveout");
EZAnimate::RegisterSound("Over Here!", "ovrhere");
EZAnimate::RegisterSound("Proceed Ahead", "proceed");
EZAnimate::RegisterSound("Ready", "ready");
EZAnimate::RegisterSound("Regroup!", "regroup");
EZAnimate::RegisterSound("Retreat!", "retreat");
EZAnimate::RegisterSound("Stop!", "stop");
EZAnimate::RegisterSound("Take Cover!", "takcovr");
EZAnimate::RegisterSound("Wait...", "wait1");
EZAnimate::RegisterSound("Waiting...", "wait2");
EZAnimate::RegisterSound("Wait for signal", "waitsig");

// --------DEFENSE----------
EZAnimate::RegisterSound("Being Attacked", "basatt");
EZAnimate::RegisterSound("Defend Base", "defbase");
EZAnimate::RegisterSound("Go Defensive", "godef");
EZAnimate::RegisterSound("Defending Base", "defend");
EZAnimate::RegisterSound("Incoming!", "incom2");
EZAnimate::RegisterSound("Need Defense", "needdef");

// --------DEPLOY-----------
EZAnimate::RegisterSound("Deploy Ammo Stn.", "depamo");
EZAnimate::RegisterSound("Deploy Beacon", "depbecn");
EZAnimate::RegisterSound("Deploy Camera", "depcam");
EZAnimate::RegisterSound("Deploy Inv. Stn.", "depinv");
EZAnimate::RegisterSound("Deploy Jammer", "depjamr");
EZAnimate::RegisterSound("Deploy M. Sensor", "depmot");
EZAnimate::RegisterSound("Deploy P. Sensor", "deppuls");
EZAnimate::RegisterSound("Deploy Turret", "deptur");

// ---------FLAG STUF--------
EZAnimate::RegisterSound("Clear Mines", "clrflg");
EZAnimate::RegisterSound("Get Enemy Flag!", "geteflg");
EZAnimate::RegisterSound("Have Enemy Flag", "haveflg");
EZAnimate::RegisterSound("Mine Flag", "mineflg");
EZAnimate::RegisterSound("Flag is Mined", "flgmine");
EZAnimate::RegisterSound("Flag not in Base", "flagtkn1");
EZAnimate::RegisterSound("Return Flag", "retflag");
EZAnimate::RegisterSound("Flag Secure", "flaghm");
EZAnimate::RegisterSound("Enemy has flag", "flagtkm2");

// ---------NEEDS------------
EZAnimate::RegisterSound("Bring Ammo", "needamo");
EZAnimate::RegisterSound("Need APC", "needpku");
EZAnimate::RegisterSound("Need Escort", "needesc");
EZAnimate::RegisterSound("Need Repairs", "needrep");
EZAnimate::RegisterSound("Hurry w/ Station", "hurystn");

// --------OBJECTIVES--------
EZAnimate::RegisterSound("Attack Objective", "attobj");
EZAnimate::RegisterSound("Capture Objective", "capobj");
EZAnimate::RegisterSound("Clear Mines From Obj", "clrobj");
EZAnimate::RegisterSound("Defend Objective", "defobj");
EZAnimate::RegisterSound("Get Objective", "getobj");
EZAnimate::RegisterSound("Objective Mined", "mineobj");
EZAnimate::RegisterSound("Repair Objective", "repobj");

// ---------STATUS-----------
EZAnimate::RegisterSound("Gen Destroyed", "gendes");
EZAnimate::RegisterSound("Turret Destroyed", "turdes");
EZAnimate::RegisterSound("APC Ready...", "waitpas");

// --------TARGETING---------
EZAnimate::RegisterSound("Fire on Target", "firetgt");
EZAnimate::RegisterSound("Target Acquired", "tgtacq");
EZAnimate::RegisterSound("Target Location", "tgtobj");
EZAnimate::RegisterSound("Out of Range", "tgtout");
EZAnimate::RegisterSound("Need target", "needtgt");

// --------TAUNTS-----------
EZAnimate::RegisterSound("Yoo-Hoo!", "taunt1");
EZAnimate::RegisterSound("How'd that Feel?", "taunt10");
EZAnimate::RegisterSound("I've had worse", "taunt11");
EZAnimate::RegisterSound("Missed Me!", "taunt2");
EZAnimate::RegisterSound("Dance!", "taunt3");
EZAnimate::RegisterSound("Come Get Some!", "taunt4");

// -----WAYPOINT SOUNDS-----
EZAnimate::RegisterSound("Attack Waypoint", "attway");
EZAnimate::RegisterSound("Defend Waypoint", "defway");
EZAnimate::RegisterSound("Escort Friendly", "escfr");
EZAnimate::RegisterSound("Go to Waypoint", "goway");
EZAnimate::RegisterSound("Pilot APC to Wpt.", "wpilot");
EZAnimate::RegisterSound("Repair Player", "repplyr");
EZAnimate::RegisterSound("Repair Item", "repitem");

// ------YELL SOUNDS--------
EZAnimate::RegisterSound("Shazbot!", "color2");
EZAnimate::RegisterSound("Dammit!", "color6");
EZAnimate::RegisterSound("Ahh, crap!", "color7");
EZAnimate::RegisterSound("Duh!", "dsgst1");
EZAnimate::RegisterSound("You Idiot!", "dsgst2");
EZAnimate::RegisterSound("Watch Shooting", "wshoot3");
EZAnimate::RegisterSound("Argh!", "dsgst4");
EZAnimate::RegisterSound("*sigh*", "dsgst5");
EZAnimate::RegisterSound("D'oh!", "oops1");
EZAnimate::RegisterSound("Oops...", "oops2");
EZAnimate::RegisterSound("Yeah!", "cheer1");
EZAnimate::RegisterSound("Woo-Hoo!", "cheer2");
EZAnimate::RegisterSound("All Right!", "cheer3");
EZAnimate::RegisterSound("Help!", "help");

// Throw additional (voicepack, perhaps) sounds in here.
// ---\/-----\/-----\/-----\/---Add your own sounds in here ---\/-----\/-----\/-

// ---/\-----/\-----/\-----/\----------------------------------/\-----/\-----/\-

// _____________________________________________________________________________
// --------------------------------ANIMATIONS-----------------------------------
EZAnimate::RegisterAnimation("<NONE>", -1);
EZAnimate::RegisterAnimation("Wave Arms", 0);
EZAnimate::RegisterAnimation("Point", 1);
EZAnimate::RegisterAnimation("Swing Arm", 2);
EZAnimate::RegisterAnimation("Hold up arm", 3);
EZAnimate::RegisterAnimation("Salute", 4);
EZAnimate::RegisterAnimation("Celebrate 1", 5);
EZAnimate::RegisterAnimation("Celebrate 2", 6);
EZAnimate::RegisterAnimation("Celebrate 3", 7);
EZAnimate::RegisterAnimation("Taunt 1", 8);
EZAnimate::RegisterAnimation("Taunt 2", 9);
EZAnimate::RegisterAnimation("Kneel Pose", 10);
EZAnimate::RegisterAnimation("Stand Pose", 11);
EZAnimate::RegisterAnimation("Wave", 12);

EZAnimate::AddDataToLists();