//---------------------------------------------------------------------------
// Grinder's Remote Flag Script
// Version:	1.1
// Category:	Flag Support
// Credits:	[KoN]Ender, for his TeamWaypoint Script, which contains a
//		kind of Remote Flag Script. I also had the idea for this script
//		when the Silencer Script came out and the "[KoN]Porkey
//		has taken our flag" Messages are muted. So there must be
//		another way to be annouced of flag grabs, drops and caps.
//---------------------------------------------------------------------------
$GrinderVersion::RemoteFlag = "1.1";

if(isFile("config\\RemoteFlagPrefs.cs"))
	exec("RemoteFlagPrefs.cs");
else {
	$GrinderPrefs::Flag::Toggle = true; }

function Grinder::Flag::Message(%client, %msg)
{
	if($GrinderPrefs::Flag::Toggle)
	{
		%yourflag = Team::GetFlagLocation(Team::Friendly());
		%enemyflag = Team::GetFlagLocation(Team::Enemy());
//		if(String::findSubStr(%msg, "You took the") != -1)
//		{
//			if(String::findSudStr(%msg, "flag") != -1)
//			{
//				remoteBP(2048, "<jc>You took the enemy flag", 1);
//			}
//		}
		if(String::findSubStr(%msg, "Your team's flag has been taken") != -1)
		{
			remoteBP(2048, "<jc><f1>" @ %yourflag @ "<f0> has taken your flag.", 4);
		}
		if(String::findSubStr(%msg, "Your team has the") != -1)
		{
			if(String::findSubStr(%msg, "flag") != -1)
			{
				if(%enemyflag == Client::getName(getManagerId()))
				{
					remoteBP(2048, "<jc><f1>You have taken the enemy flag", 3);
				}
				else
				{
					remoteBP(2048, "<jc><f1>" @ %enemyflag @ "<f0> has taken the enemy flag.", 4);
				}
			}
		}
		if(String::findSubStr(%msg, "Your flag was dropped in the field") != -1)
		{
			remoteBP(2048, "<jc>Your flag was dropped. Try to return it!", 4);
		}
		if(String::findSubStr(%msg, "flag was dropped in the field") != -1)
		{
				remoteBP(2048, "<jc>" @ %msg, 4);
		}
		if(String::findSubStr(%msg, "Your team captured the flag") != -1)
		{
			remoteBP(2048, "<jc>Your team captured the enemy flag", 4);
		}
		if(String::findSubStr(%msg, "Your team's flag was captured") != -1)
		{
			remoteBP(2048, "<jc>Your flag was captured by the enemy team", 4);
		}
		if(String::findSubStr(%msg, "Your flag was returned to base") != -1)
		{
			remoteBP(2048, "<jc>Your flag was returned to base. Secure it", 4);
		}
	}
}

function Grinder::Flag::Toggle()
{
	if($GrinderPrefs::Flag::Toggle)
	{
		$GrinderPrefs::Flag::Toggle = false;
		remoteBP(2048, "<jc>You <f1>disabled<f0> the <f1>Remote Flag<f0> Script", 1);
	}
	else
	{
		$GrinderPrefs::Flag::Toggle = true;
		remoteBP(2048, "<jc>You <f1>enabled<f0> the <f1>Remote Flag<f0> Script", 1);
	}
}

function Grinder::Flag::Quit()
{
	export("$GrinderPrefs::Flag*", "config\\RemoteFlagPrefs.cs", false);
}

function Grinder::Flag::PrestoBanner()
{
	Presto::AddScriptBanner(RemoteFlag, " Remote Flag Script\n by <f1>Grinder<f0>\n Version: <f1>" @ $GrinderVersion::RemoteFlag @ "\n\n<f0> Bug Report to:\n<f1> Grinder.Tribes@gmx.de");
}

Event::Attach(eventExit, Grinder::Flag::Quit);
Event::Attach(eventClientMessage, Grinder::Flag::Message, %client, %msg);

bindCommand(keyboard0, MAKE, shift, "]", TO, "Grinder::Flag::Toggle();");

Grinder::Flag::PrestoBanner();