$InvList[DeployableComPack] = 1;
$MobileInvList[DeployableComPack] = 1;
$RemoteInvList[DeployableComPack] = 1;
AddItem(DeployableComPack);

$CanAlwaysTeamDestroy[DeployableComStation] = 1;

ItemImageData DeployableComPackImage 
{
	shapeFile = "ammounit_remote";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.3 };
	mountRotation = { 0, 0, 0 };
	mass = 4.5;
	firstPerson = false;
};

ItemData DeployableComPack 
{
	description = "Command Station";
	shapeFile = "ammounit_remote";
	className = "Backpack";
	heading = $InvHead[ihDOb];
	shadowDetailMask = 4;
	imageType = DeployableComPackImage;
	mass = 4.0;
	elasticity = 0.2;
	price = $RemoteComEnergy + 200;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function DeployableComPack::deployShape(%player,%item) 
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] >= $TeamItemMax[%item] && !$build) 
	{
		Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
		return false;
	}
	if(!GameBase::getLOSInfo(%player,3))
	{
		Client::sendMessage(%client,0,"Deploy position out of range");
		return false;
	}
	%obj = getObjectType($los::object);
	if(%obj != "SimTerrain" && %obj != "InteriorShape" && GameBase::getDataName($los::object) != "DeployablePlatform") 
	{
		Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
		return false;
	}

// check if object is in motion, for dropships and jail cell -plasmatic
	%obj = $los::object;
	if(%obj.inmotion == true)	 
	{ 
		Client::sendMessage(%client,0,"Deploy area crappy, cannot deploy.");
		return false;
	}
		
	if(Vector::dot($los::normal,"0 0 1") <= 0.7) 
	{
		Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
		return false;
	}
	if(!checkInvDeployArea(%client,$los::position)) 
		return false;
	%inv = newObject("comunit_remote","StaticShape","DeployableComStation",true);

	%inv.cloakable = true;	//for base cloaker
	addToSet("MissionCleanup/deployed/station", %inv);
	%rot = GameBase::getRotation(%player);
	GameBase::setTeam(%inv,GameBase::getTeam(%player));
	GameBase::setPosition(%inv,$los::position);
	GameBase::setRotation(%inv,%rot);
	Gamebase::setMapName(%inv,"Command Station");
	Client::sendMessage(%client,0,"Command Station deployed");
	playSound(SoundPickupBackpack,$los::position);
	$TeamItemCount[GameBase::getTeam(%inv) @ "DeployableComPack"]++;
	%inv.deployer = %client; 	//for destroy points, bk messages -plasmatic
	echo("MSG: ",%client," deployed a Command Station");
	return true;
}

StaticShapeData DeployableComStation 
{	description = "Remote Command Station";
	shapeFile = "cmdpnl";
	className = "DeployableStation";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateCommandStation };
	sequenceSound[1] = { "power", SoundCommandStationPower };
	sequenceSound[2] = { "use", SoundUseCommandStation };
	maxDamage = 1.0;
	debrisId = flashDebrisMedium;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	triggerRadius = 1.5;
	castLOS = true;
	supression = false;
	supressable = false;
	explosionId = flashExpLarge;
};

function DeployableComStation::onAdd(%this) 
{
	$StaticShape::count += 1;
	schedule("DeployableStation::deploy(" @ %this @ ");",1,%this);
	if(GameBase::getMapName(%this) == "") 
		GameBase::setMapName (%this, "R-Com Station");
	%this.Energy = 3000;
}

function DeployableComStation::OnActivate(%this) 
{
	if(GameBase::isActive(%this)) 
	{
		%player = Station::getTarget(%this);
		if(%player != -1 && %this.lastPlayer = %player) 
		{
			%client = Player::getClient(%player);
			if(%this.target != %client) 
			{
				%this.target = %client;
				%player.CommandTag = 1;
				Client::setGuiMode(%client,2);
				Client::sendMessage(%client,0,"Command Access On");
			}
			schedule("DeployableComStation::onActivate(" @ %this @ ");",0.5,%this);
			return;
		}
		GameBase::setActive(%this,false);
	}
	if(%this.target) 
	{
		Client::sendMessage(%this.target,0,"Command Access Off");
		%this.target.CommandTag = 0;
	}
	(Client::getOwnedObject(%this.target)).Station = "";
	%this.target = "";
}
