$InvList[LaserWallPack] = 1;
$MobileInvList[LaserWallPack] = 1;
$RemoteInvList[LaserWallPack] = 1;
AddItem(LaserWallPack);

$CanAlwaysTeamDestroy[LaserWallBeacon] = 1;

ItemImageData LaserWallPackImage 
{
	shapeFile = "sensor_small";
	mountPoint = 2;
  	mountOffset = { 0, -0.1, 0.2 };
  	mountRotation = { 1.0, -3.14, 0};
	firstPerson = false;	
};

ItemData LaserWallPack 
{
	description = "Laser Wall";
	shapeFile = "sensor_small";
	className = "Backpack";
	heading = $InvHead[ihBar];
	imageType = LaserWallPackImage;
	shadowDetailMask = 4;
	mass = 1.5;
	elasticity = 0.2;
	price = 600;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function LaserWallPack::deployShape(%player,%item) 
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] >= $TeamItemMax[%item] && !$build) 
	{
		Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
		return false;
	}
	if(!GameBase::getLOSInfo(%player,4)) 
	{
		if(!$build)Client::sendMessage(%client,0,"Deploy position out of range");
		GameBase::playSound(%player, SoundPackUse, 0);
		return false;
	}

// check if object is in motion, for dropships and jail cell -plasmatic
	%obj = $los::object;
	if(%obj.inmotion == true && !$Build)	 
	{ 
		Client::sendMessage(%client,0,"Deploy area crappy, cannot deploy.");
		return false;
	}
	
		
	%rot = GameBase::getRotation(%player);//floor

	if (Vector::dot($los::normal,"0 0 -1") > 0.6) 
	{
		%prot = GameBase::getRotation(%player);
		%xRot = getWord(%prot,0);
		%yRot = getWord(%prot,1);
		%zRot = getWord(%prot,2);			
		%rot =  %xRot + 3.14159@" " @%yRot@" "@%zRot;//ceiling...
		%up = true;
	}	
	
	%platform = newObject("LaserWallBeacon", "StaticShape", LaserWallBeacon, true);
	%platform.cloakable = true;

	addToSet("MissionCleanup/deployed/Barrier", %platform);
//	%rot = GameBase::getRotation(%player);
	GameBase::setTeam(%platform, GameBase::getTeam(%player));
	GameBase::setPosition(%platform, $los::position);
	GameBase::setRotation(%platform, %rot);
	Gamebase::setMapName(%platform, "Laser beacon "@Client::getName(%client));
	if(!$build)
		Client::sendMessage(%client,0,"Laser beacon deployed.");
	GameBase::startFadeIn(%platform);
	playSound(SoundPickupBackpack,$los::position);
	$TeamItemCount[GameBase::getTeam(%player) @ "LaserWallPack"]++;
	
	if(!$build)
		echo("MSG: ",%client," deployed a Laser beacon");
	return true;
}

StaticShapeData LaserWallBeacon 
{
//	className = "Beacon";
	damageSkinData = "objectDamageSkins";

	shapeFile = "sensor_small";
	maxDamage = 0.1;
	maxEnergy = 200;

	castLOS = true;
	supression = false;
	mapFilter = 2;
	//mapIcon = "M_marker";
	visibleToSensor = true;
	explosionId = flashExpSmall;
	debrisId = flashDebrisSmall;
};

function LaserWallBeacon::onDestroyed(%this) 
{
	if(!$NoCalcDamage)
		calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 2, 0.40, 0.1, 250, 100);
	$TeamItemCount[GameBase::getTeam(%this) @ "LaserWallPack"]--;
}

function LaserWallBeacon::onCollision(%this,%object)
{
	if($debug) 
		event::collision(%this,%object);
		
	if(getObjectType(%object) == "Flier") 
	{ 
		%data = GameBase::getDataName(%object);
		if($debug)
			echo(%data@" hitting "@GameBase::getDataName(%this));
			
		%damage = GameBase::getDamageLevel(%object) + 0.01;
		GameBase::setDamageLevel(%object,%damage);
		playSound(SoundFlierCrash,GameBase::getPosition(%object));
	}
}

function LaserWallBeacon::onAdd(%this) 
{
	%Group = newObject("LaserBeacon"@%this, SimGroup);
	addToSet("MissionCleanup", %Group);

	schedule("LaserWallBeacon::initiate("@%this@");",0.5);	
		
}

function LaserWallBeacon::onremove(%this) 
{
 	%set = nameToID("MissionCleanup/LaserBeacon"@%this);
	if(%set != -1)	
		schedule("deleteobject("@%set@");",0.01);		

}

function laserWallBeacon::initiate(%this)
{
	%pos = vector::add(GameBase::getPosition(%this),"0 0 0.5");
	%thisData = GameBase::getDataName(%this);
	%type = getObjectType(%this);
//	messageall(1,"adding "@%this@" type ="@%type@%pos);
	%set=newObject("set",SimSet);
	
//	%Mask = $SimPlayerObjectType|$StaticObjectType|$MineObjectType;
	containerBoxFillSet(%set, $StaticObjectType, %Pos, 30, 30, 30,0);
	%num = Group::objectCount(%set);	
	
	for(%i = 0; %i < %num; %i++)
	{
		echo(%i);
		%obj = Group::getObject(%set,%i);
		%data = GameBase::getDataName(%obj);
		if(%this != %obj && %thisdata == %data)
		{
			if(!%s)
				%s = %obj;
			if(%s != %obj)
			{
				//pick the closest one
				%pt = GameBase::getPosition(%this);
				%po = GameBase::getPosition(%obj);
				%ps = GameBase::getPosition(%s);
				
				if(vector::getdistance(%pt,%po) < vector::getdistance(%pt,%ps))
					%s = %obj;
			}	
		}
		

		
	}
	deleteObject(%set);	
	handshake(%this,%s);
	
	if(GameBase::getLOSInfo(%this,5,"1.5708 0 0"))	//look up
	{	
		// GetLOSInfo sets the following globals:
		// 	los::position
		// 	los::normal
		// 	los::object
		%start = $los::position;
	}	
	else
		%start = vector::add(GameBase::getPosition(%this),"0 0 5");
		
	%vec = Vector::Normalize(Vector::Sub(%pos,%start));
//	messageall(1,"huzaa! "@$los::position);			
	%obj = newobject("", "item", "RepairKit", 1, false);	

	%proj = Projectile::spawnProjectile("WallLaser","0 0 0 "@ %vec @" 0 0 1 "@%start,%obj,%vel);

	addtoset("MissionCleanup/LaserBeacon"@%this, %proj);
	deleteobject(%obj);	
	
}
LaserData WallLaser
{
	laserBitmapName = "laserPulse.bmp";
	damageConversion = 0.0;
	baseDamageType = 0;
	lightRange = 0.0;
	lightColor = { 1, 1, 1 };
	detachFromShooter = false;
};
LaserData OrangeLaser
{
	laserBitmapName = "orange.flag.bmp"; 
	damageConversion = 0.0;
	baseDamageType = 0;
	lightRange = 0.0;
	lightColor = { 1, 1, 1 };
	detachFromShooter = false;
};
LaserData BlueLaser
{
	laserBitmapName = "solar.bmp";	//radar.bmp"; //white
	damageConversion = 0.0;
	baseDamageType = 0;
	lightRange = 0.0;
	lightColor = { 1, 1, 1 };
	detachFromShooter = false;
};
LaserData RedWhiteLaser
{
	laserBitmapName = "won64.bmp";	//opengl only
	damageConversion = 0.0;
	baseDamageType = 0;
	lightRange = 0.0;
	lightColor = { 1, 1, 1 };
	detachFromShooter = false;
};
LaserData TestLaser
{
	laserBitmapName = "paintpulse.bmp";	//radar.bmp"; //white
	damageConversion = 0.0;
	baseDamageType = 0;
	lightRange = 0.0;
	lightColor = { 1, 1, 1 };
	detachFromShooter = false;
};
//bitch ass beams won't render when longer than visible distance. 
function beam(%start,%end,%through)
{
	//echo("beam "@%start@", "@%end);
	%vec = Vector::Normalize(Vector::Sub(%end,%start));

	if(%through)	//getlosinfo(%start,%end,1))
	{
		//point to point through anything, will connect to last position of $missioncam's trans. 
		// will not render if longer than maps visible distance
		%rot = vector::getrotation(vector::neg(%nor));
		//Ok, time to trick tribes with Voodoo
		
		%rot = vector::getrotation(vector::neg(%vec));
		GameBase::setPosition($MissionCam,%start);	//%start
		GameBase::setRotation($MissionCam,%rot);	
		
		//connect the dots. 
		%proj = Projectile::spawnProjectile("TestLaser","0 0 0 0 0 0 0 0 1 "@%start,$MissionCam,0);
//		addtoset("MissionCleanup/LasirBeems", %proj);	
				
			

	}


	else
	{
		//point to point, will always render, but only as long as visible dist. 
		%Endobj = newObject("", "StaticShape", DeployableForce, true);
		//newObject("Camera","Turret",CameraTurret,true);
		//newObject("DeployablePlatform", "StaticShape", DeployablePlatform, true);
		//newobject("", "item", "RepairKit", 1, true);	//getObjectByTargetIndex(0);	//
		GameBase::setPosition(%Endobj,%end);
		
		%obj = newobject("", "item", "RepairKit", 1, true);
		
		//TurretLaser
		%proj = Projectile::spawnProjectile("TestLaser","0 0 0 "@ %vec @" 0 0 1 "@%start,%obj,%vel);
	//	addtoset("MissionCleanup/LasirBeems/"@%this, %proj);
		deleteobject(%Endobj);
		deleteobject(%obj);	
	}
	
	return %proj;
}


function handshake(%this,%obj)
{
	//Plasmatic Finishing touches 2/21/2006 7:11AM
//	messageall(1,"huzaa brother!");
	%pos1 = GameBase::getPosition(%this);
	%pos2 = GameBase::getPosition(%obj);
	
	for(%i=0.75; %i < 10.75; %i++)
	{
		%e = %i*0.5;
		%posA = vector::add(%pos1,"0 0 "@%e);
		%posB = vector::add(%pos2,"0 0 "@%e);
		if(!getlosinfo(%posA,%PosB,1))
		{
			%proj = beam(%posA,%posB);
			addtoset("MissionCleanup/LaserBeacon"@%this, %proj);
			addtoset("MissionCleanup/LaserBeacon"@%obj, %proj);
			
			
		}
	}
	

}