$InvList[PortableGeneratorPack] = 1;
$MobileInvList[PortableGeneratorPack] = 1;
$RemoteInvList[PortableGeneratorPack] = 1;
AddItem(PortableGeneratorPack);

ItemImageData PortableGeneratorPackImage 
{
	shapeFile = "generator_p";
	mountPoint = 2;
	mountOffset = { 0, -0.65, -0.4 };
	mass = 5.0;
	firstPerson = false;
};

ItemData PortableGeneratorPack
{
	description = "Portable Generator";
	shapeFile = "generator_p";
	classname = "Backpack";
	heading = $InvHead[ihPwr];
	imageType = PortableGeneratorPackImage;
	shadowDetailMask = 4;
	mass = 4.5;
	elasticity = 0.2;
	price = 2500;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

StaticShapeData PortableGenerator
{
	description = "Portable Generator";
	shapeFile = "generator_p";
	classname = "Generator";
	debrisId = flashDebrisSmall;
	sfxAmbient = SoundGeneratorPower;
	maxDamage = 1.8;
	mapIcon = "M_generator";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	explosionId = flashExpMedium;
	visibleToSensor = true;
	mapFilter = 4;
	shieldShapeName = "shield";
};

function PortableGeneratorPack::deployShape(%player,%item)
{
	%team = GameBase::getTeam(%player);
	%client = Player::getClient(%player);

	if($TeamItemCount[GameBase::getTeam(%player) @ %item] >= $TeamItemMax[%item])
	{
		Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %descr);
		return false;
	}
	if(!GameBase::getLOSInfo(%player,5)) 
	{
		Client::sendMessage(%client,0,"Deploy position out of range");
		return false;
	}
	%obj = getObjectType($los::object);
	if(%obj != "SimTerrain" && %obj != "InteriorShape") 
	{
		Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
		return false;
	}

// check if object is in motion, for dropships and jail cell -plasmatic
	%obj = $los::object;
	if(%obj.inmotion == true)	 
	{ 
		Client::sendMessage(%client,0,"Deploy area crappy, cannot deploy.");
		return false;
	}
		
	if(Vector::dot($los::normal,"0 0 1") <= 0.7)
	{
		Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
		return false;
	}
	if(!checkDeployArea(%client,$los::position)) 
	{
		Client::sendMessage(%client,0,"Cannot deploy here");
		return false;
	}
	%obj = newObject("Portable Generator","StaticShape","PortableGenerator",true);

	%obj.cloakable = true;
	if($debug) Echo($Ver,"|Created New Object :",%obj," ","Portable Generator");
	
	//GameBase::playSequence(%obj,1,"deploy");
	//GameBase::SetActive(%obj,false);
	
// old power code here -plasmatic	
//	Generator::CreateSimGroup(%team);
//	%group = newObject("PoweredB"@%team,SimGroup);
//	addToSet("MissionCleanup",%group);
	
	//new power code here -plasmatic
//	schedule("Ann::AddtoPowerGrid("@%obj@");",getRandom()*6 + 2);	//plasmatic 2.3
	addToSet("MissionCleanup/deployed/power", %obj);
	
	
	GameBase::setTeam(%obj,%team);
	//addToSet("MissionCleanup", %obj);
	//addToSet("MissionGroup/Teams/Team" @ %team, %obj);
	
	GameBase::setPosition(%obj,$los::position);
	GameBase::setRotation(%obj,GameBase::getRotation(%player));
	Gamebase::setMapName(%obj,"Portable Generator");
	Client::sendMessage(%client,0,"Portable Generator deployed");
	playSound(SoundCreateItem,$los::position);
	$TeamItemCount[%team @ %item]++;
	return true;
}


function PortableGenerator::onAdd(%this)
{
	$StaticShape::count += 1;
}

function PortableGenerator::onDestroyed(%this)
{	
	if($trace) echo($ver,"| PortableGenerator::onDestroyed");
	PortableGenerator::onDisabled(%this);
	StaticShape::objectiveDestroyed(%this);
	%this.cloakable = false;
	%this.nuetron = "";
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 3, 0.55, 0.30, 250, 170);
	$TeamItemCount[GameBase::getTeam(%this) @ "PortableGeneratorPack"]--;
}

function PortableGenerator::onEnabled(%this)
{	
	if($trace) echo($ver,"| PortableGenerator::onEnabled ",%this);
	GameBase::setActive(%this,true);
	GameBase::playSequence(%this,0,"power");
	schedule("Ann::Powering("@%this@",true);",3);	//ann 2.3 power -plasmatic
	GameBase::generatePower(%this, true);
	GameBase::isPowerGenerator(%this);
}

function PortableGenerator::onDisabled(%this)
{	
	if($trace) echo($ver,"| PortableGenerator::onDisabled ",%this);
	GameBase::stopSequence(%this,0);
	
	Ann::Powering(%this,false);	//ann 2.3 power -plasmatic	
 	GameBase::generatePower(%this, false);
 	//DisconnectGenerator(%this);
}
function PortableGenerator::onremove(%this)
{
 	Ann::Powering(%this,false);	//ann 2.3 power -plasmatic
}

