// __________________________________________________________________________
// ServerConfig.cs
// Sets all options for your server. Must be executed from autoexec.cs
// (see config\autoexec-example.cs)
// __________________________________________________________________________
//
// All lists work in that way. You first have to indicate the number of 
// entries you have in the list using the count variable. Then you enter
// each one of the entries, from 1 to "count".
// For example, an empty list would be:
//		$RegularAdminCount=0;
// A list with only one entry would be:
//		$RegularAdminCount=1;
//		$RegularAdminPassword[1]="regularadminpassword1";
// A list with three entries would be:
//		$RegularAdminCount=3;
//		$RegularAdminPassword[1]="regularadminpassword1";
//		$RegularAdminPassword[2]="regularadminpassword2";
//		$RegularAdminPassword[3]="regularadminpassword3";
// Please not that only items displayed as (LIST) are really lists. For 
// instance, there is only ONE super admin password, and it is not working
// as a list.
//
// All admins should configure this file entirely, until the 
// "END OF CONFIGURATION" message at the bottom of this file. It is important
// that the admin configures and tests the server appropriately before 
// making it public.
// __________________________________________________________________________

// Super Admin password
// Gives 'S' super admin
$AdminPassword="superadminpassword";

// Trusted Admin password
// Gives 'M' trusted admin
$TrustedAdminCount=1;
$TrustedAdminPassword[1]="trustedadminpassword";

// Regular Admin password
// Gives 'A' admin
$RegularAdminCount=1;
$RegularAdminPassword[1]="regularadminpassword";

// Admin password usage restrictions
// If enabled, a player must have his name registered in the list in order
// to be able to gain admin through the use of an admin password, except
// if his/her IP is in the exception list.
$AdminPasswordNameLookupEnable = 0;                            // Set to 0 to disable, or 1 to enable
$AdminPasswordNameLookupCount = 1;                             // Authorized name list count
$AdminPasswordNameLookup[01] = "Complete Player Name";
$AdminPasswordNameLookupExceptionIPCount = 1;                  // Exception List
$AdminPasswordNameLookupExceptionIP[1] = "IP:aa.bb.cc.dd";     //    IP address

// Unadmin myself password
$UnadminPassword = "unadmin";

// Kick password 
// When someone enters that password, the server kicks him
$KickMyselfCount=1;
$KickMyselfPassword[1]="iwanttokickmyself?";
                                          
// Auto-Kick IP list 
// Automatically kick these people when they join. Takes precedence over anything.
$AutoKickIPListCount=1;
$AutoKickIPList[1] = "IP:aa.bb.cc.dd";       
$AutoKickIPListDuration = 86400;             // Kick for a day

// NoAdmin IP list
// People on this list can not be admined.
$NoAdminIPListCount=1;
$NoAdminIPList[1] = "IP:aa.bb.cc.dd";

// Auto-Admin IP list
// Automatically give 'A' admin when player connects
$AutoAdminIPListCount=1;
$AutoAdminIPList[1] = "IP:aa.bb.cc.dd";

// Protected IP list
// These people can not be kicked/banned, whether or not they are admin
$ProtectedIPListCount=1;
$ProtectedIPList[1] = "IP:aa.bb.cc.dd";

// Admin options
$MapDuelOnlySuperAdmin = 0;                 // (v2.4+) Only SADs can change/vote to duel missions
$TrustedAdminCanSetServerPassword = 0;      // (v2.4+) Trusted admins can change server join password
$TrustedAdminCanStripRegularAdmin = 1;      // (v2.4+) Trusted admins can strip regular admins
$TrustedAdminCanNotBeKicked = 1;            // (v2.4+) Trusted admins can not be kicked by regular admins
$AdminKickTimeSeconds = 180;                // (v2.4+) Time a kick lasts (in seconds)
$AdminKickPasswordTimeSeconds = 180;        // (v2.4+) Time a kick lasts when player used kick password (in seconds)
$AdminBanTimeSeconds = 86400;               // (v2.4+) Time a ban lasts (in seconds)
$AdminPermaBanTimeSeconds = 86400000;       // (v2.4+) Time a perma-ban lasts (in seconds)
$OnlySuperAdminCanChangeReadyUp = 1;        // (v2.4+) Only SADs can enable/disable Ready Up
$OnlySuperAdminCanChangeAutoJoin = 1;       // (v2.4+) Only SADs can enable/disable Auto Join Team
$OnlySuperAdminCanChangeTimeLimit = 1;      // (v2.4+) Only SADs can change time limit
$OnlySuperAdminCanResetServer = 1;          // (v2.4+) Only SADs can reset server to defaults
$AllAdminsCanChangeLockedPlayerTeam = 1;    // (v2.4+) Any admin can unlock a player
$AllAdminsCanVoteMaps = 1;                  // (v2.4+) Any admin can also vote for new maps
$WarnAdminsWhenTKer = 1;                    // (v2.4+) Warn all admins when a player is TKing badly
$KickBlankPlayers = 1;                      // (v2.4+) Kick players with blank names, eg: "  "
$KickBlankPlayersDuration = 600;            // (v2.4+) Kick players with blank names (Duration of kick)
$MapVoteIncrementalDelay = 30;              // (v2.4+) Incremental delay before being able to RE-vote for a new map
$RegularPlayersCanNotVoteMapsPubMode = 0;   // (v2.4+) Regular players can note start mission change votes in Public Mode
$PubAdminsMayNotChangePubMatchMode = 1;     // (v2.8+) Public admins (voted, passworded or admined) may not change Public<->Match mode
$ReplaceTabMenuPlayerInfoByStats = 1;       // (v2.9+) Replace regular tab menu player info (name, tribe, email) by statistics (requires LizStats)
$UseNewScoringSystem = 1;                   // (v3.0+) Use the new score system (Kill/Death) instead of the old system (Score)
$DisplayTeamStatsInTabMenu = 1;             // (v3.0+) Display kills and deaths per team in Tab menu too
$SniperRifleLimitInPubMode = 3;             // (v3.0+) Limits the number of rifles to # in pub mode (3 is suggested, 0 or < 0 to disable)
$AutoObsAFKers = 1;                         // (v3.0+) Automatically put AFKers in observer in pub mode
$DisableReadyUpTimer = 1;                   // (v3.0+) Disable the ready up timer in pub mode (not needed anymore with AFK being obs'd automatically)
$TabMenuExploitKickTimeSeconds = 1200;      // (v3.0+) Duration of kick for people who attempt to use the Tab Menu exploit
$ArenaFixedWinningScore = 1;                // (v3.0+) Winning score can not be changed anymore in Pub Mode (1 to enable, 0 to disable)
$ArenaMaxNumberOfAdmins = 3;                // (v3.0+) Maximum number of admins on the server, or -1 to disable limit, or 0 to prevent anyone from adminning anyone else (only for admin adminning someone else)
$ArenaAutoEvenTeams = 1;                    // (v3.0+) Automatically even teams master switch (1: enable, 0: disable)

// Old depreciated options (for your information)
//$WarnAdminsWhenTeamsAreUneven = 1;        // (v2.4+) Warn all admins when teams are not even. Removed in v3.0 (auto-even teams)

// LizStats
$LizStatsEnable = 1;         // Master switch
$LizStatsMap = 1;            // Keep map stats (saved & restored)
$LizStatsServer = 1;         // Keep server stats (saved & restored)
$LizStatsSaveAfterMap = 1;   // 1=Save stats after every map, 0=Save only when server properly exits with quit();

// Server options
$WarnTKersWithTheirTotalTKCount = 1;                     // Warn TKers that they have X TKs
$FixInventorySpamExploit = 1;                            // Fix the litterbug exploit (litterbug can still be used)
$FixInventorySpamExploitMaxBuyCountPerInvenVisit = 75;   // Max. number of purchases per inventory visit (the higher, the most dangerous, recommanded = 75)

// Telnet options
$TelnetPort=2001;                           // Telnet console port
$TelnetPassword="telnetpassword";           // Telnet console password

// Network options
$pref::PacketRate = 15;
$pref::PacketSize = 300;

// Sets console logging mode
// 0=No Logging, 1=immediate write, 2=lazy write
$console::logmode=1;

// Mission List (Arena)
MissionList::clear();
MissionList::addMission("The ArenA");
MissionList::addMission("NoQuarterArena");
MissionList::addMission("No-Rail Arena");
MissionList::addMission("HotelArena");
MissionList::addMission("Mono-Rail Arena");
MissionList::addMission("BoxedIn");
MissionList::addMission("IveHadWorse");
MissionList::addMission("FreakyStyley");
MissionList::addMission("Dune_Arena");
MissionList::addMission("Duelist");
MissionList::addMission("TheArenaDownUnder");
MissionList::addMission("Tombstone");
MissionList::addMission("CenterHill");
MissionList::addMission("BlastsideArena");
MissionList::addMission("Whacked");
MissionList::addMission("Arena_02");
MissionList::addMission("Arena_01");
MissionList::addMission("ArenA-D");
MissionList::addMission("CloseQuarters");
MissionList::addMission("Enclosure");
MissionList::addMission("ArenaUnderTheMountain");
MissionList::addMission("Full_Force_Arena");
MissionList::addMission("InOrOut");
MissionList::addMission("OpiVille");
MissionList::addMission("TheArenaRunsCold2");
MissionList::addMission("TheCastleWithin");
MissionList::addMission("TheForgottenCave");
MissionList::addMission("arena_hell");
MissionList::addMission("WalledUnder");
MissionList::addMission("Arena-DangerousCrossing");
MissionList::addMission("TheArenaRunsCold");
MissionList::addMission("ThunderArena");
MissionList::addMission("TooCloseForComfort");
MissionList::addMission("AreciboArena");
MissionList::addMission("A Safe Warm Place");
MissionList::addMission("WalledIn");
MissionList::addMission("Morena");
MissionList::addMission("Arena_Madness");
MissionList::addMission("Gonrena");
MissionList::addMission("DesertRats");
MissionList::addMission("Damn_Arena");
MissionList::addMission("LazArena");
MissionList::addMission("ArenaUnderTheHill");


// Sets the mission to load on startup.
Server::loadMission("LazArena");
$pref::LastMission = "LazArena";


// ### END OF CONFIGURATION ###


// LizStats - Load module if lizStats is enabled (MUST BE AFTER MISSION ADDS)
if ($LizStatsEnable == 1)
{
   exec("lizStats.cs");
   LizStats::StartUp();
}

