$PlayerAnim::Crouching = 25;
$PlayerAnim::DieChest = 26;
$PlayerAnim::DieHead = 27;
$PlayerAnim::DieGrabBack = 28;
$PlayerAnim::DieRightSide = 29;
$PlayerAnim::DieLeftSide = 30;
$PlayerAnim::DieLegLeft = 31;
$PlayerAnim::DieLegRight = 32;
$PlayerAnim::DieBlownBack = 33;
$PlayerAnim::DieSpin = 34;
$PlayerAnim::DieForward = 35;
$PlayerAnim::DieForwardKneel = 36;
$PlayerAnim::DieBack = 37;
$PlayerAnim::FirstDeath = $PlayerAnim::DieChest;
$PlayerAnim::LastDeath = $PlayerAnim::DieBack;
$CorpseTimeoutValue = 22;

function Player::onAdd(%this) 
{
  GameBase::setRechargeRate(%this,8);
}

function Player::onRemove(%this) 
{
  for (%i = 0; %i < 8; %i = %i + 1) 
  {
    %type = Player::getMountedItem(%this,%i);
    if (%type != -1) 
    {
      %item = newObject("","Item",%type,1,false);
      schedule("Item::Pop(" @ %item @ ");", $ItemPopTime, %item);
      addToSet("MissionCleanup", %item);
      GameBase::setPosition(%item,GameBase::getPosition(%this));
    }
  }
}

function Player::onNoAmmo(%player,%imageSlot,%itemType) 
{
  }

function Player::onKilled(%this) 
{
  %cl = GameBase::getOwnerClient(%this);
  %cl.dead = 1;
  if($AutoRespawn > 0) schedule("Game::autoRespawn(" @ %cl @ ");",$AutoRespawn,%cl);
//if(%this.outArea==1) leaveMissionAreaDamage(%cl);
  Player::setDamageFlash(%this,0.75);
  for (%i = 0; %i < 8; %i = %i + 1) 
  {
    %type = Player::getMountedItem(%this,%i);
    if (%type != -1) 
    {
      if (%i != $WeaponSlot || !Player::isTriggered(%this,%i) || getRandom() > "0.5") Player::dropItem(%this,%type);
    }
    }
  if(%cl != -1) 
  {
//---- Move to vehicle.cs
    if(%this.vehicle != "") 
    {
      if(%this.driver != "") 
      {
        %this.driver = "";        
        %this.vehicle.Pilot = "";
        Client::setControlObject(Player::getClient(%this), %this);
        Player::setMountObject(%this, -1, 0);

//        schedule(%this.vehicle @ "::onUnPilot(" @ %this.vehicle @ ", " @ %this @ ");", 0, %this.vehicle);
          GameBase::virtual(%this.vehicle, onUnPilot, %this.vehicle, %this);
      }
      else 
      {
        %this.vehicle.Seat[%this.vehicleSlot-2] = "";
        %this.vehicleSlot = "";
      }
      %this.vehicle = "";
    }
//----

    schedule("GameBase::startFadeOut(" @ %this @ ");", $CorpseTimeoutValue, %this);
    Client::setOwnedObject(%cl, -1);
    Client::setControlObject(%cl, Client::getObserverCamera(%cl));
    Observer::setOrbitObject(%cl, %this, 5, 5, 5);
    schedule("deleteObject(" @ %this @ ");", $CorpseTimeoutValue + 2.5, %this);
    %cl.observerMode = "dead";
    %cl.dieTime = getSimTime();
  }
}

function Player::onDamage(%this,%type,%value,%pos,%vec,%mom,%vertPos,%quadrant,%object) 
{
  if (Player::isExposed(%this)) 
  {
    %damagedClient = Player::getClient(%this);
    %shooterClient = %object;
    Player::applyImpulse(%this,%mom);
    if($teamplay && %damagedClient != %shooterClient && Client::getTeam(%damagedClient) == Client::getTeam(%shooterClient) ) 
    {
      if (%shooterClient != -1) 
      {
        %curTime = getSimTime();
        if ((%curTime - %this.DamageTime > 3.5 || %this.LastHarm != %shooterClient) && %damagedClient != %shooterClient && $Server::TeamDamageScale > 0) 
        {
          if(%type != $MineDamageType) 
          {
            Client::sendMessage(%shooterClient,0,"You just harmed Teammate " @ Client::getName(%damagedClient) @ "!");
            Client::sendMessage(%damagedClient,0,"You took Friendly Fire from " @ Client::getName(%shooterClient) @ "!");
          }
          else
          {
            //Client::sendMessage(%shooterClient,0,"You just harmed Teammate " @ Client::getName(%damagedClient) @ " with your mine!");
            //Client::sendMessage(%damagedClient,0,"You just stepped on Teamate " @ Client::getName(%shooterClient) @ "'s mine!");
          }
          %this.LastHarm = %shooterClient;
          %this.DamageStamp = %curTime;
        }
        }
      %friendFire = $Server::TeamDamageScale;
    }
    else if(%type == $ImpactDamageType && Client::getTeam(%object.clLastMount) == Client::getTeam(%damagedClient)) %friendFire = $Server::TeamDamageScale;
    else %friendFire = 1.0;
    if (!Player::isDead(%this)) 
    {
      %armor = Player::getArmor(%this);
      if((%vertPos == "head") && (%type == $LaserDamageType || %type == $SniperDamageType)) 
      {
        if(%armor == "harmor")
        {
          if(%quadrant == "middle_back" || %quadrant == "middle_front" || %quadrant == "middle_middle")
          {
            %value += (%value * 0.3);
          }
          }
        else
        {
          %value += (%value * 0.3);
        }
        }
      if (%type != -1 && %this.shieldStrength)
      {
        %energy = GameBase::getEnergy(%this);
        %strength = %this.shieldStrength;
        if (%type == $ShrapnelDamageType || %type == $MortarDamageType) %strength *= 0.75;
        if (%type == $ElectricityDamageType)
        {
          %strength *= 0.0;
        }
        %absorb = %energy * %strength;
        if (%value < %absorb)
        {
          GameBase::setEnergy(%this,%energy - ((%value / %strength)*%friendFire));
          %thisPos = getBoxCenter(%this);
          %offsetZ =((getWord(%pos,2))-(getWord(%thisPos,2)));
          GameBase::activateShield(%this,%vec,%offsetZ);
          %value = 0;
        }
        else
        {
          GameBase::setEnergy(%this,0);
          %value = %value - %absorb;
        }
        }

       // Handle long-term side effects
      %armor = Player::getArmor(%this);
      if (Client::getTeam(%damagedClient) != Client::getTeam(%shooterClient) || $Deathmatch)
      {
        if (%type == $FlashDamageType)
          Shock_Damage(%damagedClient, %this);
        else if (%type == $EnergyDamageType)
          eval(%armor @ "::onPoison(" @ %damagedClient @ ", " @ %this @ ");");
        else if (%type == $PlasmaDamageType)
          eval(%armor @ "::onBurn(" @ %damagedClient @ ", " @ %this @ ");");
	else if (%type == $FeedBackDamageType)
	  FeedBack_Damage(%damagedClient, %this);
	else if (%type == $BlindDamageType)
	  Blind_Damage(%damagedClient, %this);
	else if (%type == $BroodDamageType)
	  Brood_Damage(%damagedClient, %this);
      }

      if (%value)
      {
        %armor = Player::getArmor(%this);
        %hitdamageval = 0.05;
        if(%armor == "harmor") %hittolerance = 0.25;
        else %hittolerance = 0.25;
        %weaponType = Player::getMountedItem(%this,$WeaponSlot);
        if((Player::getMountedItem(%this,$BackpackSlot) == SuicidePack))
        {
          if( ((%type == $LaserDamageType) || (%type == $SniperDamageType) ) && (%quadrant == "middle_back" || %quadrant == "middle_front" || %quadrant == "middle_middle") && (Client::getTeam(%damagedClient) != Client::getTeam(%shooterClient)))
          {
            MessageAllExcept(Player::getClient(%damagedClient), 0, Client::getName(%shooterClient) @ " sniped the huge bomb on " @ Client::getName(%damagedClient) @ "'s back!");
            Client::sendMessage(Player::getClient(%damagedClient),0,"Your Suicide Pack exploded!");
            Player::unmountItem(%this,$BackpackSlot);
            %obj = newObject("","Mine","Suicidebomb");
            addToSet("MissionCleanup", %obj);
            GameBase::throw(%obj,%this,9 * %client.throwStrength,false);
          }
          }
        if ((%vertPos == "torso") && (%quadrant == "front_right") && (%type == $LaserDamageType) && (%value > %hittolerance) && (%weaponType != -1 && %weaponType != "RepairGun"))
        {
          Player::dropItem(%this,%weaponType);
          %dlevel = GameBase::getDamageLevel(%this) + 0.05;
          Client::sendMessage(Player::getClient(%shooterClient),0, "You shot the " @ %weaponType @ " out of " @ Client::getName(%damagedClient) @ "'s hand!");
        }
        else 
        {
          %value = $DamageScale[%armor, %type] * %value * %friendFire;
          %dlevel = GameBase::getDamageLevel(%this) + %value;
        }
        %spillOver = %dlevel - %armor.maxDamage;
        GameBase::setDamageLevel(%this,%dlevel);
        %flash = Player::getDamageFlash(%this) + %value * 2;
        if (%flash > 0.75) %flash = 0.75;
        Player::setDamageFlash(%this,%flash);
        if(!Player::isDead(%this)) 
        {
          if(%damagedClient.lastDamage < getSimTime()) 
          {
            %sound = radnomItems(3,injure1,injure2,injure3);
            playVoice(%damagedClient,%sound);
            %damagedClient.lastdamage = getSimTime() + 1.5;
          }
          }
        else 
        {
          if((%spillOver > 0.5 && (%type== $ExplosionDamageType || %type == $ShrapnelDamageType || %type== $MortarDamageType || %type == $MissileDamageType)) || %type == $ElectricityDamageType) 
          {
            Player::trigger(%this, $WeaponSlot, false);
            %weaponType = Player::getMountedItem(%this,$WeaponSlot);
            if(%weaponType != -1) Player::dropItem(%this,%weaponType);
            Player::blowUp(%this);
          }
          else 
          {
            if ((%value > 0.40 && (%type== $ExplosionDamageType || %type == $ShrapnelDamageType || %type== $MortarDamageType || %type == $MissileDamageType )) || (Player::getLastContactCount(%this) > 6) ) 
            {
              if(%quadrant == "front_left" || %quadrant == "front_right") %curDie = $PlayerAnim::DieBlownBack;
              else %curDie = $PlayerAnim::DieForward;
            }
            else if( Player::isCrouching(%this) ) %curDie = $PlayerAnim::Crouching;
            else if(%vertPos=="head") 
            {
              if(%quadrant == "front_left" || %quadrant == "front_right" ) %curDie = radnomItems(2, $PlayerAnim::DieHead, $PlayerAnim::DieBack);
              else %curDie = radnomItems(2, $PlayerAnim::DieHead, $PlayerAnim::DieForward);
            }
            else if (%vertPos == "torso") 
            {
              if(%quadrant == "front_left" ) %curDie = radnomItems(3, $PlayerAnim::DieLeftSide, $PlayerAnim::DieChest, $PlayerAnim::DieForwardKneel);
              else if(%quadrant == "front_right") %curDie = radnomItems(3, $PlayerAnim::DieChest, $PlayerAnim::DieRightSide, $PlayerAnim::DieSpin);
              else if(%quadrant == "back_left" ) %curDie = radnomItems(4, $PlayerAnim::DieLeftSide, $PlayerAnim::DieGrabBack, $PlayerAnim::DieForward, $PlayerAnim::DieForwardKneel);
              else if(%quadrant == "back_right") %curDie = radnomItems(4, $PlayerAnim::DieGrabBack, $PlayerAnim::DieRightSide, $PlayerAnim::DieForward, $PlayerAnim::DieForwardKneel);
            }
            else if (%vertPos == "legs") 
            {
              if(%quadrant == "front_left" || %quadrant == "back_left") %curDie = $PlayerAnim::DieLegLeft;
              if(%quadrant == "front_right" || %quadrant == "back_right") %curDie = $PlayerAnim::DieLegRight;
            }
            Player::setAnimation(%this, %curDie);
          }
          if(%type == $ImpactDamageType && %object.clLastMount != "") %shooterClient = %object.clLastMount;
          Client::onKilled(%damagedClient,%shooterClient, %type);
        }
      }
    }
  }
}

function radnomItems(%num, %an0, %an1, %an2, %an3, %an4, %an5, %an6)
{
  return %an[floor(getRandom() * (%num - 0.01))];
}

function Player::onCollision(%this,%object)
{
  if (Player::isDead(%this))
  {
    if (getObjectType(%object) == "Player")
    {
      %sound = false;
      %max = getNumItems();
      for (%i = 0; %i < %max; %i = %i + 1)
      {
        %count = Player::getItemCount(%this,%i);
        if (%count)
        {
          %delta = Item::giveItem(%object,getItemData(%i),%count);
          if (%delta > 0)
          {
            Player::decItemCount(%this,%i,%delta);
            %sound = true;
          }
          }
        }
      if (%sound)
      {
        playSound(SoundPickupItem,GameBase::getPosition(%this));
      }
    }
  }

  if (getObjectType(%object) == "Player" && !Player::isDead(%this))
  {
    %cliendId = Player::getClient(%object);
    %thisId = Player::getClient(%this);
    %armor = Player::getArmor(%object);
    eval(%armor @ "::onPlayerContact(" @ %this @ ", " @ %object @ ");");
  }
}

function Player::getHeatFactor(%this)
{
  %client = Player::getClient(%this);
  if (Client::getControlObject(%client) != %this) return 1.0;
  %time = getIntegerTime(true) >> 5;
  %lastTime = Player::lastJetTime(%this) >> 10;
  if ((%lastTime + 1.5) < %time)
  {
    return 0.0;
  }
  else
  {
    %diff = %time - %lastTime;
    %heat = 1.0 - (%diff / 1.5);
    return %heat;
  }
}

function Player::jump(%this,%mom) 
{
  %cl = GameBase::getControlClient(%this);
  if (%cl != -1) 
  {
    %vehicle = Player::getMountObject(%this);
    %this.lastMount = %vehicle;
    %this.newMountTime = getSimTime() + 3.0;
    Player::setMountObject(%this, %vehicle, 0);
    Player::setMountObject(%this, -1, 0);
    Player::applyImpulse(%pl,%mom);
    playSound (GameBase::getDataName(%this).dismountSound, GameBase::getPosition(%this));
  }
}

function remoteKill(%client) 
{
  %player = Client::getOwnedObject(%client);
  if(%player != -1 && getObjectType(%player) == "Player" && !Player::isDead(%player)) 
  {
    if(Player::getMountedItem(%player,$BackpackSlot) == SuicidePack) 
    {
      Player::unmountItem(%player,$BackpackSlot);
      %obj = newObject("","Mine","Suicidebomb");
      addToSet("MissionCleanup", %obj);
      %client = Player::getClient(%player);
      GameBase::throw(%obj,%player,9 * %client.throwStrength,false);
    }
    else 
    {
      playNextAnim(%client);
      Player::kill(%client);
      Client::onKilled(%client,%client);
    }
  }
}

function RemotePlayFakeDeath(%client)
{
  %anim = floor(getRandom() * ($PlayerAnim::LastDeath - $PlayerAnim::FirstDeath));
  Player::setAnimation(%client, $PlayerAnim::FirstDeath + %anim);
}

$animNumber = 25;
function playNextAnim(%client) 
{
  if($animNumber > 36) $animNumber = 25;
  Player::setAnimation(%client,$animNumber++);
}

function Client::takeControl(%clientId, %objectId) 
{
  %pl = Client::getOwnedObject(%clientId);
  if (%objectId == -1 ||  
      GameBase::getTeam(%objectId) != Client::getTeam(%clientId) || 
      GameBase::getControlClient(%objectId) != -1 ||
      GameBase::getDamageState(%objectId) != "Enabled" ||
      %pl.driver != "" || %pl.vehicleSlot != "") 
    return;

  Turret::onAttemptControl(%objectId, %clientId);
}

function remoteCmdrMountObject(%clientId, %objectIdx) 
{
  Client::takeControl(%clientId, getObjectByTargetIndex(%objectIdx));
}

function checkControlUnmount(%clientId) 
{
  %ownedObject = Client::getOwnedObject(%clientId);
  %ctrlObject = Client::getControlObject(%clientId);
  if(%ownedObject != %ctrlObject) 
  {
    if (%ownedObject == -1 || %ctrlObject == -1 ||
        (getObjectType(%ownedObject) == "Player" && 
         Player::getMountObject(%ownedObject) == %ctrlObject)) return;
    Client::setControlObject(%clientId, %ownedObject);
  }
  GameBase::virtual(%ctrlObject, onDismount, %ctrlObject, %clientID); 
}

function Shock_Damage(%clientId, %player) 
{
  Client::sendMessage(%clientId,1,"Your energy systems short-circuted!");
  Player::unmountItem(%player,$WeaponSlot);
  if($shockTime[%clientId] == 0) 
  {
    GameBase::setEnergy(%player,0);
    GameBase::setRechargeRate(%player,0);
    $shockTime[%clientId] = 10;
    checkPlayerShock(%clientId, %player);
  }
  else $shockTime[%clientId] = 10;
}

function checkPlayerShock(%clientId, %player) 
{
  if($shockTime[%clientId] > 0) 
  {
    $shockTime[%clientId] -= 2;
    schedule("checkPlayerShock(" @ %clientId @ ", " @ %player @ ");",2,%player);
  }
  else 
  {
    Client::sendMessage(%clientId,1,"Your energy systems are back to normal.");
    GameBase::setRechargeRate(%player,8);
  }
}

function FeedBack_Damage(%clientId, %player) 
{
  Client::sendMessage(%clientId,1,"You have been Feedbacked!");
   %energy = GameBase::getEnergy(%player);
   %feedback = %energy / 60;
   //usual energy count is 80, like a firebat, or something or other, if they had full energy, they would get 1.5 damage

  GameBase::setEnergy(%player, 0);
   //removes all their energy, simulating "draining" it

    %lev = GameBase::getDamageLevel(%player);
   //see how much damage they already have

    Player::blowUp(%player);
   // make player explode when he dies, instead of staying still or playing a death animation
    GameBase::setDamageLevel(%player,%lev+%feedback);
   //add how much damage they have and how much from feedback to their health

    if (Player::isDead(%player))
    {
        %clientId.scoreDeaths++;
        %clientId.score--;
        Game::refreshClientScore(%clientId);

      %fbmsg = floor(getRandom() * 4);
      if (%fbmsg == 0)
      {
	%cl = Player::getClient(%player);
        messageAll(0, Client::getName(%clientId) @ " was killed from FeedBack.");
      }
      else if (%fbmsg == 1)
      {
	%cl = Player::getClient(%player);
        messageAll(0, Client::getName(%clientId) @ " was asked 'Got FeedBack?'.");
      }
      else if (%fbmsg == 2)
      {
	%cl = Player::getClient(%player);
        messageAll(0, Client::getName(%clientId) @ " kept enough energy in his jets to be used against him with FeedBack.");
      }
      else
      {
	%cl = Player::getClient(%player);
        messageAll(0, Client::getName(%clientId) @ " had his energy used against him.");
      }
    }
}

function Blind_Damage(%clientId, %player)
{
  Client::sendMessage(%clientId,1,"You have been hit with an optical flare!");
  if($blindTime[%clientId] == 0) 
  {
    Player::setDamageFlash(%player,1.0);
    $blindTime[%clientId] = 12;
    checkPlayerBlind(%clientId, %player);
  }
  else $blindTime[%clientId] = 12;
}

function checkPlayerBlind(%clientId, %player)
{ // Taken straight from Renegades
  if($blindTime[%clientId] > 0) 
  {
    $blindTime[%clientId] -= 1;
    Player::setDamageFlash(%player,1.5);
      if (Player::isDead(%player)) 
      {
        //messageall(0, Client::getName(%clientId) @ " was killed.");
        %clientId.scoreDeaths++;
        %clientId.score--;
        Game::refreshClientScore(%clientId);
        $blindTime[%clientId] = 0;
      }
      else
        schedule("checkPlayerBlind(" @ %clientId @ ", " @ %player @ ");", 0.7, %player);
  }
  else 
    Client::sendMessage(%clientId,1,"The effect of the flare has ceased to affect your eyes.");
}

function Brood_Damage(%clientId, %player) 
{
  Client::sendMessage(%clientId,1,"You have been infested with broodlings!");

	%obj = newObject("","Mine","MineSpawn");
 	addToSet("MissionCleanup", %obj);
	GameBase::throw(%obj,%player,3,false);
  //throw minespawner from the soon to be dead guy

    Player::blowUp(%player);  // make player explode when he dies, instead of staying still or playing a death animation
    %lev = GameBase::getDamageLevel(%player);
    %dead = 10.0;
    GameBase::setDamageLevel(%player,%lev+%dead);
  //kill the guy by setting damage level past max damage

    if (Player::isDead(%player))
    {
        %clientId.scoreDeaths++;
        %clientId.score--;
        Game::refreshClientScore(%clientId);

      %fbmsg = floor(getRandom() * 4);
      if (%fbmsg == 0)
      {
	%cl = Player::getClient(%player);
        messageAll(0, Client::getName(%clientId) @ " never thought he would have Broodling children.");
      }
      else if (%fbmsg == 1)
      {
	%cl = Player::getClient(%player);
        messageAll(0, Client::getName(%clientId) @ " served as an incubator for 2 yummy broodlings.");
      }
      else if (%fbmsg == 2)
      {
	%cl = Player::getClient(%player);
        messageAll(0, Client::getName(%clientId) @ " had Broodling larvae injected into him.");
      }
      else
      {
	%cl = Player::getClient(%player);
        messageAll(0, Client::getName(%clientId) @ " had his ribcage opened by a Broodling assault.");
      }
    }
}
