//************************************************************************************
//                            Commando.cs
// For kicks, we're going to see if we can't make a pretty darned nasty AI.
// This AI is going to "connect" to a game, "join" a team, and proceed with killing
// somebody. We'll do our best to make it appears as though the Commando is an actual
// player.
//
//
//************************************************************************************

//************************************************************************************
// Some into constants and important stuff
//************************************************************************************

// List of possible names for our commando.
$Commando::Names[0] = "Stryker";
$Commando::Names[1] = "killa";
$Commando::Names[2] = "DEATH";
$Commando::Names[3] = "*UA* Assassin";
$Commando::Names[4] = "QOTSA";
$Commando::Names[5] = "*US* deadily";
$Commando::Names[6] = "|ATS|LongShot|pvt";
$Commando::Names[7] = "n00b";
$Commando::Names[8] = "chris";
$Commando::Names[9] = "benson921";
$Commando::Names[10] = "hairyM0ney";
$Commando::Names[11] = "u r dead";
$Commando::Names[12] = "[KT8]-TR-Jan";
$Commando::Names[13] = "DAF Masta";
$Commando::Names[14] = "Yugio";
$Commando::Names[15] = "CommandoDth";
$Commando::Names[16] = "<f1>Heinz";
$Commando::Names[17] = "{-+}00200";
$Commando::Names[18] = "{TINY}007";
$Commando::Names[19] = "GD.TinGoD";

// If we arn't away from near our spawnpoint in this time, drop us
$Commando::TimeOut = 60000; //Miliseconds
// Distance we've got to get from our spawnpoint
$Commando::TimeOutDist = 50;

// Time it takes from "connection" to team joining
$Commando::LoginTime = 20000; //Miliseconds

//************************************************************************************
// Stuff having to do with creating our commando.
//************************************************************************************


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Name:	chooseName
// Description: Decides on a name, from a list of available names, to use for
//		our commando. Shouldn't take a name already in existance.
// Param %name: If specified, this name will be checked and used.
// Returns:	The name that will be used.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function Commando::chooseName(%name)
{
	%toReturn = "";
	%cnt = -1;
	while(%toReturn == "")
	{
		if(%cnt == -1)
			%toReturn = %name;
		else
			%toReturn = $Commando::Names[%cnt];
		if(%toReturn == "")
			return false;
		
		if(getRandom()*100 > %cnt*5+5)
			%toREturn = "";
		
		for(%i = Client::getFirst(); %i != -1 && %toReturn != ""; %i = Client::getNext(%i))
		{
			if(Client::getName(%i) == %name)
				%toReturn = "";
		}
		%cnt++;
	}
	return %toReturn;
}


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Name:	createCommando
// Description: Entry point for our commando. Called from shell. Will make a commando
//		with either requested name, or specified name, as specified weapon,
//		or (defaults) sniper. Armor is based on weapon.
// Param %name: If specified, this name will be checked and used.
//     %weapon: If specified, this will be it's main weapon. If not, it will use
//		sniper (50 cal probably)
// %ClientTarget: 
//		Since this guy is an assassin, he needs a target. This target is the
//		client ID of the person he's out to kill.
// Returns:	The AiID
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function Commando::createCommando(%ClientTarget,%name, %weapon)
{
	%name = Commando::chooseName(%name);
	// %name @ " connected to the game.";
	messageAll(0, %name @ " connected to the game.");

	schedule("Commando::createCommando2("@%clientTarget@","@%name@","@%weapon@");",$Commando::LoginTime);
}

function Commando::createCommando2(%ClientTarget,%name,%weapon)
{

	$Commando::SpawnPoint[%name] = %loc; // Keep track of this.. if they are still near it in X time, drop them
}

//************************************************************************************
// Stuff that allows our commando to communicate with others on the chat
//
// Lets not worry about this right now.
//************************************************************************************

// If someone attempts to get his attention
$Commando::initialResponse[0] = "Yes?";
$Commando::initialResponse[1] = "what";
$Commando::initialResponse[2] = "what do you want?";
$Commando::initialResponse[3] = "huh?";
$Commando::initialResponse[4] = "?";
$Commando::initialResponse[5] = "hmm?";
$Commando::initialResponseCount = 6;

// If they ask him a question after.
$Commando::questionResponse[0] = "I don't know";
$Commando::questionResponse[1] = "leave me alone";
$Commando::questionResponse[2] = "beats me";
$Commando::questionResponse[3] = "why ask me?";
$Commando::questionResponse[4] = "...";
$Commando::questionResponse[5] = "i wouldn't know";
$Commando::questionResponse[6] = "whatever";
$Commando::questionResponse[7] = "can't we just play the game?";
$Commando::questionResponseCount = 8;

// Greet people when he comes on, or if not, when they greet him
$Commando::greeting[0] = "Hi";
$Commando::greeting[1] = "Hello";
$Commando::greeting[2] = "Yo.";
$Commando::greeting[3] = "ello";
$Commando::greeting[4] = "hey";
$Commando::initialResponseCount = 5;



//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Name:	setUpChat
// Description: Preps our commando for listening on the chat.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function Commando::setUpChat(%name)
{
	// Number of responses he's sent so far.
	$Commando::ChatResponses[%name] = 0;
	// Last message the commando said.
	$Commando::LastMessageSent[%name] = "";
	// Person that's "talking" with the commando.
	// (Established via basic communications protocol: "Commando?" or "Hey Commando?" ect.)
	$Commando::TalkingWith[%name] = "";

	// Don't want to greet more then once.
	$Commando::HasGreeted[%name] = false;

}


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Name:	listenToChat
// Description: Listens to everything he can in chat. Decides if he should respond
//		to it or not, based on if it's directed at him, if he's talked a lot
//		so far, and if it's in teamchat or not
// Param %msg: The message recieved.
// Returns:	nothing
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function Commando::listenToChat(%name,%msg)
{

}


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Name:	isMessageToHim
// Description: If the message is directed at him, return true. "Commando?" ect
// Param %msg: The message recieved.
// Returns:	True if it's for him, False if not.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function Commando::isMessageToHim(%name,%msg)
{

}


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Name:	respondToQuestion
// Description: If the message is directed at him, return true. 
// Param %msg: The message recieved.
// Returns:	True if it's for him, False if not.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function Commando::respondToQuestion(%name,%msg)
{

}


