$curVoteTopic = "";
$curVoteAction = "";
$curVoteOption = "";
$curVoteCount = 0;




function Admin::changeMissionMenu(%clientId)
{
	Client::buildMenu(%clientId, "Pick Mission Type", "cmtype", true);
	%index = 1;
	for(%type = 1; %type < $MLIST::TypeCount; %type++)
	//if($MLIST::Type[%type] != "Training" 
	if($MLIST::Type[%type] == "ServerSide" 
 	   || $MLIST::Type[%type] == "ClientSide" 
	   || $MLIST::Type[%type] == "AI" )
	{
		Client::addMenuItem(%clientId, %index @ $MLIST::Type[%type], %type @ " 0");
		%index++;
	}
}


function Admin::changeMissionMenuold(%clientId)
{
	%type = 0;
	while((%type < $MLIST::TypeCount) && (getWord($MLIST::Type[%type], 0) != "DELTA")) %type++;
	Client::buildMenu(%clientId, "Pick Mission", "cmission", true);
	for(%i = 0; (%misIndex = getWord($MLIST::MissionList[%type], %i)) != -1; %i++) {
      if(%i > 6)
      {
         Client::addMenuItem(%clientId, %i+1 @ "More missions...", "more " @ %i @ " " @ %type);
         break;
      }
	  Client::addMenuItem(%clientId, %i+1 @ $MList::EName[%misindex], %misIndex @ " " @ %type);
	}
}

function processMenuCMType(%clientId, %options)
{
   %curItem = 0;
   %option = getWord(%options, 0);
   %first = getWord(%options, 1);
   Client::buildMenu(%clientId, "Pick Mission", "cmission", true);
   
   for(%i = 0; (%misIndex = getWord($MLIST::MissionList[%option], %first + %i)) != -1; %i++)
   {
      if(%i > 6)
      {
         Client::addMenuItem(%clientId, %i+1 @ "More missions...", "more " @ %first + %i @ " " @ %option);
         break;
      }
      Client::addMenuItem(%clientId, %i+1 @ $MLIST::EName[%misIndex], %misIndex @ " " @ %option);
   }
}

function processMenuCMission(%clientId, %option)
{
   if(getWord(%option, 0) == "more")
   {
      %first = getWord(%option, 1);
      %type = getWord(%option, 2);
      processMenuCMType(%clientId, %type @ " " @ %first);
      return;
   }
   %mi = getWord(%option, 0);
   %mt = getWord(%option, 1);

   %misName = $MLIST::EName[%mi];
   %misType = $MLIST::Type[%mt];

   // verify that this is a valid mission:
   if(%misType == "" || %misType == "Training")
      return;
   for(%i = 0; true; %i++)
   {
      %misIndex = getWord($MLIST::MissionList[%mt], %i);
      if(%misIndex == %mi)
         break;
      if(%misIndex == -1)
         return;
   }
   if(%clientId.isAdmin)
   {
      messageAll(0, Client::getName(%clientId) @ " changed the mission to " @ %misName @ " (" @ %misType @ ")");
		Vote::changeMission();
      Server::loadMission(%misName);
   }
   else
   {
	if(String::findSubStr($MLIST::ECondition[%mi],"_NoVote_") == -1)
	{
	      Admin::startVote(%clientId, "change the mission to " @ %misName @ " (" @ %misType @ ")", "cmission", %misName);
	      Game::menuRequest(%clientId);
	} else
	{
		Client::SendMessage(0,"You must be an administrator to vote this mission into play.");
	}
   }
}

function remoteAdminPassword(%client, %password)
{
// We don't use this. If you want to use it, you'll have to uncomment it, and provide any required safty measures.

//   if($AdminPassword != "" && %password == $AdminPassword)
//   {
//      %client.isAdmin = true;
//      %client.isSuperAdmin = true;
//   }
}

function remoteSetPassword(%client, %password)
{
   if(%client.isSuperAdmin)
      $Server::Password = %password;
}

function remoteSetTimeLimit(%client, %time)
{
   %time = floor(%time);
   if(%time == $Server::timeLimit || (%time != 0 && %time < 1))
      return;
   if(%client.isAdmin)
   {
      $Server::timeLimit = %time;
      if(%time)
         messageAll(0, Client::getName(%client) @ " changed the time limit to " @ %time @ " minute(s).");
      else
         messageAll(0, Client::getName(%client) @ " disabled the time limit.");
         
   }
}

function remoteSetTeamInfo(%client, %team, %teamName, %skinBase)
{
   if(%team >= 0 && %team < 8 && %client.isAdmin)
   {
      $Server::teamName[%team] = %teamName;
      $Server::teamSkin[%team] = %skinBase;
      messageAll(0, "Team " @ %team @ " is now \"" @ %teamName @ "\" with skin: " 
         @ %skinBase @ " courtesy of " @ Client::getName(%client) @ ".  Changes will take effect next mission.");
   }
}

function remoteVoteYes(%clientId)
{
   %clientId.vote = "yes";
   centerprint(%clientId, "", 0);
}

function remoteVoteNo(%clientId)
{
   %clientId.vote = "no";
   centerprint(%clientId, "", 0);
}

function Admin::startMatch(%admin)
{
   if(%admin == -1 || %admin.isAdmin)
   {
      if(!$CountdownStarted && !$matchStarted)
      {
         if(%admin == -1)
            messageAll(0, "Match start countdown forced by vote.");
         else
            messageAll(0, "Match start countdown forced by " @ Client::getName(%admin));
      
         Game::ForceTourneyMatchStart();
      }
   }
}

function Admin::setTeamDamageEnable(%admin, %enabled)
{
   if(%admin == -1 || %admin.isAdmin)
   {
      if(%enabled)
      {
         $Server::TeamDamageScale = 1;
         if(%admin == -1)
            messageAll(0, "Team damage set to ENABLED by consensus.");
         else
            messageAll(0, Client::getName(%admin) @ " ENABLED team damage.");
      }
      else
      {
         $Server::TeamDamageScale = 0;
         if(%admin == -1)
            messageAll(0, "Team damage set to DISABLED by consensus.");
         else
            messageAll(0, Client::getName(%admin) @ " DISABLED team damage.");
      }
   }
}
function SetComm(%private, %commander)
{
	if(%private == %commander)
	{
		Client::sendMessage(%private, 0, "You cannot set yourself as a commander.");
		return;
	}
	if(GameBase::getTeam(%commander) !=  GameBase::getTeam(%private))
	{
		Client::SendMessage(%private, 0, "But they are not on your team!");
		return;
	}
	for(%x = 1; %x <= %commander.scomm; %x++)
	{
		if($CommanderSet[%commander, %x] == %private )
		{
			Client::sendMessage(%private, 0, "You have already set them as a commander!");
			return;
		}

	}
	%commander.scomm++;
	$CommanderSet[%commander, %commander.scomm] = %private;
	Client::sendMessage(%private, 0, "You have set " @Client::getName(%commander)@ " as a commander.");
	Client::sendMessage(%commander, 0, "You have been set as a commander by " @Client::getName(%private)@ ".");
}			

function  ClearComm(%commander, %echo)
{
	for(%x = 1; %x <= %commander.scomm; %x++)
	{
		$CommanderSet[%commander, %x] = "";	

	}
	%commander.scomm = 0;
	if(!%echo)
		echo("done");	
}

function ClearFromComm(%private, %echo)
{
	for (%i = Client::getFirst(); %i != -1; %i = Client::getNext(%i))
	{
	   if(GameBase::getTeam(%i) ==  GameBase::getTeam(%private))
	   {
		for(%x = 1; %x <= %i.scomm; %x++)
		{
			if($CommanderSet[%i, %x] == %private)
			{
				$CommanderSet[%i, %x] = "";
				for(%y=%x; %y <= %i.scomm; %y++)
				{
					%guard = %y;
					$Commander[%i, %guard] = $Commander[%i, %guard+1];
				}
				%i.scomm--;
			}
		}
	    }
	}
	if(!%echo)
		echo("done");
}

function Admin::kick(%admin, %client, %ban)
{
   if(%admin != %client && (%admin == -1 || %admin.isAdmin))
   {
      if(%ban && !%admin.isSuperAdmin)
         return;
         
      if(%ban)
      {
         %word = "banned";
         %cmd = "BAN: ";
      }
      else
      {
         %word = "kicked";
         %cmd = "KICK: ";
      }
      if(%client.isSuperAdmin)
      {
         if(%admin == -1)
            messageAll(0, "A super admin cannot be " @ %word @ ".");
         else
            Client::sendMessage(%admin, 0, "A super admin cannot be " @ %word @ ".");
         return;
      }
      %ip = Client::getTransportAddress(%client);

      echo(%cmd @ %admin @ " " @ %client @ " " @ %ip);

      if(%ip == "")
         return;
      if(%ban)
         BanList::add(%ip, 1800);
      else
         BanList::add(%ip, 180);

	ClearComm(%client, true);
	ClearFromComm(%client, true);

      %name = Client::getName(%client);

      if(%admin == -1)
      {
         MessageAll(0, %name @ " was " @ %word @ " from vote.");
         Net::kick(%client, "You were " @ %word @ " by  consensus.");
      }
      else
      {
         MessageAll(0, %name @ " got his/her corpse raped and " @ %word @ " by " @ Client::getName(%admin) @ ".");
         Net::kick(%client, "You were " @ %word @ " by " @ Client::getName(%admin) @ " for being a FUCKER. Don't let it happen again.");
      }
   }
}

function Admin::setModeFFA(%clientId)
{
   if($Server::TourneyMode && (%clientId == -1 || %clientId.isAdmin))
   {
      $Server::TeamDamageScale = 0;
      if(%clientId == -1)
         messageAll(0, "Server switched to Free-For-All Mode.");
      else
         messageAll(0, "Server switched to Free-For-All Mode by " @ Client::getName(%clientId) @ ".");

      $Server::TourneyMode = false;
      centerprintall(); // clear the messages
      if(!$matchStarted && !$countdownStarted)
      {
         if($Server::warmupTime)
            Server::Countdown($Server::warmupTime);
         else   
            Game::startMatch();
      }
   }
}

function Admin::setModeTourney(%clientId)
{
   if(!$Server::TourneyMode && (%clientId == -1 || %clientId.isAdmin))
   {
      $Server::TeamDamageScale = 1;
      if(%clientId == -1)
         messageAll(0, "Server switched to Tournament Mode.");
      else
         messageAll(0, "Server switched to Tournament Mode by " @ Client::getName(%clientId) @ ".");

      $Server::TourneyMode = true;
      Server::nextMission();
   }
}

function Admin::voteFailed()
{
   $curVoteInitiator.numVotesFailed++;

   if($curVoteAction == "kick" || $curVoteAction == "admin")
      $curVoteOption.voteTarget = "";
}

function Admin::voteSucceded()
{
   $curVoteInitiator.numVotesFailed = "";
   if($curVoteAction == "kick")
   {
      if($curVoteOption.voteTarget)
         Admin::kick(-1, $curVoteOption);
   }
   else if($curVoteAction == "admin")
   {
      if($curVoteOption.voteTarget)
      {
         $curVoteOption.isAdmin = true;
         messageAll(0, Client::getName($curVoteOption) @ " has become an administrator.");
         if($curVoteOption.menuMode == "options")
            Game::menuRequest($curVoteOption);
      }
      $curVoteOption.voteTarget = false;
   }
   else if($curVoteAction == "cmission")
   {
      messageAll(0, "Changing to mission " @ $curVoteOption @ ".");
		Vote::changeMission();
      Server::loadMission($curVoteOption);
   }
   else if($curVoteAction == "tourney")
      Admin::setModeTourney(-1);
   else if($CurVoteAction == "tdc")
	  Admin::setTDScale($curVoteOption);
   else if($CurVoteAction == "votsni")
	  Admin::setSniperLimit($curVoteOption);
   else if($curVoteAction == "ffa")
      Admin::setModeFFA(-1);
   else if($curVoteAction == "etd")
      Admin::setTeamDamageEnable(-1, true);
   else if($curVoteAction == "dtd")
      Admin::setTeamDamageEnable(-1, false);
   else if($curVoteOption == "smatch")
      Admin::startMatch(-1);
}

function Admin::countVotes(%curVote)
{
   // if %end is true, cancel the vote either way
   if(%curVote != $curVoteCount)
      return;

   %votesFor = 0;
   %votesAgainst = 0;
   %votesAbstain = 0;
   %totalClients = 0;
   %totalVotes = 0;
   for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
   {
      %totalClients++;
      if(%cl.vote == "yes")
      {
         %votesFor++;
         %totalVotes++;
      }
      else if(%cl.vote == "no")
      {
         %votesAgainst++;
         %totalVotes++;
      }
      else
         %votesAbstain++;
   }
   %minVotes = floor($Server::MinVotesPct * %totalClients);
   if(%minVotes < $Server::MinVotes)
      %minVotes = $Server::MinVotes;

   if(%totalVotes < %minVotes)
   {
      %votesAgainst += %minVotes - %totalVotes;
      %totalVotes = %minVotes;
   }
   %margin = $Server::VoteWinMargin;
   if($curVoteAction == "admin")
   {
      %margin = $Server::VoteAdminWinMargin;
      %totalVotes = %votesFor + %votesAgainst + %votesAbstain;
      if(%totalVotes < %minVotes)
         %totalVotes = %minVotes;
   }
   if(%votesFor / %totalVotes >= %margin)
   {
      messageAll(0, "Vote to " @ $curVoteTopic @ " passed: " @ %votesFor @ " to " @ %votesAgainst @ " with " @ %totalClients - (%votesFor + %votesAgainst) @ " abstentions.");
      Admin::voteSucceded();
   }
   else  // special team kick option:
   {
      if($curVoteAction == "kick") // check if the team did a majority number on him:
      {
         %votesFor = 0;
         %totalVotes = 0;
         for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
         {
            if(GameBase::getTeam(%cl) == $curVoteOption.kickTeam)
            {
               %totalVotes++;
               if(%cl.vote == "yes")
                  %votesFor++;
            }
         }
         if(%totalVotes >= $Server::MinVotes && %votesFor / %totalVotes >= $Server::VoteWinMargin)
         {
            messageAll(0, "Vote to " @ $curVoteTopic @ " passed: " @ %votesFor @ " to " @ %totalVotes - %votesFor @ ".");
            Admin::voteSucceded();
            $curVoteTopic = "";
            return;
         }
      }
      messageAll(0, "Vote to " @ $curVoteTopic @ " did not pass: " @ %votesFor @ " to " @ %votesAgainst @ " with " @ %totalClients - (%votesFor + %votesAgainst) @ " abstentions.");
      Admin::voteFailed();
   }
   $curVoteTopic = "";
}

function Admin::startVote(%clientId, %topic, %action, %option)
{
   if(%clientId.lastVoteTime == "")
      %clientId.lastVoteTime = -$Server::MinVoteTime;

   // we want an absolute time here.
   %time = getIntegerTime(true) >> 5;
   %diff = %clientId.lastVoteTime + $Server::MinVoteTime - %time;

   if(%diff > 0)
   {
      Client::sendMessage(%clientId, 0, "You can't start another vote for " @ floor(%diff) @ " seconds.");
      return;
   }
   if($curVoteTopic == "")
   {
      if(%clientId.numFailedVotes)
         %time += %clientId.numFailedVotes * $Server::VoteFailTime;

      %clientId.lastVoteTime = %time;
      $curVoteInitiator = %clientId;
      $curVoteTopic = %topic;
      $curVoteAction = %action;
      $curVoteOption = %option;
      if(%action == "kick")
         $curVoteOption.kickTeam = GameBase::getTeam($curVoteOption);
      $curVoteCount++;
      bottomprintall("<jc><f1>" @ Client::getName(%clientId) @ " <f0>initiated a vote to <f1>" @ $curVoteTopic, 10);
      for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
         %cl.vote = "";
      %clientId.vote = "yes";
      for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
         if(%cl.menuMode == "options")
            Game::menuRequest(%clientId);
      schedule("Admin::countVotes(" @ $curVoteCount @ ", true);", $Server::VotingTime, 35);
   }
   else
   {
      Client::sendMessage(%clientId, 0, "Voting already in progress.");
   }
//	Client::sendMessage(%clientId, 0, "Your attempts to democratize my server has failed miserably. You will be punished for your revolutionary actions.");
//	messageAll(0, Client::getName(%clientId) @ " was just executed for attempting a coup. Don't make the same mistake.");
//	Player::blowUp(%clientId);
//   	remoteKill(%clientId);
   		
}

function Game::menuRequest(%clientId)
{
   %curItem = 0;
   Client::buildMenu(%clientId, "Options", "options", true);
   if(!%clientId.selClient){
	if(!$matchStarted || !$Server::TourneyMode)
  	 {
		if($Game::missionType != "Extermination")
   		{
		    	if(%clientId.observerMode == "dead"){
				if( %client.dieTime + $Server::respawnTime >= getSimTime() && !$SceneRunning && !%clientId.noTeamChange)
					Client::addMenuItem(%clientId, %curItem++ @ "Change Teams/Observe", "changeteams");
			} else if( !$SceneRunning && !%clientId.noTeamChange)
				Client::addMenuItem(%clientId, %curItem++ @ "Change Teams/Observe", "changeteams");
		} else
		{	
			Client::addMenuItem(%clientId, %curItem++ @ "Change Spawn Armor", "changeSpawnArmor");
		}	
		// DELTAFORCE
		Client::addMenuItem(%clientId, %curItem++ @ "Weapon Options", "weaponoptions");
		// END DELTAFORCE
		Client::addMenuItem(%clientId, %curItem++ @ "Current Stats", "currentstats");
	   }
   }
   if(%clientId.selClient)
   {
      %sel = %clientId.selClient;
      %name = Client::getName(%sel);

      Client::addMenuItem(%clientId, %curItem++ @ "Set as commander " @ %name, "scomm " @ %sel);
      if($curVoteTopic == "" && !%clientId.isAdmin  && %clientId.noVote == "" )
      {
         Client::addMenuItem(%clientId, %curItem++ @ "Vote to admin " @ %name, "vadmin " @ %sel);
         Client::addMenuItem(%clientId, %curItem++ @ "Vote to kick " @ %name, "vkick " @ %sel);
      }
      if(%clientId.isAdmin)
      {
         Client::addMenuItem(%clientId, %curItem++ @ "Kick " @ %name, "kick " @ %sel);
         Client::addMenuItem(%clientId, %curItem++ @ "Kill " @ %name, "killpass1 " @ %sel);
	 if(%sel.noVote == true)
	         Client::addMenuItem(%clientId, %curItem++ @ "Allow voting for " @ %name, "canvote " @ %sel);
	 else
	         Client::addMenuItem(%clientId, %curItem++ @ "Deny voting to " @ %name, "novote " @ %sel);

	 if(%sel.noTeamChange == true)
	         Client::addMenuItem(%clientId, %curItem++ @ "Unlock " @ %name @ "'s Team", "unlockTeam " @ %sel);
	 else
	         Client::addMenuItem(%clientId, %curItem++ @ "Lock " @ %name @ "'s Team", "lockTeam " @ %sel);
         if(%clientId.isSuperAdmin)
         {
            Client::addMenuItem(%clientId, %curItem++ @ "Ban " @ %name, "ban " @ %sel);
            Client::addMenuItem(%clientId, %curItem++ @ "Admin " @ %name, "admin " @ %sel);
	    if(%sel.notalk == true)
         	Client::addMenuItem(%clientId, %curItem++ @ "UnGmute " @ %name, "unGmute " @ %sel);
      	    else
         	Client::addMenuItem(%clientId, %curItem++ @ "GMute " @ %name, "Gmute " @ %sel);
         }
	if($Game::missionType != "Extermination")
	{
		Client::addMenuItem(%clientId, %curItem++ @ "Change " @ %name @ "'s team", "fteamchange " @ %sel);
	}
      }
      if(%clientId.muted[%sel])
         Client::addMenuItem(%clientId, %curItem++ @ "Unmute " @ %name, "unmute " @ %sel);
      else
         Client::addMenuItem(%clientId, %curItem++ @ "Mute " @ %name, "mute " @ %sel);
      if(%clientId.observerMode == "observerOrbit")
         Client::addMenuItem(%clientId, %curItem++ @ "Observe " @ %name, "observe " @ %sel);
   }
   if($curVoteTopic != "" && %clientId.vote == "")
   {
      Client::addMenuItem(%clientId, %curItem++ @ "Vote YES to " @ $curVoteTopic, "voteYes " @ $curVoteCount);
      Client::addMenuItem(%clientId, %curItem++ @ "Vote NO to " @ $curVoteTopic, "voteNo " @ $curVoteCount);
   }
   else if($curVoteTopic == "" && !%clientId.isAdmin && %clientId.noVote == "" )
   {
      Client::addMenuItem(%clientId, %curItem++ @ "Vote to change mission", "vcmission");

//      Client::addMenuItem(%clientId, %curItem++ @ "Vote to set team damage scale", "vtdc");
//	   Client::addMenuItem(%clientId, %curItem++ @ "Vote to set sniper limitation", "vsni");         
//      if($Server::TourneyMode)
//      {
//         Client::addMenuItem(%clientId, %curItem++ @ "Vote to enter FFA mode", "vcffa");
//         if(!$CountdownStarted && !$matchStarted)
//            Client::addMenuItem(%clientId, %curItem++ @ "Vote to start the match", "vsmatch");
//      }
//      else
//         Client::addMenuItem(%clientId, %curItem++ @ "Vote to enter Tournament mode", "vctourney");

   }
   else if(%clientId.isAdmin)
   {
      Client::addMenuItem(%clientId, %curItem++ @ "Change mission", "cmission");
      //if($Server::TeamDamageScale == 1.0)
      //   Client::addMenuItem(%clientId, %curItem++ @ "Disable team damage", "dtd");
      //else
      //   Client::addMenuItem(%clientId, %curItem++ @ "Enable team damage", "etd");
	  Client::addMenuItem(%clientId, %curItem++ @ "Set Team Damage Scale", "tdc");
//	  Client::addMenuItem(%clientId, %curItem++ @ "Set Sniper Limitation", "sni");
//      if($Server::TourneyMode)
//      {
//         Client::addMenuItem(%clientId, %curItem++ @ "Change to FFA mode", "cffa");
//         if(!$CountdownStarted && !$matchStarted)
//            Client::addMenuItem(%clientId, %curItem++ @ "Start the match", "smatch");
//      }
//      else
//         Client::addMenuItem(%clientId, %curItem++ @ "Change to Tournament mode", "ctourney");
      Client::addMenuItem(%clientId, %curItem++ @ "Set Time Limit", "ctimelimit");
      if(%clientId.isSuperAdmin)
	      Client::addMenuItem(%clientId, %curItem++ @ "Reset Server Defaults", "reset");
   }
}

function remoteSelectClient(%clientId, %selId)
{
	// Al-la WorstAim's crash protection	
	// ** 
	%clientId.tries++;
	if(%clientId.tries > 5)
	{
		if(%clientId.gone)
		{
			return;
		}
		%name = client::getName(%clientId);
		banlist::add(client::getTransportAddress(%clientId), 999);
		kick(%clientId,"You Were Kicked For Spamming remoteSelectClient",0);
		%clientId.gone = true;
		return;
	}
	schedule(%clientId@".tries = 0;", 0.5);
	// ** 

   if(%clientId.selClient != %selId)
   {
      %clientId.selClient = %selId;
      if(%clientId.menuMode == "options")
         Game::menuRequest(%clientId);
      remoteEval(%clientId, "setInfoLine", 1, "Player Info for " @ Client::getName(%selId) @ ":");
      remoteEval(%clientId, "setInfoLine", 2, "Real Name: " @ $Client::info[%selId, 1]);
      remoteEval(%clientId, "setInfoLine", 3, "Email Addr: " @ $Client::info[%selId, 2]);
      remoteEval(%clientId, "setInfoLine", 4, "Tribe: " @ $Client::info[%selId, 3]);
      remoteEval(%clientId, "setInfoLine", 5, "URL: " @ $Client::info[%selId, 4]);
      remoteEval(%clientId, "setInfoLine", 6, "Other: " @ $Client::info[%selId, 5]);
   }
}

function processMenuFPickTeam(%clientId, %team)
{
if($Game::missionType != "Extermination")
{

   if(%clientId.isAdmin)
      processMenuPickTeam(%clientId.ptc, %team, %clientId);
   %clientId.ptc = "";
}
}

// DELTAFORCE
function processMenuGrenOptions(%clientId, %opt)
{
	if(%opt == "exp")
	{
		$GrenMode[%clientId] = 0;
		//remoteEval(%clientId, BP, "<f0><jc>Grenades set for Fragmentation detonation", 4);
		bottomprint(%clientId, "<f0><jc>Grenades set for Fragmentation detonation", 4);
		return;
	} else if(%opt == "smoke")
	{
		$GrenMode[%clientId] = 1;
		//remoteEval(%clientId, BP, "<f0><jc>Grenades set for Smoke detonation", 4);
		bottomprint(%clientId, "<f0><jc>Grenades set for Smoke detonation", 4);
		return;
	}
}


function processMenuASOptions(%clientId, %opt)
{
	if(%opt == "he") {
		$ASMode[%clientId] = 0;
		//remoteEval(%clientId, BP, "<f0><jc>Airstrike set to High Explosive payload", 4);
		bottomprint(%clientId, "<f0><jc>Airstrike set to High Explosive payload", 4);
		return;
	} else if(%opt == "napalm") {
		$ASMode[%clientId] = 1;
		//remoteEval(%clientId, BP, "<f0><jc>Airstrike set to Napalm payload", 4);
		bottomprint(%clientId, "<f0><jc>Airstrike set to Napalm payload", 4);
		return;
	}
}


function processMenuMPOptions(%clientId, %opt)
{
	if(%opt == "standard") {
		$MP5Mode[%clientId] = 0;
		//remoteEval(%clientId, BP, "<f0><jc>MP5 set to Standard fire", 4);
		bottomprint(%clientId, "<f0><jc>MP5 set to Standard fire", 4);
		return;
	} else if(%opt == "threeshot") {
		$MP5Mode[%clientId] = 1;
		//remoteEval(%clientId, BP, "<f0><jc>MP5 set to Three-shot Burst fire", 4);
		bottomprint(%clientId, "<f0><jc>MP5 set to Three-shot Burst fire", 4);
		return;
	}
}

function processMenuSGOptions(%clientId, %opt)
{
	if(%opt == "flechette") {
		$ShotgunMode[%clientId] = 0;
		//remoteEval(%clientId, BP, "<f0><jc>SPAS-12 loaded with Flechette rounds", 4);
		bottomprint(%clientId, "<f0><jc>SPAS-12 loaded with Flechette rounds", 4);
		return;
	}
	else if(%opt == "slug") {
		$ShotgunMode[%clientId] = 1;
		//remoteEval(%clientId, BP, "<f0><jc>SPAS-12 loaded with Slug rounds", 4);
		bottomprint(%clientId, "<f0><jc>SPAS-12 loaded with Slug rounds", 4);
		return;	
	}
}

function processMenuLockOptions(%clientId, %opt)
{
	if(%opt == "pre") {
		$LockingMode[%clientId] = 0;
		//remoteEval(%clientId, BP, "<f0><jc>Locking set to Oldstyle Pre-Lock: Before Fire", 4);
		bottomprint(%clientId, "<f0><jc>Locking set to Oldstyle Pre-Lock: Before Fire", 4);
		return;
	}
	else if(%opt == "post") {
		$LockingMode[%clientId] = 1;
		//remoteEval(%clientId, BP, "<f0><jc>Locking set to Newstyle Post-Lock: Travel Past", 4);
		bottomprint(%clientId, "<f0><jc>Locking set to Newstyle Post-Lock: Travel Past", 4);
		return;	
	}
}

function processMenuMineOptions(%clientId, %opt)
{
	if(%opt == "AP") {
		%clientId.minetype = 1;
		bottomprint(%clientId, "<f0><jc>Mine Layer (Volcano) Mine Type set to Standard AP Mine", 4);
		return;
	}
	else if(%opt == "APB") {
		%clientId.minetype = 2;
		bottomprint(%clientId, "<f0><jc>Mine Layer (Volcano) Mine Type set to AP Bouncing Mine", 4);
		return;	
	}
	else if(%opt == "AA") {
		%clientId.minetype = 3;
		bottomprint(%clientId, "<f0><jc>Mine Layer (Volcano) Mine Type set to AA Mine", 4);
		return;	
	}
}

function processMenuCounterOptions(%clientId, %opt)
{
	if(%opt == "FL") {
		%clientId.countermeasure = "Flare";
		bottomprint(%clientId, "<f0><jc>Countermeasure type set to Flares (AI)", 4);
		return;
	}
	else if(%opt == "CH") {
		%clientId.countermeasure = "Chaff";
		bottomprint(%clientId, "<f0><jc>Countermeasure type set to Chaff (AR)", 4);
		return;	
	}
}

function processMenuhflinkOptions(%clientId, %opt)
{
	if(%opt == "UL") {
		%clientId.hflink = 0;
		bottomprint(%clientId, "<f0><jc>Same type weapons set to unlinked", 4);
		return;
	}
	else if(%opt == "FL") {
		%clientId.hflink = 1;
		bottomprint(%clientId, "<f0><jc>Same type weapons set to Fire-Linked", 4);
		return;	
	}
	else if(%opt == "SL") {
		%clientId.hflink = 2;
		bottomprint(%clientId, "<f0><jc>Same type weapons set to Selected-Linked", 4);
		return;	
	}
}

function processMenuDBOptions(%clientId, %opt)
{
	if(!Player::isDead(%this)) {
		if(%opt == "CT") {
			bottomprint(%clientId, "<f0><jc>Deploying Command Tent!", 4);
			CommandTent::place(%clientId);
			return;
		}
		else if(%opt == "CS") {
			bottomprint(%clientId, "<f0><jc>Deploying Concrete Slab!", 4);
			Concrete::place(%clientId);
			return;	
		}
		else if(%opt == "B") {
			bottomprint(%clientId, "<f0><jc>Deploying Defensive Bunker!", 4);
			Bunker::place(%clientId);
			return;	
		}
		else if(%opt == "WT") {
			bottomprint(%clientId, "<f0><jc>Deploying Watch Tower!", 4);
			WatchTower::place(%clientId);
			return;	
		}
		else if(%opt == "AS") {
			bottomprint(%clientId, "<f0><jc>Deploying Airstrip!", 4);
			Airstrip::place(%clientId);
			return;	
		}
		else if(%opt == "CP") {
			bottomprint(%clientId, "<f0><jc>Deploying Chopper Pad!", 4);
			ChopperPad::place(%clientId);
			return;	
		}
		else if(%opt == "TY") {
			bottomprint(%clientId, "<f0><jc>Deploying Tank Yard!", 4);
			TankYard::place(%clientId);
			return;	
		}
		else if(%opt == "dropbase2")
			processMenuWOptions(%clientId,"dropbase2");
		else if(%opt == "RUL") {
			bottomprint(%clientId, "<f0><jc>Deploying Radar Uplink!", 4);
			RadarUplink::place(%clientId);
			return;	
		}
		else if(%opt == "SAT") {
			%curOpt = 0;
			Client::buildMenu(%clientId, "Satalite Options:", "SatOpts", true);
			Client::addMenuItem(%clientId,%curOpt++@"Move to my current waypoint", "WYP");
			Client::addMenuItem(%clientId,%curOpt++@"Move to my current location", "RMV");
			//Client::addMenuItem(%clientId,%curOpt++@"Move to teammate's location", "TMV");
			return;
		}
	}
	else {
		bottomprint(%clientId, "<f0><jc>Must be alive and playing to deploy!", 4);
		return;
	}		
}

function processMenuSatOpts(%clientId,%opt)
{
	%sat = $TeamSat[Client::getTeam(%clientID)];
	echo($LastPlayerWayPoint[%clientId]);
	if(!Player::isDead(%this)) {
		if(gamebase::getdamagelevel(%sat) > 0) {
			Client::sendMessage(%clientId, $MSGTypeGame, "The uplink station is either unpowered or damaged! Cannot transmit coordinates!");
			return;
		}
		if(%opt == "WYP") {
			//echo("$Uplink[%sat] == "@$Uplink[%sat]@"; $UplinkCmd[$Uplink[%sat]] == "@$UplinkCmd[$Uplink[%sat]]@"; Station::getTarget($UplinkCmd[$Uplink[%sat]]) == "@Station::getTarget($UplinkCmd[$Uplink[%sat]])@"; Player::getClient(Station::getTarget($UplinkCmd[$Uplink[%sat]])) == "@Player::getClient(Station::getTarget($UplinkCmd[$Uplink[%sat]]))@"; %clientId == "@%clientId); 
			if(Player::getClient(Station::getTarget($UplinkCmd[$Uplink[%sat]])) == %clientId) {
				if($LastPlayerWayPoint[%clientID]) {
					Client::sendMessage(%clientId, $MSGTypeGame, "Repositioning Satalite to waypoint coordinates...");
					$SatDest[%sat] = $LastPlayerWayPoint[%clientID];	
					echo($satonroute[%sat]);
					%start = "true";
				}
				else
					Client::sendMessage(%clientId, $MSGTypeGame, "No waypoint cooridinates input...");
			}
			else
				Client::sendMessage(%clientId, $MSGTypeGame, "Must be at Radar Uplink Station to Control Satalite remotely...");
		}
		else if(%opt == "RMV") {
			Client::sendMessage(%clientId, $MSGTypeGame, "Repositioning Satalite to your coordinates...");
			$SatDest[%sat] = gamebase::getposition(%clientID);
			echo($satonroute[%sat]);
			%start = "true";
		}
		if($satonroute[$TeamSat[Client::getTeam(%clientID)]] == "" && %start == "true")
			Satalite::updatePos(%sat);
		return;
	}
	else {
		bottomprint(%clientId, "<f0><jc>Must be alive to command Satalite!", 4);
		return;
	}
}

function processMenuWOptions(%clientId, %opt)
{
	if(%opt == "autoshotgun") {
		Client::buildMenu(%clientId, "Choose mode:", "SGOptions", true);
		Client::addMenuItem(%clientId, "0Flechette", "flechette");
		Client::addMenuItem(%clientId, "1Slug", "slug");
		return;
	}
	else if (%opt == "mp5") {
		Client::buildMenu(%clientId, "Choose mode:", "MPOptions", true);
		Client::addMenuItem(%clientId, "0Standard", "standard");
		Client::addMenuItem(%clientId, "1Three-shot Burst", "threeshot");
		return;
	}
	else if(%opt == "airstrike") {
		Client::buildMenu(%clientId, "Choose mode:", "ASOptions", true);
		Client::addMenuItem(%clientId, "0High Explosive", "he");
		Client::addMenuItem(%clientId, "1Napalm", "napalm");
		return;
	} else if(%opt == "grenade") {
		Client::buildMenu(%clientId, "Choose mode:", "GrenOptions", true);
		Client::addMenuItem(%clientId, "0Frag", "exp");
		Client::addMenuItem(%clientId, "1Smoke", "smoke");
		return;
	} else if(%opt == "lock") {
		Client::buildMenu(%clientId, "Choose mode:", "lockOptions", true);
		Client::addMenuItem(%clientId, "0Old Pre-Lock Method", "pre");
		Client::addMenuItem(%clientId, "1New Post-Lock Method", "post");
		return;
	} else if(%opt == "mine") {
		Client::buildMenu(%clientId, "Choose mode:", "mineOptions", true);
		Client::addMenuItem(%clientId, "0AP mine", "AP");
		Client::addMenuItem(%clientId, "1AP Bouncing Mine", "APB");
		Client::addMenuItem(%clientId, "2AA Mine", "AA");
		return;
	} else if(%opt == "counter") {
		Client::buildMenu(%clientId, "Choose mode:", "counterOptions", true);
		Client::addMenuItem(%clientId, "0Flare", "FL");
		Client::addMenuItem(%clientId, "1Chaff", "CH");
		return;
	} else if(%opt == "WOMore") {
		Client::BuildMenu(%clientId, "Weapon Options:","WOptions", true);
		Client::addMenuItem(%clientId, "7Vehicle Firelinking", "hflink");
		if(%clientid.scomm >= floor(getNumTeamPlayers(Client::getTeam(%clientID))/2))
		{
			if($istourny)
				Client::addMenuItem(%clientId, "7DropBase Options", "dropbase");
		}
	} else if(%opt == "hflink") {
		Client::buildMenu(%clientId, "Choose mode:", "hflinkOptions", true);
		Client::addMenuItem(%clientId, "0Unlinked", "UL");
		Client::addMenuItem(%clientId, "1Fire-Linked", "FL");
		Client::addMenuItem(%clientId, "2Selected-Linked", "SL");
		return;
	} else if(%opt == "dropbase") {
		Client::buildMenu(%clientId, "Do which?:", "DBOptions", true);	
		%x = 0;	
		if($CommandTents[Client::getTeam(%clientID)] > 0 ) {
			Client::addMenuItem(%clientId, %x@"Build CommandTent", "CT");
			%x++;
		}
		if($Concretes[Client::getTeam(%clientID)] > 0 && $CTLayed[Client::getTeam(%clientID)] == true) {
			Client::addMenuItem(%clientId, %x@"Build ConcreteSlab", "CS");
			%x++;
		}
		if($Bunkers[Client::getTeam(%clientID)] > 0 && $CTLayed[Client::getTeam(%clientID)] == true) {
			Client::addMenuItem(%clientId, %x@"Build Bunker", "B");
			%x++;
		}
		if($WatchTowers[Client::getTeam(%clientID)] > 0 && $CTLayed[Client::getTeam(%clientID)] == true) {
			Client::addMenuItem(%clientId, %x@"Build WatchTower", "WT");
			%x++;
		}
		if($Airstrips[Client::getTeam(%clientID)] > 0 && $CTLayed[Client::getTeam(%clientID)] == true) {
			Client::addMenuItem(%clientId, %x@"Build Airstrip", "AS");
			%x++;
		}
		if($ChopperPads[Client::getTeam(%clientID)] > 0 && $CTLayed[Client::getTeam(%clientID)] == true) {
			Client::addMenuItem(%clientId, %x@"Build ChopperPad", "CP");
			%x++;
		}
		if($TankYards[Client::getTeam(%clientID)] > 0 && $CTLayed[Client::getTeam(%clientID)] == true) {
			Client::addMenuItem(%clientId, %x@"Build TankYard", "TY");
			%x++;
		}
		if(%x > 6)
			Client::addMenuItem(%clientId, %x@"More...", "dropbase2");
		else {
			//Client::buildMenu(%clientId, "Do which?:", "DBOptions", true);	
			if($RadarUplinks[Client::getTeam(%clientID)] > 0 && $CTLayed[Client::getTeam(%clientID)] == true) {
				Client::addMenuItem(%clientId, %x@"Build RadarUplink", "RUL");
				%x++;
			}
		}
		if(%x > 6)
			Client::addMenuItem(%clientId, %x@"More...", "dropbase2");
		else {
			if($TeamSat[Client::getTeam(%clientID)] != "") {
				Client::addMenuItem(%clientId, %x@"Satalite Options", "SAT");
				%x++;
			}		
		}
		return;
	}
	else if(%opt == "dropbase2") {
		%x = 0;
		Client::buildMenu(%clientId, "Do which?:", "DBOptions", true);	
		if($RadarUplinks[Client::getTeam(%clientID)] > 0 && $CTLayed[Client::getTeam(%clientID)] == true) {
			Client::addMenuItem(%clientId, %x@"Build RadarUplink", "RUL");
			%x++;
		}
		if($TeamSat[Client::getTeam(%clientID)] != "") {
			Client::addMenuItem(%clientId, %x@"Satalite Options", "SAT");
			%x++;
		}
	}
}

function processMenuCStats(%clientId, %opt)
{
	if(%opt == "Kstats"){
		if(!%clientId.kills)
			%clientId.kills = 0;
		BottomPrint(%clientId, "<jc>You have " @ %clientId.kills @ " total kills this game.", 5);
	}
	else if(%opt == "Dstats"){
		if(!%clientId.deaths)
			%clientId.deaths = 0;
		BottomPrint(%clientId, "<jc>You have " @ %clientId.deaths @ " total deaths this game.", 5);
	}
	else if(%opt == "KDstats"){
		if(!%clientId.kills)
			%clientId.kills = 0;
		if(!%clientId.deaths)
			%clientId.deaths = 0;
		BottomPrint(%clientId, "<jc>You have " @ getKillDeathRatio(%clientId) @ "% kills to deaths ratio this game.", 5);
	}
	else if(%opt == "TKstats"){
		if(!$TKCount[%clientId, Client::getName(%clientId)])
			$TKCount[%clientId, Client::getName(%clientId)] = 0;
		BottomPrint(%clientId, "<jc>You have " @ $TKCount[%clientId, Client::getName(%clientId)] @ " total TeamKills this game.", 5);
	}
	else if(%opt == "Fstats"){
		getNearestThreeScores(%clientId);
	}
	else if(%opt == "Vstats"){
		getVetStats(%clientID);
	}
}

function getVetStats(%cl)
{
	%count = 0;
	%buff = "<f"@%count@">";
	if($Veteran::Kills[%cl,Knife] >= $Veteran::L3VetKills)
	{
		%buff = %buff@"Knife: 3";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,Knife] >= $Veteran::L2VetKills)
	{
		%buff = %buff@"Knife: 2";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,Knife] >= $Veteran::L1VetKills)
	{
		%buff = %buff@"Knife: 1";
		%buff = %buff @ "  <f"@%count++@">";
	}
	
	if(%count >=2)
		%count = -1;
	if($Veteran::Kills[%cl,pistol] >= $Veteran::L3VetKills)
	{
		%buff = %buff@"M9: 3";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,pistol] >= $Veteran::L2VetKills)
	{
		%buff = %buff@"M9: 2";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,pistol] >= $Veteran::L1VetKills)
	{
		%buff = %buff@"M9: 1";
		%buff = %buff @ "  <f"@%count++@">";
	}

	if(%count >=2)
		%count = -1;

	if($Veteran::Kills[%cl,m16] >= $Veteran::L3VetKills)
	{
		%buff = %buff@"M16: 3";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,m16] >= $Veteran::L2VetKills)
	{
		%buff = %buff@"M16: 2";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,m16] >= $Veteran::L1VetKills)
	{
		%buff = %buff@"M16: 1";
		%buff = %buff @ "  <f"@%count++@">";
	}
	if(%count >=2)
		%count = -1;

	if($Veteran::Kills[%cl,saw] >= $Veteran::L3VetKills)
	{
		%buff = %buff@"M249: 3";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,saw] >= $Veteran::L2VetKills)
	{
		%buff = %buff@"M249: 2";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,saw] >= $Veteran::L1VetKills)
	{
		%buff = %buff@"M249: 1";
		%buff = %buff @ "  <f"@%count++@">";
	}
	if(%count >=2)
		%count = -1;

	if($Veteran::Kills[%cl,shotgun] >= $Veteran::L3VetKills)
	{
		%buff = %buff@"SPAS-12: 3";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,shotgun] >= $Veteran::L2VetKills)
	{
		%buff = %buff@"SPAS-12: 2";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,shotgun] >= $Veteran::L1VetKills)
	{
		%buff = %buff@"SPAS-12: 1";
		%buff = %buff @ "  <f"@%count++@">";
	}
	if(%count >=2)
		%count = -1;

	if($Veteran::Kills[%cl,law] >= $Veteran::L3VetKills)
	{
		%buff = %buff@"LAW: 3";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,law] >= $Veteran::L2VetKills)
	{
		%buff = %buff@"LAW: 2";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,law] >= $Veteran::L1VetKills)
	{
		%buff = %buff@"LAW: 1";
		%buff = %buff @ "  <f"@%count++@">";
	}
	if(%count >=2)
		%count = -1;

	if($Veteran::Kills[%cl,mp5] >= $Veteran::L3VetKills)
	{
		%buff = %buff@"MP5: 3";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,mp5] >= $Veteran::L2VetKills)
	{
		%buff = %buff@"MP5: 2";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,mp5] >= $Veteran::L1VetKills)
	{
		%buff = %buff@"MP5: 1";
		%buff = %buff @ "  <f"@%count++@">";
	}
	if(%count >=2)
		%count = -1;

	if($Veteran::Kills[%cl,robar] >= $Veteran::L3VetKills)
	{
		%buff = %buff@"M40A1: 3";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,robar] >= $Veteran::L2VetKills)
	{
		%buff = %buff@"M40A1: 2";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,robar] >= $Veteran::L1VetKills)
	{
		%buff = %buff@"M40A1: 1";
		%buff = %buff @ "  <f"@%count++@">";
	}
	if(%count >=2)
		%count = -1;

	if($Veteran::Kills[%cl,psg1] >= $Veteran::L3VetKills)
	{
		%buff = %buff@"PSG1: 3";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,psg1] >= $Veteran::L2VetKills)
	{
		%buff = %buff@"PSG1: 2";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,psg1] >= $Veteran::L1VetKills)
	{
		%buff = %buff@"PSG1: 1";
		%buff = %buff @ "  <f"@%count++@">";
	}
	if(%count >=2)
		%count = -1;

	if($Veteran::Kills[%cl,FlameThrower] >= $Veteran::L3VetKills)
	{
		%buff = %buff@"Flamethrower: 3";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,flamethrower] >= $Veteran::L2VetKills)
	{
		%buff = %buff@"Flamethrower: 2";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,flamethrower] >= $Veteran::L1VetKills)
	{
		%buff = %buff@"Flamethrower: 1";
		%buff = %buff @ "  <f"@%count++@">";
	}

	if($Veteran::Kills[%cl,Medic] >= $Veteran::L3VetKills)
	{
		%buff = %buff@"Medic: 3";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,Medic] >= $Veteran::L2VetKills)
	{
		%buff = %buff@"Medic: 2";
		%buff = %buff @ "  <f"@%count++@">";
	} else if($Veteran::Kills[%cl,Medic] >= $Veteran::L1VetKills)
	{
		%buff = %buff@"Medic: 1";
		%buff = %buff @ "  <f"@%count++@">";
	}
	
	if(%buff == "<f0>")
		%buff = "<jc>You have no veteran status yet.";

	bottomprint(%cl,%buff,10);
}

function getNearestThreeScores(%clientId)
{
	//echo("did we start?");
	if(!%clientId.kills)
		%clientId.kills = 0;
	if(!%clientId.deaths)
		%clientId.deaths = 0;
	if(!$TKCount[%clientId, Client::getName(%clientId)])
		$TKCount[%clientId, Client::getName(%clientId)] = 0;

	%numClients = getNumClients();
	if(%numClients == 0)
		return;
	else if(%numclients == 1) {
		BottomPrint(%clientId," Rank\tName\t\t\t\t\t\tScore\t\t\tKills\t\t\tDeaths\t\t\tRatio\t\t\tTKills\n"
			@ " 1\t\t\t"@client::getname(%clientId)@"\t\t\t\t\t\t"@%clientId.score@"\t\t\t\t\t"@%clientId.kills@"\t\t\t\t"@%clientId.deaths@"\t\t\t\t\t"@getKillDeathRatio(%clientId)@"\t\t\t\t\t"@$TKCount[%clientId, Client::getName(%clientId)],
			10);	
	} else if (%numclients == 2) {
		if(getClientByIndex(0).score > getClientByIndex(1).score){
			  BottomPrint(%clientId," Rank\tName\t\t\t\t\t\tScore\t\t\tKills\t\t\tDeaths\t\t\tRatio\t\t\tTKills\n"
				@ " 1\t\t\t"@client::getname(getClientByIndex(0))@"\t\t\t\t\t\t"@getClientByIndex(0).score@"\t\t\t\t\t"@getClientByIndex(0).kills@"\t\t\t\t"@getClientByIndex(0).deaths@"\t\t\t\t\t"@getKillDeathRatio(getClientByIndex(0))@"\t\t\t\t\t"@$TKCount[getClientByIndex(0), Client::getName(getClientByIndex(0))]@"\n"
				@ " 2\t\t\t"@client::getname(getClientByIndex(1))@"\t\t\t\t\t\t"@getClientByIndex(1).score@"\t\t\t\t\t"@getClientByIndex(1).kills@"\t\t\t\t"@getClientByIndex(1).deaths@"\t\t\t\t\t"@getKillDeathRatio(getClientByIndex(1))@"\t\t\t\t\t"@$TKCount[getClientByIndex(1), Client::getName(getClientByIndex(1))],
				10);
		} else {
			  BottomPrint(%clientId," Rank\tName\t\t\t\t\t\tScore\t\t\tKills\t\t\tDeaths\t\t\tRatio\t\t\tTKills\n"
				@ " 1\t\t\t"@client::getname(getClientByIndex(1))@"\t\t\t\t\t\t"@getClientByIndex(1).score@"\t\t\t\t\t"@getClientByIndex(1).kills@"\t\t\t\t"@getClientByIndex(1).deaths@"\t\t\t\t\t"@getKillDeathRatio(getClientByIndex(1))@"\t\t\t\t\t"@$TKCount[getClientByIndex(1), Client::getName(getClientByIndex(1))]@"\n"
				@ " 2\t\t\t"@client::getname(getClientByIndex(0))@"\t\t\t\t\t\t"@getClientByIndex(0).score@"\t\t\t\t\t"@getClientByIndex(0).kills@"\t\t\t\t"@getClientByIndex(0).deaths@"\t\t\t\t\t"@getKillDeathRatio(getClientByIndex(0))@"\t\t\t\t\t"@$TKCount[getClientByIndex(0), Client::getName(getClientByIndex(0))],
				10);	
		}
	} else {
	
		//Stick our players in an array.
		%count=0;
		for(%k = Client::getFirst(); %k != -1; %k = Client::getNext(%k)) {
			%clientList[%count] = %k;
			%count++;
		}
		//for(%k = 0 ; %k < %numClients; %k++) 
		//	%clientList[%k] = getClientByIndex(%k);
		//echo(%Numclients);
		//for(%blah =0; %blah <%count; %blah++)
		//	echo(%clientList[%blah].score@ " " @%clientList[%blah]);
		//echo("");			
		//Standard bubble sort the players by score.
		//%sortNum = 0;
		//%swapped = 1;
		//while( %swapped == 1 ) {
		//	%swapped = 0;
		//	for(%x = %sortNum ; %x < %numClients -1; %x++) {
		//		if( %clientList[%x].score < %clientList[%x++].score) {
		//			%holder = %clientList[%x];
		//			%clientList[%x] = %clientList[%x++];
		//			%clientList[%x++] = %holder;
		//			%swapped = 1;
		//		}
		//	}
		//	%sortNum++;
		//}
		

		for(%x = 0; %x < %numClients; %x++){
			for(%z = %x+1; %z < %numClients; %z++){ 
				if( %clientList[%x].score < %clientList[%z].score){
					%holder = %clientList[%x];
					%clientList[%x] = %clientList[%z];
					%clientList[%z] = %holder;
					
				}			

			}
		}

		//echo("did we get here?");
		//for(%blah =0; %blah <%count; %blah++)
		//	echo(%clientList[%blah].score@ " " @%clientList[%blah]);

		//Search for the player making the call
		%notFound = 1;
		for(%y = 0 ; %y < %numClients && %notFound == 1; %y++){
			if(%clientList[%y] == %clientId){
				%ourClient = %y;
				%notFound = 0;
			}
		}
		
		%ourlocation = %ourclient;
		//set each of the clients to be listed.
		if(%ourClient == 0){
			//echo("Client is at the beginning");
			%a = %clientList[%ourClient];
			%b = %clientList[%ourClient++];
			%c = %clientList[%ourClient++];
			%aR = %ourlocation++;
			%bR = %ourlocation++;
			%cR = %ourlocation++;
		} else if(%ourClient == (%numClients - 1)){
			//echo("Client is at the end");
			%a = %clientList[%ourClient-2];
			%b = %clientList[%ourClient++];
			%c = %clientList[%ourClient++];
			%aR = %ourlocation--;
			%bR = %ourlocation++;
			%cR = %ourlocation++;
		} else {
			//echo("client is somewhere else");
			%a = %clientList[%ourClient--];
			%b = %clientList[%ourClient++];
			%c = %clientList[%ourClient++];
			%aR = %ourlocation;
			%bR = %ourlocation++;
			%cR = %ourlocation++;
		}		
		//echo(%aR @ " "@ %a);
		//echo(%bR @ " "@ %b);
		//echo(%cR @ " "@ %c);
		//And display the stats
		BottomPrint(%clientId," Rank\tName\t\t\t\t\t\tScore\t\t\tKills\t\t\tDeaths\t\t\tRatio\t\t\tTKills\n"
				@" "@%aR@"\t\t\t"@client::getname(%a)@"\t\t\t\t\t\t"@%a.score@"\t\t\t\t\t"@%a.kills@"\t\t\t\t"@%a.deaths@"\t\t\t\t\t"@getKillDeathRatio(%a)@"\t\t\t\t\t"@$TKCount[%a, Client::getName(%a)]@"\n"
				@" "@%bR@"\t\t\t"@client::getname(%b)@"\t\t\t\t\t\t"@%b.score@"\t\t\t\t\t"@%b.kills@"\t\t\t\t"@%b.deaths@"\t\t\t\t\t"@getKillDeathRatio(%b)@"\t\t\t\t\t"@$TKCount[%b, Client::getName(%b)]@"\n"
				@" "@%cR@"\t\t\t"@client::getname(%c)@"\t\t\t\t\t\t"@%c.score@"\t\t\t\t\t"@%c.kills@"\t\t\t\t"@%c.deaths@"\t\t\t\t\t"@getKillDeathRatio(%c)@"\t\t\t\t\t"@$TKCount[%c, Client::getName(%c)],
				10);	

	}
}

// END DELTAFORCE

function processMenuPickSpawnArmor(%clientId, %armor, %adminClient)
{
	if($Game::missionType != "Extermination")
		return;

	$Extermination::CurSpawn[%clientId] = %armor;

}
function processMenuPickTeam(%clientId, %team, %adminClient)
{
	if($Game::missionType == "Extermination")
  		return;


	//echo($Game::MissionType);
	
	if($Game::missionType == "Assassination" && (%team != -2 && %team != -1 && %team != 0 && %team != 1 && %team != 2) ) {
		return;
	} else if(($Game::missionType == "Hostage" || $hostageGame == 1 || $Game::missionType == "Jail") && ((%team != -2 && %team != -1) && ( %team >= getNumTeams()-1 || %team < 0 ))) {
		return;
	} else if($Game::missionType != "Assassination" && ((%team != -2 && %team != -1) && ( %team >= getNumTeams() || %team < 0 ))) {
		return;
	}	



  
	ClearComm(%clientId, true);
	ClearFromComm(%clientId, true);
	checkPlayerCash(%clientId);
   if(%team != -1 && %team == Client::getTeam(%clientId))
      return;

   if(%clientId.observerMode == "justJoined")
   {
      %clientId.observerMode = "";
      centerprint(%clientId, "");
   }



   // DELTAFORCE
	if($Game::missionType == "Assassination") {
   		if($Hunted == %clientId) {
			if($HuntedQueue == 0) {
				schedule("centerprint("@%clientId@", \"<jc><f0>You cannot change teams...no one else wants to be the VIP!\", 4);", 0.5);
				return;
			} else {
				$Hunted = $HuntedList[0];
				for(%i = 0; %i < $HuntedQueue-1; %i++) {
					$HuntedList[%i] = $HuntedList[%i+1];
					if($HuntedList[%i])
						schedule("bottomprint("@$HuntedList[%i]@", \"<jc><f0>You are #"@(%i+1)@" in line to be the VIP.\", 4);", 0.5);
				}
				$HuntedQueue--;
				Player::kill($Hunted);
				GameBase::setTeam($Hunted, 0);

				schedule("centerprint("@$Hunted@", \"<jc><f0>You are the VIP!\", 4);", 0.5);
			}
		}
		if(%team == 0) {
			if ($Hunted == 0) { // No VIP yet...
				$Hunted = %clientId;
				schedule("centerprint("@%clientId@", \"<jc><f0>You are the VIP!\", 4);", 0.5);
			}
		} else if(%team == 1) {
			if ( getNumTeamPlayers(1) > (getNumTeamPlayers(0)) ) {
				schedule("centerprint("@%clientId@", \"<jc><f0>Too many Assassins. You are now a Bodyguard.\", 4);", 0.5);
				%team = 0;
			}
		} else if(%team == 2) {
			%team = 0;
			if ($Hunted) {
				for(%i = 0; %i < $HuntedQueue; %i++)
				{
					if($HuntedList[%i] == %clientId)
						return;
				}
				$HuntedQueue++;
				$HuntedList[$HuntedQueue-1] = %clientId;
				schedule("centerprint("@%clientId@", \"<jc><f0>You are #"@$HuntedQueue@" in line to be the VIP. You are now a Bodyguard.\", 4);", 0.5);
				
				if(GameBase::getTeam(%clientId) == %team)
					return;
			} else {
				$Hunted = %clientId;
				schedule("centerprint("@$Hunted@", \"<jc><f0>You are the VIP!\", 4);", 0.5);
			}
		}
	}
	// END DELTAFORCE

   if((!$matchStarted || !$Server::TourneyMode || %adminClient) && %team == -2)
   {
      if(Observer::enterObserverMode(%clientId))
      {
         %clientId.notready = "";
         if(%adminClient == "") 
            messageAll(0, Client::getName(%clientId) @ " became an observer.");
         else
            messageAll(0, Client::getName(%clientId) @ " was forced into observer mode by " @ Client::getName(%adminClient) @ ".");
			Game::resetScores(%clientId);	
		   Game::refreshClientScore(%clientId);

		   // DELTAFORCE
		   if($Hunted == %clientId)
		   {
				$Hunted = 0;
				if ($HuntedQueue == 0) {
					for (%h = Client::getFirst(); %h != -1; %h = Client::getNext(%h)) 
					{
						if((GameBase::getTeam(%h) == 0) && (%h != %clientId))
							break;
					}
					if(%h != -1)
					{
						$Hunted = %h;
						Player::kill(%h);
						schedule("centerprint("@%h@", \"<jc><f0>You are now the VIP!\", 4);", 0.5);
					}
				} else {
					%h = $HuntedList[0];
					for (%i = 0; %i < $HuntedQueue-1; %i++) {
						$HuntedList[%i] = $HuntedList[%i+1];
						if($HuntedList[%i])
							schedule("bottomprint("@$HuntedList[%i]@", \"<jc><f0>You are #"@(%i+1)@" in line to be the VIP.\", 4);", 0.5);
					}
					$HuntedQueue--;
					$Hunted = %h;
					Player::kill(%h);
					GameBase::setTeam(%h, 0);
	ClearComm(%client, true);
	ClearFromComm(%client, true);

					schedule("centerprint("@%h@", \"<jc><f0>You are now the VIP!\", 4);", 0.5);
				}
			}
			// END DELTAFORCE
		}
      return;
   }

   %player = Client::getOwnedObject(%clientId);
   if(%player != -1 && getObjectType(%player) == "Player" && !Player::isDead(%player)) {
		playNextAnim(%clientId);
	   Player::kill(%clientId);
	}
   %clientId.observerMode = "";
   if(%adminClient == "")
      messageAll(0, Client::getName(%clientId) @ " changed teams.");
   else
      messageAll(0, Client::getName(%clientId) @ " was teamchanged by " @ Client::getName(%adminClient) @ ".");

   if(%team == -1)
   {
      Game::assignClientTeam(%clientId);
      %team = Client::getTeam(%clientId);
   }
   GameBase::setTeam(%clientId, %team);

   %clientId.teamEnergy = 0;
	Client::clearItemShopping(%clientId);
	if(Client::getGuiMode(%clientId) != 1)
		Client::setGuiMode(%clientId,1);		
	Client::setControlObject(%clientId, -1);

   if($matchStarted)
	   Game::playerSpawn(%clientId, true);
   else
	   Game::playerSpawn(%clientId, false);
	%team = Client::getTeam(%clientId);
	if($TeamEnergy[%team] != "Infinite")
		$TeamEnergy[%team] += $InitialPlayerEnergy;
   if($Server::TourneyMode && !$CountdownStarted)
   {
      bottomprint(%clientId, "<f1><jc>Press FIRE when ready.", 0);
      %clientId.notready = true;
   }
}

function processMenuOptions(%clientId, %option)
{
   %opt = getWord(%option, 0);
   %cl = getWord(%option, 1);

	$Options[%clientId] = 0;

   if(%opt == "fteamchange")
   {
	if($Game::missionType == "Extermination")
  		return;

      %clientId.ptc = %cl;
      Client::buildMenu(%clientId, "Pick a team:", "FPickTeam", true);
      Client::addMenuItem(%clientId, "0Observer", -2);
      $Options[%clientId]++;
      // DELTAFORCE
	if($Game::missionType == "Assassination") {
		Client::addMenuItem(%clientId, "1VIP", 2);
		$Options[%clientId]++;
		Client::addMenuItem(%clientId, "2Bodyguards", 0);
		$Options[%clientId]++;
		Client::addMenuItem(%clientId, "3Assassins", 1);
		$Options[%clientId]++;
	} else if ((!$hostageGame || $Game::missionType != "Hostage") && $Game::missionType != "Jail") {
		Client::addMenuItem(%clientId, "1Automatic", -1);
		$Options[%clientId]++;
	}
	if($Game::missionType == "Hostage" || $Game::missionType == "Jail" ) {
		for(%i = 0; %i < getNumTeams()-1; %i = %i + 1)
			Client::addMenuItem(%clientId, (%i+2) @ getTeamName(%i), %i);
			$Options[%clientId]++;
   	} else {
      		%i = getNumTeams();
        	//Client::addMenuItem(%clientId, (2) @ getTeamName(%i), %i);
          	$Options[%clientId]++;
		for(%i = 0; %i < getNumTeams(); %i = %i + 1)
         		Client::addMenuItem(%clientId, (%i+2) @ getTeamName(%i), %i);
   	}
   	// END DELTAFORCE
   	return;
   }
   // DELTAFORCE
   else if(%opt == "weaponoptions")
   {
   	Client::buildMenu(%clientId, "Weapon Options:", "WOptions", true);
	Client::addMenuItem(%clientId, "0Airstrike", "airstrike");
	Client::addMenuItem(%clientId, "1Auto Shotgun", "autoshotgun");
	Client::addMenuItem(%clientId, "2Grenade", "grenade");
	Client::addMenuItem(%clientId, "3Silenced MP5", "mp5");
	Client::addMenuItem(%clientId, "4Locking Method", "lock");
	Client::addMenuItem(%clientId, "5MineLayer Type", "mine");
	Client::addMenuItem(%clientId, "6Countermeasure Type", "counter");
	Client::addMenuItem(%clientId, "7More","WOMore");
//	Client::addMenuItem(%clientId, "7Vehicle Firelinking", "hflink");

//	if(%clientid.scomm >= floor(getNumTeamPlayers(Client::getTeam(%clientID))/2))
//	{
//		if($istourny)
//			Client::addMenuItem(%clientId, "7DropBase Options", "dropbase");
//	}
				
	
	return;
   } // END DELTAFORCE
   else if(%opt == "currentstats")
   {
	Client::buildMenu(%clientId, "Current Stat Options:", "CStats", true);
	Client::addMenuItem(%clientId, "0Kills", "Kstats");
	Client::addMenuItem(%clientId, "1Deaths", "Dstats");
	Client::addMenuItem(%clientId, "2K-D Ratio", "KDstats");
	Client::addMenuItem(%clientId, "3TKs", "TKstats");
	Client::addMenuItem(%clientId, "4Full Stats", "Fstats");
	Client::addMenuItem(%clientId, "5Vet Stats", "Vstats");
	return;
   }
   else if(%opt == "changeSpawnArmor")
   {
        Client::buildMenu(%clientId, "Pick an armor loadout:", "PickSpawnArmor", true);
        Client::addMenuItem(%clientId, "0Infantry", infantry);
        Client::addMenuItem(%clientId, "1Medic", medic);
        Client::addMenuItem(%clientId, "2AmmoSupplier", ammo);
	return;
   }
   else if(%opt == "changeteams" &&  !$SceneRunning && !%clientId.noTeamChange)
   {
    if($Game::missionType != "Extermination")
    {
      if(!$matchStarted || !$Server::TourneyMode)
      {
         Client::buildMenu(%clientId, "Pick a team:", "PickTeam", true);
         Client::addMenuItem(%clientId, "0Observer", -2);
	$Options[%clientId]++;
  	   // DELTAFORCE
	   	if($Game::missionType == "Assassination") {
			Client::addMenuItem(%clientId, "1VIP", 2);
			$Options[%clientId]++;
			Client::addMenuItem(%clientId, "2Bodyguards", 0);
			$Options[%clientId]++;
			Client::addMenuItem(%clientId, "3Assassins", 1);
			$Options[%clientId]++;
		} else if ((!$hostageGame || $Game::missionType != "Hostage") && $Game::missionType != "Jail") {
			Client::addMenuItem(%clientId, "1Automatic", -1);
			$Options[%clientId]++;
		}
		if($Game::missionType == "Hostage" || $Game::missionType == "Jail") {
			for(%i = 0; %i < getNumTeams()-1; %i = %i + 1)
				Client::addMenuItem(%clientId, (%i+2) @ getTeamName(%i), %i);
				$Options[%clientId]++;
   		} else {
      			//%j = checkTeams();
	      
	  		//if($Shifter::KeepBalanced)
      			//{
      	  			%i = checkTeams();
          			Client::addMenuItem(%clientId, (2) @ getTeamName(%i), %i);
				$Options[%clientId]++;
          		//}
      	  		//else
          		//{
          		//	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
          		//		Client::addMenuItem(%clientId, (%i+2) @ getTeamName(%i), %i);
      	 		//}
			
   	    }
   	   // END DELTAFORCE
         return;
      }
     }
   }
   else if(%opt == "mute")
      %clientId.muted[%cl] = true;
   else if(%opt == "unmute")
      %clientId.muted[%cl] = "";
   else if(%opt == "canvote")
      %cl.noVote = "";
   else if(%opt == "novote")
      %cl.noVote = true;
   else if(%opt == "unlockTeam")
      %cl.noTeamChange = "";
   else if(%opt == "lockteam")
      %cl.noTeamChange = true;
   else if(%opt == "Gmute") {
   	Client::buildMenu(%clientId, "Global Mute?:", "GMaffirm", true);
    	Client::addMenuItem(%clientId, "1Mute " @ Client::getName(%cl)@ "?", "yes " @ %cl);
    	Client::addMenuItem(%clientId, "2Dont Mute " @ Client::getName(%cl)@ "1", "no " @ %cl);
	return;
   } else if(%opt == "unGmute") {
   	Client::buildMenu(%clientId, "Global Unmute?:", "GUMaffirm", true);
      	Client::addMenuItem(%clientId, "1Unmute " @ Client::getName(%cl)@ "?", "yes " @ %cl);
      	Client::addMenuItem(%clientId, "2Dont Unmute " @ Client::getName(%cl)@ "1", "no " @ %cl);
	return;
   } else if(%opt == "vkick")
   {
      %cl.voteTarget = true;
      Admin::startVote(%clientId, "kick " @ Client::getName(%cl), "kick", %cl);
   }
   else if(%opt == "vadmin")
   {
      %cl.voteTarget = true;
      Admin::startVote(%clientId, "admin " @ Client::getName(%cl), "admin", %cl);
   }
   else if(%opt == "scomm")
   {
      Client::buildMenu(%clientId, "Set commander:", "caffirm", true);
      Client::addMenuItem(%clientId, "1Set " @ Client::getName(%cl)@ " as commander?", "yes " @ %cl);
      Client::addMenuItem(%clientId, "2Don't set " @ Client::getName(%cl)@ " as commander?", "no " @ %cl);
      return;
   }
   else if(%opt == "vsmatch")
      Admin::startVote(%clientId, "start the match", "smatch", 0);
   //else if(%opt == "vetd")
   //   Admin::startVote(%clientId, "enable team damage", "etd", 0);
   //else if(%opt == "vdtd")
   //   Admin::startVote(%clientId, "disable team damage", "dtd", 0);
   else if(%opt == "vtdc") {
	  Client::buildMenu(%clientId, "Vote on Team Damage Scale", "vtdscale", true);
	  Client::addMenuItem(%clientId, "10%", 0);
	  Client::addMenuItem(%clientId, "210%", 10);
	  Client::addMenuItem(%clientId, "325%", 25);
	  Client::addMenuItem(%clientId, "450%", 50);
	  Client::addMenuItem(%clientId, "575%", 75);
	  Client::addMenuItem(%clientId, "690%", 90);
	  Client::addMenuItem(%clientId, "7100%", 100);
	  return;
   }
   else if(%opt == "vsni") {
	  Client::buildMenu(%clientId, "Vote on Sniper Limitation", "vtdsni", true);
	  Client::addMenuItem(%clientId, "110%", 10);
	  Client::addMenuItem(%clientId, "220%", 20);
	  Client::addMenuItem(%clientId, "330%", 30);
	  Client::addMenuItem(%clientId, "440%", 40);
	  Client::addMenuItem(%clientId, "550%", 50);
	  return;
   }
   //else if(%opt == "etd")
   //   Admin::setTeamDamageEnable(%clientId, true);
   //else if(%opt == "dtd")
   //   Admin::setTeamDamageEnable(%clientId, false);
   else if(%opt == "vcffa")
      Admin::startVote(%clientId, "change to Free For All mode", "ffa", 0);
   else if(%opt == "vctourney")
      Admin::startVote(%clientId, "change to Tournament mode", "tourney", 0);
   else if(%opt == "cffa")
      Admin::setModeFFA(%clientId);
   else if(%opt == "ctourney")
      Admin::setModeTourney(%clientId);
   else if(%opt == "voteYes" && %cl == $curVoteCount)
   {
      %clientId.vote = "yes";
      centerprint(%clientId, "", 0);
   }
   else if(%opt == "voteNo" && %cl == $curVoteCount)
   {
      %clientId.vote = "no";
      centerprint(%clientId, "", 0);
   }
   else if(%opt == "kick")
   {
      Client::buildMenu(%clientId, "Confirm kick:", "kaffirm", true);
      Client::addMenuItem(%clientId, "1Kick " @ Client::getName(%cl), "yes " @ %cl);
      Client::addMenuItem(%clientId, "2Don't kick " @ Client::getName(%cl), "no " @ %cl);
      return;
   }
   else if(%opt == "admin")
   {
      Client::buildMenu(%clientId, "Confirm admim:", "aaffirm", true);
      Client::addMenuItem(%clientId, "1Admin " @ Client::getName(%cl), "yes " @ %cl);
      Client::addMenuItem(%clientId, "2Don't admin " @ Client::getName(%cl), "no " @ %cl);
      return;
   }
   else if(%opt == "ban")
   {
      Client::buildMenu(%clientId, "Confirm Ban:", "baffirm", true);
      Client::addMenuItem(%clientId, "1Ban " @ Client::getName(%cl), "yes " @ %cl);
      Client::addMenuItem(%clientId, "2Don't ban " @ Client::getName(%cl), "no " @ %cl);
      return;
   }
   else if(%opt == "killpass1") //======================================================================== Admin Kill Player
   {
   	Client::buildMenu(%clientId, "Kill?:", "Killaffirm", true);
      	Client::addMenuItem(%clientId, "1Kill " @ Client::getName(%cl)@ "?", "yes " @ %cl);
      	Client::addMenuItem(%clientId, "2Dont Kill " @ Client::getName(%cl)@ "!", "no " @ %cl);
	return;
   }

   // DELTAFORCE
   else if(%opt == "tdc") {
	  Client::buildMenu(%clientId, "Set Team Damage Scale", "tdscale", true);
	  Client::addMenuItem(%clientId, "10%", 0);
	  Client::addMenuItem(%clientId, "210%", 10);
	  Client::addMenuItem(%clientId, "325%", 25);
	  Client::addMenuItem(%clientId, "450%", 50);
	  Client::addMenuItem(%clientId, "575%", 75);
	  Client::addMenuItem(%clientId, "690%", 90);
	  Client::addMenuItem(%clientId, "7100%", 100);
	  return;
   }
   else if(%opt == "sni") {
	  Client::buildMenu(%clientId, "Set Sniper Limitation", "tdsni", true);
	  Client::addMenuItem(%clientId, "110%", 10);
	  Client::addMenuItem(%clientId, "220%", 20);
	  Client::addMenuItem(%clientId, "330%", 30);
	  Client::addMenuItem(%clientId, "440%", 40);
	  Client::addMenuItem(%clientId, "550%", 50);
	  return;
   }
   // END DELTAFORCE
   else if(%opt == "smatch")
      Admin::startMatch(%clientId);
   else if(%opt == "vcmission" || %opt == "cmission")
   {
      Admin::changeMissionMenu(%clientId, %opt == "cmission");
      return;
   }
   else if(%opt == "ctimelimit")
   {
      Client::buildMenu(%clientId, "Change Time Limit:", "ctlimit", true);
      Client::addMenuItem(%clientId, "110 Minutes", 10);
      Client::addMenuItem(%clientId, "215 Minutes", 15);
      Client::addMenuItem(%clientId, "320 Minutes", 20);
      Client::addMenuItem(%clientId, "425 Minutes", 25);
      Client::addMenuItem(%clientId, "530 Minutes", 30);
      Client::addMenuItem(%clientId, "645 Minutes", 45);
      Client::addMenuItem(%clientId, "760 Minutes", 60);
      Client::addMenuItem(%clientId, "8No Time Limit", 0);
      return;
   }
   else if(%opt == "reset")
   {
      Client::buildMenu(%clientId, "Confirm Reset:", "raffirm", true);
      Client::addMenuItem(%clientId, "1Reset", "yes");
      Client::addMenuItem(%clientId, "2Don't Reset", "no");
      return;
   }
   else if(%opt == "observe")
   {
      Observer::setTargetClient(%clientId, %cl);
      return;
   }
   Game::menuRequest(%clientId);
}

function processMenuCAffirm(%clientId, %opt)
{
   if(getWord(%opt, 0) == "yes"){
     SetComm(%clientId, getWord(%opt, 1));
   }
   Game::menuRequest(%clientId);
}

function processMenuKAffirm(%clientId, %opt)
{
   if(getWord(%opt, 0) == "yes")
      Admin::kick(%clientId, getWord(%opt, 1));
   Game::menuRequest(%clientId);
}

function processMenuKillAffirm(%clientId, %opt)
{
	if(getword(%opt, 0) == "yes"){
		%cl = getword(%opt, 1);
		if(%cl.issuperadmin != true) {
      			Player::blowUp(%cl);
      			remoteKill(%cl);
			Echo(%clientId @ " just remotely killed " @ %cl);
      			Client::sendMessage(%cl, 0, "Try not to piss off the admins next time.");
      			messageAll(0, Client::getName(%cl) @ " was executed by " @Client::getName(%clientID)@ " for insubordination.");
      			Game::menuRequest(%clientId);
      		} else {
			Echo(%clientId @ " just attempted to remotely kill " @ %cl);
      			Client::sendMessage(%cl, 0, Client::getName(%clientID) @ " (" @ %clientID @ ") " @ "just attempted to remotely kill you.");
			client::sendmessage(%clientID, 0, "You cannot kill a superadmin fool.");
     		}
	}
	else
		Client::sendMessage(%clientId, 0, "Wuss!");
      		Game::menuRequest(%clientId);

}

function processMenuGMAffirm(%clientId, %opt)
{
	if(getword(%opt, 0) == "yes"){
		%cl = getword(%opt, 1);
		if(%cl.issuperadmin != true){
      			Echo(%clientId @ " just Globaly muted " @ %cl);
      			Client::sendMessage(%cl, 0, "What was that again?");
			%cl.notalk = true;
      			Game::menuRequest(%clientId);
      		} else {
			Echo(%clientId @ " just attempted to globaly mute " @ %cl);
      			Client::sendMessage(%cl, 0, Client::getName(%clientID) @ " (" @ %clientID @ ") " @ "just attempted to globaly mute you.");
			client::sendmessage(%clientID, 0, "You cannot make a superadmin shut up you fool.");
     		}
	}
	else
		Client::sendMessage(%clientId, 0, "Wuss!");
      		Game::menuRequest(%clientId);



}

function processMenuGUMAffirm(%clientId, %opt)
{
	if(getword(%opt, 0) == "yes"){
		%cl = getword(%opt, 1);
		Echo(%clientId @ " just Globaly UNmuted " @ %cl);
      		Client::sendMessage(%cl, 0, "You spam, you die.");
		%cl.notalk = false;
      		Game::menuRequest(%clientId);
      		
	}
	else
		Client::sendMessage(%clientId, 0, "Thats a good lad!");
      		Game::menuRequest(%clientId);



}

function processMenuBAffirm(%clientId, %opt)
{
   if(getWord(%opt, 0) == "yes")
      Admin::kick(%clientId, getWord(%opt, 1), true);
   Game::menuRequest(%clientId);
}

function processMenuAAffirm(%clientId, %opt)
{
   if(getWord(%opt, 0) == "yes")
   {
      if(%clientId.isSuperAdmin)
      {
         %cl = getWord(%opt, 1);
         %cl.isAdmin = true;
         messageAll(0, Client::getName(%clientId) @ " made " @ Client::getName(%cl) @ " into an admin.");
      }
   }
   Game::menuRequest(%clientId);
}

// DELTAFORCE
function processMenuTDSni(%clientId, %opt)
{
	if(%clientId.isAdmin) {
		$Server::SniperLimit = %opt / 100;
		bottomprintall("<jc>Sniper limitation set to " @ %opt @"% of a team", 4);
	}
}

function processMenuTDScale(%clientId, %opt)
{
	if(%clientId.isAdmin) {
			$Server::TeamDamageScale = %opt / 100;
			bottomprintall("<jc>Team damage scale set to " @ %opt @"%", 4);
	}
}

function processMenuVTDScale(%clientId, %opt) {
	Admin::startVote(%clientId, "set the team damage scale to " @ %opt @"%", "tdc", %opt);
}

function processMenuVTDSni(%clientId, %opt) {
	Admin::startVote(%clientId, "set the sniper limitation to " @ %opt @"%", "votsni", %opt);
}

function Admin::setTDScale(%opt) 
{
	$Server::TeamDamageScale = %opt / 100;
	bottomprintall("<jc>Team damage scale set to " @ %opt @"% by CONSENSUS", 4);
}

function Admin::setSniperLimit(%opt)
{
	$Server::SniperLimit = %opt / 100;
	bottomprintall("<jc>Sniper limitation set to " @ %opt @"% of a team by CONSENSUS", 4);
}
// END DELTAFORCE

function processMenuRAffirm(%clientId, %opt)
{
   if(%opt == "yes" && %clientId.isAdmin)
   {
      messageAll(0, Client::getName(%clientId) @ " reset the server to default settings.");
      Server::refreshData();
   }
   Game::menuRequest(%clientId);
}

function processMenuCTLimit(%clientId, %opt)
{
   remoteSetTimeLimit(%clientId, %opt);
}

//From Shifter...
function checkTeams()
{
      %numTeams = getNumTeams();
      %numPlayers = getNumClients();
      for(%i=0;%i<%numTeams;%i=%i+1)
         	%numTeamPlayers[%i] = 0;
			
      for(%i=0;%i<%numPlayers;%i=%i+1)
      {
         	%pl = getClientByIndex(%i);
         	if(%pl != %playerId)
         	{
            		%team = Client::getTeam(%pl);
            		%numTeamPlayers[%team] = %numTeamPlayers[%team] + 1;
         	}
      }
      %lowPlayer = %numTeamPlayers[0];
      %lowTeam = 0;

      for(%i=1;%i<%numTeams;%i=%i+1)
      {
         	if(%numTeamPlayers[%i] < %lowPlayer)
         	{
            		%lowTeam = %i;
            		%lowPlayer = %numTeamPlayers;
         	}
      }
      return %lowTeam;
} 

function getnumteamplayers(%team)
{
      %numTeams = getNumTeams();
      %numPlayers = getNumClients();
      for(%i=0;%i<%numTeams;%i=%i+1)
         	%numTeamPlayers[%i] = 0;
			
      for(%i=0;%i<%numPlayers;%i=%i+1)
      {
         	%pl = getClientByIndex(%i);
         	if(%pl != %playerId)
         	{
            		%team = Client::getTeam(%pl);
            		%numTeamPlayers[%team] = %numTeamPlayers[%team] + 1;
         	}
      }
	return %numTeamPlayers[%team];
}
