//-------------------------------------------------------------------------- 
//-------------------------------------------------------------------------- 
$DamageScaleSensor[$ImpactDamageType] = 1.0;
$DamageScaleSensor[$BulletDamageType] = 0.8;
$DamageScaleSensor[$PlasmaDamageType] = 0.5;
$DamageScaleSensor[$EnergyDamageType] = 1.0;
$DamageScaleSensor[$ExplosionDamageType] = 1.0;
$DamageScaleSensor[$ChargeDamageType] = 1.0;
$DamageScaleSensor[$ShrapnelDamageType] = 1.0;
$DamageScaleSensor[$DebrisDamageType] = 1.0;
$DamageScaleSensor[$MissileDamageType] = 1.0;
$DamageScaleSensor[$LaserDamageType] = 1.0;
$DamageScaleSensor[$MortarDamageType] = 1.0;
$DamageScaleSensor[$BlasterDamageType] = 1.0;
$DamageScaleSensor[$ElectricityDamageType] = 0.01;
$DamageScaleSensor[$MineDamageType]        = 1.0;
$DamageScaleSensor[$BleedDamageType] = 0.0;
$DamageScaleSensor[$GrenadeDamageType] = 0.5;
$DamageScaleSensor[$PoisonDamageType] = 0.0;
$DamageScaleSensor[$SmokeDamageType] = 0.0;
$DamageScaleSensor[$StabDamageType] = 0.0;

$DamageScaleSensor[$SAWDamageType] = 0.8;
$DamageScaleSensor[$M16DamageType] = 0.8;
$DamageScaleSensor[$PistolDamageType] = 0.8;
$DamageScaleSensor[$MP5DamageType] = 0.8;
$DamageScaleSensor[$RobarDamageType] = 0.8;
$DamageScaleSensor[$PSG1DamageType] = 0.8;
$DamageScaleSensor[$ShotGunDamageType] = 0.8;
$DamageScaleSensor[$LawDamageType] = 1.0;
$DamageScaleSensor[$FlameThrowerDamageType] = 0.5;
//-------------------------------------------------------------------------- 
// Default sensor methods

function Sensor::onActivate(%this)
{
	if(GameBase::isPowered(%this)) {
		GameBase::playSequence(%this,0,"power");
	}
}

function Sensor::onDeactivate(%this)
{
	GameBase::pauseSequence(%this,0);
}

function Sensor::onPower(%this,%power,%generator)
{
	if (%power) {
		%this.shieldStrength = 0.03;
		GameBase::setRechargeRate(%this,10);
	}
	else {
		%this.shieldStrength = 0;
		GameBase::setRechargeRate(%this,0);
	}
	GameBase::setActive(%this,%power);
}

function Sensor::onEnabled(%this)
{

	Locking::AddtoList(%this);
	if (GameBase::isPowered(%this)) {
		%this.shieldStrength = 0.03;				  
		GameBase::setRechargeRate(%this,10);
		GameBase::setActive(%this,true);
		Radar::Add(%this);
	} else if(Gamebase::GetDataName(%this).className == DeployableSensor)
	{
		GameBase::playSequence(%this,0,"power");
		GameBase::setActive(%this,true);
		Radar::Add(%this);
	}
}

function Sensor::onDisabled(%this)
{
	Locking::RemovefromList(%this);
	%this.shieldStrength = 0;
	GameBase::setRechargeRate(%this,0);
	Sensor::onDeactivate(%this);
	Radar::Remove(%this);
}

function Sensor::onDestroyed(%this)
{

	Radar::Remove(%this);
	StaticShape::objectiveDestroyed(%this);
	%this.shieldStrength = 0;
	GameBase::setRechargeRate(%this,0);
	Sensor::onDeactivate(%this);
	%sensorName = GameBase::getDataName(%this);
	if(%sensorName == DeployableSensorJammer) 
   	$TeamItemCount[GameBase::getTeam(%this) @ "DeployableSensorJammerPack"]--;
	else if(%sensorName == DeployableMotionSensor) 
   	$TeamItemCount[GameBase::getTeam(%this) @ "MotionSensorPack"]--;
	else if(%sensorName == DeployablePulseSensor) 
   	$TeamItemCount[GameBase::getTeam(%this) @ "PulseSensorPack"]--;
	else if(%sensorName == DeployableRadar) 
   	$TeamItemCount[GameBase::getTeam(%this) @ "RadarPack"]--;
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 2, 0.40, 
		0.1, 250, 100);
}

function Sensor::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
	%value = %value * $DamageScaleSensor[%type];
   if(%this.objectiveLine)
		%this.lastDamageTeam = GameBase::getTeam(%object);
	%TDS= 1;
	if(GameBase::getTeam(%this) == GameBase::getTeam(%object)) {
		%name = GameBase::getDataName(%this);
		if(%name != DeployableMotionSensor && %name != DeployablePulseSensor && %name != DeployableSensorJammer  && %name != DeployableRadar )				
	  		%TDS = $Server::TeamDamageScale / 100;
	}
	StaticShape::shieldDamage(%this,%type,%value * %TDS,%pos,%vec,%mom,%object);
}



//------------------------------------------------------------------------

SensorData PulseSensor
{
   description = "Large Radar Tower";
   shapeFile = "radar";
//   explosionId = DebrisExp;
   maxDamage = 1.5;
   range = 400;
   dopplerVelocity = 0;
   castLOS = true;
   supression = false;
	visibleToSensor = true;
	sequenceSound[0] = { "power", SoundSensorPower };
	mapFilter = 4;
	mapIcon = "M_Radar";
	debrisId = flashDebrisLarge;
   shieldShapeName = "shield_medium";
	maxEnergy = 100;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	explosionId = LargeShockwave;
};


//------------------------------------------------------------------------

SensorData MediumPulseSensor
{
   description = "Medium Radar Tower";
   shapeFile = "sensor_pulse_med";
//   explosionId = DebrisExp;
   maxDamage = 1.0;
   range = 250;
   dopplerVelocity = 0;
   castLOS = true;
   supression = false;
	visibleToSensor = true;
	sequenceSound[0] = { "power", SoundSensorPower };
	mapFilter = 4;
	mapIcon = "M_Radar";
	debrisId = flashDebrisLarge;
   shieldShapeName = "shield_medium";
	maxEnergy = 100;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
};

//------------------------------------------------------------------------


SensorData KiowaPulseSensor
{
   description = "Kiowa Sensor Pulse";
   shapeFile = "breath";
//   explosionId = DebrisExp;
   maxDamage = 10000;
   range = 400;
   dopplerVelocity = 0;
   castLOS = false;
   supression = false;
	visibleToSensor = false;
	sequenceSound[0] = { "power", SoundSensorPower };
	mapFilter = 4;
	mapIcon = "M_Radar";
	debrisId = flashDebrisLarge;
   shieldShapeName = "shield_medium";
	maxEnergy = 100;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	explosionId = LargeShockwave;
};



//------------------------------------------------------------------------

SensorData DeployableMotionSensor
{
   description = "Motion Sensor";
	className = "DeployableSensor";
	shapeFile = "sensor_small";
	shadowDetailMask = 16;
	visibleToSensor = true;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
//   explosionId = DebrisExp;
	damageLevel = {0.8, 1.0};
	maxDamage = 0.4;
	debrisId = defaultDebrisSmall;
	range = 50;
	dopplerVelocity = 1;
   castLOS = false;
   supression = false;
	supressable = false;
	pinger = false;
	mapFilter = 4;
	mapIcon = "M_motionSensor";
	damageSkinData = "objectDamageSkins";
};


SensorData DeployablePulseSensor
{
	description = "Remote Sensor Antenna";
	className = "DeployableSensor";
	shapeFile = "radar_small";
	shadowDetailMask = 4;
	visibleToSensor = true;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	damageLevel = {0.8, 1.0};
	maxDamage = 1.0;
//   explosionId = DebrisExp;
	debrisId = flashDebrisSmall;
	range = 200;
	castLOS = true;
	supression = false;
	mapFilter = 4;
	mapIcon = "M_Radar";
};


SensorData DeployableRadar
{
	description = "Remote Radar Antenna";
	className = "DeployableSensor";
	shapeFile = "radar_small";
	shadowDetailMask = 4;
	visibleToSensor = true;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	damageLevel = {0.8, 1.0};
	maxDamage = 1.0;
//   explosionId = DebrisExp;
	debrisId = flashDebrisSmall;
	range = 0;
	castLOS = true;
	supression = false;
	mapFilter = 4;
	mapIcon = "M_Radar";
};


SensorData DeployableSensorJammer
{
	description = "Remote Sensor Jammer";
	className = "DeployableSensor";
	shapeFile = "sensor_jammer";
	shadowDetailMask = 4;
	visibleToSensor = true;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	damageLevel = {0.8, 1.0};
	maxDamage = 0.5;
//	explosionId = DebrisExp;
	debrisId = defaultDebrisSmall;
	range = 80;
	castLOS = true;
	supression = true;
	mapFilter = 4;
	mapIcon = "M_sensorJammer";
};



function DeployableSensor::onAdd(%this)
{
	schedule("DeployableSensor::deploy(" @ %this @ ");",1,%this);
	Locking::AddtoList(%this);
}

function DeployableSensor::onRemove(%this)
{
	
	Locking::RemoveFromList(%this);
	Radar::Remove(%this);
}

function DeployableSensor::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function DeployableSensor::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);

	GameBase::playSequence(%this,0,"power");
}

function DeployableSensor::onPower(%this,%power,%generator)
{
	// Deployable sensors should always be powered.
	%this.shieldStrength = 0.03;
	GameBase::setRechargeRate(%this,10);
	GameBase::setActive(%this,true);
}

//------------------------------------------------------------------------


SensorData Satalite
{
    description = "Spy Satalite";
    shapeFile = "force";
//  explosionId = DebrisExp;
    maxDamage = 1.0;
    range = 700;
    dopplerVelocity = 0;
    castLOS = true;
    supression = false;
    visibleToSensor = true;
    sequenceSound[0] = { "power", SoundSensorPower };
    mapFilter = 4;
    mapIcon = "M_Radar";
    debrisId = flashDebrisLarge;
    shieldShapeName = "shield_medium";
    maxEnergy = 100;
    damageSkinData = "objectDamageSkins";
    shadowDetailMask = 16;
};

SensorData SataliteUplinkDish
{
    description = "Satilite Uplink Dish";
    shapeFile = "sat_big";
//  explosionId = DebrisExp;
    maxDamage = 5.0;
    range = 0;
    dopplerVelocity = 0;
    castLOS = true;
    supression = false;
    visibleToSensor = true;
    sequenceSound[0] = { "power", SoundSensorPower };
    mapFilter = 4;
    mapIcon = "M_Radar";
    debrisId = flashDebrisLarge;
    shieldShapeName = "shield_medium";
    maxEnergy = 100;
    damageSkinData = "objectDamageSkins";
    shadowDetailMask = 16;
};

function SataliteUplinkDish::onActivate(%this)
{
    if(GameBase::isPowered(%this)) {
        GameBase::playSequence(%this,1,"sequence03");
        GameBase::setSequenceDirection(%this,1,0);
        schedule("GameBase::stopSequence("@%this@","@1@");",0.23);
        schedule("GameBase::playSequence("@%this@","@0@","@"sequence01"@");",1.0);
    }
}

function SataliteUplinkDish::onDeactivate(%this)
{
    GameBase::stopSequence(%this,0);
    Satalite::Hault($Satalite[%this]);
}

function SataliteUplinkDish::onPower(%this,%power,%generator)
{
    if(%power)
        GameBase::playSequence(%this,0,"sequence01");
    else {
        GameBase::stopSequence(%this,0);
        Satalite::Hault($Satalite[%this]);
    }
}

function SataliteUplinkDish::onEnabled(%this)
{
    if(GameBase::isPowered(%this)) {
        GameBase::playSequence(%this,0,"sequence01");
        Satalite::updatePos($Satalite[%this]);
    }
}

function SataliteUplinkDish::onDisabled(%this)
{
    GameBase::stopSequence(%this,0);
}

function SataliteUplinkDish::onDamage(%this,%type,%value,%pos,%vec,%mom,%object) {%value = 0;}

function Satalite::onDamage(%this,%type,%value,%pos,%vec,%mom,%object) {%value = 0;}

 
//------------------------------------------------------------------------


SensorData Satalite2
{
    description = "Spy Satalite";
    shapeFile = "force";
//  explosionId = DebrisExp;
    maxDamage = 1.0;
    range = 100000;
    dopplerVelocity = 0;
    castLOS = true;
    supression = false;
    visibleToSensor = true;
    sequenceSound[0] = { "power", SoundSensorPower };
    mapFilter = 4;
    mapIcon = "M_Radar";
    debrisId = flashDebrisLarge;
    shieldShapeName = "shield_medium";
    maxEnergy = 100;
    damageSkinData = "objectDamageSkins";
    shadowDetailMask = 16;
};
