//----------------------------------------------------------------------------

//----------------------------------------------------------------------------

//----------------------------------------------------------------------------

// List of all items available to buy from inventory station
$InvList[Blaster] = 0;
$InvList[Chaingun] = 0;
$InvList[Disclauncher] = 0;
$InvList[GrenadeLauncher] = 0;
$InvList[Mortar] = 0;
$InvList[PlasmaGun] = 0;
$InvList[LaserRifle] = 0;
$InvList[EnergyRifle] = 0;
$InvList[TargetingLaser] = 1;
$InvList[BouncingMinePack] = 1;
$InvList[APMinePack] = 1;
$InvList[AAMinePack] = 1;
$InvList[Grenade] = 1;
// DELTA FORCE
$InvList[Knife] = 1;
$InvList[SOCOM] = 1;
$InvList[OICW] = 1;
$InvList[SAW] = 1;
$InvList[MP5] = 1;
$InvList[PSG1] = 1;
$InvList[FiftyCal] = 1;
$InvList[LAW] = 1;
$InvList[Howitzer] = 0;
$InvList[Airstrike] = 0;
$InvList[GrappleHook] = 0;
$InvList[Minigun] = 0;
$InvList[LowMountMinigun] = 0;
$InvList[TwentyFivemmgun] = 0;
$InvList[LowMountTwentyFivemmgun] = 0;
$InvList[Fortymmgun] = 0;
$InvList[AbramsGun] = 0;
$InvList[LowMountAbramsGun] = 0;
$InvList[AutoShotgun] = 1;
$InvList[Stinger] = 1;
$InvList[Flamethrower] = 1;
// END DELTA FORCE

$InvList[BulletAmmo] = 0;
$InvList[PlasmaAmmo] = 0;
$InvList[DiscAmmo] = 0;
$InvList[GrenadeAmmo] = 0;
$InvList[MortarAmmo] = 0;
// DELTA FORCE
$InvList[SOCOMammo] = 0;
$InvList[OICWammo] = 0;
$InvList[SAWammo] = 0;
$InvList[MP5ammo] = 0;
$InvList[PSG1ammo] = 0;
$InvList[FiftyCalammo] = 0;
$InvList[LAWammo] = 0;
$InvList[HowitzerAmmo] = 0;
$InvList[AutoShotgunammo] = 0;
$InvList[Stingerammo] = 0;
$InvList[Flameammo] = 0;

$InvList[SOCOMClip] = 1;
$InvList[OICWClip] = 1;
$InvList[SAWClip] = 1;
$InvList[MP5Clip] = 1;
$InvList[PSG1Clip] = 1;
$InvList[FiftyCalClip] = 1;
$InvList[AutoShotgunClip] = 1;
$InvList[StingerClip] = 1;
// END DELTA FORCE
  
$InvList[EnergyPack] = 0;
$InvList[RepairPack] = 1;
$InvList[ShieldPack] = 0;
$InvList[SensorJammerPack] = 1;
$InvList[MotionSensorPack] = 1;
$InvList[PulseSensorPack] = 1;
$InvList[RadarPack] = 1;
$InvList[DeployableSensorJammerPack] = 1;
$InvList[CameraPack] = 1;
//$InvList[TurretPack] = 1;
$InvList[RepairKit] = 1;
$InvList[DeployableInvPack] = 1;
$InvList[DeployableAmmoPack] = 1;
$InvList[DeployableHealthPack] = 1;
// DELTA FORCE
$InvList[SAMPack] = 1;
$InvList[HowitzerPack] = 1;
$InvList[TwentyPack] = 1;
$InvList[Charge] = 1;
$InvList[AirstrikePack] = 0;
$InvList[ReloaderPack] = 1;
$InvList[GrapplePack] = 1;
$InvList[Parachute] = 1;
$InvList[FuelPack] = 1;
$InvList[PortGenPack] = 1;
$InvList[AAPack] = 1;
$InvList[AmmoPackSmall] = 1;
$InvList[AmmoPackHeavy] = 1;
$InvList[AmmoPackExp] = 1;
$InvList[MedicPack] = 1;
$InvList[SandBagpack] = 1;
// END DELTA FORCE

//VehicleModule list
$InvList[SideWinderModule] = 1;
$InvList[PhoenixModule] = 1;
$InvList[HellFireModule] = 1;
$InvList[HydraModule] = 1;
$InvList[UPKGunPodModule] = 1;
$InvList[GUVGunPodModule] = 1;
$InvList[FiftyCalModule] = 1;
$InvList[MaverickModule] = 1;
$InvList[HARMModule] = 1;
$InvList[Mk82Module] = 1;
$InvList[Mk84Module] = 1;
$InvList[Mk82PackageModule] = 1;
$InvList[Mk84PackageModule] = 1;
$InvList[APClusterModule] = 1;
$InvList[MineClusterModule] = 1;
$InvList[BombletClusterModule] = 1;
$InvList[BunkerBusterModule] = 1;
$InvList[TankSmokeModule] = 1;
$InvList[TankNerveGasModule] = 1;
$InvList[IncendiaryNapamModule] = 1;
$InvList[NuclearModule] = 1;
$InvList[DaisyCutterModule] = 1;
$InvList[SupplyCrateModule] = 1;
$InvList[EMCModule] = 1;

//----------------------------------------------------------------------------

// List of all items available to buy from Remote Station
$RemoteInvList[Blaster] = 0;
$RemoteInvList[Chaingun] = 0;
$RemoteInvList[Disclauncher] = 0;
$RemoteInvList[GrenadeLauncher] = 0;
$RemoteInvList[Mortar] = 0;
$RemoteInvList[PlasmaGun] = 0;
$RemoteInvList[LaserRifle] = 0;
$RemoteInvList[EnergyRifle] = 0;
$RemoteInvList[TargetingLaser] = 1;
$RemoteInvList[BouncingMinePack] = 1;
$RemoteInvList[APMinePack] = 1;
$RemoteInvList[AAMinePack] = 1;
$RemoteInvList[Grenade] = 1;
// DELTA FORCE
$RemoteInvList[Knife] = 1;
$RemoteInvList[SOCOM] = 1;
$RemoteInvList[OICW] = 1;
$RemoteInvList[SAW] = 1;
$RemoteInvList[MP5] = 1;
$RemoteInvList[PSG1] = 1;
$RemoteInvList[FiftyCal] = 1;
$RemoteInvList[LAW] = 1;
$RemoteInvList[Howitzer] = 0;
$RemoteInvList[Airstrike] = 0;
$RemoteInvList[GrappleHook] = 0;
$RemoteInvList[Minigun] = 0;
$RemoteInvList[LowMountMinigun] = 0;
$RemoteInvList[TwentyFivemmgun] = 0;
$RemoteInvList[LowMountTwentyFivemmgun] = 0;
$RemoteInvList[Fortymmgun] = 0;
$RemoteInvList[AbramsGun] = 0;
$RemoteInvList[LowMountAbramsGun] = 0;
$RemoteInvList[AutoShotgun] = 1;
$RemoteInvList[Stinger] = 1;
$RemoteInvList[Flamethrower] = 1;
// END DELTA FORCE

$RemoteInvList[BulletAmmo] = 0;
$RemoteInvList[PlasmaAmmo] = 0;
$RemoteInvList[DiscAmmo] = 0;
$RemoteInvList[GrenadeAmmo] = 0;
$RemoteInvList[MortarAmmo] = 0;
// DELTA FORCE
$RemoteInvList[SOCOMammo] = 0;
$RemoteInvList[OICWammo] = 0;
$RemoteInvList[SAWammo] = 0;
$RemoteInvList[MP5ammo] = 0;
$RemoteInvList[PSG1ammo] = 0;
$RemoteInvList[FiftyCalammo] = 0;
$RemoteInvList[LAWammo] = 0;
$RemoteInvList[HowitzerAmmo] = 0;
$RemoteInvList[AutoShotgunammo] = 0;
$RemoteInvList[Stingerammo] = 0;
$RemoteInvList[Flameammo] = 0;

$RemoteInvList[SOCOMClip] = 1;
$RemoteInvList[OICWClip] = 1;
$RemoteInvList[SAWClip] = 1;
$RemoteInvList[MP5Clip] = 1;
$RemoteInvList[PSG1Clip] = 1;
$RemoteInvList[FiftyCalClip] = 1;
$RemoteInvList[AutoShotgunClip] = 1;
$RemoteInvList[StingerClip] = 1;

// END DELTA FORCE
  
$RemoteInvList[EnergyPack] = 0;
$RemoteInvList[RepairPack] = 1;
$RemoteInvList[ShieldPack] = 0;
$RemoteInvList[SensorJammerPack] = 1;
$RemoteInvList[MotionSensorPack] = 1;
$RemoteInvList[PulseSensorPack] = 1;
$RemoteInvList[RadarPack] = 1;
$RemoteInvList[DeployableSensorJammerPack] = 1;
$RemoteInvList[CameraPack] = 1;
//$RemoteInvList[TurretPack] = 1;
$RemoteInvList[RepairKit] = 1;
// DELTA FORCE
$RemoteInvList[DeployableHealthPack] = 0;
$RemoteInvList[SAMPack] = 0;
$RemoteInvList[HowitzerPack] = 0;
$RemoteInvList[TwentyPack] = 0;
$RemoteInvList[Charge] = 1;
$RemoteInvList[AirstrikePack] = 0;
$RemoteInvList[ReloaderPack] = 1;
$RemoteInvList[GrapplePack] = 0;
$RemoteInvList[Parachute] = 0;
$RemoteInvList[FuelPack] = 1;
$RemoteInvList[PortGenPack] = 1;
$RemoteInvList[AAPack] = 0;
$RemoteInvList[AmmoPackSmall] = 1;
$RemoteInvList[AmmoPackHeavy] = 1;
$RemoteInvList[AmmoPackExp] = 1;
$RemoteInvList[MedicPack] = 1;
$RemoteInvList[SandBagpack] = 1;
//VehicleModule list
$RemoteInvList[SideWinderModule] = 1;
$RemoteInvList[PhoenixModule] = 1;
$RemoteInvList[HellFireModule] = 1;
$RemoteInvList[HydraModule] = 1;
$RemoteInvList[FiftyCalModule] = 1;
$RemoteInvList[TankSmokeModule] = 1;
$RemoteInvList[TankNerveGasModule] = 1;
$RemoteInvList[EMCModule] = 1;
// END DELTA FORCE

//----------------------------------------------------------------------------

// List of all items available to buy from Vehicle station
// DELTA FORCE
$VehicleInvList[FalconVehicle] = 1;
$VehicleInvList[TomcatVehicle] = 1;
//$VehicleInvList[DiveBomberVehicle] = 1;
$VehicleInvList[WarthogVehicle] = 1;
$VehicleInvList[BomberVehicle] = 1;
$VehicleInvList[HerculesVehicle] = 1;
$VehicleInvList[SentryVehicle] = 1;
$VehicleInvList[GunshipVehicle] = 1;
$VehicleInvList[ApacheVehicle] = 1;
$VehicleInvList[KiowaVehicle] = 1;
$VehicleInvList[HindVehicle] = 1;
$VehicleInvList[BlackhawkVehicle] = 1;
$VehicleInvList[HumveeVehicle] = 1;
$VehicleInvList[AbramsVehicle] = 1;
$VehicleInvList[BradleyVehicle] = 1;
$VehicleInvList[LineBackerVehicle] = 1;
$VehicleInvList[MLRSVehicle] = 1;
$VehicleInvList[MineLayerVehicle] = 1;
// List of all items available to buy from Jet station
$JetInvList[FalconVehicle] = 1;
$JetInvList[TomcatVehicle] = 1;
//$JetInvList[DiveBomberVehicle] = 1;
$JetInvList[WarthogVehicle] = 1;
$JetInvList[BomberVehicle] = 1;
$JetInvList[HerculesVehicle] = 1;
$JetInvList[SentryVehicle] = 1;
$JetInvList[GunshipVehicle] = 1;

//Modules available from Jet and Chopper station, as well as inv.
$JetInvList[SideWinderModule] = 1;		$ChopperInvList[SideWinderModule] = 1;
$JetInvList[PhoenixModule] = 1;			
$JetInvList[HellFireModule] = 1;		$ChopperInvList[HellFireModule] = 1;
$JetInvList[HydraModule] = 1;			$ChopperInvList[HydraModule] = 1;
						$ChopperInvList[UPKGunPodModule] = 1;
						$ChopperInvList[GUVGunPodModule] = 1;
						$ChopperInvList[FiftyCalModule] = 1;

$JetInvList[MaverickModule] = 1;		
$JetInvList[HARMModule] = 1;			
$JetInvList[Mk82Module] = 1;			$ChopperInvList[Mk82Module] = 1;
$JetInvList[Mk84Module] = 1;
$JetInvList[Mk82PackageModule] = 1;
$JetInvList[Mk84PackageModule] = 1;			
$JetInvList[APClusterModule] = 1;		$ChopperInvList[APClusterModule] = 1;
$JetInvList[MineClusterModule] = 1;		$ChopperInvList[MineClusterModule] = 1;
$JetInvList[BombletClusterModule] = 1;		$ChopperInvList[BombletClusterModule] = 1;
$JetInvList[BunkerBusterModule] = 1;		
$JetInvList[TankSmokeModule] = 1;		$ChopperInvList[TankSmokeModule] = 1;
$JetInvList[TankNerveGasModule] = 1;		$ChopperInvList[TankNerveGasModule] = 1;
$JetInvList[IncendiaryNapamModule] = 1;		$ChopperInvList[IncendiaryNapamModule] = 1;
$JetInvList[NuclearModule] = 1;			
$JetInvList[DaisyCutterModule] = 1;			
$JetInvList[SupplyCrateModule] = 1;
$JetInvList[EMCModule] = 1;			$ChopperInvList[EMCModule] = 1;
$JetInvList[ReloaderPack] = 1;			$ChopperInvList[ReloaderPack] = 1;
$JetInvList[RepairPack] = 1;			$ChopperInvList[RepairPack] = 1;
$JetInvList[Parachute] = 1;			$ChopperInvList[Parachute] = 1;


// List of all items available to buy from Chopper station
$ChopperInvList[ApacheVehicle] = 1;
$ChopperInvList[KiowaVehicle] = 1;
$ChopperInvList[BlackhawkVehicle] = 1;
$ChopperInvList[HindVehicle] = 1;
// List of all items available to buy from Tank station
$TankInvList[HumveeVehicle] = 1;
$TankInvList[AbramsVehicle] = 1;
$TankInvList[BradleyVehicle] = 1;
$TankInvList[LineBackerVehicle] = 1;
$TankInvList[MLRSVehicle] = 1;
$TankInvList[MineLayerVehicle] = 1;

// END DELTA FORCE

//----------------------------------------------------------------------------

// DELTA FORCE
$DataBlockName[FalconVehicle] = Falcon;
$DataBlockName[FalconMoveVehicle] = FalconMove;
$DataBlockName[TomcatVehicle] = Tomcat;
$DataBlockName[TomcatMoveVehicle] = TomcatMove;
//$DataBlockName[DiveBomberVehicle] = DiveBomber;
$DataBlockName[WarthogVehicle] = Warthog;
$DataBlockName[MoveWarthogVehicle] = MoveWarthog;
$DataBlockName[BomberVehicle] = Bomber;
$DataBlockName[BomberMoveVehicle] = BomberMove;
$DataBlockName[HerculesVehicle] = Hercules;
$DataBlockName[SentryVehicle] = Sentry;
$DataBlockName[SentryMoveVehicle] = SentryMove;
$DataBlockName[GunshipVehicle] = Gunship;
$DataBlockName[ApacheVehicle] = Apache;
$DataBlockName[KiowaVehicle] = Kiowa;
$DataBlockName[HindVehicle] = Hind;
$DataBlockName[BlackhawkVehicle] = Blackhawk;
$DataBlockName[MoveBlackhawkExtractionVehicle] = MoveBlackhawkExtraction;
$DataBlockName[HumveeVehicle] = Humvee;
$DataBlockName[AbramsVehicle] = Abrams;
$DataBlockName[BradleyVehicle] = Bradley;
$DataBlockName[LineBackerVehicle] = LineBacker;
$DataBlockName[MLRSVehicle] = MLRS;
$DataBlockName[MineLayerVehicle] = MineLayer;
// END DELTA FORCE

// DELTA FORCE
$VehicleToItem[Falcon] = FalconVehicle;
$VehicleToItem[FalconMove] = FalconMoveVehicle;
$VehicleToItem[Tomcat] = TomcatVehicle;
$VehicleToItem[TomcatMove] = TomcatMoveVehicle;
//$VehicleToItem[DiveBomber] = DiveBomberVehicle;
$VehicleToItem[Warthog] = WarthogVehicle;
$VehicleToItem[MoveWarthog] = MoveWarthogVehicle;
$VehicleToItem[Bomber] = BomberVehicle;
$VehicleToItem[BomberMove] = BomberMoveVehicle;
$VehicleToItem[Hercules] = HerculesVehicle;
$VehicleToItem[Sentry] = SentryVehicle;
$VehicleToItem[SentryMove] = SentryMoveVehicle;
$VehicleToItem[Gunship] = GunshipVehicle;
$VehicleToItem[Apache] = ApacheVehicle;
$VehicleToItem[Kiowa] = KiowaVehicle;
$VehicleToItem[Hind] = HindVehicle;
$VehicleToItem[Blackhawk] = BlackhawkVehicle;
$VehicleToItem[MoveBlackhawkExtraction] = MoveBlackhawkExtractionVehicle;
$VehicleToItem[Humvee] = HumveeVehicle;
$VehicleToItem[Abrams] = AbramsVehicle;
$VehicleToItem[Bradley] = BradleyVehicle;
$VehicleToItem[LineBacker] = LineBackerVehicle;
$VehicleToItem[MLRS] = MLRSVehicle;
$VehicleToItem[MineLayer] = MineLayerVehicle;
//END DELTA FORCE


// DELTA FORCE STATIONS
// ------------------------------------------------

// END DELTA FORCE STATIONS
// --------------------------------------------------

//----------------------------------------------------------------------------
// Default station animations

function Station::onActivate(%this)
{
	//echo("Activate " @ %this);
	%obj = Station::getTarget(%this);
	if (%obj != -1) {
		GameBase::playSequence(%this,1,"activate");
		GameBase::setSequenceDirection(%this,1,1);
		%this.lastPlayer = %obj;
	}
	else 
		GameBase::setActive(%this,false);
}

function Station::onDeactivate(%this)
{
	//echo("Dectivate " @ %this);
	GameBase::stopSequence(%this,2);
	GameBase::setSequenceDirection(%this,1,0);
}

function Station::onEndSequence(%this,%thread)
{
	//echo("End sequence " @ %this);
 	if (%thread == 1 && GameBase::isActive(%this)) {
		GameBase::playSequence(%this,2,"use");
		return true;
	}
	%client = %this.target;
	if(%client == "") {
		%player = Station::getTarget(%this);
		%client = Player::getClient(%player);
	}
	if(%client != "") {
		if(Client::getGuiMode(%client) != 1)
			Client::setGuiMode(%client,1);
		
		%team = Client::getTeam(%client);
		if($TeamEnergy[%team] != "Infinite") {
			if(%this.clTeamEnergy != %client.TeamEnergy) {
				if(%client.teamEnergy < 0)
					Client::sendMessage(%client,0,"Your total mission purchases have come to " @ (%client.teamEnergy * -1) @ ".");
				else
					Client::sendMessage(%client,0,"You have increased the Team Energy by " @ %client.teamEnergy @ ".");
			}
			if((%client.teamEnergy -%client.EnergyWarning < $TeammateSpending) && ($TeammateSpending != 0) && !$TeamEnergyCheat) {
				TeamMessages(0, %team, "Teammate " @ Client::getName(%client) @ " has spent " @ (%client.teamEnergy *-1) @ " of the TeamEnergy"); 
				%client.EnergyWarning = %client.teamEnergy;
			}
			if($TeamEnergy[%team] < $WarnEnergyLow)  
				TeamMessages(0, %team, "TeamEnergy Low: " @ $TeamEnergy[%team]); 
		}
	}
	if(%this.target != "") {
		(Client::getOwnedObject(%this.target)).Station = "";
		%this.target = "";
	}
	if(GameBase::getDataName(%this) == VehicleStation && %this.vehiclePad.busy < getSimTime())
		VehiclePad::checkSeq(%this.vehiclePad, %this);
	//%this.clTeamEnergy = "";
	if(GameBase::getDataName(%this) == JetStation && %this.JetPad.busy < getSimTime())
		JetPad::checkSeq(%this.JetPad, %this);
	//%this.clTeamEnergy = "";
	if(GameBase::getDataName(%this) == ChopperStation && %this.ChopperPad.busy < getSimTime())
		ChopperPad::checkSeq(%this.ChopperPad, %this);
	//%this.clTeamEnergy = "";
	if(GameBase::getDataName(%this) == TankStation && %this.TankPad.busy < getSimTime())
		TankPad::checkSeq(%this.TankPad, %this);
	%this.clTeamEnergy = "";
	return false;
}

function Station::onPower(%this,%power,%generator)
{
	if (%power) {
		GameBase::playSequence(%this,0,"power");
		GameBase::playSequence(%this,1);
	}
	else {
		GameBase::stopSequence(%this,0);
		GameBase::pauseSequence(%this,1);
		GameBase::pauseSequence(%this,2);
		Station::checkTarget(%this);
	}
}

function Station::onEnabled(%this)
{

	if (GameBase::isPowered(%this)) {		
		GameBase::playSequence(%this,0,"power");
		GameBase::playSequence(%this,1);
	}
}

function Station::checkTarget(%this)
{

	if(%this.target) {
		Client::setGuiMode(%this.target,1);
		GameBase::setActive(%this,false);
	}
}

function Station::onDisabled(%this)
{
	Station::weaponCheck(%this);
	GameBase::stopSequence(%this,0);
	GameBase::setSequenceDirection(%this,1,0);
	GameBase::pauseSequence(%this,1);
	GameBase::stopSequence(%this,2);
	Station::checkTarget(%this);
}

function Station::onDestroyed(%this)
{
	Station::weaponCheck(%this);
	StaticShape::objectiveDestroyed(%this);
	GameBase::stopSequence(%this,0);
	GameBase::stopSequence(%this,1);
	GameBase::stopSequence(%this,2);
	Station::checkTarget(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 2, 0.40, 
		0.1, 250, 100); 
}

function Station::weaponCheck(%this)
{
	if(%this.lastPlayer != "") {
		%player = %this.lastPlayer;
		%player.Station = "";
		if(Player::getMountedItem(%player,$WeaponSlot) == -1){
			if(%player.lastWeapon != "") {
				Player::useItem(%player,%player.lastWeapon);		 	
				%player.lastWeapon = "";
	  		}
		}											
	 	%this.lastPlayer = "";
  	}
}

function Station::getTarget(%this)
{
	if(GameBase::getLOSInfo(%this,1.5,"0 0 3.14")) {
	  	// GetLOSInfo sets the following globals:
	  	// 	los::position
	  	// 	los::normal
	  	// 	los::object
		%plr = $LOS::Object;
	  	%obj = getObjectType(%plr);
		dbecho(3, "STATION: LOS got " @ %obj);
	  	if (%obj == "Player") {	
			if( Player::isAiControlled( %plr ) != "True" ) {
				return %plr;
         		}
		}
	}

	if(gamebase::GetDataName(%this) == CargoInvStation)
	{
		%plr = %this.ColTarget;
	  	%obj = getObjectType(%plr);
		dbecho(3, "STATION: LOS got " @ %obj);
	  	if (%obj == "Player") {	
			if( Player::isAiControlled( %plr ) != "True" ) {
				return %plr;
         		}
		}
	}
	dbecho(3, "STATION: LOS Got None");
	return -1;
}	

function Station::onCollision(%this, %object)
{
	if(%this.target == ""){
		dbecho(3, "STATION: Collision (" @ %this @ "," @ %object @ ")");
		%obj = getObjectType(%object);
		if (%obj == "Player" && isPlayerBusy(%object) == 0) {
  		 	%client = Player::getClient(%object);
			// DELTAFORCE
			if($Game::missionType == "Assassination") {
				if(%client == $Hunted) {
					Client::sendMessage(%client,0,"The VIP cannot buy anything! ~waccess_denied.wav");
					return;
				}
			}
			// END DELTAFORCE
 			if((GameBase::getTeam(%object) == GameBase::getTeam(%this) || GameBase::getTeam(%this) == -1) && Station::getTarget(%this) == %object) {
				if (GameBase::getDamageState(%this) == "Enabled") {
					if (GameBase::isPowered(%this) || $PortGenPower[%this] > 0) { 
						if(%this.enterTime == "")
							%this.enterTime = getSimTime();
						GameBase::setActive(%this,true);
					}
					else 
						Client::sendMessage(%client,0,"Unit is not powered");
				}
				else 
					Client::sendMessage(%client,0,"Unit is disabled");
			}
			else if(Station::getTarget(%this) == %object)
   	   {
				%curTime = getSimTime();
				if(%curTime - %object.stationDeniedStamp > 3.5 && GameBase::getDamageState(%this) == "Enabled") {
					Client::clearItemShopping(%client);
					Station::onDeactivate(%this);
					Station::onEndSequence(%this,1);
					if(Client::getGuiMode(%client) != 1)
						Client::setGuiMode(%client,1);
					%object.stationDeniedStamp = %curTime;
					Client::sendMessage(%client,0,"--ACCESS DENIED-- Wrong Team ~waccess_denied.wav");
					// DELTAFORCE
					sendGameTeamMessage(GameBase::getTeam(%this), "The enemy is inside your base! ~wsniper2.wav");
					// END DELTAFORCE
				}
			}
		}
	}
}

function Station::itemsToResupply(%player)
{
	%client = Player::getClient(%player);

	%cnt = 0;
	%cnt = %cnt + AmmoStation::resupply(%player,"",RepairPatch,1);
	%cnt = %cnt + AmmoStation::resupply(%player,"",Grenade,2);
	%cnt = %cnt + AmmoStation::resupply(%player,"",RepairKit,1);
//	%cnt = %cnt + AmmoStation::resupply(%player,ChainGun,BulletAmmo,20);
//	%cnt = %cnt + AmmoStation::resupply(%player,PlasmaGun,PlasmaAmmo,5);
//	%cnt = %cnt + AmmoStation::resupply(%player,GrenadeLauncher,GrenadeAmmo,2);
//	%cnt = %cnt + AmmoStation::resupply(%player,DiscLauncher,DiscAmmo,2);
//	%cnt = %cnt + AmmoStation::resupply(%player,Mortar,MortarAmmo,2);
	// DELTA FORCE
//	%cnt = %cnt + AmmoStation::resupply(%player,SOCOM,SOCOMAmmo,20);
//	%cnt = %cnt + AmmoStation::resupply(%player,OICW,OICWAmmo,50);
//	%cnt = %cnt + AmmoStation::resupply(%player,SAW,SAWAmmo,50);
//	%cnt = %cnt + AmmoStation::resupply(%player,MP5,MP5Ammo,50);
//	%cnt = %cnt + AmmoStation::resupply(%player,PSG1,PSG1Ammo,10);
//	%cnt = %cnt + AmmoStation::resupply(%player,FiftyCal,FiftyCalAmmo,5);
//	%cnt = %cnt + AmmoStation::resupply(%player,AutoShotgun,AutoShotgunAmmo,50);
//	%cnt = %cnt + AmmoStation::resupply(%player,LAW,LAWAmmo,5);
//	%cnt = %cnt + AmmoStation::resupply(%player,Stinger,StingerAmmo,1);
//	%cnt = %cnt + AmmoStation::resupply(%player,Flamethrower,FlameAmmo,25);
//	%cnt = %cnt + AmmoStation::resupply(%player,Howitzer,HowitzerAmmo,5);

	%cnt = %cnt + AmmoStation::resupply(%player,SOCOM,SOCOMClip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,OICW,OICWClip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,SAW,SAWClip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,MP5,MP5Clip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,PSG1,PSG1Clip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,FiftyCal,FiftyCalClip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,AutoShotgun,AutoShotgunClip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,Stinger,StingerClip,1);

	if($ReloaderPackLeft[%client] < 100)
	{
		$ReloaderPackLeft[%client] += 5;
		%cnt += 5;
		if($ReloaderPackLeft[%client] > 100)
			$ReloaderPackLeft[%client] = 100;
	}
	// END DELTA FORCE
	return %cnt;
}

function DASitemsToResupply(%player)
{
	%client = Player::getClient(%player);

	%cnt = 0;
	%cnt = %cnt + AmmoStation::resupply(%player,"",Grenade,2);
	%cnt = %cnt + AmmoStation::resupply(%player,"",RepairKit,1);
	%cnt = %cnt + AmmoStation::resupply(%player,ChainGun,BulletAmmo,20);
	%cnt = %cnt + AmmoStation::resupply(%player,PlasmaGun,PlasmaAmmo,5);
	%cnt = %cnt + AmmoStation::resupply(%player,GrenadeLauncher,GrenadeAmmo,2);
	%cnt = %cnt + AmmoStation::resupply(%player,DiscLauncher,DiscAmmo,2);
	%cnt = %cnt + AmmoStation::resupply(%player,Mortar,MortarAmmo,2);
	// DELTA FORCE
//	%cnt = %cnt + AmmoStation::resupply(%player,SOCOM,SOCOMAmmo,20);
//	%cnt = %cnt + AmmoStation::resupply(%player,OICW,OICWAmmo,50);
//	%cnt = %cnt + AmmoStation::resupply(%player,SAW,SAWAmmo,50);
//	%cnt = %cnt + AmmoStation::resupply(%player,MP5,MP5Ammo,50);
//	%cnt = %cnt + AmmoStation::resupply(%player,PSG1,PSG1Ammo,10);
//	%cnt = %cnt + AmmoStation::resupply(%player,FiftyCal,FiftyCalAmmo,5);
//	%cnt = %cnt + AmmoStation::resupply(%player,AutoShotgun,AutoShotgunAmmo,50);
//	%cnt = %cnt + AmmoStation::resupply(%player,LAW,LAWAmmo,5);
//	%cnt = %cnt + AmmoStation::resupply(%player,Stinger,StingerAmmo,1);
//	%cnt = %cnt + AmmoStation::resupply(%player,Flamethrower,FlameAmmo,25);
//	%cnt = %cnt + AmmoStation::resupply(%player,Howitzer,HowitzerAmmo,5);

	%cnt = %cnt + AmmoStation::resupply(%player,SOCOM,SOCOMClip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,OICW,OICWClip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,SAW,SAWClip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,MP5,MP5Clip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,PSG1,PSG1Clip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,FiftyCal,FiftyCalClip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,AutoShotgun,AutoShotgunClip,1);
	%cnt = %cnt + AmmoStation::resupply(%player,Stinger,StingerClip,1);

	if($ReloaderPackLeft[%client] < 100)
	{
		$ReloaderPackLeft[%client] += 5;
		%cnt += 5;
		if($ReloaderPackLeft[%client] > 100)
			$ReloaderPackLeft[%client] = 100;
	}
	// END DELTA FORCE
	return %cnt;
}

//----------------------------------------------------------------------------
// Deployable stations

function DeployableStation::onActivate(%this)
{
	//echo("Activate " @ %this);
	%obj = Station::getTarget(%this);

	if (%obj != -1) {
		GameBase::playSequence(%this,1,"activate");
		GameBase::setSequenceDirection(%this,1,1);
	}
	else 
		GameBase::setActive(%this,false);
}


function DeployableStation::onEndSequence(%this,%thread)
{
   if(!%thread) {
		%this.deployed = 1;
		GameBase::playSequence(%this,2,"power");
	}
}

function DeployableStation::deploy(%this)
{
	GameBase::playSequence(%this,0,"deploy");
}

function DeployableStation::onDeactivate(%this)
{
	//echo("Dectivate " @ %this);
	GameBase::stopSequence(%this,1);
}

function DeployableStation::onEnabled(%this)
{
	GameBase::playSequence(%this,2,"power");
}

function DeployableStation::onDisabled(%this)
{
	GameBase::stopSequence(%this,2);
	GameBase::stopSequence(%this,1);
	Station::checkTarget(%this);
}

function DeployableStation::onDestroyed(%this)
{
	DeployableStation::onDisabled(%this);
	%stationName = GameBase::getDataName(%this);

	if(%stationName == DeployableInvStation) 
    	$TeamItemCount[GameBase::getTeam(%this) @ "DeployableInvPack"]--;
	else if( %stationName == DeployableAmmoStation) 
	  	$TeamItemCount[GameBase::getTeam(%this) @ "DeployableAmmoPack"]--;
	else if( %stationName == DeployableHealthStation)
		$TeamItemCount[GameBase::getTeam(%this) @ "DeployableHealthPack"]--;
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 2, 0.30, 
		0.1, 200, 100); 
	Station::weaponCheck(%this);
}

function DeployableStation::onCollision(%this, %object)
{
//	echo("Collision (" @ %this @ ",	" @ %object @ ")");
	%obj = getObjectType(%object);
	if (%obj == "Player" && isPlayerBusy(%object) == 0) {
  	 	%client = Player::getClient(%object);
		// DELTAFORCE
		if($Game::missionType == "Assassination") {
			if(%client == $Hunted) {
				Client::sendMessage(%client,0,"The VIP cannot buy anything! ~waccess_denied.wav");
				return;
			}
		}
		// END DELTAFORCE
		if(GameBase::getTeam(%object) == GameBase::getTeam(%this) || GameBase::getTeam(%this) == -1) {
			if (GameBase::getDamageState(%this) == "Enabled") {
				if(gamebase::GetDataName(%this) == CargoInvStation)
				{
					if(%this.lastTouched[%object] == "")
					{
						%this.ColTarget = %object;
						%this.lastTouched[%object] = true;
						if(%this.enterTime == "") 
							%this.enterTime = getSimTime();
						GameBase::setActive(%this,true);
					} else
						%this.lastTouched[%object] = "";
				
				} else
				{
					if(%this.enterTime == "") 
						%this.enterTime = getSimTime();
					GameBase::setActive(%this,true);
				}
			}
			else 
				Client::sendMessage(%client,0,"Unit is disabled");
		}
      else if(Station::getTarget(%this) == %object) {
			%curTime = getSimTime();
			if(%curTime - %object.stationDeniedStamp > 3.5 && GameBase::getDamageState(%this) == "Enabled") {
				%object.stationDeniedStamp = %curTime;
				Client::sendMessage(%client,0,"--ACCESS DENIED-- Wrong Team ~waccess_denied.wav");
			}
		}
	}
}

//----------------------------------------------------------------------------

//----------------------------------------------------------------------------

StaticShapeData AmmoStation
{
   description = "Ammo Supply Unit";
	shapeFile = "ammounit";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateAmmoStation };
	sequenceSound[1] = { "power", SoundAmmoStationPower };
	sequenceSound[2] = { "use", SoundUseAmmoStation };
	maxDamage = 2.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
   explosionId = flashExpLarge;
};

function AmmoStation::onEndSequence(%this,%thread)
{
	//echo("End Seq ",%thread);
	%player = Station::getTarget(%this);
	if(%this.clTeamEnergy == "")
		%this.clTeamEnergy = (Player::getClient(%player)).TeamEnergy;
	if (Station::onEndSequence(%this,%thread)) {    
		%weapon = Player::getMountedItem(%player,$WeaponSlot);
		if(%weapon != -1) {
			%player.lastWeapon = %weapon;
			Player::unMountItem(%player,$WeaponSlot);
		}
		AmmoStation::onResupply(%this);
	}
}									
											
function AmmoStation::onResupply(%this)
{
	if (GameBase::isActive(%this)) {
		%player = Station::getTarget(%this);
		if (%player != -1 && %this.lastPlayer == %player) {
			// Hardcoded here for the ammo types
			if(GameBase::getDataName(%this) == DeployableAmmoStation)
				%cnt = DASitemsToResupply(%player);
			else
				%cnt = Station::itemsToResupply(%player);
			if(getSimTime() - %this.enterTime > 11)
				%cnt = 0;
			if (%cnt != 0) {
				%player.waitThrowTime = getSimTime();
				schedule("AmmoStation::onResupply(" @ %this @ ");",0.5,%this);
				return;
			}
			%player.Station = "";
			%client = Player::getClient(%player);
			%this.target = "";
			Client::sendMessage(%client,0,"Resupply Complete");
			Client::setInventoryText(%client, "<f1><jc>TEAM ENERGY: " @ $TeamEnergy[Client::getTeam(%client)]);

			if(Player::getMountedItem(%player,$WeaponSlot) == -1){
				if(%player.lastWeapon != "") {
					Player::useItem(%player,%player.lastWeapon);		 	
					%player.lastWeapon = "";
	  			}
			}			
		}
		else if(%this.target != "") {
			%player = Client::getOwnedObject(%this.target);
			%player.Station = "";
			if(Player::getMountedItem(%player,$WeaponSlot) == -1){
				if(%player.lastWeapon != "") {
					Player::useItem(%player,%player.lastWeapon);		 	
					%player.lastWeapon = "";
	  			}
			}		
			%this.target = "";
		}
		else {
			%this.lastPlayer.Station = "";
			if(Player::getMountedItem(%this.lastPlayer,$WeaponSlot) == -1){
				if(%this.lastPlayer.lastWeapon != "") {
					Player::useItem(%this.lastPlayer,%this.lastPlayer.lastWeapon);		 	
					%this.lastPlayer.lastWeapon = "";
	  			}
			}
			%this.target = "";
		}
		GameBase::setActive(%this,false);
		%this.enterTime="";
	}
}
		 											
function AmmoStation::resupply(%player,%weapon,%item,%delta)
{
	%delta = checkResources(%player,%item,%delta,1);		
	if(%delta > 0) {						
		if(%item == RepairPatch) {
			teamEnergyBuySell(%player,%item.price * %delta * -1);
			GameBase::repairDamage(%player,0.06);
		 	return %delta;
		}
		else if (%item == MineAmmo || %item == Grenade || %item == RepairKit) {
			teamEnergyBuySell(%player,%item.price * %delta * -1);
			Player::incItemCount(%player,%item,%delta);
		 	return %delta;
		}
		else if (Player::getItemCount(%player,%weapon)) {
			teamEnergyBuySell(%player,%item.price * %delta * -1);
			Player::incItemCount(%player,%item,%delta);
		 	return %delta;
		}
	}
	return 0;
}

//----------------------------------------------------------------------------
StaticShapeData DeployableAmmoStation
{
   description = "Remote Ammo Unit";
	shapeFile = "ammounit_remote";
	className = "DeployableStation";
	maxDamage = 0.25;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	sequenceSound[1] = { "use", SoundUseAmmoStation };
	sequenceSound[2] = { "power", SoundAmmoStationPower };

	visibleToSensor = true;
	shadowDetailMask = 4;
	castLOS = true;
	supression = false;
	supressable = false;
	mapFilter = 4;
	mapIcon = "M_station";
	debrisId = flashDebrisSmall;
	damageSkinData = "objectDamageSkins";
   explosionId = flashExpMedium;
};


function DeployableAmmoStation::onAdd(%this)
{
	schedule("DeployableStation::deploy(" @ %this @ ");",1,%this);
	if (GameBase::getMapName(%this) == "") 
		GameBase::setMapName (%this, "R-Ammo Station");
	%this.Energy = $RemoteAmmoEnergy;
}

function DeployableAmmoStation::onActivate(%this)
{
	if(%this.deployed == 1) {
		GameBase::playSequence(%this,1,"use");
		//echo("Activate " @ %this);
		schedule("AmmoStation::onResupply(" @ %this @ ");",0.5,%this);
		%this.lastPlayer = Station::getTarget(%this);
		%player = %this.lastPlayer; 
		%player.Station = %this;
		%this.target = Player::getClient(Station::getTarget(%this));
		%weapon = Player::getMountedItem(%player,$WeaponSlot);
		if(%weapon != -1) {
			%player.lastWeapon = %weapon;
			Player::unMountItem(%player,$WeaponSlot);
		}
	}
	else 
		GameBase::setActive(%this,false);	
}


//----------------------------------------------------------------------------

StaticShapeData DeployableHealthStation
{
   description = "Remote Medical Unit";
	shapeFile = "ammounit_remote";
	className = "DeployableStation";
	maxDamage = 0.25;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	sequenceSound[1] = { "use", SoundUseAmmoStation };
	sequenceSound[2] = { "power", SoundAmmoStationPower };

	visibleToSensor = true;
	shadowDetailMask = 4;
	castLOS = true;
	supression = false;
	supressable = false;
	mapFilter = 4;
	mapIcon = "M_station";
	debrisId = flashDebrisSmall;
	damageSkinData = "objectDamageSkins";
   explosionId = flashExpMedium;
};

function DeployableHealthStation::onAdd(%this)
{
	schedule("DeployableStation::deploy(" @ %this @ ");",1,%this);
	if (GameBase::getMapName(%this) == "") 
		GameBase::setMapName (%this, "R-Medical Station");
	%this.Energy = $RemoteAmmoEnergy;
}

function DeployableHealthStation::onActivate(%this)
{
	if(%this.deployed == 1) {
		GameBase::playSequence(%this,1,"use");
		//echo("Activate " @ %this);
		schedule("DeployableHealthStation::heal(" @ %this @ ", 1);",0.5,%this);
		%this.lastPlayer = Station::getTarget(%this);
		%player = %this.lastPlayer; 
		%player.Station = %this;
		%this.target = Player::getClient(Station::getTarget(%this));
		%weapon = Player::getMountedItem(%player,$WeaponSlot);
		if(%weapon != -1) {
			%player.lastWeapon = %weapon;
			Player::unMountItem(%player,$WeaponSlot);
		}
	}
	else 
		GameBase::setActive(%this,false);	
}

function DeployableHealthStation::heal(%this, %delta)
{
	%player = Station::getTarget(%this);
	%delta = checkResources(%player,RepairPatch,%delta,1);		
	if(%delta > 0) {						
		teamEnergyBuySell(%player,RepairPatch.price * -1);
		GameBase::repairDamage(%player,0.06);
		schedule("DeployableHealthStation::heal(" @ %this @ ", "@%delta@");",0.5,%this);
	} else
	{
		Client::sendMessage(%this.target,0,"Healing Complete");
		GameBase::setActive(%this,false);
		%this.enterTime="";
		%this.target="";
		%this.lastPlayer.Station="";
	}
	$woundedWeaponArm[%player] = 0;
	$woundedLegs[%player] = 0;
	if(Player::getArmor(%player) == "marmor2" || Player::getArmor(%player) == "marmor3")
		Player::setArmor(%player,marmor);
   	else if(Player::getArmor(%player) == "sarmor2" || Player::getArmor(%player) == "sarmor3")
		Player::setArmor(%player,sarmor);
	else if(Player::getArmor(%player) == "iarmor2" || Player::getArmor(%player) == "iarmor3")
		Player::setArmor(%player,iarmor);
	else if(Player::getArmor(%player) == "garmor2" || Player::getArmor(%player) == "garmor3")
		Player::setArmor(%player,garmor);
	else if(Player::getArmor(%player) == "carmor2" || Player::getArmor(%player) == "carmor3")
		Player::setArmor(%player,carmor);
	else if(Player::getArmor(%player) == "earmor2" || Player::getArmor(%player) == "earmor3")
		Player::setArmor(%player,earmor);
	else if(Player::getArmor(%player) == "larmor2" || Player::getArmor(%player) == "larmor3")
		Player::setArmor(%player,larmor);
	else if(Player::getArmor(%player) == "aarmor2" || Player::getArmor(%player) == "aarmor3")
		Player::setArmor(%player,aarmor);
	else if(Player::getArmor(%player) == "comarmor2" || Player::getArmor(%player) == "comarmor3")
		Player::setArmor(%player,comarmor);
	else if(Player::getArmor(%player) == "mfemale2" || Player::getArmor(%player) == "mfemale3")
		Player::setArmor(%player,mfemale);
	else if(Player::getArmor(%player) == "sfemale2" || Player::getArmor(%player) == "sfemale3")
		Player::setArmor(%player,sfemale);
	else if(Player::getArmor(%player) == "ifemale2" || Player::getArmor(%player) == "ifemale3")
		Player::setArmor(%player,ifemale);
	else if(Player::getArmor(%player) == "gfemale2" || Player::getArmor(%player) == "gfemale3")
		Player::setArmor(%player,gfemale);
	else if(Player::getArmor(%player) == "cfemale2" || Player::getArmor(%player) == "cfemale3")
		Player::setArmor(%player,cfemale);
	else if(Player::getArmor(%player) == "efemale2" || Player::getArmor(%player) == "efemale3")
		Player::setArmor(%player,efemale);
	else if(Player::getArmor(%player) == "lfemale2" || Player::getArmor(%player) == "lfemale3")
		Player::setArmor(%player,lfemale);
	else if(Player::getArmor(%player) == "afemale2" || Player::getArmor(%player) == "afemale3")
		Player::setArmor(%player,afemale);
	else if(Player::getArmor(%player) == "comfemale2" || Player::getArmor(%player) == "comfemale3")
		Player::setArmor(%player,comfemale);
	armorChange2(%player);
	$PlayerBleeding[Player::getClient(%player)] = 0;

}

//----------------------------------------------------------------------------

StaticShapeData DeployableInvStation
{
	description = "Remote Inv Unit";
	shapeFile = "invent_remote";
	className = "DeployableStation";
	maxDamage = 0.25;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	sequenceSound[1] = { "use", SoundUseAmmoStation };
	sequenceSound[2] = { "power", SoundInventoryStationPower };			
	visibleToSensor = true;
	shadowDetailMask = 4;
	castLOS = true;
	supression = false;
	supressable = false;
	mapFilter = 4;
	mapIcon = "M_station";
	debrisId = flashDebrisMedium;
	damageSkinData = "objectDamageSkins";
   explosionId = flashExpSmall;
//	triggerRadius = 1.5;
};

function DeployableInvStation::onAdd(%this)
{
	schedule("DeployableStation::deploy(" @ %this @ ");",1,%this);
	if (GameBase::getMapName(%this) == "") 
		GameBase::setMapName (%this, "R-Inv Station");
	%this.Energy = $RemoteInvEnergy;
}

function DeployableInvStation::onActivate(%this)
{
	if(%this.deployed == 1) {
		GameBase::playSequence(%this,1,"use");
		//echo("Activate " @ %this);
 		InventoryStation::onResupply(%this,"RemoteInvList");
		%this.lastPlayer = Station::getTarget(%this);
	}
	else
		GameBase::setActive(%this,false);
}

StaticShapeData CargoInvStation
{
	description = "Cargo Crate";

	shapeFile = "magcargo";
	className = "DeployableStation";
	maxDamage = 1;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	sequenceSound[1] = { "use", SoundUseAmmoStation };
	sequenceSound[2] = { "power", SoundInventoryStationPower };			
	visibleToSensor = true;
	castLOS = true;
	supression = false;
	supressable = false;
	mapFilter = 4;
	mapIcon = "M_station";
	debrisId = flashDebrisSmall;
	shadowDetailMask = 16;
	explosionId = flashExpMedium;
	damageSkinData = "objectDamageSkins";
   explosionId = flashExpSmall;
//	triggerRadius = 1.5;
};


function CargoInvStation::onAdd(%this)
{
	schedule("DeployableStation::deploy(" @ %this @ ");",1,%this);
	if (GameBase::getMapName(%this) == "") 
		GameBase::setMapName (%this, "R-Inv Station");
	%this.Energy = $RemoteInvEnergy;
}

function CargoInvStation::onActivate(%this)
{
	if(%this.deployed == 1) {
		GameBase::playSequence(%this,1,"use");
		//echo("Activate " @ %this);
 		InventoryStation::onResupply(%this,"RemoteInvList");
		%this.lastPlayer = Station::getTarget(%this);
	}
	else
	{
		GameBase::setActive(%this,false);
	}
}



//----------------------------------------------------------------------------

StaticShapeData InventoryStation
{
   description = "Station Supply Unit";
	shapeFile = "inventory_sta";
	className = "Station";
	visibleToSensor = true;
	validateMaterials = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
	maxDamage = 2.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	triggerRadius = 1.5;
   explosionId = flashExpLarge;
};

function InventoryStation::onEndSequence(%this,%thread)
{
	//echo("End Seq ",%thread);
	if (Station::onEndSequence(%this,%thread)) 
		InventoryStation::onResupply(%this,"InvList");
}

function InventoryStation::onResupply(%this,%InvShopList)
{
	dbecho(3, "STATION::Resupply");
	if (GameBase::isActive(%this)) {
		%player = Station::getTarget(%this);
		if (%player != -1 && %this.lastPlayer == %player) {
			%client = Player::getClient(%player);
			if (%this.target != %client) {
				%prevplayer = Client::getOwnedObject(%this.target);
				if(%prevplayer.Station == %this)
				{
					Client::clearItemShopping(%this.target);
					if(Client::getGuiMode(%this.target) != 1)
					Client::setGuiMode(%this.target,1);
				}
				%player.Station = %this;
				setupShoppingList(%client,%this,%InvShopList);
				updateBuyingList(%client);
				%this.target = %client;
				%this.clTeamEnergy = %client.TeamEnergy;
				%client.invo = %this;
				%client.ListType = %InvShopList;
         		if(!%client.noEnterInventory)
   				Client::setGuiMode(%client,$GuiModeInventory);
				Client::sendMessage(%client,0,"Station Access On");
				%player.ResupplyFlag = 1;
				%weapon = Player::getMountedItem(%player,$WeaponSlot);
				if(%weapon != -1) {
					%player.lastWeapon = %weapon;
					Player::unMountItem(%player,$WeaponSlot);
				}
			}
			%player.waitThrowTime = getSimTime();
			schedule("InventoryStation::onResupply(" @ %this @ ");",0.5,%this);
			$woundedWeaponArm[%client] = 0;
			$woundedLegs[%client] = 0;
			if(Player::getArmor(%client) == "marmor2" || Player::getArmor(%client) == "marmor3")
				Player::setArmor(%client,marmor);
   			else if(Player::getArmor(%client) == "sarmor2" || Player::getArmor(%client) == "sarmor3")
				Player::setArmor(%client,sarmor);
			else if(Player::getArmor(%client) == "iarmor2" || Player::getArmor(%client) == "iarmor3")
				Player::setArmor(%client,iarmor);
			else if(Player::getArmor(%client) == "garmor2" || Player::getArmor(%client) == "garmor3")
				Player::setArmor(%client,garmor);
			else if(Player::getArmor(%client) == "carmor2" || Player::getArmor(%client) == "carmor3")
				Player::setArmor(%client,carmor);
			else if(Player::getArmor(%client) == "earmor2" || Player::getArmor(%client) == "earmor3")
				Player::setArmor(%client,earmor);
			else if(Player::getArmor(%client) == "larmor2" || Player::getArmor(%client) == "larmor3")
				Player::setArmor(%client,larmor);
			else if(Player::getArmor(%client) == "aarmor2" || Player::getArmor(%client) == "aarmor3")
				Player::setArmor(%client,aarmor);
			else if(Player::getArmor(%client) == "comarmor2" || Player::getArmor(%client) == "comarmor3")
				Player::setArmor(%client,comarmor);
			else if(Player::getArmor(%client) == "mfemale2" || Player::getArmor(%client) == "mfemale3")
				Player::setArmor(%client,mfemale);
			else if(Player::getArmor(%client) == "sfemale2" || Player::getArmor(%client) == "sfemale3")
				Player::setArmor(%client,sfemale);
			else if(Player::getArmor(%client) == "ifemale2" || Player::getArmor(%client) == "ifemale3")
				Player::setArmor(%client,ifemale);
			else if(Player::getArmor(%client) == "gfemale2" || Player::getArmor(%client) == "gfemale3")
				Player::setArmor(%client,gfemale);
			else if(Player::getArmor(%client) == "cfemale2" || Player::getArmor(%client) == "cfemale3")
				Player::setArmor(%client,cfemale);
			else if(Player::getArmor(%client) == "efemale2" || Player::getArmor(%client) == "efemale3")
				Player::setArmor(%client,efemale);
			else if(Player::getArmor(%client) == "lfemale2" || Player::getArmor(%client) == "lfemale3")
				Player::setArmor(%client,lfemale);
			else if(Player::getArmor(%client) == "afemale2" || Player::getArmor(%client) == "afemale3")
				Player::setArmor(%client,afemale);
			else if(Player::getArmor(%client) == "comfemale2" || Player::getArmor(%client) == "comfemale3")
				Player::setArmor(%client,comfemale);
			armorChange(%client);
			$PlayerBleeding[Player::getClient(%client)] = 0;
		
			if(%player.ResupplyFlag) 
			   %player.ResupplyFlag = resupply(%this);
			return;
		}
		GameBase::setActive(%this,false);
	}
	if (%this.target != "") {	   
		%player = Client::getOwnedObject(%this.target);
		Client::clearItemShopping(%this.target);
		Client::sendMessage(%this.target,0,"Station Access Off");
		Station::onEndSequence(%this);
		if(GameBase::getDataName(%player.Station) == DeployableInvStation
			|| GameBase::getDataName(%player.Station) == CargoInvStation) {
			Client::setInventoryText(%this.target, "<f1><jc>TEAM ENERGY: " @ $TeamEnergy[Client::getTeam(%this.target)]);
			if(Client::getGuiMode(%this.target) != 1)
				Client::setGuiMode(%this.target,1);
			%player.Station = "";
  			%this.target = "";
		}
		if(Player::getMountedItem(%player,$WeaponSlot) == -1){
			if(%player.lastWeapon != "") {
				Player::useItem(%player,%player.lastWeapon);		 	
				%player.lastWeapon = "";
	  		}
		}
	}
	%this.enterTime="";
}


function resupply(%this)
{
	if (GameBase::isActive(%this)) {
		%player = Station::getTarget(%this);
		if (%player != -1) {
			// Hardcoded here for the ammo types
			if(GameBase::getDataName(%this) == DeployableInvStation
				|| GameBase::getDataName(%this) == CargoInvStation)
				%cnt = DASitemsToResupply(%player);
			else
				%cnt = Station::itemsToResupply(%player);
			if(getSimTime() - %this.enterTime > 11)
				%cnt = 0;
			%client = Player::getClient(%player);
			if (%cnt != 0) {
				updateBuyingList(%client);
				return 1;
			}
			Client::sendMessage(%client,0,"Resupply Complete");
			return 0;
		}
	}
	return 0;
}


//----------------------------------------------------------------------------
function setupShoppingList(%client,%station,%ListType)
{
	%armor = player::Getarmor(%client);
	client::clearItemShopping(%client);
	%max = getNumItems();
	if(%ListType == "InvList") {
		for (%i = 0; %i < %max; %i = %i + 1) {
			%item = getItemData(%i);
			if($InvList[%item] != "" && $InvList[%item] && !%station.dontSell[%item] && $ItemMax[%armor,%item] >0) 
				Client::setItemShopping(%client, %item);
			else if(%item.className == Armor && !%station.dontSell[%item] && %item != "CommandoArmor")  
				Client::setItemShopping(%client, %item);
		}
	}
	else if(%ListType == "RemoteInvList") {
		for (%i = 0; %i < %max; %i = %i + 1) {
			%item = getItemData(%i);
			if($RemoteInvList[%item] != "" && $RemoteInvList[%item] && !%station.dontSell[%item] && $ItemMax[%armor,%item] >0) 
				Client::setItemShopping(%client, %item);
	   }
	}
	else if(%ListType == "VehicleInvList") {
		for (%i = 0; %i < %max; %i = %i + 1) {						
			%item = getItemData(%i);
			if($VehicleInvList[%item] != "" && $VehicleInvList[%item] && !%station.dontSell[%item]) 
				Client::setItemShopping(%client, %item);
		}
	}
	else if(%ListType == "JetInvList") {
		for (%i = 0; %i < %max; %i = %i + 1) {						
			%item = getItemData(%i);
			if($JetInvList[%item] != "" && $JetInvList[%item] && !%station.dontSell[%item]) 
				Client::setItemShopping(%client, %item);
		}
	}
	else if(%ListType == "ChopperInvList") {
		for (%i = 0; %i < %max; %i = %i + 1) {						
			%item = getItemData(%i);
			if($ChopperInvList[%item] != "" && $ChopperInvList[%item] && !%station.dontSell[%item]) 
				Client::setItemShopping(%client, %item);
		}
	}
	else if(%ListType == "TankInvList") {
		for (%i = 0; %i < %max; %i = %i + 1) {						
			%item = getItemData(%i);
			if($TankInvList[%item] != "" && $TankInvList[%item] && !%station.dontSell[%item]) 
				Client::setItemShopping(%client, %item);
		}
	}
	else {
	}
}


function updateBuyingList(%client)
{
   Client::clearItemBuying(%client);
	%station = (Client::getOwnedObject(%client)).Station;
	%stationName = GameBase::getDataName(%station); 
	if(%stationName == DeployableInvStation || %stationName == DeployableAmmoStation || %stationName == CargoInvStation) {
		%energy = %station.Energy;
   	Client::setInventoryText(%client, "<f1><jc>STATION ENERGY: " @ %energy );
	}
   else {
		%energy = $TeamEnergy[Client::getTeam(%client)];
		Client::setInventoryText(%client, "<f1><jc>TEAM ENERGY: " @ %energy);
	}
	%armor = Player::getArmor(%client);
	%max = getNumItems();
	for (%i = 0; %i < %max; %i++) {
		%item = getItemData(%i);
      if(!%item.showInventory)
         continue;
		if($ItemMax[%armor, %item] != "" && Client::isItemShoppingOn(%client,%i)) {
			%extraAmmo = 0;
			if(Player::getMountedItem(%client,$BackpackSlot) == ammopack)
				%extraAmmo = $AmmoPackMax[%item];
			if($ItemMax[%armor, %item] + %extraAmmo > Player::getItemCount(%client,%item))	{
				if(%energy >= %item.price ) {
					if(%item.className == Weapon) {
						if(Player::getItemClassCount(%client,"Weapon") < $MaxWeapons[%armor])					
							Client::setItemBuying(%client, %item);
					}
					else { 
						if($TeamItemMax[%item] != "") {						
							if($TeamItemCount[GameBase::getTeam(%client) @ %item] < $TeamItemMax[%item])
								Client::setItemBuying(%client, %item);
						}
						else
							Client::setItemBuying(%client, %item);
					}
				}
		   }
		}
		else if(%item.className == Armor && %item != $ArmorName[%armor] && Client::isItemShoppingOn(%client,%i)  && %item != "CommandoArmor") 
			Client::setItemBuying(%client, %item);
		else if(%item.className == Vehicle && $TeamItemCount[client::getTeam(%client) @ %item] < $TeamItemMax[%item] && Client::isItemShoppingOn(%client,%i))
			Client::setItemBuying(%client, %item);
	}
}

//----------------------------------------------------------------------------
StaticShapeData CommandStation
{
   description = "Command Station";
	shapeFile = "cmdpnl";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateCommandStation };
	sequenceSound[1] = { "power", SoundCommandStationPower };
	sequenceSound[2] = { "use", SoundUseCommandStation };
	maxDamage = 2.0;
	debrisId = flashDebrisMedium;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	triggerRadius = 1.5;
   explosionId = flashExpLarge;
};

function CommandStation::onEndSequence(%this,%thread)
{
	//echo("End Seq ",%thread);
	(Client::getOwnedObject(%this.target)).Station = "";
	%this.target = "";
	if (Station::onEndSequence(%this,%thread)) 
		CommandStation::onResupply(%this);
}

function CommandStation::onResupply(%this)
{
	if (GameBase::isActive(%this)) {
		%player = Station::getTarget(%this);
		if (%player != -1 && %this.lastPlayer == %player) {
			%client = Player::getClient(%player);
			if (%this.target != %client) {
				%this.target = %client;
				%player.CommandTag = 1;
				Client::setGuiMode(%client,2);
				Client::sendMessage(%client,0,"Command Access On");
				%player.station = %this;
			}
			schedule("CommandStation::onResupply(" @ %this @ ");",0.5,%this);
			return;
		}
		GameBase::setActive(%this,false);
	}
	if (%this.target) {
		Client::sendMessage(%this.target,0,"Command Access Off");
		(Client::getOwnedObject(%this.target)).CommandTag = "";
		checkControlUnmount(%this.target);
	}
	(Client::getOwnedObject(%this.target)).Station = "";
	%this.target = "";
}


//----------------------------------------------------------------------------
StaticShapeData VehicleStation
{
   description = "Station Vehicle Unit";
	shapeFile = "vehi_pur_pnl";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
//   explosionId = DebrisExp;
	maxDamage = 2.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	triggerRadius = 1.5;
   explosionId = flashExpLarge;
};

function VehicleStation::onEndSequence(%this,%thread)
{
	//echo("End Seq ",%thread);
	if (Station::onEndSequence(%this,%thread)) 
		VehicleStation::onBuyingVechicle(%this);
}

function VehicleStation::onBuyingVechicle(%this)
{
	if (GameBase::isActive(%this)) {
		%player = Station::getTarget(%this);
		if (%player != -1 && %this.lastPlayer == %player) {
			%client = Player::getClient(%player);
			if (%this.target != %client) {
				setupShoppingList(%client,%this,"VehicleInvList");
				updateBuyingList(%client);
				%this.target = %client;
				%this.clTeamEnergy = %client.TeamEnergy;
				Client::setGuiMode(%client,4);
				Client::sendMessage(%client,0,"Station Access On");
				%player.Station = %this;
			 	%numItems = Group::objectCount(GetGroup(%this));
				for(%i = 0 ; %i<%numItems ; %i++) { 
					%obj = Group::getObject(GetGroup(%this), %i);
					%name = GameBase::getDataName(%obj); 
					if(%name == VehiclePad) { 
						%this.vehiclePad = %obj;
						GameBase::setActive(%this.vehiclePad,true);
						%i = %numItems;
					}
				}
			}
			schedule("VehicleStation::onBuyingVechicle(" @ %this @ ");",0.5,%this);
			return;
		}
		GameBase::setActive(%this,false);
	}
	if (%this.target) {	   
		Client::clearItemShopping(%this.target);
		Client::sendMessage(%this.target,0,"Station Access Off");
		Station::onEndSequence(%this);
	}
}


function VehicleStation::checkBuying(%client,%item)
{
	%player = Client::getOwnedObject(%client);
	%obj = %player.Station.vehiclePad;
	if(GameBase::isPowered(%obj) && GameBase::getDamageState(%obj) == "Enabled") {
		%markerPos = GameBase::getPosition(%obj);
  		%set = newObject("set",SimSet);
		%mask = $VehicleObjectType | $SimPlayerObjectType | $ItemObjectType;
		%objInWay = containerBoxFillSet(%set,%mask,%markerPos,6,5,14,1);
		%station = %player.Station;
		if(%objInWay == 1) {
			%object = Group::getObject(%set, 0);	
			%sName = GameBase::getDataName(%object);
			if(%sName.className == Vehicle) {
				if(GameBase::getControlClient(%object) == -1) {
					if(%station.fadeOut == "") {
						if(%item != $VehicleToItem[%sname]) {
							%object.fading = 1;
							%station.fadeOut=1;
							teamEnergyBuySell(%player,$VehicleToItem[%sName].price);
							$TeamItemCount[Client::getTeam(%client) @ ($VehicleToItem[%sName])]--;
							GameBase::startFadeOut(%object);
							schedule("Locking::RemoveFromList(" @ %object @ ");",2.5,%object);
							schedule("deleteObject(" @ %object @ ");",2.5,%object);
							schedule(%object @ ".fading = \"\";",2.5,%object);
							schedule(%station @ ".fadeOut = \"\";",2.5,%station);
							%objInWay--;
						}
						else
							return 2;
					}
					else {
						Client::SendMessage(%client,0,"ERROR - Vehicle creation pad busy"); 
						return 0;
					}
				}
				else { 
					Client::SendMessage(%client,0,"ERROR - Vehicle in creation area is mounted");
					return 0;
				}
			} 
		}
		if(!%objInWay) {
			if (checkResources(%player,%item,1)) {
	    		%vehicle = newObject("",flier,$DataBlockName[%item],true);
				Gamebase::setMapName(%vehicle,%item.description);
            %vehicle.clLastMount = %client;
				addToSet("MissionCleanup", %vehicle);
			  	%vehicle.fading = 1;
				GameBase::setTeam(%vehicle,Client::getTeam(%client));
				%vehicle.boughtTeam = Client::getTeam(%client);
				if(%object.fading) { 
					schedule("GameBase::startFadeIn(" @ %vehicle @ ");",2.5,%vehicle);
					schedule("GameBase::setPosition(" @ %vehicle @ ",\"" @ %markerPos @ "\");",2.5,%vehicle);
					schedule("GameBase::setRotation(" @ %vehicle @ ",\"" @ GameBase::getRotation(%obj) @ "\");",2.5,%vehicle);
					schedule(%vehicle @ ".fading = \"\"; VehiclePad::checkSeq(" @ %obj @ "," @ %player.Station @ ");",5,%vehicle);
					%obj.busy = getSimTime() + 5;
				}
				else {
					GameBase::startFadeIn(%vehicle);
					GameBase::setPosition(%vehicle,%markerPos);
					GameBase::setRotation(%vehicle,GameBase::getRotation(%obj));
				 	schedule(%vehicle @ ".fading = \"\"; VehiclePad::checkSeq(" @ %obj @ "," @ %player.Station @ ");",3,%vehicle);
					%obj.busy = getSimTime() + 3;
				}
				deleteObject(%set);
				$TeamItemCount[Client::getTeam(%client) @ %item]++;
				return 1;
			}
		}
		else
			Client::SendMessage(%client,0,"ERROR - Object in vehicle creation area");
		deleteObject(%set);
	}	
	else
		Client::SendMessage(%client,0,"ERROR - Vehicle Pad Disabled");

	return 0;
}


StaticShapeData VehiclePad
{
   description = "Vehicle Pad";
	shapeFile = "vehi_pur_poles";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
	maxDamage = 5.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
   explosionId = flashExpLarge;
	damageSkinData = "objectDamageSkins";
};



function VehiclePad::onActivate(%this)
{
	GameBase::playSequence(%this,1,"use");
}

function VehiclePad::onDeactivate(%this)
{
	GameBase::stopSequence(%this,1);
}

function VehiclePad::onEnabled(%this)
{
}

function VehiclePad::onAdd(%this)
{
}

function VehiclePad::onCollision(%this, %object)
{
}

function VehiclePad::onPower(%this,%power,%generator)
{
	if(!%power)
		GameBase::setActive(%this,false);
}

function VehiclePad::checkSeq(%this, %station)
{
	if(%station.target == "")
		GameBase::setActive(%this,false);
}

//```````````````````````````````````````````````````
StaticShapeData JetStation
{
   description = "Station Jet Unit";
	shapeFile = "vehi_pur_pnl";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
//   explosionId = DebrisExp;
	maxDamage = 2.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	triggerRadius = 1.5;
   explosionId = flashExpLarge;
};

function JetStation::onEndSequence(%this,%thread)
{
	//echo("End Seq ",%thread);
	if (Station::onEndSequence(%this,%thread)) 
		JetStation::onBuyingJet(%this);
}

function JetStation::onBuyingJet(%this)
{
	if (GameBase::isActive(%this)) {
		%player = Station::getTarget(%this);
		if (%player != -1 && %this.lastPlayer == %player) {
			%client = Player::getClient(%player);
			if (%this.target != %client) {
				setupShoppingList(%client,%this,"JetInvList");
				updateBuyingList(%client);
				%this.target = %client;
				%this.clTeamEnergy = %client.TeamEnergy;
				Client::setGuiMode(%client,4);
				Client::sendMessage(%client,0,"Station Access On");
				%player.Station = %this;
			 	%numItems = Group::objectCount(GetGroup(%this));
				for(%i = 0 ; %i<%numItems ; %i++) { 
					%obj = Group::getObject(GetGroup(%this), %i);
					%name = GameBase::getDataName(%obj); 
					if(%name == JetPad) { 
						%this.jetPad = %obj;
						GameBase::setActive(%this.JetPad,true);
						%i = %numItems;
					}
				}
			}
			schedule("JetStation::onBuyingJet(" @ %this @ ");",0.5,%this);
			return;
		}
		GameBase::setActive(%this,false);
	}
	if (%this.target) {	   
		Client::clearItemShopping(%this.target);
		Client::sendMessage(%this.target,0,"Station Access Off");
		Station::onEndSequence(%this);
	}
}


function JetStation::checkBuying(%client,%item)
{
	%player = Client::getOwnedObject(%client);
	%obj = %player.Station.JetPad;
	if(GameBase::isPowered(%obj) && GameBase::getDamageState(%obj) == "Enabled") {
		%markerPos = GameBase::getPosition(%obj);
  		%set = newObject("set",SimSet);
		%mask = $VehicleObjectType | $SimPlayerObjectType | $ItemObjectType;
		%objInWay = containerBoxFillSet(%set,%mask,%markerPos,6,5,14,1);
		%station = %player.Station;
		if(%objInWay == 1) {
			%object = Group::getObject(%set, 0);	
			%sName = GameBase::getDataName(%object);
			if(%sName.className == Vehicle) {
				if(GameBase::getControlClient(%object) == -1) {
					if(%station.fadeOut == "") {
						if(%item != $VehicleToItem[%sname]) {
							%object.fading = 1;
							%station.fadeOut=1;
							teamEnergyBuySell(%player,$VehicleToItem[%sName].price);
							$TeamItemCount[Client::getTeam(%client) @ ($VehicleToItem[%sName])]--;
							$JetUnits[%team]++;
							GameBase::startFadeOut(%object);
							schedule("Locking::RemoveFromList(" @ %object @ ");",2.5,%object);
							schedule("Radar::Remove(" @ %object @ ");",2.5,%object);
							schedule("Radar::Detectable::Remove(" @ %object @ ");",2.5,%object);
							schedule("deleteObject(" @ %object @ ");",2.5,%object);
							schedule(%object @ ".fading = \"\";",2.5,%object);
							schedule(%station @ ".fadeOut = \"\";",2.5,%station);
							%objInWay--;
						}
						else
							return 2;
					}
					else {
						Client::SendMessage(%client,0,"ERROR - Jet creation pad busy"); 
						return 0;
					}
				}
				else { 
					Client::SendMessage(%client,0,"ERROR - Jet in creation area is mounted");
					return 0;
				}
			} 
		}
		if(!%objInWay) {
			if (checkResources(%player,%item,1)) {
	    		%vehicle = newObject("",flier,$DataBlockName[%item],true);
				Gamebase::setMapName(%vehicle,%item.description);
            %vehicle.clLastMount = %client;
				addToSet("MissionCleanup", %vehicle);
			  	%vehicle.fading = 1;
				GameBase::setTeam(%vehicle,Client::getTeam(%client));
				%vehicle.boughtTeam = Client::getTeam(%client);

				if(%object.fading) { 
					schedule("GameBase::startFadeIn(" @ %vehicle @ ");",2.5,%vehicle);
					schedule("GameBase::setPosition(" @ %vehicle @ ",\"" @ %markerPos @ "\");",2.5,%vehicle);
					schedule("GameBase::setRotation(" @ %vehicle @ ",\"" @ GameBase::getRotation(%obj) @ "\");",2.5,%vehicle);
					schedule(%vehicle @ ".fading = \"\"; JetPad::checkSeq(" @ %obj @ "," @ %player.Station @ ");",5,%vehicle);
					%obj.busy = getSimTime() + 5;
				}
				else {
					GameBase::startFadeIn(%vehicle);
					GameBase::setPosition(%vehicle,%markerPos);
					GameBase::setRotation(%vehicle,GameBase::getRotation(%obj));
				 	schedule(%vehicle @ ".fading = \"\"; VehiclePad::checkSeq(" @ %obj @ "," @ %player.Station @ ");",3,%vehicle);
					%obj.busy = getSimTime() + 3;
				}
				deleteObject(%set);
				$TeamItemCount[Client::getTeam(%client) @ %item]++;
				return 1;
			}
		}
		else
			Client::SendMessage(%client,0,"ERROR - Object in Jet creation area");
		deleteObject(%set);
	}	
	else
		Client::SendMessage(%client,0,"ERROR - Jet Pad Disabled");

	return 0;
}


StaticShapeData JetPad
{
   description = "Jet Pad";
	shapeFile = "vehi_pur_poles";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
	maxDamage = 5.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
   explosionId = flashExpLarge;
	damageSkinData = "objectDamageSkins";
};



function JetPad::onActivate(%this)
{
	GameBase::playSequence(%this,1,"use");
}

function JetPad::onDeactivate(%this)
{
	GameBase::stopSequence(%this,1);
}

function JetPad::onEnabled(%this)
{
}

function JetPad::onAdd(%this)
{
}

function JetPad::onCollision(%this, %object)
{
}

function JetPad::onPower(%this,%power,%generator)
{
	if(!%power)
		GameBase::setActive(%this,false);
}

function JetPad::checkSeq(%this, %station)
{
	if(%station.target == "")
		GameBase::setActive(%this,false);
}

//```````````````````````````````````````````````````
StaticShapeData ChopperStation
{
   description = "Station Chopper Unit";
	shapeFile = "vehi_pur_pnl";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
//   explosionId = DebrisExp;
	maxDamage = 2.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	triggerRadius = 1.5;
   explosionId = flashExpLarge;
};

function ChopperStation::onEndSequence(%this,%thread)
{
	//echo("End Seq ",%thread);
	if (Station::onEndSequence(%this,%thread)) 
		ChopperStation::onBuyingChopper(%this);
}

function ChopperStation::onBuyingChopper(%this)
{
	if (GameBase::isActive(%this)) {
		%player = Station::getTarget(%this);
		if (%player != -1 && %this.lastPlayer == %player) {
			%client = Player::getClient(%player);
			if (%this.target != %client) {
				setupShoppingList(%client,%this,"ChopperInvList");
				updateBuyingList(%client);
				%this.target = %client;
				%this.clTeamEnergy = %client.TeamEnergy;
				Client::setGuiMode(%client,4);
				Client::sendMessage(%client,0,"Station Access On");
				%player.Station = %this;
			 	%numItems = Group::objectCount(GetGroup(%this));
				for(%i = 0 ; %i<%numItems ; %i++) { 
					%obj = Group::getObject(GetGroup(%this), %i);
					%name = GameBase::getDataName(%obj); 
					if(%name == ChopperPad) { 
						%this.ChopperPad = %obj;
						GameBase::setActive(%this.ChopperPad,true);
						%i = %numItems;
					}
				}
			}
			schedule("ChopperStation::onBuyingChopper(" @ %this @ ");",0.5,%this);
			return;
		}
		GameBase::setActive(%this,false);
	}
	if (%this.target) {	   
		Client::clearItemShopping(%this.target);
		Client::sendMessage(%this.target,0,"Station Access Off");
		Station::onEndSequence(%this);
	}
}


function ChopperStation::checkBuying(%client,%item)
{
	%player = Client::getOwnedObject(%client);
	%obj = %player.Station.ChopperPad;
	if(GameBase::isPowered(%obj) && GameBase::getDamageState(%obj) == "Enabled") {
		%markerPos = vector::add(GameBase::getPosition(%obj), "0 0 3");
  		%set = newObject("set",SimSet);
		%mask = $VehicleObjectType | $SimPlayerObjectType | $ItemObjectType;
		%objInWay = containerBoxFillSet(%set,%mask,%markerPos,6,5,14,1);
		%station = %player.Station;
		if(%objInWay == 1) {
			%object = Group::getObject(%set, 0);	
			%sName = GameBase::getDataName(%object);
			if(%sName.className == Vehicle) {
				if(GameBase::getControlClient(%object) == -1) {
					if(%station.fadeOut == "") {
						if(%item != $VehicleToItem[%sname]) {
							%object.fading = 1;
							%station.fadeOut=1;
							teamEnergyBuySell(%player,$VehicleToItem[%sName].price);
							$TeamItemCount[Client::getTeam(%client) @ ($VehicleToItem[%sName])]--;
							$ChopperUnits[%team]++;
							GameBase::startFadeOut(%object);
							schedule("deleteObject(" @ %object @ ");",2.5,%object);
							schedule("Locking::RemoveFromList(" @ %object @ ");",2.5,%object);
							schedule("Radar::Remove(" @ %object @ ");",2.5,%object);
							schedule("Radar::Detectable::Remove(" @ %object @ ");",2.5,%object);
							schedule(%object @ ".fading = \"\";",2.5,%object);
							schedule(%station @ ".fadeOut = \"\";",2.5,%station);
							%objInWay--;
						}
						else
							return 2;
					}
					else {
						Client::SendMessage(%client,0,"ERROR - Chopper creation pad busy"); 
						return 0;
					}
				}
				else { 
					Client::SendMessage(%client,0,"ERROR - Chopper in creation area is mounted");
					return 0;
				}
			} 
		}
		if(!%objInWay) {
			if (checkResources(%player,%item,1)) {
	    		%vehicle = newObject("",flier,$DataBlockName[%item],true);
				Gamebase::setMapName(%vehicle,%item.description);
            			%vehicle.clLastMount = %client;
				addToSet("MissionCleanup", %vehicle);
			  	%vehicle.fading = 1;
				GameBase::setTeam(%vehicle,Client::getTeam(%client));
				%vehicle.boughtTeam = Client::getTeam(%client);
				if(%object.fading) { 
					schedule("GameBase::startFadeIn(" @ %vehicle @ ");",2.5,%vehicle);
					schedule("GameBase::setPosition(" @ %vehicle @ ",\"" @ %markerPos @ "\");",2.5,%vehicle);
					schedule("GameBase::setRotation(" @ %vehicle @ ",\"" @ GameBase::getRotation(%obj) @ "\");",2.5,%vehicle);
					schedule(%vehicle @ ".fading = \"\"; VehiclePad::checkSeq(" @ %obj @ "," @ %player.Station @ ");",5,%vehicle);
					%obj.busy = getSimTime() + 5;
				}
				else {
					GameBase::startFadeIn(%vehicle);
					GameBase::setPosition(%vehicle,%markerPos);
					GameBase::setRotation(%vehicle,GameBase::getRotation(%obj));
				 	schedule(%vehicle @ ".fading = \"\"; ChopperPad::checkSeq(" @ %obj @ "," @ %player.Station @ ");",3,%vehicle);
					%obj.busy = getSimTime() + 3;
				}
				deleteObject(%set);
				$TeamItemCount[Client::getTeam(%client) @ %item]++;
				return 1;
			}
		}
		else
			Client::SendMessage(%client,0,"ERROR - Object in Chopper creation area");
		deleteObject(%set);
	}	
	else
		Client::SendMessage(%client,0,"ERROR - Chopper Pad Disabled");

	return 0;
}


StaticShapeData ChopperPad
{
   description = "Chopper Pad";
	shapeFile = "vehi_pur_poles";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
	maxDamage = 5.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
   explosionId = flashExpLarge;
	damageSkinData = "objectDamageSkins";
};



function ChopperPad::onActivate(%this)
{
	GameBase::playSequence(%this,1,"use");
}

function ChopperPad::onDeactivate(%this)
{
	GameBase::stopSequence(%this,1);
}

function ChopperPad::onEnabled(%this)
{
}

function ChopperPad::onAdd(%this)
{
}

function ChopperPad::onCollision(%this, %object)
{
}

function ChopperPad::onPower(%this,%power,%generator)
{
	if(!%power)
		GameBase::setActive(%this,false);
}

function ChopperPad::checkSeq(%this, %station)
{
	if(%station.target == "")
		GameBase::setActive(%this,false);
}

//```````````````````````````````````````````````````
StaticShapeData TankStation
{
   description = "Station Tank Unit";
	shapeFile = "vehi_pur_pnl";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
//   explosionId = DebrisExp;
	maxDamage = 2.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	triggerRadius = 1.5;
   explosionId = flashExpLarge;
};

function TankStation::onEndSequence(%this,%thread)
{
	//echo("End Seq ",%thread);
	if (Station::onEndSequence(%this,%thread)) 
		TankStation::onBuyingTank(%this);
}

function TankStation::onBuyingTank(%this)
{
	if (GameBase::isActive(%this)) {
		%player = Station::getTarget(%this);
		if (%player != -1 && %this.lastPlayer == %player) {
			%client = Player::getClient(%player);
			if (%this.target != %client) {
				setupShoppingList(%client,%this,"TankInvList");
				updateBuyingList(%client);
				%this.target = %client;
				%this.clTeamEnergy = %client.TeamEnergy;
				Client::setGuiMode(%client,4);
				Client::sendMessage(%client,0,"Station Access On");
				%player.Station = %this;
			 	%numItems = Group::objectCount(GetGroup(%this));
				for(%i = 0 ; %i<%numItems ; %i++) { 
					%obj = Group::getObject(GetGroup(%this), %i);
					%name = GameBase::getDataName(%obj); 
					if(%name == TankPad) { 
						%this.TankPad = %obj;
						GameBase::setActive(%this.TankPad,true);
						%i = %numItems;
					}
				}
			}
			schedule("TankStation::onBuyingTank(" @ %this @ ");",0.5,%this);
			return;
		}
		GameBase::setActive(%this,false);
	}
	if (%this.target) {	   
		Client::clearItemShopping(%this.target);
		Client::sendMessage(%this.target,0,"Station Access Off");
		Station::onEndSequence(%this);
	}
}


function TankStation::checkBuying(%client,%item)
{
	%player = Client::getOwnedObject(%client);
	%obj = %player.Station.TankPad;
	if(GameBase::isPowered(%obj) && GameBase::getDamageState(%obj) == "Enabled") {
		%markerPos = GameBase::getPosition(%obj);
  		%set = newObject("set",SimSet);
		%mask = $VehicleObjectType | $SimPlayerObjectType | $ItemObjectType;
		%objInWay = containerBoxFillSet(%set,%mask,%markerPos,6,5,14,1);
		%station = %player.Station;
		if(%objInWay == 1) {
			%object = Group::getObject(%set, 0);	
			%sName = GameBase::getDataName(%object);
			if(%sName.className == Vehicle) {
				if(GameBase::getControlClient(%object) == -1) {
					if(%station.fadeOut == "") {
						if(%item != $VehicleToItem[%sname]) {
							%object.fading = 1;
							%station.fadeOut=1;
							teamEnergyBuySell(%player,$VehicleToItem[%sName].price);
							$TeamItemCount[Client::getTeam(%client) @ ($VehicleToItem[%sName])]--;
							$TankUnits[%team]++;
							GameBase::startFadeOut(%object);
							schedule("Locking::RemoveFromList(" @ %object @ ");",2.5,%object);
							schedule("deleteObject(" @ %object @ ");",2.5,%object);
							schedule(%object @ ".fading = \"\";",2.5,%object);
							schedule(%station @ ".fadeOut = \"\";",2.5,%station);
							%objInWay--;
						}
						else
							return 2;
					}
					else {
						Client::SendMessage(%client,0,"ERROR - Tank creation pad busy"); 
						return 0;
					}
				}
				else { 
					Client::SendMessage(%client,0,"ERROR - Tank in creation area is mounted");
					return 0;
				}
			} 
		}
		if(!%objInWay) {
			if (checkResources(%player,%item,1)) {
	    		%vehicle = newObject("",flier,$DataBlockName[%item],true);
				Gamebase::setMapName(%vehicle,%item.description);
            %vehicle.clLastMount = %client;
				addToSet("MissionCleanup", %vehicle);
			  	%vehicle.fading = 1;
				GameBase::setTeam(%vehicle,Client::getTeam(%client));
				%vehicle.boughtTeam = Client::getTeam(%client);
				if(%object.fading) { 
					schedule("GameBase::startFadeIn(" @ %vehicle @ ");",2.5,%vehicle);
					schedule("GameBase::setPosition(" @ %vehicle @ ",\"" @ %markerPos @ "\");",2.5,%vehicle);
					schedule("GameBase::setRotation(" @ %vehicle @ ",\"" @ GameBase::getRotation(%obj) @ "\");",2.5,%vehicle);
					schedule(%vehicle @ ".fading = \"\"; VehiclePad::checkSeq(" @ %obj @ "," @ %player.Station @ ");",5,%vehicle);
					%obj.busy = getSimTime() + 5;
				}
				else {
					GameBase::startFadeIn(%vehicle);
					GameBase::setPosition(%vehicle,%markerPos);
					GameBase::setRotation(%vehicle,GameBase::getRotation(%obj));
				 	schedule(%vehicle @ ".fading = \"\"; TankPad::checkSeq(" @ %obj @ "," @ %player.Station @ ");",3,%vehicle);
					%obj.busy = getSimTime() + 3;
				}
				deleteObject(%set);
				$TeamItemCount[Client::getTeam(%client) @ %item]++;
				return 1;
			}
		}
		else
			Client::SendMessage(%client,0,"ERROR - Object in Tank creation area");
		deleteObject(%set);
	}	
	else
		Client::SendMessage(%client,0,"ERROR - Tank Pad Disabled");

	return 0;
}


StaticShapeData TankPad
{
   description = "Tank Pad";
	shapeFile = "vehi_pur_poles";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
	maxDamage = 5.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
   explosionId = flashExpLarge;
	damageSkinData = "objectDamageSkins";
};



function TankPad::onActivate(%this)
{
	GameBase::playSequence(%this,1,"use");
}

function TankPad::onDeactivate(%this)
{
	GameBase::stopSequence(%this,1);
}

function TankPad::onEnabled(%this)
{
}

function TankPad::onAdd(%this)
{
}

function TankPad::onCollision(%this, %object)
{
}

function TankPad::onPower(%this,%power,%generator)
{
	if(!%power)
		GameBase::setActive(%this,false);
}

function TankPad::checkSeq(%this, %station)
{
	if(%station.target == "")
		GameBase::setActive(%this,false);
}
