//---------------------------------------------------------------------------------
// Vehicle crash messages - %1 = killer's name, %2 = pilot's name
//       %3 = killer's gender pronoun (his/her), %4 = pilot's gender pronoun
//---------------------------------------------------------------------------------

$crashMsg[Tomcat, 0]		= "%1 shot %2's Tomcat out of the sky.";
$crashMsg[Tomcat, 1]		= "%1 got the tongue of %2's Tomcat.";
$crashMsg[Tomcat, 2]		= "%1 doesn't think %2's fighter is all that superior.";
$crashMsg[Tomcat, 3]		= "%2's Tomcat wasnt fast enough to outmanuver %1.";

$crashMsg[Falcon, 0]		= "%1 shot %2's Falcon out of the sky.";
$crashMsg[Falcon, 1]		= "%1 clipped the wings of %2's Falcon.";
$crashMsg[Falcon, 2]		= "%2 should have brought a Tomcat to face %1.";
$crashMsg[Falcon, 3]		= "%2's strike fighter was taken down by %1.";

$crashMsg[Warthog, 0]		= "%1 shot %2's Warthog out of the sky.";
$crashMsg[Warthog, 1]		= "%1 cooks up %2's Warthog with a bit of BBQ sauce.";
$crashMsg[Warthog, 2]		= "%1 is showered with pieces of %2's Warthog.";
$crashMsg[Warthog, 3]		= "On %1's request, %2 flew %3 low altitude bomber a bit TOO low.";

$crashMsg[MoveWarthog, 0]	= "%1 shot %2's Warthog out of the sky.";
$crashMsg[MoveWarthog, 1]	= "%1 cooks up %2's Warthog with a bit of BBQ sauce.";
$crashMsg[MoveWarthog, 2]	= "%1 is showered with pieces of %2's Warthog.";
$crashMsg[MoveWarthog, 3]	= "On %1's request, %2 flew %3 low altitude bomber a bit TOO low.";

$crashMsg[Hercules, 0]		= "%1 shot %2's Hercules out of the sky.";
$crashMsg[Hercules, 1]		= "The strength of %2's Herclues failed when faced with %1.";
$crashMsg[Hercules, 2]		= "%1 declares %2's flight canceled much to the dismay of %2's passengers.";
$crashMsg[Hercules, 3]		= "%1 forces %2's cargo plane to take an emergency \"landing.\"";

$crashMsg[Sentry, 0]		= "%1 shot %2's Sentry out of the sky.";
$crashMsg[Sentry, 1]		= "%2's Sentry didn't see %1 in time.";
$crashMsg[Sentry, 2]		= "%1 managed to sneak up on %2's Sentry.";
$crashMsg[Sentry, 3]		= "%1 says to %2, \"AWACS? What AWACS?\"";

$crashMsg[Gunship, 0]		= "%1 shot %2's Gunship out of the sky.";
$crashMsg[Gunship, 1]		= "%2's Gunship just didn't have enough guns to defeat %1.";
$crashMsg[Gunship, 2]		= "%1 brings %2's Gunship to a sudden end.";
$crashMsg[Gunship, 3]		= "%2's ground plans were cut short by %1's air plans.";

$crashMsg[Bomber, 0]		= "%1 shot %2's Bomber out of the sky.";
$crashMsg[Bomber, 1]		= "%1 finds that %2's Bomber is less effective when in many pieces.";
$crashMsg[Bomber, 2]		= "%2 didn't fly high enough to avoid %1.";
$crashMsg[Bomber, 3]		= "%1 shows %2 how vulnerable his Bomber really is.";

$crashMsg[Apache, 0]		= "%1 shot %2's Apache out of the sky.";
$crashMsg[Apache, 1]		= "%1 decides to play Cowboys and Indians with %2's Apache";
$crashMsg[Apache, 2]		= "%1 puts the rotary on %2's Apache on hold.";
$crashMsg[Apache, 3]		= "%2's Apache wasn't manuverable enough to face %1.";

$crashMsg[Kiowa, 0]		= "%1 shot %2's Kiowa out of the sky.";
$crashMsg[Kiowa, 1]		= "%1 decides to play Cowboys and Indians with %2's Kiowa";
$crashMsg[Kiowa, 2]		= "%1 found %2's Kiowa.";
$crashMsg[Kiowa, 3]		= "%2's Kiowa wasn't able to run or hide from %1.";

$crashMsg[Hind, 0]		= "%1 shot %2's Hind out of the sky.";
$crashMsg[Hind, 1]		= "%1's hatred burns red for %2's Hind.";
$crashMsg[Hind, 2]		= "%2's Russian influence wasn't enough to prevent destruction by %1.";
$crashMsg[Hind, 3]		= "%1 was as deadly to %2's Hind as it was to infantry.";

$crashMsg[Blackhawk, 0]		= "%1 shot %2's Blackhawk out of the sky.";
$crashMsg[Blackhawk, 1]		= "%1 REALLY likes the movie \"Blackhawk Down\" much to %2's dismay";
$crashMsg[Blackhawk, 2]		= "%1 clips the wings of %2's Blackhawk.";
$crashMsg[Blackhawk, 3]		= "%1 order's %2's passengers to abandon ship.";

$crashMsg[MoveBlackhawkExtraction, 0]		= "%1 shot %2's Blackhawk out of the sky.";
$crashMsg[MoveBlackhawkExtraction, 1]		= "%1 REALLY likes the movie \"Blackhawk Down\" much to %2's dismay";
$crashMsg[MoveBlackhawkExtraction, 2]		= "%1 clips the wings of %2's Blackhawk.";
$crashMsg[MoveBlackhawkExtraction, 3]		= "%1 order's %2's passengers to abandon ship.";


$crashMsg[Humvee, 0]        = "%2's HMMWV got taken to the trash heap by %1.";
$crashMsg[Humvee, 1]        = "%1 wrecked %2's HMMWV permanently.";
$crashMsg[Humvee, 2]        = "%1 trashed %2's HMMWV.";
$crashMsg[Humvee, 3]        = "%2's HMMWV was scattered by %1.";

$crashMsg[Abrams, 0]        = "%1 blew %2's M1A1 Abrams to pieces.";
$crashMsg[Abrams, 1]        = "%2's M1A1 Abrams was shredded by %1.";
$crashMsg[Abrams, 2]        = "%1 retired %2's M1A1 Abrams.";
$crashMsg[Abrams, 3]        = "%2's M1A1 Abrams was reduced to scrap by %1.";

$crashMsg[Bradley, 0]       = "%2's M113 Bradley was derailed by %1.";
$crashMsg[Bradley, 1]       = "%1 nailed %2's M113 Bradley's weak spot.";
$crashMsg[Bradley, 2]       = "%2's M113 Bradley should've avoided %1.";
$crashMsg[Bradley, 3]       = "%1 found %2's M113 Bradley to be quite explosive.";

$crashMsg[LineBacker, 0]    = "%2's M6 Bradley LB was stopped cold by %1.";
$crashMsg[LineBacker, 1]    = "%1 crushed %2's M6 Bradley LB.";
$crashMsg[LineBacker, 2]    = "%2's M6 Bradley lost a fight to %1.";
$crashMsg[LineBacker, 3]    = "%1 made sure that %2's M6 Bradley LB would never ride again.";

$crashMsg[MLRS, 0]      = "%1 smashed up %2's MLRS SPLL.";
$crashMsg[MLRS, 1]      = "%2's MLRS SPLL was turned to junk by %1.";
$crashMsg[MLRS, 2]      = "%1 desicrated %2's MLRS SPLL.";
$crashMsg[MLRS, 3]      = "%2's MLRS SPLL found %1 a bit too late.";

$crashMsg[MineLayer, 0]      = "%1 blew up %2's Cargo.";
$crashMsg[MineLayer, 1]      = "%2's Cargo was hijacked, and destroyed by %1.";
$crashMsg[MineLayer, 2]      = "%1 sabatoged %2's Volcano.";
$crashMsg[MineLayer, 3]      = "%2's Volcano spontaniously combusted. %1 helped a bit.";


$Vmodule[1] = "AIM-9 Sidewinder"; 
$Vmodule[2] = "AIM-54 Phoenix";
$Vmodule[3] = "AGM-114 Hellfire"; 
$Vmodule[4] = "AGM-64 Maverick"; 
$Vmodule[5] = "AGM-88 HARM";
$Vmodule[6] = "Mk-82 500Lb Bomb"; 
$Vmodule[7] = "Mk-84 2000Lb Bomb"; 
$Vmodule[8] = "CBU-59 APAM Bomb"; 
$Vmodule[9] = "CBU-89 Gator Mine Bomb"; 
$Vmodule[10] = "CBU-87 Cluster Bomb"; 
$Vmodule[11] = "BLU-113 Penetrator Bomb"; 
$Vmodule[12] = "M-10 Smoke Tank"; 
$Vmodule[13] = "M-10 Tear Gas Tank"; 
$Vmodule[14] = "Mk-77 Incendiary Bomb"; 
$Vmodule[15] = "Mk-53 Hydrogen Bomb";
$Vmodule[16] = "ALQ-131 ECM Pod"; 
$Vmodule[17] = "Mk-82 500Lb Bombs [4]"; 
$Vmodule[18] = "Mk-84 2000Lb Bomb [2]"; 
$Vmodule[19] = "BLU-82B Daisy Cutter Bomb"; 
$Vmodule[20] = "Supply Crate"; 
$Vmodule[21] = "2.75inch Hydra-70"; 
$Vmodule[22] = "UPK-23-250 23mm Gun Pod"; 
$Vmodule[23] = "GUV YaKB 12.7mm Gun Pod"; 
$Vmodule[24] = "M296 .50 Cal Gun Pod"; 

$ModuleToWeapon[SideWinderModule] = SidewinderRocket;
$ModuleToWeapon[PhoenixModule] = PhoenixRocket;
$ModuleToWeapon[HellfireModule] = ApacheRocket;
$ModuleToWeapon[HydraModule] = HydraRocket;
$ModuleToWeapon[UPKGunPodModule] = TwentyFivemmBullet;
$ModuleToWeapon[GUVGunPodModule] = SAWBullet;
$ModuleToWeapon[FiftyCalModule] = FiftyCalPodBullet;
$ModuleToWeapon[MaverickModule] = MavRocket;
$ModuleToWeapon[HARMModule] = HARMRocket;
$ModuleToWeapon[Mk82Module] = BigBomb;
$ModuleToWeapon[Mk84Module] = BombShell;
$ModuleToWeapon[APClusterModule] = APClusterBomb;
$ModuleToWeapon[MineClusterModule] = MineClusterBomb;
$ModuleToWeapon[BombletClusterModule] = BombletClusterBomb;
$ModuleToWeapon[BunkerBusterModule] = BunkerBusterBomb;
$ModuleToWeapon[TankSmokeModule] = TankSmoke;
$ModuleToWeapon[TankNerveGasModule] = TankNerveGas;
$ModuleToWeapon[IncendiaryNapalmModule] = NapalmBomb;
$ModuleToWeapon[NuclearModule] = NukeShell;
$ModuleToWeapon[EMCModule] = EMCContainer;
$ModuleToWeapon[Mk82PackageModule] = BigBomb;
$ModuleToWeapon[Mk84PackageModule] = BombShell;
$ModuleToWeapon[DaisyCutterModule] = DaisyShell;
$ModuleToWeapon[SupplyCrateModule] = SupplyDrop;


$WeaponToNumber[SidewinderRocket] = 1;
$WeaponToNumber[PhoenixRocket] = 2;
$WeaponToNumber[ApacheRocket] = 3;
$WeaponToNumber[MavRocket] = 4;
$WeaponToNumber[HARMRocket] = 5;
$WeaponToNumber[BigBomb] = 6;
$WeaponToNumber[BombShell] = 7;
$WeaponToNumber[APClusterBomb] = 8;
$WeaponToNumber[MineClusterBomb] = 9;
$WeaponToNumber[BombletClusterBomb] = 10;
$WeaponToNumber[BunkerBusterBomb] = 11;
$WeaponToNumber[TankSmoke] = 12;
$WeaponToNumber[TankNerveGas] = 13;
$WeaponToNumber[NapalmBomb] = 14;
$WeaponToNumber[NukeShell] = 15;
$WeaponToNumber[EMCContainer] = 16;
//$WeaponToNumber[BigBomb] = 17; // Just fucks things up and were decrementing normaly anyway so....
//$WeaponToNumber[BombShell] = 18;
$WeaponToNumber[DaisyShell] = 19;
$WeaponToNumber[SupplyDrop] = 20;
$WeaponToNumber[HydraRocket] = 21;
$WeaponToNumber[TwentyFivemmBullet] = 22;
$WeaponToNumber[SAWBullet] = 23;
$WeaponToNumber[FiftyCalPodBullet] = 24;


$NumberOfMiss[1] = 1;
$NumberOfMiss[2] = 6;
$NumberOfMiss[3] = 4;
$NumberOfMiss[4] = 1;
$NumberOfMiss[5] = 1;
$NumberOfMiss[6] = 1;
$NumberOfMiss[7] = 1;
$NumberOfMiss[8] = 1;
$NumberOfMiss[9] = 1;
$NumberOfMiss[10] = 1;
$NumberOfMiss[11] = 1;
$NumberOfMiss[12] = 50;
$NumberOfMiss[13] = 50;
$NumberOfMiss[14] = 1;
$NumberOfMiss[15] = 1;
$NumberOfMiss[16] = 1;
$NumberOfMiss[17] = 4;
$NumberOfMiss[18] = 2;
$NumberOfMiss[19] = 1;
$NumberOfMiss[20] = 1;
$NumberOfMiss[21] = 19;
$NumberOfMiss[22] = 250;
$NumberOfMiss[23] = 750;
$NumberOfMiss[24] = 500;


$VmoduleHP[1] = 1;
$VmoduleHP[2] = 1;
$VmoduleHP[3] = 1;
$VmoduleHP[4] = 1;
$VmoduleHP[5] = 1;
$VmoduleHP[6] = 2;
$VmoduleHP[7] = 3;
$VmoduleHP[8] = 1;
$VmoduleHP[9] = 1;
$VmoduleHP[10] = 1;
$VmoduleHP[11] = 1;
$VmoduleHP[12] = 2;
$VmoduleHP[13] = 2;
$VmoduleHP[14] = 3;
$VmoduleHP[15] = -1;
$VmoduleHP[16] = 1;
$VmoduleHP[17] = -1;
$VmoduleHP[18] = -1;
$VmoduleHP[19] = -1;
$VmoduleHP[20] = -1;
$VmoduleHP[21] = 1;
$VmoduleHP[22] = 1;
$VmoduleHP[23] = 1;
$VmoduleHP[24] = 1;

$VmoduleBB[1] = -1;
$VmoduleBB[2] = -1;
$VmoduleBB[3] = -1;
$VmoduleBB[4] = -1;
$VmoduleBB[5] = -1;
$VmoduleBB[6] = 1;
$VmoduleBB[7] = 2;
$VmoduleBB[8] = -1;
$VmoduleBB[9] = -1;
$VmoduleBB[10] = -1;
$VmoduleBB[11] = -1;
$VmoduleBB[12] = -1;
$VmoduleBB[13] = -1;
$VmoduleBB[14] = -1;
$VmoduleBB[15] = 54;
$VmoduleBB[16] = -1;
$VmoduleBB[17] = 4;
$VmoduleBB[18] = 4;
$VmoduleBB[19] = 1; // Herc only however.
$VmoduleBB[20] = 1; // Herc only however.
$VmoduleBB[21] = -1;
$VmoduleBB[22] = -1;
$VmoduleBB[23] = -1;
$VmoduleBB[24] = -1;


$VehicleCounterMeasures[Hercules] = 0;
$VehicleCounterMeasures[Sentry] = 30;
$VehicleCounterMeasures[Bomber] = 60;
$VehicleCounterMeasures[Hind] = 30;
$VehicleCounterMeasures[Apache] = 30;
$VehicleCounterMeasures[Kiowa] = 30;
$VehicleCounterMeasures[Tomcat] = 60;
$VehicleCounterMeasures[Falcon] = 60;
$VehicleCounterMeasures[Warthog] = 60;
$VehicleCounterMeasures[MoveWarthog] = 60;
$VehicleCounterMeasures[Blackhawk] = 30;
$VehicleCounterMeasures[MoveBlackhawkExtraction] = 30;
$VehicleCounterMeasures[Gunship] = 60;

$VehicleCounterMeasures[Humvee] = 0;
$VehicleCounterMeasures[Abrams] = 0;
$VehicleCounterMeasures[Bradley] = 0;
$VehicleCounterMeasures[Linebacker] = 0;
$VehicleCounterMeasures[MineLayer] = 0;
$VehicleCounterMeasures[MLRS] = 0;


// DELTA FORCE VEHICLES
// ---------------------------------------------

//----------------------------------------------------------------------------
//Falcon, F-16
//----------------------------------------------------------------------------

FlierData Falcon
{
	range = 500;
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "flyer";
   shieldShapeName = "shield_medium";
   mass = 100.0;
   drag = 0.5;
   density = 1.2;
   maxBank = 5.0;
   maxPitch = 100.0; //(5) This way we can do many loops in the air without rewinding
   maxSpeed = 75;
   minSpeed = 0;
	lift = 20.0;
	maxAlt = 450;
	maxVertical = 20;
	maxDamage = 3.8;
	damageLevel = {1.0, 1.0};
	maxEnergy = 100;
	accel = 0.4395;//0.5;

	groundDamageScale = 1.0;

	//projectileType = FalconBullet;
	reloadDelay = 0.1;
	repairRate = 0;
	fireSound = shockExplosion;
	damageSound = SoundTankCrash;
	ramDamage = 1.5;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundDiscSpin;
	moveSound = SoundFlyerActive;

	visibleDriver = false;
	driverPose = 22;
	description = "F-16 Falcon";
};

//----------------------------------------------------------------------------
//DiveBomber Stuka
//----------------------------------------------------------------------------

//FlierData DiveBomber
//{
//	explosionId = flashExpLarge;
//	debrisId = flashDebrisLarge;
//	className = "Vehicle";
//   shapeFile = "flyer";
//   shieldShapeName = "shield_medium";
//   mass = 8.0;
//   drag = 0.5;
//   density = 1.2;
//   maxBank = 6.5;
//   maxPitch = 100.0; //6.5
//  maxSpeed = 60;
//   minSpeed = 0;
//	lift = 20;
//	maxAlt = 300;
//	maxVertical = 20;
//	maxDamage = 3.0;
//	damageLevel = {1.0, 1.0};
//	maxEnergy = 100;
//	accel = 0.4;
//
//	groundDamageScale = 1.0;
//
//	//projectileType = BombShell;
//	reloadDelay = 5.0;
//	repairRate = 0;
//	fireSound = SoundDryFire;
//	damageSound = SoundTankCrash;
//	ramDamage = 1.5;
//	ramDamageType = -1;
//	mapFilter = 2;
//	mapIcon = "M_vehicle";
//	visibleToSensor = true;
//	shadowDetailMask = 2;
//
//	mountSound = SoundFlyerMount;
//	dismountSound = SoundFlyerDismount;
//	idleSound = SoundDiscSpin;
//	moveSound = SoundFlyerActive;
//
//	visibleDriver = false;
//	driverPose = 22;
//	description = "JU87B-1 Sturzkampfflugzeus";
//};

//----------------------------------------------------------------------------
//Tomcat, F-14
//----------------------------------------------------------------------------

FlierData Tomcat
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "flyer";
   shieldShapeName = "shield_medium";
   mass = 100.0;
   drag = 0.5;
   density = 1.2;
   maxBank = 100.0;
   maxPitch = 100.0;//6
   maxSpeed = 80;
   minSpeed = 0;
	lift = 20.0;
	maxAlt = 450;
	maxVertical = 20;
	maxDamage = 3.5;
	damageLevel = {1.0, 1.0};
	maxEnergy = 100;
	accel = 0.5;

	groundDamageScale = 1.0;

	//projectileType = FalconBullet;
	reloadDelay = 0.1;
	repairRate = 0;
	fireSound = shockExplosion;
	damageSound = SoundTankCrash;
	ramDamage = 1.5;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundDiscSpin;
	moveSound = SoundFlyerActive;

	visibleDriver = false;
	driverPose = 22;
	description = "F-14A Tomcat";
};

FlierData Apache
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "flyer";
   shieldShapeName = "shield_medium";
   mass = 9.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.5;
   maxPitch = 0.5;
   maxSpeed = 45;
   minSpeed = -2;
	lift = 0.75;
	maxAlt = 300;
	maxVertical = 10;
	maxDamage = 2.0;
	damageLevel = {1.0, 1.0};
	maxEnergy = 100;
	accel = 0.4;

	groundDamageScale = 1.0;

	//projectileType = ApacheRocket;
	reloadDelay = 0.5;
	repairRate = 0;
	fireSound = SoundFireFlierRocket;
	damageSound = SoundFlierCrash;
	ramDamage = 1.5;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundFlyerIdle;
	moveSound = SoundFlyerActive;

	visibleDriver = False;
	driverPose = 22;
	description = "AH-64D Apache";
};

FlierData Kiowa
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "flyer";
   shieldShapeName = "shield_medium";
   mass = 9.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.5;
   maxPitch = 0.5;
   maxSpeed = 40;
   minSpeed = -2;
	lift = 0.65;
	maxAlt = 300;
	maxVertical = 10;
	maxDamage = 1.75;
	damageLevel = {1.0, 1.0};
	maxEnergy = 100;
	accel = 0.4;

	groundDamageScale = 1.0;

	//projectileType = ApacheRocket;
	reloadDelay = 0.5;
	repairRate = 0;
	fireSound = SoundFireFlierRocket;
	damageSound = SoundFlierCrash;
	ramDamage = 1.5;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundFlyerIdle;
	moveSound = SoundFlyerActive;

	visibleDriver = False;
	driverPose = 22;
	description = "OH-58D Kiowa";
};

FlierData Hind
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc_sml";
   shieldShapeName = "shield_medium";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.5;
   maxPitch = 0.5;
   maxSpeed = 30;
   minSpeed = -1;
	lift = 1.24;
	maxAlt =300;
	maxVertical = 10;
	maxDamage = 5.0;
	damageLevel = {1.0, 1.0};
	maxEnergy = 100;
	accel = 0.1;

	groundDamageScale = 0.5;

	//projectileType = ApacheRocket;
	reloadDelay = 0.5;
	repairRate = 0;
	fireSound = SoundFireFlierRocket;
	damageSound = SoundFlierCrash;
	ramDamage = 8.0;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundFlyerIdle;
	moveSound = SoundFlyerActive;

	visibleDriver = false;
	driverPose = 23;
	description = "Mi-24 Hind";
};

function Hind::onFire(%this) 
{
	Vehicle::onFire(%this);
}

FlierData Bomber
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc";
   shieldShapeName = "shield_large";
     mass = 500.0;
   drag = 0.5;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.5;
   maxSpeed = 30;
   minSpeed = 0;
	lift = 20.0;
	maxAlt = 500;
	maxVertical = 20;
	maxDamage = 15.0;
	damageLevel = {1.0, 1.0};
	destroyDamage = 1.0;
	maxEnergy = 100;
	accel = 0.15;

	groundDamageScale = 1.0;

	//projectileType = BombShell;
	reloadRate = 0;
	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	fireSound = SoundDryFire;
	reloadDelay = 0.3;
	damageSound = SoundTankCrash;
	visibleToSensor = False;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundDiscSpin;
	moveSound = SoundFlyerActive;

	visibleDriver = False;
	driverPose = 23;
	description = "B-52 Stratofortress";
};

FlierData Hercules
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc";
   shieldShapeName = "shield_large";
     mass = 500.0;
   drag = 0.5;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.5;
   maxSpeed = 30;
   minSpeed = 0;
	lift = 20.0;
	maxAlt = 500;
	maxVertical = 20;
	maxDamage = 15.0;
	damageLevel = {1.0, 1.0};
	destroyDamage = 1.0;
	maxEnergy = 100;
	accel = 0.15;

	groundDamageScale = 1.0;

	//projectileType = BombShell;
	//reloadRate = 0;
	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	//fireSound = SoundFireMortar;
	reloadDelay = 0.3;
	damageSound = SoundTankCrash;
	visibleToSensor = True;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundDiscSpin;
	moveSound = SoundFlyerActive;

	visibleDriver = False;
	driverPose = 23;
	description = "C-130 Hercules";
};

FlierData Sentry
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc";
   shieldShapeName = "shield_large";
     mass = 500.0;
   drag = 0.5;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.5;
   maxSpeed = 30;
   minSpeed = 0;
	lift = 20.0;
	maxAlt = 500;
	maxVertical = 20;
	maxDamage = 15.0;
	damageLevel = {1.0, 1.0};
	destroyDamage = 1.0;
	maxEnergy = 100;
	accel = 0.15;

	groundDamageScale = 1.0;

	//projectileType = BombShell;
	reloadRate = 0;
	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	fireSound = SoundDryFire;
	reloadDelay = 0.3;
	damageSound = SoundTankCrash;
	visibleToSensor = False;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundDiscSpin;
	moveSound = SoundFlyerActive;

	visibleDriver = False;
	driverPose = 23;
	description = "E-3 Sentry";
};

FlierData Gunship
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc";
   shieldShapeName = "shield_large";
     mass = 500.0;
   drag = 0.5;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.5;
   maxSpeed = 30;
   minSpeed = 0;
	lift = 20.0;
	maxAlt = 500;
	maxVertical = 20;
	maxDamage = 15.0;
	damageLevel = {1.0, 1.0};
	destroyDamage = 1.0;
	maxEnergy = 100;
	accel = 0.15;

	groundDamageScale = 1.0;

	//projectileType = BombShell;
	//reloadRate = 0;
	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	//fireSound = SoundFireMortar;
	reloadDelay = 0.3;
	damageSound = SoundTankCrash;
	visibleToSensor = True;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundDiscSpin;
	moveSound = SoundFlyerActive;

	visibleDriver = False;
	driverPose = 23;
	description = "AC-130U Gunship";
};

function Gunship::onAdd(%this) 
{
	$VehicleAmmo[%this, LowMountTwentyFivemmgun] = 1000;
	$VehicleAmmo[%this, LowMountAbramsGun] = 100;
	$VehicleAmmo[%this, Fortymmgun] = 256;
	$PassengerSlot[%this, 2] = 0;
	$PassengerSlot[%this, 3] = 0;
	$PassengerSlot[%this, 4] = 0;
	$PassengerSlot[%this, 5] = 0;
	Vehicle::onAdd(%this);
}

FlierData Warthog
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc_sml";
   shieldShapeName = "shield_large";
     mass = 100.0;
   drag = 0.5;
   density = 1.2;
   maxBank = 100;//2.7;
   maxPitch = 100;//5.7;
   maxSpeed = 55;
   minSpeed = 0;
	lift = 20.0;
	maxAlt = 250;
	maxVertical = 20;
	maxDamage = 7.0;
	damageLevel = {1.0, 1.0};
	destroyDamage = 1.0;
	maxEnergy = 100;
	accel = 0.2363;

	groundDamageScale = 1.0;

	//projectileType = WarthogBullet;
	//reloadDelay = 0.5;
	//reloadRate = 0;
	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	//fireSound = SoundFireMortar;
	//reloadDelay = 0.3;
	damageSound = SoundTankCrash;
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundDiscSpin;
	moveSound = SoundFlyerActive;

	visibleDriver = False;
	driverPose = 23;
	description = "A-10 Warthog";
};
function Warthog::onFire(%this)
{
	Vehicle::onFire(%this);
}

FlierData TOWMissile
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "rocket";
   shieldShapeName = "shield_medium";
   mass = 9.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.5;
   maxPitch = 0.5;
   maxSpeed = 60;
   minSpeed = 60;
	lift = 0.75;
	maxAlt = 200;
	maxVertical = 10;
	maxDamage = 0.001;
	damageLevel = {1.0, 1.0};
	maxEnergy = 100;
	accel = 2.0;

	groundDamageScale = 5.0;

	reloadDelay = 0.0;
	repairRate = 0;
	damageSound = SoundFlierCrash;
	ramDamage = 3.5;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	visibleToSensor = true;
	shadowDetailMask = 2;

	moveSound = SoundJetHeavy;

	visibleDriver = false;
	driverPose = 22;
	description = "TOW";
};

function OutOfCable(%this) 
{
	%cl = GameBase::getControlClient(%this);
	Vehicle::dismount(%this, "0 0 0");
	//remoteEval(%cl, BP, "<jc><f0>TOW Missile is out of cable", 4);
	bottomprint(%cl, "<jc><f0>TOW Missile is out of cable", 4);
}

function TOWMissile::onAdd(%this) 
{
	GameBase::setRechargeRate(%this, -25); // TOW lives for 4 seconds
	schedule("OutOfCable("@%this@");", 4, %this);
	schedule("$TOWDetEnable["@%this@"] = 1;", 0.5, %this);
}

function TOWMissile::onFire(%this)
{
	if ($TOWDetEnable[%this] == 1) {
		%cl = GameBase::getControlClient(%this);
		Vehicle::dismount(%this, "0 0 0");
		//remoteEval(%cl, BP, "<jc><f0>TOW Missile Remotely Detonated", 4);
		bottomprint(%cl, "<jc><f0>TOW Missile Remotely Detonated", 4);
		$TOWDetEnable[%this] = 0;
	}
}

FlierData Blackhawk
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc_sml";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.175;
   maxSpeed = 37;
   minSpeed = -1;
	lift = 0.5;
	maxAlt = 300;
	maxVertical = 6;
	maxDamage = 7.0;
	damageLevel = {1.0, 1.0};
	destroyDamage = 1.0;
	maxEnergy = 100;
	accel = 0.25;

	groundDamageScale = 0.50;

	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	fireSound = SoundFireFlierRocket;
	reloadDelay = 3.0;
	damageSound = SoundTankCrash;
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundFlyerIdle;
	moveSound = SoundFlyerActive;

	visibleDriver = false;
	driverPose = 23;
	description = "UH-60 Blackhawk";
};

function Blackhawk::onAdd(%this) 
{
	$VehicleAmmo[%this, LowMountMinigun] = 400;
	$PassengerSlot[%this, 2] = 0;
	$PassengerSlot[%this, 3] = 0;
	Vehicle::onAdd(%this);
}


FlierData Humvee
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc_sml";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.3;
   maxSpeed = 30;
   minSpeed = -10;
	//lift = 26.0;
	lift = 2.0;
	maxAlt = 10;
	maxVertical = 6;
	maxDamage = 2.0;
	damageLevel = {1.0, 1.0};
	destroyDamage = 1.0;
	maxEnergy = 100;
	accel = 0.25;

	groundDamageScale = 0.50;

	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	fireSound = SoundFireFlierRocket;
	reloadDelay = 3.0;
	damageSound = SoundTankCrash;
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundGeneratorPower;
	moveSound = SoundFlyerActive;

	visibleDriver = false;
	driverPose = 23;
	description = "HMMWV";
};

function Humvee::onAdd(%this) 
{
	$VehicleAmmo[%this, TOW] = 8;
	$VehicleAmmo[%this, AutoGrenLauncher] = 50;
	$PassengerSlot[%this, 2] = 0;
	$PassengerSlot[%this, 3] = 0;
	Vehicle::onAdd(%this);
}

FlierData Abrams
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc_sml";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.3;
   maxSpeed = 20;
   minSpeed = -10;
	//lift = 26.0;
	lift = 2.0;
	maxAlt = 10;
	maxVertical = 6;
	maxDamage = 6.5;
	damageLevel = {1.0, 1.0};
	destroyDamage = 1.0;
	maxEnergy = 100;
	accel = 0.25;

	groundDamageScale = 0.50;

	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	fireSound = SoundFireFlierRocket;
	reloadDelay = 3.0;
	damageSound = SoundTankCrash;
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundGeneratorPower;
	moveSound = SoundFlyerActive;

	visibleDriver = false;
	driverPose = 23;
	description = "M1A1 Abrams";
};

function Abrams::onAdd(%this) 
{
	$VehicleAmmo[%this, AbramsGun] = 30;
	$VehicleAmmo[%this, Minigun] = 400;
	$PassengerSlot[%this, 2] = 0;
	$PassengerSlot[%this, 3] = 0;
	Vehicle::onAdd(%this);
}

FlierData Bradley
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.175;
   maxSpeed = 20;								   
   minSpeed = -10;
	//lift = 26.0;
	lift = 2.0;
	maxAlt = 10;
	maxVertical = 6;
	maxDamage = 6.5;
	damageLevel = {1.0, 1.0};
	maxEnergy = 100;
	accel = 0.25;

	groundDamageScale = 0.125;

	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	fireSound = SoundFireFlierRocket;
	reloadDelay = 3.0;
	damageSound = SoundTankCrash;
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundGeneratorPower;
	moveSound = SoundFlyerActive;

	visibleDriver = false;
	driverPose = 23;
	description = "M113 Bradley";
};
function Bradley::onAdd(%this) 
{
	$VehicleAmmo[%this, TwentyFivemmgun] = 300;
	$VehicleAmmo[%this, TOW] = 2;
	$VehicleAmmo[%this, MiniGun] = 700;
	$PassengerSlot[%this, 2] = 0;
	$PassengerSlot[%this, 3] = 0;
	$PassengerSlot[%this, 4] = 0;
	Vehicle::onAdd(%this);
}

FlierData LineBacker
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.175;
   maxSpeed = 20;								   
   minSpeed = -10;
	//lift = 26.0;
	lift = 2.0;
	maxAlt = 10;
	maxVertical = 6;
	maxDamage = 6.5;
	damageLevel = {1.0, 1.0};
	maxEnergy = 100;
	accel = 0.25;

	groundDamageScale = 0.125;

	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	fireSound = SoundFireFlierRocket;
	reloadDelay = 3.0;
	damageSound = SoundTankCrash;
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundGeneratorPower;
	moveSound = SoundFlyerActive;

	visibleDriver = false;
	driverPose = 23;
	description = "M6 Bradley LB";
};
function LineBacker::onAdd(%this) 
{
	$VehicleAmmo[%this, StingerLauncherGun] = 10;
	$VehicleAmmo[%this, TwentyFivemmgun] = 600;
	$VehicleAmmo[%this, MiniGun] = 1000;
	$PassengerSlot[%this, 2] = 0;
	$PassengerSlot[%this, 3] = 0;
	$PassengerSlot[%this, 4] = 0;
	Vehicle::onAdd(%this);
}

FlierData MLRS
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.175;
   maxSpeed = 20;								   
   minSpeed = -10;
	//lift = 26.0;
	lift = 2.0;
	maxAlt = 10;
	maxVertical = 6;
	maxDamage = 5.5;
	damageLevel = {1.0, 1.0};
	maxEnergy = 100;
	accel = 0.25;

	groundDamageScale = 0.125;

	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	fireSound = SoundFireFlierRocket;
	reloadDelay = 3.0;
	damageSound = SoundTankCrash;
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundGeneratorPower;
	moveSound = SoundFlyerActive;

	visibleDriver = false;
	driverPose = 23;
	description = "MLRS SPLL";
};
function MLRS::onAdd(%this) 
{
	$VehicleAmmo[%this, MLRSLauncher] = 12;
	$PassengerSlot[%this, 2] = 0;
	Vehicle::onAdd(%this);
}

FlierData MineLayer
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc_sml";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.3;
   maxSpeed = 25;
   minSpeed = -10;
	//lift = 26.0;
	lift = 2.0;
	maxAlt = 10;
	maxVertical = 6;
	maxDamage = 2.0;
	damageLevel = {1.0, 1.0};
	destroyDamage = 1.0;
	maxEnergy = 100;
	accel = 0.25;

	groundDamageScale = 0.50;

	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	fireSound = SoundFireFlierRocket;
	reloadDelay = 3.0;
	damageSound = SoundTankCrash;
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundGeneratorPower;
	moveSound = SoundFlyerActive;

	visibleDriver = false;
	driverPose = 23;
	description = "M548A3";
};

$DamageScale[Falcon, $ImpactDamageType] = 5.0;
$DamageScale[Falcon, $BulletDamageType] = 0.9;
$DamageScale[Falcon, $PlasmaDamageType] = 1.0;
$DamageScale[Falcon, $EnergyDamageType] = 1.0;
$DamageScale[Falcon, $ExplosionDamageType] = 1.0;
$DamageScale[Falcon, $ShrapnelDamageType] = 1.0;
$DamageScale[Falcon, $DebrisDamageType] = 1.0;
$DamageScale[Falcon, $MissileDamageType] = 2.0;
$DamageScale[Falcon, $LaserDamageType] = 1.0;
$DamageScale[Falcon, $MortarDamageType] = 1.0;
$DamageScale[Falcon, $BlasterDamageType] = 1.0;
$DamageScale[Falcon, $ElectricityDamageType] = 0.01;
$DamageScale[Falcon, $MineDamageType]        = 1.0;
$DamageScale[Falcon, $BleedDamageType] = 0.0;
$DamageScale[Falcon, $GrenadeDamageType] = 0.5;
$DamageScale[Falcon, $PoisonDamageType] = 0.0;
$DamageScale[Falcon, $SmokeDamageType] = 0.0;
$DamageScale[Falcon, $StabDamageType] = 0.0;

//$DamageScale[DiveBomber, $ImpactDamageType] = 5.0;
//$DamageScale[DiveBomber, $BulletDamageType] = 1.0;
//$DamageScale[DiveBomber, $PlasmaDamageType] = 1.0;
//$DamageScale[DiveBomber, $EnergyDamageType] = 1.0;
//$DamageScale[DiveBomber, $ExplosionDamageType] = 1.0;
//$DamageScale[DiveBomber, $ShrapnelDamageType] = 1.0;
//$DamageScale[DiveBomber, $DebrisDamageType] = 1.0;
//$DamageScale[DiveBomber, $MissileDamageType] = 2.3;
//$DamageScale[DiveBomber, $LaserDamageType] = 1.0;
//$DamageScale[DiveBomber, $MortarDamageType] = 1.0;
//$DamageScale[DiveBomber, $BlasterDamageType] = 1.0;
//$DamageScale[DiveBomber, $ElectricityDamageType] = 0.01;
//$DamageScale[DiveBomber, $MineDamageType]        = 1.0;
//$DamageScale[DiveBomber, $BleedDamageType] = 0.0;
//$DamageScale[DiveBomber, $GrenadeDamageType] = 0.5;

$DamageScale[Tomcat, $ImpactDamageType] = 5.0;
$DamageScale[Tomcat, $BulletDamageType] = 0.8;
$DamageScale[Tomcat, $PlasmaDamageType] = 1.0;
$DamageScale[Tomcat, $EnergyDamageType] = 1.0;
$DamageScale[Tomcat, $ExplosionDamageType] = 1.0;
$DamageScale[Tomcat, $ShrapnelDamageType] = 1.0;
$DamageScale[Tomcat, $DebrisDamageType] = 1.0;
$DamageScale[Tomcat, $MissileDamageType] = 2.0;
$DamageScale[Tomcat, $LaserDamageType] = 1.0;
$DamageScale[Tomcat, $MortarDamageType] = 1.0;
$DamageScale[Tomcat, $BlasterDamageType] = 1.0;
$DamageScale[Tomcat, $ElectricityDamageType] = 0.01;
$DamageScale[Tomcat, $MineDamageType]        = 1.0;
$DamageScale[Tomcat, $BleedDamageType] = 0.0;
$DamageScale[Tomcat, $GrenadeDamageType] = 0.5;
$DamageScale[Tomcat, $PoisonDamageType] = 0.0;
$DamageScale[Tomcat, $SmokeDamageType] = 0.0;
$DamageScale[Tomcat, $StabDamageType] = 0.0;

$DamageScale[Apache, $ImpactDamageType] = 5.0;
$DamageScale[Apache, $BulletDamageType] = 0.3;
$DamageScale[Apache, $PlasmaDamageType] = 0.05;
$DamageScale[Apache, $EnergyDamageType] = 1.0;
$DamageScale[Apache, $ExplosionDamageType] = 1.0;
$DamageScale[Apache, $ShrapnelDamageType] = 1.0;
$DamageScale[Apache, $DebrisDamageType] = 1.0;
$DamageScale[Apache, $MissileDamageType] = 1.8;
$DamageScale[Apache, $LaserDamageType] = 0.5;
$DamageScale[Apache, $MortarDamageType] = 1.0;
$DamageScale[Apache, $BlasterDamageType] = 0.5;
$DamageScale[Apache, $ElectricityDamageType] = 1.0;
$DamageScale[Apache, $MineDamageType]        = 1.0;
$DamageScale[Apache, $ChargeDamageType]      = 1.0;
$DamageScale[Apache, $AirstrikeDamageType]   = 1.0;
$DamageScale[Apache, $BleedDamageType] = 0.0;
$DamageScale[Apache, $GrenadeDamageType] = 0.5;
$DamageScale[Apache, $PoisonDamageType] = 0.0;
$DamageScale[Apache, $SmokeDamageType] = 0.0;
$DamageScale[Apache, $StabDamageType] = 0.0;

$DamageScale[Kiowa, $ImpactDamageType] = 5.0;
$DamageScale[Kiowa, $BulletDamageType] = 0.5;
$DamageScale[Kiowa, $PlasmaDamageType] = 0.05;
$DamageScale[Kiowa, $EnergyDamageType] = 1.0;
$DamageScale[Kiowa, $ExplosionDamageType] = 1.0;
$DamageScale[Kiowa, $ShrapnelDamageType] = 1.0;
$DamageScale[Kiowa, $DebrisDamageType] = 1.0;
$DamageScale[Kiowa, $MissileDamageType] = 1.8;
$DamageScale[Kiowa, $LaserDamageType] = 0.5;
$DamageScale[Kiowa, $MortarDamageType] = 1.0;
$DamageScale[Kiowa, $BlasterDamageType] = 0.5;
$DamageScale[Kiowa, $ElectricityDamageType] = 1.0;
$DamageScale[Kiowa, $MineDamageType]        = 1.0;
$DamageScale[Kiowa, $ChargeDamageType]      = 1.0;
$DamageScale[Kiowa, $AirstrikeDamageType]   = 1.0;
$DamageScale[Kiowa, $BleedDamageType] = 0.0;
$DamageScale[Kiowa, $GrenadeDamageType] = 0.6;
$DamageScale[Kiowa, $PoisonDamageType] = 0.0;
$DamageScale[Kiowa, $SmokeDamageType] = 0.0;
$DamageScale[Kiowa, $StabDamageType] = 0.0;

$DamageScale[Hind, $ImpactDamageType] = 3.0;
$DamageScale[Hind, $BulletDamageType] = 0.05;
$DamageScale[Hind, $PlasmaDamageType] = 1.0;
$DamageScale[Hind, $EnergyDamageType] = 1.0;
$DamageScale[Hind, $ExplosionDamageType] = 1.0;
$DamageScale[Hind, $ShrapnelDamageType] = 0.3;
$DamageScale[Hind, $DebrisDamageType] = 0.5;
$DamageScale[Hind, $MissileDamageType] = 1.6;
$DamageScale[Hind, $LaserDamageType] = 0.5;
$DamageScale[Hind, $MortarDamageType] = 1.0;
$DamageScale[Hind, $BlasterDamageType] = 0.5;
$DamageScale[Hind, $ElectricityDamageType] = 1.0;
$DamageScale[Hind, $MineDamageType]        = 1.0;
$DamageScale[Hind, $ChargeDamageType]      = 1.0;
$DamageScale[Hind, $AirstrikeDamageType]   = 1.0;
$DamageScale[Hind, $BleedDamageType] = 0.0;
$DamageScale[Hind, $GrenadeDamageType] = 0.5;
$DamageScale[Hind, $PoisonDamageType] = 0.0;
$DamageScale[Hind, $SmokeDamageType] = 0.0;
$DamageScale[Hind, $StabDamageType] = 0.0;

$DamageScale[Bomber, $ImpactDamageType] = 10.0;
$DamageScale[Bomber, $BulletDamageType] = 0.5;
$DamageScale[Bomber, $PlasmaDamageType] = 1.0;
$DamageScale[Bomber, $EnergyDamageType] = 1.0;
$DamageScale[Bomber, $ExplosionDamageType] = 0.7;
$DamageScale[Bomber, $ShrapnelDamageType] = 0.6;
$DamageScale[Bomber, $DebrisDamageType] = 0.7;
$DamageScale[Bomber, $MissileDamageType] = 2.0;
$DamageScale[Bomber, $LaserDamageType] = 0.3;
$DamageScale[Bomber, $MortarDamageType] = 1.0;
$DamageScale[Bomber, $BlasterDamageType] = 0.5;
$DamageScale[Bomber, $ElectricityDamageType] = 1.0;
$DamageScale[Bomber, $MineDamageType]        = 1.0;
$DamageScale[Bomber, $ChargeDamageType] = 1.0;
$DamageScale[Bomber, $AirstrikeDamageType]   = 1.0;
$DamageScale[Bomber, $BleedDamageType] = 0.0;
$DamageScale[Bomber, $GrenadeDamageType] = 0.5;
$DamageScale[Bomber, $PoisonDamageType] = 0.0;
$DamageScale[Bomber, $SmokeDamageType] = 0.0;
$DamageScale[Bomber, $StabDamageType] = 0.0;

$DamageScale[Hercules, $ImpactDamageType] = 10.0;
$DamageScale[Hercules, $BulletDamageType] = 0.5;
$DamageScale[Hercules, $PlasmaDamageType] = 1.0;
$DamageScale[Hercules, $EnergyDamageType] = 1.0;
$DamageScale[Hercules, $ExplosionDamageType] = 0.7;
$DamageScale[Hercules, $ShrapnelDamageType] = 0.6;
$DamageScale[Hercules, $DebrisDamageType] = 0.7;
$DamageScale[Hercules, $MissileDamageType] = 2.0;
$DamageScale[Hercules, $LaserDamageType] = 0.3;
$DamageScale[Hercules, $MortarDamageType] = 1.0;
$DamageScale[Hercules, $BlasterDamageType] = 0.5;
$DamageScale[Hercules, $ElectricityDamageType] = 1.0;
$DamageScale[Hercules, $MineDamageType]        = 1.0;
$DamageScale[Hercules, $ChargeDamageType] = 1.0;
$DamageScale[Hercules, $AirstrikeDamageType]   = 1.0;
$DamageScale[Hercules, $BleedDamageType] = 0.0;
$DamageScale[Hercules, $GrenadeDamageType] = 0.5;
$DamageScale[Hercules, $PoisonDamageType] = 0.0;
$DamageScale[Hercules, $SmokeDamageType] = 0.0;
$DamageScale[Hercules, $StabDamageType] = 0.0;

$DamageScale[Sentry, $ImpactDamageType] = 10.0;
$DamageScale[Sentry, $BulletDamageType] = 0.5;
$DamageScale[Sentry, $PlasmaDamageType] = 1.0;
$DamageScale[Sentry, $EnergyDamageType] = 1.0;
$DamageScale[Sentry, $ExplosionDamageType] = 0.7;
$DamageScale[Sentry, $ShrapnelDamageType] = 0.6;
$DamageScale[Sentry, $DebrisDamageType] = 0.7;
$DamageScale[Sentry, $MissileDamageType] = 2.0;
$DamageScale[Sentry, $LaserDamageType] = 0.3;
$DamageScale[Sentry, $MortarDamageType] = 1.0;
$DamageScale[Sentry, $BlasterDamageType] = 0.5;
$DamageScale[Sentry, $ElectricityDamageType] = 1.0;
$DamageScale[Sentry, $MineDamageType]        = 1.0;
$DamageScale[Sentry, $ChargeDamageType] = 1.0;
$DamageScale[Sentry, $AirstrikeDamageType]   = 1.0;
$DamageScale[Sentry, $BleedDamageType] = 0.0;
$DamageScale[Sentry, $GrenadeDamageType] = 0.5;
$DamageScale[Sentry, $PoisonDamageType] = 0.0;
$DamageScale[Sentry, $SmokeDamageType] = 0.0;
$DamageScale[Sentry, $StabDamageType] = 0.0;

$DamageScale[Gunship, $ImpactDamageType] = 10.0;
$DamageScale[Gunship, $BulletDamageType] = 0.5;
$DamageScale[Gunship, $PlasmaDamageType] = 1.0;
$DamageScale[Gunship, $EnergyDamageType] = 1.0;
$DamageScale[Gunship, $ExplosionDamageType] = 0.7;
$DamageScale[Gunship, $ShrapnelDamageType] = 0.6;
$DamageScale[Gunship, $DebrisDamageType] = 0.7;
$DamageScale[Gunship, $MissileDamageType] = 2.0;
$DamageScale[Gunship, $LaserDamageType] = 0.3;
$DamageScale[Gunship, $MortarDamageType] = 1.0;
$DamageScale[Gunship, $BlasterDamageType] = 0.5;
$DamageScale[Gunship, $ElectricityDamageType] = 1.0;
$DamageScale[Gunship, $MineDamageType]        = 1.0;
$DamageScale[Gunship, $ChargeDamageType] = 1.0;
$DamageScale[Gunship, $AirstrikeDamageType]   = 1.0;
$DamageScale[Gunship, $BleedDamageType] = 0.0;
$DamageScale[Gunship, $GrenadeDamageType] = 0.5;
$DamageScale[Gunship, $PoisonDamageType] = 0.0;
$DamageScale[Gunship, $SmokeDamageType] = 0.0;
$DamageScale[Gunship, $StabDamageType] = 0.0;

$DamageScale[Warthog, $ImpactDamageType] = 10.0;
$DamageScale[Warthog, $BulletDamageType] = 0.7;
$DamageScale[Warthog, $PlasmaDamageType] = 1.0;
$DamageScale[Warthog, $EnergyDamageType] = 1.0;
$DamageScale[Warthog, $ExplosionDamageType] = 0.7;
$DamageScale[Warthog, $ShrapnelDamageType] = 0.6;
$DamageScale[Warthog, $DebrisDamageType] = 0.7;
$DamageScale[Warthog, $MissileDamageType] = 2.0;
$DamageScale[Warthog, $LaserDamageType] = 0.3;
$DamageScale[Warthog, $MortarDamageType] = 1.0;
$DamageScale[Warthog, $BlasterDamageType] = 0.5;
$DamageScale[Warthog, $ElectricityDamageType] = 1.0;
$DamageScale[Warthog, $MineDamageType]        = 1.0;
$DamageScale[Warthog, $ChargeDamageType] = 1.0;
$DamageScale[Warthog, $AirstrikeDamageType]   = 1.0;
$DamageScale[Warthog, $BleedDamageType] = 0.0;
$DamageScale[Warthog, $GrenadeDamageType] = 0.5;
$DamageScale[Warthog, $PoisonDamageType] = 0.0;
$DamageScale[Warthog, $SmokeDamageType] = 0.0;
$DamageScale[Warthog, $StabDamageType] = 0.0;

$DamageScale[MoveWarthog, $ImpactDamageType] = 10.0;
$DamageScale[MoveWarthog, $BulletDamageType] = 0.7;
$DamageScale[MoveWarthog, $PlasmaDamageType] = 1.0;
$DamageScale[MoveWarthog, $EnergyDamageType] = 1.0;
$DamageScale[MoveWarthog, $ExplosionDamageType] = 0.7;
$DamageScale[MoveWarthog, $ShrapnelDamageType] = 0.6;
$DamageScale[MoveWarthog, $DebrisDamageType] = 0.7;
$DamageScale[MoveWarthog, $MissileDamageType] = 2.0;
$DamageScale[MoveWarthog, $LaserDamageType] = 0.3;
$DamageScale[MoveWarthog, $MortarDamageType] = 1.0;
$DamageScale[MoveWarthog, $BlasterDamageType] = 0.5;
$DamageScale[MoveWarthog, $ElectricityDamageType] = 1.0;
$DamageScale[MoveWarthog, $MineDamageType]        = 1.0;
$DamageScale[MoveWarthog, $ChargeDamageType] = 1.0;
$DamageScale[MoveWarthog, $AirstrikeDamageType]   = 1.0;
$DamageScale[MoveWarthog, $BleedDamageType] = 0.0;
$DamageScale[MoveWarthog, $GrenadeDamageType] = 0.5;
$DamageScale[MoveWarthog, $PoisonDamageType] = 0.0;
$DamageScale[MoveWarthog, $SmokeDamageType] = 0.0;
$DamageScale[MoveWarthog, $StabDamageType] = 0.0;

$DamageScale[TOWMissile, $ImpactDamageType] = 10.0;
$DamageScale[TOWMissile, $BulletDamageType] = 0.6;
$DamageScale[TOWMissile, $PlasmaDamageType] = 1.0;
$DamageScale[TOWMissile, $EnergyDamageType] = 1.0;
$DamageScale[TOWMissile, $ExplosionDamageType] = 1.0;
$DamageScale[TOWMissile, $ShrapnelDamageType] = 1.0;
$DamageScale[TOWMissile, $DebrisDamageType] = 1.0;
$DamageScale[TOWMissile, $MissileDamageType] = 1.0;
$DamageScale[TOWMissile, $LaserDamageType] = 1.0;
$DamageScale[TOWMissile, $MortarDamageType] = 1.0;
$DamageScale[TOWMissile, $BlasterDamageType] = 0.5;
$DamageScale[TOWMissile, $ElectricityDamageType] = 1.0;
$DamageScale[TOWMissile, $MineDamageType]        = 1.0;
$DamageScale[TOWMissile, $ChargeDamageType]      = 1.0;
$DamageScale[TOWMissile, $AirstrikeDamageType]   = 1.0;
$DamageScale[TOWMissile, $BleedDamageType] = 0.0;
$DamageScale[TOWMissile, $GrenadeDamageType] = 1.0;
$DamageScale[TOWMissile, $PoisonDamageType] = 0.0;
$DamageScale[TOWMissile, $SmokeDamageType] = 0.0;
$DamageScale[TOWMissile, $StabDamageType] = 0.0;

$DamageScale[Blackhawk, $ImpactDamageType] = 5.0;
$DamageScale[Blackhawk, $BulletDamageType] = 0.1;
$DamageScale[Blackhawk, $PlasmaDamageType] = 1.0;
$DamageScale[Blackhawk, $EnergyDamageType] = 1.0;
$DamageScale[Blackhawk, $ExplosionDamageType] = 1.0;
$DamageScale[Blackhawk, $ShrapnelDamageType] = 1.0;
$DamageScale[Blackhawk, $DebrisDamageType] = 1.0;
$DamageScale[Blackhawk, $MissileDamageType] = 1.5;
$DamageScale[Blackhawk, $LaserDamageType] = 0.5;
$DamageScale[Blackhawk, $MortarDamageType] = 1.0;
$DamageScale[Blackhawk, $BlasterDamageType] = 0.5;
$DamageScale[Blackhawk, $ElectricityDamageType] = 1.0;
$DamageScale[Blackhawk, $MineDamageType]        = 1.0;
$DamageScale[Blackhawk, $ChargeDamageType] = 1.0;
$DamageScale[Blackhawk, $AirstrikeDamageType]   = 1.0;
$DamageScale[Blackhawk, $BleedDamageType] = 0.0;
$DamageScale[Blackhawk, $GrenadeDamageType] = 0.5;
$DamageScale[Blackhawk, $PoisonDamageType] = 0.0;
$DamageScale[Blackhawk, $SmokeDamageType] = 0.0;
$DamageScale[Blackhawk, $StabDamageType] = 0.0;

$DamageScale[MoveBlackhawkExtraction, $ImpactDamageType] = 5.0;
$DamageScale[MoveBlackhawkExtraction, $BulletDamageType] = 0.1;
$DamageScale[MoveBlackhawkExtraction, $PlasmaDamageType] = 1.0;
$DamageScale[MoveBlackhawkExtraction, $EnergyDamageType] = 1.0;
$DamageScale[MoveBlackhawkExtraction, $ExplosionDamageType] = 1.0;
$DamageScale[MoveBlackhawkExtraction, $ShrapnelDamageType] = 1.0;
$DamageScale[MoveBlackhawkExtraction, $DebrisDamageType] = 1.0;
$DamageScale[MoveBlackhawkExtraction, $MissileDamageType] = 1.5;
$DamageScale[MoveBlackhawkExtraction, $LaserDamageType] = 0.5;
$DamageScale[MoveBlackhawkExtraction, $MortarDamageType] = 1.0;
$DamageScale[MoveBlackhawkExtraction, $BlasterDamageType] = 0.5;
$DamageScale[MoveBlackhawkExtraction, $ElectricityDamageType] = 1.0;
$DamageScale[MoveBlackhawkExtraction, $MineDamageType]        = 1.0;
$DamageScale[MoveBlackhawkExtraction, $ChargeDamageType] = 1.0;
$DamageScale[MoveBlackhawkExtraction, $AirstrikeDamageType]   = 1.0;
$DamageScale[MoveBlackhawkExtraction, $BleedDamageType] = 0.0;
$DamageScale[MoveBlackhawkExtraction, $GrenadeDamageType] = 0.5;
$DamageScale[MoveBlackhawkExtraction, $PoisonDamageType] = 0.0;
$DamageScale[MoveBlackhawkExtraction, $SmokeDamageType] = 0.0;
$DamageScale[MoveBlackhawkExtraction, $StabDamageType] = 0.0;

$DamageScale[Humvee, $ImpactDamageType] = 0.0;
$DamageScale[Humvee, $BulletDamageType] = 0.2;
$DamageScale[Humvee, $PlasmaDamageType] = 0.5;
$DamageScale[Humvee, $EnergyDamageType] = 1.0;
$DamageScale[Humvee, $ExplosionDamageType] = 0.8;
$DamageScale[Humvee, $ShrapnelDamageType] = 0.8;
$DamageScale[Humvee, $DebrisDamageType] = 0.7;
$DamageScale[Humvee, $MissileDamageType] = 3.0;
$DamageScale[Humvee, $LaserDamageType] = 0.0;
$DamageScale[Humvee, $MortarDamageType] = 0.8;
$DamageScale[Humvee, $BlasterDamageType] = 0.5;
$DamageScale[Humvee, $ElectricityDamageType] = 1.0;
$DamageScale[Humvee, $MineDamageType]        = 0.8;
$DamageScale[Humvee, $ChargeDamageType]       = 1.0;
$DamageScale[Humvee, $AirstrikeDamageType]   = 1.0;
$DamageScale[Humvee, $BleedDamageType] = 0.0;
$DamageScale[Humvee, $GrenadeDamageType] = 0.5;
$DamageScale[Humvee, $PoisonDamageType] = 0.0;
$DamageScale[Humvee, $SmokeDamageType] = 0.0;
$DamageScale[Humvee, $StabDamageType] = 0.0;

$DamageScale[Abrams, $ImpactDamageType] = 0.0;
$DamageScale[Abrams, $BulletDamageType] = 0.2;
$DamageScale[Abrams, $PlasmaDamageType] = 0.5;
$DamageScale[Abrams, $EnergyDamageType] = 1.0;
$DamageScale[Abrams, $ExplosionDamageType] = 0.8;
$DamageScale[Abrams, $ShrapnelDamageType] = 0.8;
$DamageScale[Abrams, $DebrisDamageType] = 0.7;
$DamageScale[Abrams, $MissileDamageType] = 2.0;
$DamageScale[Abrams, $LaserDamageType] = 0.0;
$DamageScale[Abrams, $MortarDamageType] = 0.8;
$DamageScale[Abrams, $BlasterDamageType] = 0.5;
$DamageScale[Abrams, $ElectricityDamageType] = 1.0;
$DamageScale[Abrams, $MineDamageType]        = 0.7;
$DamageScale[Abrams, $ChargeDamageType]       = 0.8;
$DamageScale[Abrams, $AirstrikeDamageType]   = 0.5;
$DamageScale[Abrams, $BleedDamageType] = 0.0;
$DamageScale[Abrams, $GrenadeDamageType] = 0.5;
$DamageScale[Abrams, $PoisonDamageType] = 0.0;
$DamageScale[Abrams, $SmokeDamageType] = 0.0;
$DamageScale[Abrams, $StabDamageType] = 0.0;

$DamageScale[Bradley, $ImpactDamageType] = 0.0;
$DamageScale[Bradley, $BulletDamageType] = 0.2;
$DamageScale[Bradley, $PlasmaDamageType] = 0.5;
$DamageScale[Bradley, $EnergyDamageType] = 1.0;
$DamageScale[Bradley, $ExplosionDamageType] = 0.8;
$DamageScale[Bradley, $ShrapnelDamageType] = 0.8;
$DamageScale[Bradley, $DebrisDamageType] = 0.7;
$DamageScale[Bradley, $MissileDamageType] = 2.0;
$DamageScale[Bradley, $LaserDamageType] = 0.0;
$DamageScale[Bradley, $MortarDamageType] = 0.8;
$DamageScale[Bradley, $BlasterDamageType] = 0.5;
$DamageScale[Bradley, $ElectricityDamageType] = 1.0;
$DamageScale[Bradley, $MineDamageType]        = 0.7;
$DamageScale[Bradley, $ChargeDamageType]      = 0.8;
$DamageScale[Bradley, $AirstrikeDamageType]   = 0.5;
$DamageScale[Bradley, $BleedDamageType] = 0.0;
$DamageScale[Bradley, $GrenadeDamageType] = 0.5;
$DamageScale[Bradley, $PoisonDamageType] = 0.0;
$DamageScale[Bradley, $SmokeDamageType] = 0.0;
$DamageScale[Bradley, $StabDamageType] = 0.0;

$DamageScale[LineBacker, $ImpactDamageType] = 0.0;
$DamageScale[LineBacker, $BulletDamageType] = 0.2;
$DamageScale[LineBacker, $PlasmaDamageType] = 0.5;
$DamageScale[LineBacker, $EnergyDamageType] = 1.0;
$DamageScale[LineBacker, $ExplosionDamageType] = 0.8;
$DamageScale[LineBacker, $ShrapnelDamageType] = 0.8;
$DamageScale[LineBacker, $DebrisDamageType] = 0.7;
$DamageScale[LineBacker, $MissileDamageType] = 2.0;
$DamageScale[LineBacker, $LaserDamageType] = 0.0;
$DamageScale[LineBacker, $MortarDamageType] = 0.8;
$DamageScale[LineBacker, $BlasterDamageType] = 0.5;
$DamageScale[LineBacker, $ElectricityDamageType] = 1.0;
$DamageScale[LineBacker, $MineDamageType]        = 0.7;
$DamageScale[LineBacker, $ChargeDamageType]      = 0.8;
$DamageScale[LineBacker, $AirstrikeDamageType]   = 0.5;
$DamageScale[LineBacker, $BleedDamageType] = 0.0;
$DamageScale[LineBacker, $GrenadeDamageType] = 0.5;
$DamageScale[LineBacker, $PoisonDamageType] = 0.0;
$DamageScale[LineBacker, $SmokeDamageType] = 0.0;
$DamageScale[LineBacker, $StabDamageType] = 0.0;

$DamageScale[MLRS, $ImpactDamageType] = 0.0;
$DamageScale[MLRS, $BulletDamageType] = 0.2;
$DamageScale[MLRS, $PlasmaDamageType] = 0.5;
$DamageScale[MLRS, $EnergyDamageType] = 1.0;
$DamageScale[MLRS, $ExplosionDamageType] = 0.8;
$DamageScale[MLRS, $ShrapnelDamageType] = 0.8;
$DamageScale[MLRS, $DebrisDamageType] = 0.7;
$DamageScale[MLRS, $MissileDamageType] = 2.0;
$DamageScale[MLRS, $LaserDamageType] = 0.0;
$DamageScale[MLRS, $MortarDamageType] = 0.8;
$DamageScale[MLRS, $BlasterDamageType] = 0.5;
$DamageScale[MLRS, $ElectricityDamageType] = 1.0;
$DamageScale[MLRS, $MineDamageType]        = 0.7;
$DamageScale[MLRS, $ChargeDamageType]      = 0.8;
$DamageScale[MLRS, $AirstrikeDamageType]   = 0.5;
$DamageScale[MLRS, $BleedDamageType] = 0.0;
$DamageScale[MLRS, $GrenadeDamageType] = 0.5;
$DamageScale[MLRS, $PoisonDamageType] = 0.0;
$DamageScale[MLRS, $SmokeDamageType] = 0.0;
$DamageScale[MLRS, $StabDamageType] = 0.0;

$DamageScale[MineLayer, $ImpactDamageType] = 0.0;
$DamageScale[MineLayer, $BulletDamageType] = 0.2;
$DamageScale[MineLayer, $PlasmaDamageType] = 0.5;
$DamageScale[MineLayer, $EnergyDamageType] = 1.0;
$DamageScale[MineLayer, $ExplosionDamageType] = 0.8;
$DamageScale[MineLayer, $ShrapnelDamageType] = 0.8;
$DamageScale[MineLayer, $DebrisDamageType] = 0.7;
$DamageScale[MineLayer, $MissileDamageType] = 3.0;
$DamageScale[MineLayer, $LaserDamageType] = 0.0;
$DamageScale[MineLayer, $MortarDamageType] = 0.8;
$DamageScale[MineLayer, $BlasterDamageType] = 0.5;
$DamageScale[MineLayer, $ElectricityDamageType] = 1.0;
$DamageScale[MineLayer, $MineDamageType]        = 0.8;
$DamageScale[MineLayer, $ChargeDamageType]       = 1.0;
$DamageScale[MineLayer, $AirstrikeDamageType]   = 1.0;
$DamageScale[MineLayer, $BleedDamageType] = 0.0;
$DamageScale[MineLayer, $GrenadeDamageType] = 0.5;
$DamageScale[MineLayer, $PoisonDamageType] = 0.0;
$DamageScale[MineLayer, $SmokeDamageType] = 0.0;
$DamageScale[MineLayer, $StabDamageType] = 0.0;

$VehicleAmmoType[Humvee, 2] = TOWAmmo;
$VehicleAmmoType[Humvee, 3] = AutoGrenAmmo;

$VehicleAmmoType[Abrams, 2] = AbramsAmmo;
$VehicleAmmoType[Abrams, 3] = MinigunAmmo;

$VehicleAmmoType[Gunship, 4] = LowMountAbramsAmmo;
$VehicleAmmoType[Gunship, 5] = FortymmAmmo;
$VehicleAmmoType[Gunship, 2] = LowMountTwentyFivemmAmmo;
$VehicleAmmoType[Gunship, 3] = LowMountTwentyFivemmAmmo;

$VehicleAmmoType[Blackhawk, 2] = LowMountMinigunAmmo;
$VehicleAmmoType[Blackhawk, 3] = LowMountMinigunAmmo;

$VehicleAmmoType[MoveBlackhawkExtraction, 2] = LowMountMinigunAmmo;
$VehicleAmmoType[MoveBlackhawkExtraction, 3] = LowMountMinigunAmmo;

$VehicleAmmoType[Bradley, 2] = TOWAmmo;
$VehicleAmmoType[Bradley, 3] = TwentyFivemmAmmo;
$VehicleAmmoType[Bradley, 4] = Minigunammo;

$VehicleAmmoType[LineBacker, 2] = StingerLauncherAmmo;
$VehicleAmmoType[LineBacker, 3] = TwentyFivemmAmmo;
$VehicleAmmoType[LineBacker, 4] = Minigunammo;

$VehicleAmmoType[MLRS, 2] = MLRSAmmo;

$VehicleReloadRate[TOWAmmo] = 2;
$VehicleReloadRate[AutoGrenAmmo] = 10;
$VehicleReloadRate[AbramsAmmo] = 8;
$VehicleReloadRate[LowMountAbramsAmmo] = 8;
$VehicleReloadRate[MinigunAmmo] = 80;
$VehicleReloadRate[LowMountMinigunAmmo] = 80;
$VehicleReloadRate[TwentyFivemmAmmo] = 70;
$VehicleReloadRate[LowMountTwentyFivemmAmmo] = 70;
$VehicleReloadRate[FortymmAmmo] = 50;
$VehicleReloadRate[StingerLauncherAmmo] = 2;
$VehicleReloadRate[MLRSAmmo] = 1;

$VehicleAmmoMax[Humvee, TOWAmmo] = 8;
$VehicleAmmoMax[Humvee, AutoGrenAmmo] = 50;

$VehicleAmmoMax[Abrams, AbramsAmmo] = 30;
$VehicleAmmoMax[Abrams, MinigunAmmo] = 400;

$VehicleAmmoMax[Gunship, LowMountAbramsAmmo] = 100;
$VehicleAmmoMax[Gunship, FortymmAmmo] = 246;
$VehicleAmmoMax[Gunship, LowMountTwentyFivemmAmmo] = 1000;

$VehicleAmmoMax[Blackhawk, LowMountMinigunAmmo] = 400;

$VehicleAmmoMax[MoveBlackhawkExtraction, LowMountMinigunAmmo] = 400;

$VehicleAmmoMax[Bradley, TOWAmmo] = 2;
$VehicleAmmoMax[Bradley, MinigunAmmo] = 700;
$VehicleAmmoMax[Bradley, TwentyFivemmAmmo] = 500;

$VehicleAmmoMax[LineBacker, StingerLauncherAmmo] = 10;
$VehicleAmmoMax[LineBacker, MinigunAmmo] = 1000;
$VehicleAmmoMax[LineBacker, TwentyFivemmAmmo] = 700;

$VehicleAmmoMax[MLRS, MLRSAmmo] = 12;

// ------ Vehicle weapons ------

// MineLayer
$VehicleHPSpace[MineLayer] = 0.1; //Doesnt matter.
$VehicleSWType[MineLayer] = false;

$VehiclePrimaryGuns[MineLayer] = 1;
$VehicleWeapon[MineLayer, 0] = Volcano;
$VehicleWeaponAmmoMax[MineLayer, Volcano] = 10;
$VehicleWeapFireDelay[MineLayer, Volcano] = 1.00;


// WARTHOG
$VehicleHPSpace[MoveWarthog] = 0.8;
$VehicleSWType[MoveWarthog] = false;

$BombBay[MoveWarthog] = 0;
$VehicleMaxHardPoints[MoveWarthog] = 11;
$VehiclePrimaryGuns[MoveWarthog] = 1;
$VehicleWeapon[MoveWarthog, 0] = WarthogBullet;
//$VehicleWeapon[MoveWarthog, 1] = ApacheRocket;
//$VehicleWeapon[MoveWarthog, 2] = BigBomb;

$VehicleWeaponAmmoMax[MoveWarthog, WarthogBullet] = 1100;
$VehicleWeaponAmmoMax[MoveWarthog, SidewinderRocket] = 11;
$VehicleWeaponAmmoMax[MoveWarthog, ApacheRocket] = 44;
$VehicleWeaponAmmoMax[MoveWarthog, MavRocket] = 11;
$VehicleWeaponAmmoMax[MoveWarthog, HydraRocket] = 209;
$VehicleWeaponAmmoMax[MoveWarthog, BigBomb] = 5;
$VehicleWeaponAmmoMax[MoveWarthog, BombShell] = 3;
$VehicleWeaponAmmoMax[MoveWarthog, APClusterBomb] = 11;
$VehicleWeaponAmmoMax[MoveWarthog, MineClusterBomb] = 11;
$VehicleWeaponAmmoMax[MoveWarthog, BombletClusterBomb] = 11;
$VehicleWeaponAmmoMax[MoveWarthog, BunkerBusterBomb] = 11;
$VehicleWeaponAmmoMax[MoveWarthog, TankSmoke] = 250;
$VehicleWeaponAmmoMax[MoveWarthog, TankNerveGas] = 250;
$VehicleWeaponAmmoMax[MoveWarthog, NapalmBomb] = 3;
$VehicleWeaponAmmoMax[MoveWarthog, EMCContainer] = 1;
//leave on, and list all available weaponry. must fix reloader pack. must make move warthog switch ALL variables over, or delete it.

$VehicleWeapFireDelay[MoveWarthog, WarthogBullet] = 0.0333;
$VehicleWeapFireDelay[MoveWarthog, StingerMissile] = 1.0;
$VehicleWeapFireDelay[MoveWarthog, ApacheRocket] = 0.5; 
$VehicleWeapFireDelay[MoveWarthog, MavRocket] = 1.5;
$VehicleWeapFireDelay[MoveWarthog, HydraRocket] = 0.1;
$VehicleWeapFireDelay[MoveWarthog, BigBomb] = 1.0;
$VehicleWeapFireDelay[MoveWarthog, BombShell] = 1.0;
$VehicleWeapFireDelay[MoveWarthog, APClusterBomb] = 1.0;
$VehicleWeapFireDelay[MoveWarthog, MineClusterBomb] = 1.0;
$VehicleWeapFireDelay[MoveWarthog, BombletClusterBomb] = 1.0;
$VehicleWeapFireDelay[MoveWarthog, BunkerBusterBomb] = 1.0;
$VehicleWeapFireDelay[MoveWarthog, TankSmoke] = 0.3;
$VehicleWeapFireDelay[MoveWarthog, TankNerveGas] = 0.3;
$VehicleWeapFireDelay[MoveWarthog, NapalmBomb] = 1.5;
$VehicleWeapFireDelay[MoveWarthog, EMCContainer] = 1.0;

$VehicleHPSpace[Warthog] = 0.8;
$VehicleSWType[Warthog] = false;

$BombBay[Warthog] = 0;
$VehicleMaxHardPoints[Warthog] = 11;
$VehiclePrimaryGuns[Warthog] = 1;
$VehicleWeapon[Warthog, 0] = WarthogBullet;
//$VehicleWeapon[Warthog, 1] = ApacheRocket;
//$VehicleWeapon[Warthog, 2] = BigBomb;

$VehicleWeaponAmmoMax[Warthog, WarthogBullet] = 1100;
$VehicleWeaponAmmoMax[Warthog, SidewinderRocket] = 11;
$VehicleWeaponAmmoMax[Warthog, ApacheRocket] = 44;
$VehicleWeaponAmmoMax[Warthog, MavRocket] = 11;
$VehicleWeaponAmmoMax[Warthog, HydraRocket] = 209;
$VehicleWeaponAmmoMax[Warthog, BigBomb] = 5;
$VehicleWeaponAmmoMax[Warthog, BombShell] = 3;
$VehicleWeaponAmmoMax[Warthog, APClusterBomb] = 11;
$VehicleWeaponAmmoMax[Warthog, MineClusterBomb] = 11;
$VehicleWeaponAmmoMax[Warthog, BombletClusterBomb] = 11;
$VehicleWeaponAmmoMax[Warthog, BunkerBusterBomb] = 11;
$VehicleWeaponAmmoMax[Warthog, TankSmoke] = 250;
$VehicleWeaponAmmoMax[Warthog, TankNerveGas] = 250;
$VehicleWeaponAmmoMax[Warthog, NapalmBomb] = 3;
$VehicleWeaponAmmoMax[Warthog, EMCContainer] = 1;

$VehicleWeapFireDelay[Warthog, WarthogBullet] = 0.0333;
$VehicleWeapFireDelay[Warthog, StingerMissile] = 1.0;
$VehicleWeapFireDelay[Warthog, ApacheRocket] = 0.7; 
$VehicleWeapFireDelay[Warthog, MavRocket] = 2.0;
$VehicleWeapFireDelay[Warthog, HydraRocket] = 0.1;
$VehicleWeapFireDelay[Warthog, BigBomb] = 1.0;
$VehicleWeapFireDelay[Warthog, BombShell] = 1.0;
$VehicleWeapFireDelay[Warthog, APClusterBomb] = 1.0;
$VehicleWeapFireDelay[Warthog, MineClusterBomb] = 1.0;
$VehicleWeapFireDelay[Warthog, BombletClusterBomb] = 1.0;
$VehicleWeapFireDelay[Warthog, BunkerBusterBomb] = 1.0;
$VehicleWeapFireDelay[Warthog, TankSmoke] = 0.3;
$VehicleWeapFireDelay[Warthog, TankNerveGas] = 0.3;
$VehicleWeapFireDelay[Warthog, NapalmBomb] = 1.5;
$VehicleWeapFireDelay[Warthog, EMCContainer] = 1.0;

// Falcon
$VehicleHPSpace[Falcon] = 0.9;
$VehicleSWType[Falcon] = true;

$BombBay[Falcon] = 0;
$VehicleMaxHardPoints[Falcon] = 7;
$VehiclePrimaryGuns[Falcon] = 1;
$VehicleWeapon[Falcon, 0] = NATOBullet;
//$VehicleWeapon[Falcon, 1] = MavRocket;
//$VehicleWeapon[Falcon, 2] = StingerMissile;

$VehicleWeaponAmmoMax[Falcon, NATOBullet] = 511;
$VehicleWeaponAmmoMax[Falcon, SidewinderRocket] = 7;
$VehicleWeaponAmmoMax[Falcon, MavRocket] = 7;
$VehicleWeaponAmmoMax[Falcon, HARMRocket] = 7;
$VehicleWeaponAmmoMax[Falcon, BigBomb] = 3;
$VehicleWeaponAmmoMax[Falcon, BombShell] = 2;
$VehicleWeaponAmmoMax[Falcon, APClusterBomb] = 7;
$VehicleWeaponAmmoMax[Falcon, MineClusterBomb] = 7;
$VehicleWeaponAmmoMax[Falcon, BombletClusterBomb] = 7;
$VehicleWeaponAmmoMax[Falcon, BunkerBusterBomb] = 7;
$VehicleWeaponAmmoMax[Falcon, TankSmoke] = 150;
$VehicleWeaponAmmoMax[Falcon, TankNerveGas] = 150;
$VehicleWeaponAmmoMax[Falcon, NapalmBomb] = 2;
$VehicleWeaponAmmoMax[Falcon, EMCContainer] = 1;

$VehicleWeapFireDelay[Falcon, NATOBullet] = 0.05;
$VehicleWeapFireDelay[Falcon, SidewinderRocket] = 1.0;
$VehicleWeapFireDelay[Falcon, MavRocket] = 2.0;
$VehicleWeapFireDelay[Falcon, HARMRocket] = 1.0;
$VehicleWeapFireDelay[Falcon, BigBomb] = 1.0;
$VehicleWeapFireDelay[Falcon, BombShell] = 1.0;
$VehicleWeapFireDelay[Falcon, APClusterBomb] = 1.0;
$VehicleWeapFireDelay[Falcon, MineClusterBomb] = 1.0;
$VehicleWeapFireDelay[Falcon, BombletClusterBomb] = 1.0;
$VehicleWeapFireDelay[Falcon, BunkerBusterBomb] = 1.0;
$VehicleWeapFireDelay[Falcon, TankSmoke] = 0.05;
$VehicleWeapFireDelay[Falcon, TankNerveGas] = 0.05;
$VehicleWeapFireDelay[Falcon, NapalmBomb] = 1.5;
$VehicleWeapFireDelay[Falcon, EMCContainer] = 1.0;


// DIVEBOMBER
//$VehiclePrimaryGuns[DiveBomber] = 2;
//$VehicleWeapon[DiveBomber, 0] = NATOBullet;
//$VehicleWeapon[DiveBomber, 1] = BombShell;

//$VehicleWeaponAmmoMax[DiveBomber, SAWBullet] = 200;
//$VehicleWeaponAmmoMax[DiveBomber, BombShell] = 1;

//$VehicleWeapFireDelay[DiveBomber, SAWBullet] = 0.05;
//$VehicleWeapFireDelay[DiveBomber, BombShell] = 3;

// Tomcat
$VehicleHPSpace[Tomcat] = 0.9;
$VehicleSWType[Tomcat] = true;

$BombBay[Tomcat] = 0;
$VehicleMaxHardPoints[Tomcat] = 6;
$VehiclePrimaryGuns[Tomcat] = 1;
$VehicleWeapon[Tomcat, 0] = NATOBullet;
//$VehicleWeapon[Tomcat, 1] = PhoenixRocket;
//$VehicleWeapon[Tomcat, 2] = StingerMissile;

$VehicleWeaponAmmoMax[Tomcat, NATOBullet] = 511;
$VehicleWeaponAmmoMax[Tomcat, SidewinderRocket] = 4;
$VehicleWeaponAmmoMax[Tomcat, PhoenixRocket] = 6;
$VehicleWeaponAmmoMax[Tomcat, BigBomb] = 3;
$VehicleWeaponAmmoMax[Tomcat, BombShell] = 2;
$VehicleWeaponAmmoMax[Tomcat, BombletClusterBomb] = 6;
$VehicleWeaponAmmoMax[Tomcat, EMCContainer] = 1;

$VehicleWeapFireDelay[Tomcat, NATOBullet] = 0.02;
$VehicleWeapFireDelay[Tomcat, SidewinderRocket] = 1.0;
$VehicleWeapFireDelay[Tomcat, PhoenixRocket] = 1.0;
$VehicleWeapFireDelay[Tomcat, BigBomb] = 1.0;
$VehicleWeapFireDelay[Tomcat, BombShell] = 1.0;
$VehicleWeapFireDelay[Tomcat, BombletClusterBomb] = 1.0;
$VehicleWeapFireDelay[Tomcat, EMCContainer] = 1.0;

// APACHE
$BombBay[Apache] = 0;
$VehicleHPSpace[apache] = 0.9;
$VehicleSWType[apache] = false;

$VehicleMaxHardPoints[Apache] = 4; // Apache has 4 "all purpose" (can only use 
	//Hellfire or hydra racks) HPs, but has 2 additional sidewinder only HPs.
$VehiclePrimaryGuns[Apache] = 1;
$VehicleWeapon[Apache, 0] = WarthogBullet;
//$VehicleWeapon[Apache, 1] = ApacheRocket;
//$VehicleWeapon[Apache, 2] = StingerMissile;

$VehicleWeaponAmmoMax[Apache, WarthogBullet] = 1200;
$VehicleWeaponAmmoMax[Apache, SidewinderRocket] = 2;
$VehicleWeaponAmmoMax[Apache, ApacheRocket] = 16;
$VehicleWeaponAmmoMax[Apache, HydraRocket] = 76;
$VehicleWeaponAmmoMax[Apache, EMCContainer] = 1;

$VehicleWeapFireDelay[Apache, WarthogBullet] = 0.0909;
$VehicleWeapFireDelay[Apache, ApacheRocket] = 0.7;
$VehicleWeapFireDelay[Apache, HydraRocket] = 0.1;
$VehicleWeapFireDelay[Apache, SidewinderRocket] = 1.0;
$VehicleWeapFireDelay[Apache, EMCContainer] = 1.0;


// Kiowa
$BombBay[Kiowa] = 0;
$VehicleHPSpace[Kiowa] = 0.9;
$VehicleSWType[Kiowa] = false;

$VehicleMaxHardPoints[Kiowa] = 2; 
$VehiclePrimaryGuns[Kiowa] = 2;
$VehicleWeapon[Kiowa, 0] = targetingLaser;
$VehicleWeapon[Kiowa, 1] = sensorPulse;


$VehicleWeaponAmmoMax[Kiowa, targetingLaser] = -1;
$VehicleWeaponAmmoMax[Kiowa, sensorPulse] = -1;
$VehicleWeaponAmmoMax[Kiowa, FiftyCalPodBullet] = 1000;
$VehicleWeaponAmmoMax[Kiowa, SidewinderRocket] = 2;
$VehicleWeaponAmmoMax[Kiowa, ApacheRocket] = 8;
$VehicleWeaponAmmoMax[Kiowa, HydraRocket] = 38;

$VehicleWeapFireDelay[Kiowa, targetingLaser] = 0.3;
$VehicleWeapFireDelay[Kiowa, sensorPulse] = 5;
$VehicleWeapFireDelay[Kiowa, FiftyCalPodBullet] = 0.12;
$VehicleWeapFireDelay[Kiowa, ApacheRocket] = 0.7;
$VehicleWeapFireDelay[Kiowa, HydraRocket] = 0.1;
$VehicleWeapFireDelay[Kiowa, SidewinderRocket] = 1.0;

// HIND
$VehicleHPSpace[hind] = 1.5;
$VehicleSWType[hind] = false;

$BombBay[Hind] = 0;
$VehicleMaxHardPoints[Hind] = 6;
$VehiclePrimaryGuns[Hind] = 1;
$VehicleWeapon[Hind, 0] = WarthogBullet;
//$VehicleWeapon[Hind, 1] = ApacheRocket;
//$VehicleWeapon[Hind, 2] = StingerMissile;

$VehicleWeaponAmmoMax[Hind, WarthogBullet] = 750;
$VehicleWeaponAmmoMax[Hind, SidewinderRocket] = 6;
$VehicleWeaponAmmoMax[Hind, ApacheRocket] = 24;
$VehicleWeaponAmmoMax[Hind, TwentyFivemmBullet] = 1500;
$VehicleWeaponAmmoMax[Hind, SAWBullet] = 4500;
$VehicleWeaponAmmoMax[Hind, BigBomb] = 3;
$VehicleWeaponAmmoMax[Hind, APClusterBomb] = 6;
$VehicleWeaponAmmoMax[Hind, MineClusterBomb] = 6;
$VehicleWeaponAmmoMax[Hind, BombletClusterBomb] = 6;
$VehicleWeaponAmmoMax[Hind, BunkerBusterBomb] = 6;
$VehicleWeaponAmmoMax[Hind, TankSmoke] = 150;
$VehicleWeaponAmmoMax[Hind, TankNerveGas] = 150;
$VehicleWeaponAmmoMax[Hind, NapalmBomb] = 2;
$VehicleWeaponAmmoMax[Hind, EMCContainer] = 1;

$VehicleWeapFireDelay[Hind, WarthogBullet] = 0.03;
$VehicleWeapFireDelay[Hind, SidewinderRocket] = 1.0;
$VehicleWeapFireDelay[Hind, ApacheRocket] = 0.9;
$VehicleWeapFireDelay[Hind, TwentyFivemmBullet] = 0.02;
$VehicleWeapFireDelay[Hind, SAWBullet] = 0.015;
$VehicleWeapFireDelay[Hind, BigBomb] = 1.0;
$VehicleWeapFireDelay[Hind, APClusterBomb] = 1.0;
$VehicleWeapFireDelay[Hind, MineClusterBomb] = 1.0;
$VehicleWeapFireDelay[Hind, BombletClusterBomb] = 1.0;
$VehicleWeapFireDelay[Hind, BunkerBusterBomb] = 1.0;
$VehicleWeapFireDelay[Hind, TankSmoke] = 0.3;
$VehicleWeapFireDelay[Hind, TankNerveGas] = 0.3;
$VehicleWeapFireDelay[Hind, NapalmBomb] = 1.5;
$VehicleWeapFireDelay[Hind, EMCContainer] = 1.0;

// Bomber
$VehicleHPSpace[Bomber] = 1.5; // doesnt matter
$VehicleSWType[Bomber] = false;

$BombBay[Bomber] = 1;
$BombBayMax[Bomber] = 54;
$VehicleMaxHardPoints[Bomber] = 0;
$VehiclePrimaryGuns[Bomber] = 0;
//$VehicleWeapon[Bomber, 0] = BombShell;

$VehicleWeaponAmmoMax[Bomber, BigBomb] = 54;
$VehicleWeaponAmmoMax[Bomber, BombShell] = 27;
$VehicleWeaponAmmoMax[Bomber, NukeShell] = 1;

$VehicleWeapFireDelay[Bomber, BigBomb] = 0.3;
$VehicleWeapFireDelay[Bomber, BombShell] = 0.3;
$VehicleWeapFireDelay[Bomber, NukeShell] = 1.0;

// Hercules (special)
$VehicleHPSpace[Hercules] = 1.5; // doesnt matter
$VehicleSWType[Hercules] = false;

$BombBay[Hercules] = 1;
$BombBayMax[Hercules] = 4;
$VehicleMaxHardPoints[Hercules] = 0;
$VehiclePrimaryGuns[Hercules] = 0;
//$VehicleWeapon[Hercules, 0] = DaisyShell;

$VehicleWeaponAmmoMax[Hercules, DaisyShell] = 4;
$VehicleWeaponAmmoMax[Hercules, SupplyDrop] = 4;

$VehicleWeapFireDelay[Hercules, DaisyShell] = 2.0;
$VehicleWeapFireDelay[Hercules, SupplyDrop] = 2.0;

// GENERAL WEAP DESCRIPTIONS

$WeaponDesc[NATOBullet] = "20mm Chain Gun";
$WeaponDesc[SAWBullet] = "12.7mm Chain Gun";
$WeaponDesc[FiftyCalPodBullet] = "M296 .50 cal Machine Gun";
$WeaponDesc[TwentyFivemmBullet] = "23mm Chain Gun";
$WeaponDesc[WarthogBullet] = "30mm Cannon";
$WeaponDesc[Volcano] = "Volcano Mining System";
$WeaponDesc[TargetingLaser] = "Laser Range Finder/Designator";
$WeaponDesc[SensorPulse] = "Sensor Scan Pulse";

$WeaponDesc[SidewinderRocket] = "AIM-9J Sidewinder Missile";
$WeaponDesc[PhoenixRocket] = "AIM-54 Phoenix Missile";
$WeaponDesc[ApacheRocket] = "AGM-114 Hellfire Missile";
$WeaponDesc[HydraRocket] = "2.75inch Hydra-70";
$WeaponDesc[MavRocket] = "AGM-65 Maverick Missile";
$WeaponDesc[HARMRocket] = "AGM-88 HARM Missile";

$WeaponDesc[BigBomb] = "Mk82 500Lb Bomb";
$WeaponDesc[BombShell] = "Mk84 2000Lb Bomb";
$WeaponDesc[APClusterBomb] = "CBU-59 APAM Bomb";
$WeaponDesc[MineClusterBomb] = "CBU-89 Gator Mine Bomb";
$WeaponDesc[BombletClusterBomb] = "CBU-87 Cluster Bomb";
$WeaponDesc[BunkerBusterBomb] = "BLU-113 Penetrator Bomb";
$WeaponDesc[TankSmoke] = "M-10 Smoke Tank";
$WeaponDesc[TankNerveGas] = "M-10 Tear Gas Tank";
$WeaponDesc[NapalmBomb] = "Mk-77 Incendiary Bomb";

$WeaponDesc[NukeShell] = "Mk-53 Hydrogen Bomb";
$WeaponDesc[DaisyShell] = "BLU-82B Daisy Cutter Bomb";

$WeaponDesc[SupplyDrop] = "Standard Supply Crate";
$WeaponDesc[EMCContainer] = "ALQ-131 ECM Pod";

$WeaponReloadRate[NATOBullet] = 20;
$WeaponReloadRate[WarthogBullet] = 25;
$WeaponReloadRate[Volcano] = 2;
// Only the bullets are relevent now.
//$WeaponReloadRate[ApacheRocket] = 5;
//$WeaponReloadRate[PhoenixRocket] = 5;
//$WeaponReloadRate[StingerMissile] = 5;
//$WeaponReloadRate[BigBomb] = 1;
//$WeaponReloadRate[BombShell] = 1;
//$WeaponReloadRate[MavRocket] = 3;


// Be sure to add in the $Locking:: information in items.cs if you add a new locking missile.
$WeaponRequiresLock[SAWBullet] = False;
$WeaponRequiresLock[FiftyCalPodBullet] = false;
$WeaponRequiresLock[NATOBullet] = False;
$WeaponRequiresLock[TwentyFivemmBullet] = False;
$WeaponRequiresLock[WarthogBullet] = False;
$WeaponRequiresLock[Volcano] = False;

$WeaponRequiresLock[TargetingLaser] = false;
$WeaponRequiresLock[SensorPulse] = false;

$WeaponRequiresLock[SidewinderRocket] = True;
$WeaponRequiresLock[PhoenixRocket] = True;
$WeaponRequiresLock[ApacheRocket] = False;
$WeaponRequiresLock[HydraRocket] = False;
// Locking isn't working for the AtG rockets properly, so.. disable for now.
$WeaponRequiresLock[MavRocket] = False;
$WeaponRequiresLock[HARMRocket] = False;

$WeaponRequiresLock[BigBomb] = False;
$WeaponRequiresLock[BombShell] = False;
$WeaponRequiresLock[APClusterBomb] = False;
$WeaponRequiresLock[MineClusterBomb] = False;
$WeaponRequiresLock[BombletClusterBomb] = False;
$WeaponRequiresLock[BunkerBusterBomb] = False;
$WeaponRequiresLock[TankSmoke] = False;
$WeaponRequiresLock[TankNerveGas] = False;
$WeaponRequiresLock[NapalmBomb] = False;

$WeaponRequiresLock[NukeShell] = False;
$WeaponRequiresLock[DaisyShell] = False;

$WeaponRequiresLock[SupplyDrop] = False;
$WeaponRequiresLock[EMCContainer] = False;


$WeaponFreeFall[SAWBullet] = False;
$WeaponFreeFall[FiftyCalPodBullet] = false;
$WeaponFreeFall[NATOBullet] = False;
$WeaponFreeFall[TwentyFivemmBullet] = False;
$WeaponFreeFall[WarthogBullet] = False;
$WeaponFreeFall[Volcano] = False;

$WeaponFreeFall[TargetingLaser] = false;
$WeaponFreeFall[SensorPulse] = false;

$WeaponFreeFall[SidewinderRocket] = False;
$WeaponFreeFall[PhoenixRocket] = False;
$WeaponFreeFall[ApacheRocket] = False;
$WeaponFreeFall[HydraRocket] = False;
$WeaponFreeFall[MavRocket] = False;
$WeaponFreeFall[HARMRocket] = False;

$WeaponFreeFall[BigBomb] = True;
$WeaponFreeFall[BombShell] = True;
$WeaponFreeFall[APClusterBomb] = True;
$WeaponFreeFall[MineClusterBomb] = True;
$WeaponFreeFall[BombletClusterBomb] = True;
$WeaponFreeFall[BunkerBusterBomb] = True;
$WeaponFreeFall[TankSmoke] = True;
$WeaponFreeFall[TankNerveGas] = True;
$WeaponFreeFall[NapalmBomb] = True;

$WeaponFreeFall[NukeShell] = True;
$WeaponFreeFall[DaisyShell] = True;

$WeaponFreeFall[SupplyDrop] = True;
$WeaponFreeFall[EMCContainer] = True;


$WeaponSound[NATOBullet] = shockExplosion;
$WeaponSound[FiftyCalPodBullet] = shockExplosion;
$WeaponSound[SAWBullet] = shockExplosion;
$WeaponSound[TwentyFivemmBullet] = shockExplosion;
$WeaponSound[WarthogBullet] = shockExplosion;
$WeaponSound[Volcano] = SoundDryFire;

$WeaponSound[TargetingLaser] = energyExplosion;
$WeaponSound[SensorPulse] = SoundSensorPulse;

$WeaponSound[SidewinderRocket] = SoundFireFlierRocket;
$WeaponSound[PhoenixRocket] = SoundFireFlierRocket;
$WeaponSound[ApacheRocket] = SoundFireFlierRocket;
$WeaponSound[HydraRocket] = SoundFireFlierRocket;
$WeaponSound[MavRocket] = SoundFireFlierRocket;
$WeaponSound[HARMRocket] = SoundFireFlierRocket;

$WeaponSound[BigBomb] = SoundDryFire;
$WeaponSound[BombShell] = SoundDryFire;
$WeaponSound[APClusterBomb] = SoundDryFire;
$WeaponSound[MineClusterBomb] = SoundDryFire;
$WeaponSound[BombletClusterBomb] = SoundDryFire;
$WeaponSound[BunkerBusterBomb] = SoundDryFire;
$WeaponSound[TankSmoke] = SoundDryFire;
$WeaponSound[TankNerveGas] = SoundDryFire;
$WeaponSound[NapalmBomb] = SoundDryFire;

$WeaponSound[NukeShell] = SoundDryFire;
$WeaponSound[DaisyShell] = SoundDryFire;

$WeaponSound[SupplyDrop] = SoundDryFire;
$WeaponSound[EMCContainer] = SoundDryFire;


//-Modes that use Lock On
//::WingMount	= Mounted on the wings and alternate sides
//::Laser	= Mounted on the Nose, Laser fire
//::NoseFire	= Mounted on the Nose normal fire
//::BombA	= Fire from center of the vehicle and drops down
//::BombB	= Fire from center of the vehicle and uses path
//::LockOnA	= Requires a Lock On
//::LockOnB	= Lock On supported but not required
//::LockOnC	= Lock On supported but not required bomb fall mode
//::Deflect	= Deflects and shields against all attacks for a limited time
//::Shield	= Shields against as long as it is activated, disables firing ability
//::Detonate	= Detonates current vehicle
//::Spike	= Sequential projectiles spawned to form a sphere
//::DropA	= Pickup vehicle/Drop vehicle.
//::DropB	= Drop infantry. Infantry cannot voluntarilly jump from this vehicle.




// END DELTA FORCE VEHICLES
// --------------------------------------------------

//----------------------------------------------------------------------------

//----------------------------------------------------------------------------

function Vehicle::onFire(%this)
{

//for(%x = -1; %x < 8; %x++){
//	echo($Vehicleownedweapon[%this,%x]);
//	echo($VehicleWeaponAmmo[%this, $Vehicleownedweapon[%this,%x]]);
//	
//}
	%name = Vehicle::getDataName(%this);
	%weapNum = $VehicleGuns[%this];

	// Player is actually client here...
	%player = GameBase::getControlClient(%this);

	// Flier based vehicles won't let you use any other transform for spawning bullet type projectiles,
	// except for it's default. So if we're using a flier, we need to fire off of the player object.
	// Ok; we only care about doing this for the Kiowa's guns. so don't screw with it for anything else.
	if(Vehicle::GetSize(%this) == small && Vehicle::isKiowa(%this) )
	{
		%fireObj = client::GetOwnedObject(%player);
		%hpposLower = "0 2.5 -2";
	}
	else
	{
		%fireObj = %this;
		%hpposLower = "0 0 0";
	}	
	if(%name == Apache)
		%hp = $VehicleMaxHardPoints[%name]+2;
	else
		%hp = $VehicleMaxHardPoints[%name];
	if(%weapNum > 0)
	{
		if($VehicleCanFire[%this])
		{
			%weapName = $VehicleOwnedWeapon[%this,$VehicleCurWeapon[%this]];
			%oldweap = %weapname;
							
			//echo(%weapName@" " @$VehicleWeaponAmmo[%this,%weapName]);
			if($VehicleWeaponAmmo[%this, %weapName] > 0 && %player.hflink != 2)
			{
				$weapPName[%this] = $WeaponDesc[$VehicleOwnedWeapon[%this,$VehicleCurWeapon[%this]]];
				// Fire the gun

				%weaponNum = $VehicleWeapToFire[%this,%weapname];
				%wasat = %weaponNum;
				%vel = Item::getVelocity(%this);
				%playerVel = %vel;
				%rot = GameBase::getRotation(%this);                             
				%pos = getBoxCenter(%this);

				%pos = GetOffSetRot(vector::Add(%hpposLower,"0 2.5 -.3"),%Rot,%Pos);

				
				// Pirmary weapon, or a non-hardpoint Put on nose.
				%transorg = GameBase::getMuzzleTransform(%this);
				%transform = getword(%transorg,0)@" "@getword(%transorg,1)@" "@getword(%transorg,2)@" "@
						getword(%transorg,3)@" "@getword(%transorg,4)@" "@getword(%transorg,5)@" ";

				if(%player.hflink == 0 || $BombBay[%name])
				{

					if($VehicleWeapon[%name,0] != %weapName && (%name != Kiowa || $VehicleWeapon[%name,1] != %weapName) && !$BombBay[%name])
					{
						
						//Move to next HP position to fire.
						%weaponNum = %weaponNum+1; 
						if(%weaponNum == %hp)
							 %weaponNum = 0;
						while($VehicleHPList[%this,%weaponNum] != %Weapname && %weaponNum != %wasat)
						{
							%weaponNum = %weaponNum+1; 
							if(%weaponNum == %hp)
								 %weaponNum = 0;
						}
						$VehicleWeapToFire[%this,%weapName] = %weaponNum;					

						// If we have an odd number of hardpoints.
						if((%hp%2) == 1)
							%mod = 1; //Move things by 1
						else
							%mod = 2; //Else move things up 2				
		
						// If were sweep winged, give us a sweep
						if($VehicleSWType[%name])
							%pos = GetOffSetRot("0 "@ -0.1*floor((%weaponNum+%mod)/2) @" 0",%Rot,%Pos);		

						// Calculate our launch position
						%pos = GetOffSetRot(
							pow(-1,(%mod+%weaponNum))*$VehicleHPSpace[%name]*floor((%weaponNum+%mod)/2) @" 0 0",%Rot,%Pos);	
					}
					%transform = %transform @ %Rot @" "@ %pos;

				
					if($WeaponRequiresLock[%weapName]) //Really only applies to sidewinders right now. If more locking missiles are added, this will need to be modified
					{
						// Good Lock
						if($Locking::AttackTarget[%this] != "" && $Locking::LockStatus[%this] >= $Locking::RedLock)
						{
							%projectile = Projectile::spawnProjectile($Locking::WeaponRedLock[%weapName], %transform, %fireObj, %playerVel, $Locking::AttackTarget[%this]);
							Vehicle::AddSeekingMissile($Locking::AttackTarget[%this],%projectile);
							warningMessage(GameBase::getControlClient($Locking::AttackTarget[%this]), %projectile);
							%projectile.target = $Locking::AttackTarget[%this];
						}
						// Poor Lock
						else if($Locking::AttackTarget[%this] != "" && $Locking::LockStatus[%this] >= $Locking::YellowLock)
						{
							%projectile = Projectile::spawnProjectile($Locking::WeaponYellowLock[%weapName], %transform, %fireObj, %playerVel, $Locking::AttackTarget[%this]);
							Vehicle::AddSeekingMissile($Locking::AttackTarget[%this],%projectile);
							warningMessage(GameBase::getControlClient($Locking::AttackTarget[%this]), %projectile);		
							%projectile.target = $Locking::AttackTarget[%this];
 						} 
						// No lock; Free fire.
						else
							%projectile = Projectile::spawnProjectile($Locking::WeaponGreenLock[%weapName], %transform, %fireObj, %playerVel);

					} else if($WeaponFreeFall[%weapName])
					{
						if(%weapName == EMCContainer){
							BottomPrint(GameBase::getControlClient(%this), "ECM Jettisoned", 3);
							Player::setSensorSupression(%this,0);
							Player::setSensorSupression(%player,0);
							%this.ECM = false;
						} else Projectile::spawnProjectile(%weapName, %transform, %fireObj, %playerVel);

					// Old and unused
					} else if (%weapName == PhoenixRocket)
					{
					   if($LockingMode[%player] == 0){
						GameBase::getLOSInfo(%this, 1000);
						if (Vehicle::isAircraft($los::object)){
							%projectile = Projectile::spawnProjectile(PhoenixMissile, %transform, %fireObj, %playerVel, $los::object);
							BottomPrint(%player, "<jc>Lock Achieved", 3);
							warningMessage(GameBase::getControlClient($los::object), %projectile);
						}
						else 
						{
							%projectile = Projectile::spawnProjectile(%weapName, %transform, %fireObj, %playerVel);
					   		%projectile.owner = %this;	
					   	}
					   } else {
						Projectile::spawnProjectile(%weapName, %transform, %fireObj, %playerVel);
					   }
					} else if(%weapName == volcano) {
						VolcanicEruption(%this, %player);
					
					} else if(%weapName == TargetingLaser)
					{
						Vehicle::FireTargetingLaser(%this, %player);
					} else if(%weapName == SensorPulse)
					{
						Vehicle::FireSensorPulse(%this, %player);
					} else if(%weapName == RadarPulse)
					{
						Vehicle::FireRadarPulse(%this, %player);
					} else Projectile::spawnProjectile(%weapName, %transform, %fireObj, %playerVel);

					GameBase::playSound(%this, $WeaponSound[%weapName], 3);
			   		%projectile.owner = %this;	

					// Set up fire delay until next shot
					$VehicleCanFire[%this] = False;
					%delay = $VehicleWeapFireDelay[%name, %weapName];
					schedule("$VehicleCanFire["@%this@"] = True;", %delay, %this);  		
	
					// Decrement ammo count

					if($VehicleWeaponAmmoMax[%name,%weapName] != -1)
					{
						$VehicleWeaponAmmo[%this, %weapName]--;
					}					

					// Decrease Hard Point count, or count down to doing so, if neccessary.	
					if( ($VehicleCurWeapon[%this] + $Vehicle::PrimaryGuns[%name]-1) <= %hp  && ($BombBay[%name] == 0)) 
					{
						%notdone = $VModuleHP[$WeaponToNumber[%weapname]];
						for(%i = %weaponNum; %i < %hp  && %NotDone;%i++)
						{
							if($VehicleHPList[%this,%i] == %weapName) {
								%NotDone--;
								$VehicleHPAmmoLeft[%this,%i]--;
							}
						}

						if( $VehicleHPAmmoLeft[%this,%weaponNum] < 1 )
						{	
							$VehicleHP[%this] = $VehicleHP[%this] - $VmoduleHP[$WeaponToNumber[%weapName]];
							
							%notdone = $VModuleHP[$WeaponToNumber[%weapname]];
							for(%i = %weaponNum; %i < $vehicleMaxHardPoints[%name] && %NotDone;%i++)
							{
								if($VehicleHPList[%this,%i] == %weapName) {
									%NotDone--;
									$VehicleHPList[%this,%i] = "";
								}
							}
							
						
	
							if(%weapName == TankSmoke)
							{
								Projectile::spawnProjectile(Tank, %transform, %fireObj, %playerVel);
								BottomPrint(GameBase::getControlClient(%this), "Smoke Tank Jettisoned", 3);					
		
							} else if(%weapName == TankNerveGas)
							{
								Projectile::spawnProjectile(Tank, %transform, %fireObj, %playerVel);
								BottomPrint(GameBase::getControlClient(%this), "Nerve Gas Tank Jettisoned", 3);
							}
						}
						if(%weapName == SideWinderRocket && %name == Apache){
							$VehicleSWHP[%this] = $VehicleSWHP[%this] - $VmoduleHP[$WeaponToNumber[%weapName]];
						}
					}
					
					// Decrease number of weapons ($VehicleGuns[]) and switch weapons if out of ammo. Have to pack the list of weapons too.. grrr...
					if($VehicleWeaponAmmo[%this, %weapName] == 0 && $VehicleCurWeapon[%this] >= $VehiclePrimaryGuns[%name]){
						%weaponToRemove = -1;
						for(%i = $VehiclePrimaryGuns[%name]; %i <= $VehicleGuns[%this]; %i++)
						{
							if($VehicleOwnedWeapon[%this, %i] == %weapName)
								%weaponToRemove = %i;
		
						}
						if(%weaponToRemove == -1)
							echo("ERROR: Weapon to remove on the vehicle not found, but out of ammo!!");					
						else{
							for(%i = %weaponToRemove; %i < $VehicleGuns[%this]; %i++)
							{
								$VehicleOwnedWeapon[%this, %i] = $VehicleOwnedWeapon[%this, %i+1];
							}
							$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = Null;
						}
						$VehicleCurWeapon[%this] = $VehicleGuns[%this];
						$VehicleGuns[%this]--;
						//remoteNextWeapon(%this);
					
					}

				} else if(%player.hflink == 1){
					for(%x = -1; %x < 12;%x++)
						$HPToFire[%this,%x] = "";
					$WorseDelay[%this] = 0;
					if(%weapName == SAWBullet || %weapName == NATOBullet 
					   || %weapName == WarthogBullet || %weapName == TwentyFivemmBullet || %weapName == FiftyCalPodBullet)
					{
						if(($VehicleWeapon[%name,0] == NATOBullet ||	
						   $VehicleWeapon[%name,0] == WarthogBullet) &&
						   $VehicleWeaponAmmo[%this, %weapName] > 0) 
							$HPToFire[%this,-1] = true;
						%weaponNewNum = 0;
						%wasat = %WeaponNewNum;
						if($VehicleHPList[%this,%weaponNewNum] == SAWBullet 
							|| $VehicleHPList[%this,%weaponNewNum] == TwentyFivemmBullet
							|| $VehicleHPList[%this,%weaponNewNum] == FiftyCalPodBullet)
							$HPToFire[%this,%weaponNewNum] = true;

						%WeaponNewNum++;
						if(%weaponNewNum >= %hp)
							%weaponNewNum = 0;
						while(%weaponNewNum != %wasat)
						{
							if($VehicleHPList[%this,%weaponNewNum] == SAWBullet 
								|| $VehicleHPList[%this,%weaponNewNum] == TwentyFivemmBullet
								|| $VehicleHPList[%this,%weaponNewNum] == FiftyCalPodBullet)
								$HPToFire[%this,%weaponNewNum] = true;
							%weaponNewNum = %weaponNewNum+1; 
							if(%weaponNewNum >= %hp)
								 %weaponNewNum = 0;
						}
					} else {
						%weaponNewNum = 0;
						%wasat = %WeaponNewNum;
						if($VehicleHPList[%this,%weaponNewNum] == %weapName)
							$HPToFire[%this,%weaponNewNum] = true;

						%WeaponNewNum++;
						if(%weaponNewNum >= %hp)
							%weaponNewNum = 0;
						while(%weaponNewNum != %wasat)
						{
							if($VehicleHPList[%this,%weaponNewNum] == %weapName)
								$HPToFire[%this,%weaponNewNum] = true;
							%weaponNewNum = %weaponNewNum+1;
							if(%weaponNewNum >= %hp)
								 %weaponNewNum = 0;
						}							
					}
					%fireThis = -1;
					while(%fireThis != %hp)
					{
//echo("START");
//echo(%firethis);
//echo($VehicleHPList[%this,%firethis]);
//echo($VehicleHPAmmoLeft[%this,%firethis]);
						if($HPToFire[%this,%fireThis])
						{
							%pos = getBoxCenter(%this);

							%pos = GetOffSetRot("0 2.5 -.3",%Rot,%Pos);
							%transform = getword(%transorg,0)@" "@getword(%transorg,1)@" "@getword(%transorg,2)@" "@
								getword(%transorg,3)@" "@getword(%transorg,4)@" "@getword(%transorg,5)@" ";
							if(%fireThis != -1)
							{
								// If we have an odd number of hardpoints.
								if((%hp%2) == 1)
									%mod = 1; //Move things by 1
								else
									%mod = 2; //Else move things up 2				
			
								// If were sweep winged, give us a sweep
								if($VehicleSWType[%name])
									%pos = GetOffSetRot("0 "@ -0.1*floor((%fireThis+%mod)/2) @" 0",%Rot,%Pos);		
								// Calculate our launch position
								%pos = GetOffSetRot(
								pow(-1,(%mod+%fireThis))*$VehicleHPSpace[%name]*floor((%fireThis+%mod)/2) @" 0 0",%Rot,%Pos);	
							}
							%transform = %transform @ %Rot @" "@ %pos;
						

							if(%fireThis == -1)
							{
								if(%name == Kiowa)
								{
									%weapname = $VehicleWeapon[%name,$Vehicle::PrimeSelected[%this]];
								} else
								{
									%weapname = $VehicleWeapon[%name,0];
								}
							}
							else
							{
								%weapname = $VehicleHPList[%this,%fireThis];
							}

							if($WeaponRequiresLock[%weapName]) //Really only applies to sidewinders right now. If more locking missiles are added, this will need to be modified
							{
								// Good Lock
								if($Locking::AttackTarget[%this] != "" && $Locking::LockStatus[%this] >= $Locking::RedLock)
								{
									%projectile = Projectile::spawnProjectile($Locking::WeaponRedLock[%weapName], %transform, %fireObj, %playerVel, $Locking::AttackTarget[%this]);
									Vehicle::AddSeekingMissile($Locking::AttackTarget[%this],%projectile);
									warningMessage(GameBase::getControlClient($Locking::AttackTarget[%this]), %projectile);
									%projectile.target = $Locking::AttackTarget[%this];
								}
								// Poor Lock
								else if($Locking::AttackTarget[%this] != "" && $Locking::LockStatus[%this] >= $Locking::YellowLock)
								{
									%projectile = Projectile::spawnProjectile($Locking::WeaponYellowLock[%weapName], %transform, %fireObj, %playerVel, $Locking::AttackTarget[%this]);
									Vehicle::AddSeekingMissile($Locking::AttackTarget[%this],%projectile);
									warningMessage(GameBase::getControlClient($Locking::AttackTarget[%this]), %projectile);		
									%projectile.target = $Locking::AttackTarget[%this];
 								} 
								// No lock; Free fire.
								else
						   			%projectile = Projectile::spawnProjectile($Locking::WeaponGreenLock[%weapName], %transform, %fireObj, %playerVel);
							} else if($WeaponFreeFall[%weapName])
							{
								if(%weapName == EMCContainer){
									BottomPrint(GameBase::getControlClient(%this), "ECM Jettisoned", 3);
									Player::setSensorSupression(%this,0);
									Player::setSensorSupression(%player,0);
									%this.ECM = false;
									
								
								} else Projectile::spawnProjectile(%weapName, %transform, %fireObj, %playerVel);


							// Old and unused
							} else if (%weapName == PhoenixRocket)
							{
							   if($LockingMode[%player] == 0){
								GameBase::getLOSInfo(%this, 1000);
								if (Vehicle::isAircraft($los::object)){
									%projectile = Projectile::spawnProjectile(PhoenixMissile, %transform, %fireObj, %playerVel, $los::object);
									BottomPrint(%player, "<jc>Lock Achieved", 3);
									warningMessage(GameBase::getControlClient($los::object), %projectile);
								}
								else 
								{
									%projectile = Projectile::spawnProjectile(%weapName, %transform, %fireObj, %playerVel);
							   		%projectile.owner = %this;	
							   	}
							   } else {
								Projectile::spawnProjectile(%weapName, %transform, %fireObj, %playerVel);
							   }
							} else if(%weapName == volcano) {
								VolcanicEruption(%this, %player);
					
							} else if(%weapName == TargetingLaser)
							{
								Vehicle::FireTargetingLaser(%this, %player);
							} else if(%weapName == SensorPulse)
							{
								Vehicle::FireSensorPulse(%this, %player);
							} else if(%weapName == RadarPulse)
							{
								Vehicle::FireRadarPulse(%this, %player);
							} else Projectile::spawnProjectile(%weapName, %transform, %fireObj, %playerVel);

							GameBase::playSound(%this, $WeaponSound[%weapName], 3);
					   		%projectile.owner = %this;	
			
							// Set up fire delay until next shot
							$VehicleCanFire[%this] = False;
							if($VehicleWeapFireDelay[%name, %weapName] > $WorseDelay[%this])
								$WorseDelay[%this] = $VehicleWeapFireDelay[%name, %weapName];
			
							// Decrement ammo count
							if($VehicleWeaponAmmoMax[%name,%weapName] != -1)
							{
								$VehicleWeaponAmmo[%this, %weapName]--;
							}

							// Decrease Hard Point count, or count down to doing so, if neccessary.	
//echo("FT2 " @%firethis);
							if( %fireThis != -1 && ($BombBay[%name] == 0)) 
							{
								%notdone = $VModuleHP[$WeaponToNumber[%weapname]];
//echo("ND" @%notDone);
//echo("ONE: " @%i@", "@$VehicleMaxHardPoints[%name]@", "@%notdone);
								for(%i = %firethis; %i < %hp  && %NotDone;%i++)
								{
//echo(%i@", "@$VehicleMaxHardPoints[%name]@", "@%notdone);
//echo($VehicleHPList[%this,%i]@", "@%weapname);
									if($VehicleHPList[%this,%i] == %weapName) {
										%NotDone--;
										$VehicleHPAmmoLeft[%this,%i]--;
									}
								}

							
								if( $VehicleHPAmmoLeft[%this,%firethis] < 1 )
								{	
									$VehicleHP[%this] = $VehicleHP[%this] - $VmoduleHP[$WeaponToNumber[%weapName]];
									
									%notdone = $VModuleHP[$WeaponToNumber[%weapname]];
									for(%i = %firethis; %i < %hp  && %NotDone;%i++)
									{
										if($VehicleHPList[%this,%i] == %weapName) {
											%NotDone--;
											$VehicleHPList[%this,%i] = "";
										}
									}

									if(%weapName == TankSmoke)
									{
										Projectile::spawnProjectile(Tank, %transform, %fireObj, %playerVel);
										BottomPrint(GameBase::getControlClient(%this), "Smoke Tank Jettisoned", 3);					
				
									} else if(%weapName == TankNerveGas)
									{
										Projectile::spawnProjectile(Tank, %transform, %fireObj, %playerVel);
										BottomPrint(GameBase::getControlClient(%this), "Nerve Gas Tank Jettisoned", 3);
									}
								}
								if(%weapName == SideWinderRocket && %name == Apache){
									$VehicleSWHP[%this] = $VehicleSWHP[%this] - $VmoduleHP[$WeaponToNumber[%weapName]];
								}
							}
							
							// Decrease number of weapons ($VehicleGuns[]) and switch weapons if out of ammo. Have to pack the list of weapons too.. grrr...
							if($VehicleWeaponAmmo[%this, %weapName] == 0 && %fireThis != -1){
								%weaponToRemove = -1;
								for(%i = $VehiclePrimaryGuns[%name]; %i <= $VehicleGuns[%this]; %i++)
								{
									if($VehicleOwnedWeapon[%this, %i] == %weapName)
										%weaponToRemove = %i;
				
								}
								if(%weaponToRemove == -1)
									echo("ERROR: Weapon to remove on the vehicle not found, but out of ammo!!");					
								else{
									for(%i = %weaponToRemove; %i < $VehicleGuns[%this]; %i++)
									{
										$VehicleOwnedWeapon[%this, %i] = $VehicleOwnedWeapon[%this, %i+1];
									}
									$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = Null;
								}
								$VehicleCurWeapon[%this] = $VehicleGuns[%this];
								$VehicleGuns[%this]--;
								//remoteNextWeapon(%this);
					
							}
						}

						%fireThis++;
					}
					%delay = $WorseDelay[%this];
					schedule("$VehicleCanFire["@%this@"] = True;", %delay, %this);  		

				} 		
				//Decrease BombBay Count.
				if($VehicleCurWeapon[%this] >= $VehiclePrimaryGuns[%name] && $BombBay[%name] == 1)
				{
					$VehicleBB[%this] = $VehicleBB[%this] - $VmoduleBB[$WeaponToNumber[%weapName]];
					if(%name == Hercules)
						%this.openSeats++;
				

				}				

				%weapName = %oldWeap;
				if($VehicleWeaponAmmoMax[%name,%weapName] != -1)
				{
					%enerLevel = $VehicleWeaponAmmo[%this, %weapName] / $VehicleWeaponAmmoMax[%name, %weapName] * 100;
					GameBase::setEnergy(%this, %enerLevel);
				}			
				
				
			} else if(%player.hflink == 2){

					// Set energy to reflect ammo level
					// Fire the gun
				
				$weapPName[%this] = $WeaponDesc[$VehicleOwnedWeapon[%this,$VehicleCurWeapon[%this]]];
				// Fire the gun
				%weaponNum = $VehicleWeapToFire[%this,%weapname];
				%wasat = %weaponNum;
				%vel = Item::getVelocity(%this);
				%playerVel = %vel;
				%rot = GameBase::getRotation(%this);                             
				%pos = getBoxCenter(%this);		
				%pos = GetOffSetRot(vector::Add(%hpposLower,"0 2.5 -.3"),%Rot,%Pos);	
						
				// Pirmary weapon, or a non-hardpoint Put on nose.
				%transorg = GameBase::getMuzzleTransform(%this);
				%transform = getword(%transorg,0)@" "@getword(%transorg,1)@" "@getword(%transorg,2)@" "@
						getword(%transorg,3)@" "@getword(%transorg,4)@" "@getword(%transorg,5)@" ";
					%oldweap = $LastOn[%this];

					$WorseDelay[%this] = 0;
					%fireThis = -1;
					while(%fireThis != %hp)
					{
//echo("START");
//echo(%firethis);
//echo($VehicleHPList[%this,%firethis]);
//echo($VehicleHPAmmoLeft[%this,%firethis]);
						if($HPToFire[%this,%fireThis])
						{
							%pos = getBoxCenter(%this);

							%pos = GetOffSetRot(vector::Add(%hpposLower,"0 2.5 -.3"),%Rot,%Pos);
							%transform = getword(%transorg,0)@" "@getword(%transorg,1)@" "@getword(%transorg,2)@" "@
								getword(%transorg,3)@" "@getword(%transorg,4)@" "@getword(%transorg,5)@" ";
							if(%fireThis != -1)
							{
								// If we have an odd number of hardpoints.
								if((%hp%2) == 1)
									%mod = 1; //Move things by 1
								else
									%mod = 2; //Else move things up 2				
			
								// If were sweep winged, give us a sweep
								if($VehicleSWType[%name])
									%pos = GetOffSetRot("0 "@ -0.1*floor((%fireThis+%mod)/2) @" 0",%Rot,%Pos);		
								// Calculate our launch position
								%pos = GetOffSetRot(
								pow(-1,(%mod+%fireThis))*$VehicleHPSpace[%name]*floor((%fireThis+%mod)/2) @" 0 0",%Rot,%Pos);	
							}
							%transform = %transform @ %Rot @" "@ %pos;


							if(%fireThis == -1)
							{
								if(%name == Kiowa)
								{
									%weapname = $VehicleWeapon[%name,$Vehicle::PrimeSelected[%this]];
								} else
								{
									%weapname = $VehicleWeapon[%name,0];
								}
							}
							else
							{
								%weapname = $VehicleHPList[%this,%fireThis];
							}

							if($WeaponRequiresLock[%weapName]) //Really only applies to sidewinders right now. If more locking missiles are added, this will need to be modified
							{
								// Good Lock
								if($Locking::AttackTarget[%this] != "" && $Locking::LockStatus[%this] >= $Locking::RedLock)
								{
									%projectile = Projectile::spawnProjectile($Locking::WeaponRedLock[%weapName], %transform, %fireObj, %playerVel, $Locking::AttackTarget[%this]);
									Vehicle::AddSeekingMissile($Locking::AttackTarget[%this],%projectile);
									warningMessage(GameBase::getControlClient($Locking::AttackTarget[%this]), %projectile);
									%projectile.target = $Locking::AttackTarget[%this];
								}
								// Poor Lock
								else if($Locking::AttackTarget[%this] != "" && $Locking::LockStatus[%this] >= $Locking::YellowLock)
								{
									%projectile = Projectile::spawnProjectile($Locking::WeaponYellowLock[%weapName], %transform, %fireObj, %playerVel, $Locking::AttackTarget[%this]);
									Vehicle::AddSeekingMissile($Locking::AttackTarget[%this],%projectile);
									warningMessage(GameBase::getControlClient($Locking::AttackTarget[%this]), %projectile);		
									%projectile.target = $Locking::AttackTarget[%this];
 								} 
								// No lock; Free fire.
								else
						   			%projectile = Projectile::spawnProjectile($Locking::WeaponGreenLock[%weapName], %transform, %fireObj, %playerVel);
							} else if($WeaponFreeFall[%weapName])
							{
								if(%weapName == EMCContainer){
									BottomPrint(GameBase::getControlClient(%this), "ECM Jettisoned", 3);
									Player::setSensorSupression(%this,0);
									Player::setSensorSupression(%player,0);
									%this.ECM = false;
								} else Projectile::spawnProjectile(%weapName, %transform, %fireObj, %playerVel);
	
								// old and unused
							} else if (%weapName == PhoenixRocket)
							{
							   if($LockingMode[%player] == 0){
								GameBase::getLOSInfo(%this, 1000);
								if (Vehicle::isAircraft($los::object)){
									%projectile = Projectile::spawnProjectile(PhoenixMissile, %transform, %fireObj, %playerVel, $los::object);
									BottomPrint(%player, "<jc>Lock Achieved", 3);
									warningMessage(GameBase::getControlClient($los::object), %projectile);
								}
								else 
								{
									%projectile = Projectile::spawnProjectile(%weapName, %transform, %fireObj, %playerVel);
							   		%projectile.owner = %this;	
							   	}
							   } else {
								Projectile::spawnProjectile(%weapName, %transform, %fireObj, %playerVel);
							   }
							} else if(%weapName == volcano) {
								VolcanicEruption(%this, %player);
					
							} else if(%weapName == TargetingLaser)
							{
								Vehicle::FireTargetingLaser(%this, %player);
							} else if(%weapName == SensorPulse)
							{
								Vehicle::FireSensorPulse(%this, %player);
							} else if(%weapName == RadarPulse)
							{
								Vehicle::FireRadarPulse(%this, %player);
							} else Projectile::spawnProjectile(%weapName, %transform, %fireObj, %playerVel);

							GameBase::playSound(%this, $WeaponSound[%weapName], 3);
					   		%projectile.owner = %this;	
			
							// Set up fire delay until next shot
							$VehicleCanFire[%this] = False;
							if($VehicleWeapFireDelay[%name, %weapName] > $WorseDelay[%this])
								$WorseDelay[%this] = $VehicleWeapFireDelay[%name, %weapName];
			
							// Decrement ammo count

							if($VehicleWeaponAmmoMax[%name,%weapName] != -1)
							{
								$VehicleWeaponAmmo[%this, %weapName]--;
							}			

							// Decrease Hard Point count, or count down to doing so, if neccessary.	
//echo("FT2 " @%firethis);
							if( %fireThis != -1 && ($BombBay[%name] == 0)) 
							{
								%notdone = $VModuleHP[$WeaponToNumber[%weapname]];
//echo("ND" @%notDone);
//echo("ONE: " @%i@", "@$VehicleMaxHardPoints[%name]@", "@%notdone);
								for(%i = %firethis; %i < %hp && %NotDone;%i++)
								{
//echo(%i@", "@$VehicleMaxHardPoints[%name]@", "@%notdone);
//echo($VehicleHPList[%this,%i]@", "@%weapname);
									if($VehicleHPList[%this,%i] == %weapName) {
										%NotDone--;
										$VehicleHPAmmoLeft[%this,%i]--;
									}
								}

							
								if( $VehicleHPAmmoLeft[%this,%firethis] < 1 )
								{	
									$VehicleHP[%this] = $VehicleHP[%this] - $VmoduleHP[$WeaponToNumber[%weapName]];
									
									%notdone = $VModuleHP[$WeaponToNumber[%weapname]];
									for(%i = %firethis; %i < %hp && %NotDone;%i++)
									{
										if($VehicleHPList[%this,%i] == %weapName) {
											%NotDone--;
											$VehicleHPList[%this,%i] = "";
											$HPToFire[%this,%i] = "";
										}
									}

									if(%weapName == TankSmoke)
									{
										Projectile::spawnProjectile(Tank, %transform, %fireObj, %playerVel);
										BottomPrint(GameBase::getControlClient(%this), "Smoke Tank Jettisoned", 3);					
				
									} else if(%weapName == TankNerveGas)
									{
										Projectile::spawnProjectile(Tank, %transform, %fireObj, %playerVel);
										BottomPrint(GameBase::getControlClient(%this), "Nerve Gas Tank Jettisoned", 3);
									}
								}
								if(%weapName == SideWinderRocket && %name == Apache){
									$VehicleSWHP[%this] = $VehicleSWHP[%this] - $VmoduleHP[$WeaponToNumber[%weapName]];
								}
							} else if(%fireThis == -1)
							{
								if($VehicleWeaponAmmo[%this, $VehicleWeapon[%name,0]] <= 0)	
									$HPToFire[%this,%fireThis] = "";

							}
							
							// Decrease number of weapons ($VehicleGuns[]) and switch weapons if out of ammo. Have to pack the list of weapons too.. grrr...
							if($VehicleWeaponAmmo[%this, %weapName] == 0 && %fireThis != -1){
								%weaponToRemove = -1;
								for(%i = $VehiclePrimaryGuns[%name]; %i <= $VehicleGuns[%this]; %i++)
								{
									if($VehicleOwnedWeapon[%this, %i] == %weapName)
										%weaponToRemove = %i;
				
								}
								if(%weaponToRemove == -1)
									echo("ERROR: Weapon to remove on the vehicle not found, but out of ammo!!");					
								else{
									for(%i = %weaponToRemove; %i < $VehicleGuns[%this]; %i++)
									{
										$VehicleOwnedWeapon[%this, %i] = $VehicleOwnedWeapon[%this, %i+1];
									}
									$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = Null;
								}
								$VehicleCurWeapon[%this] = $VehicleGuns[%this];
								$VehicleGuns[%this]--;
								//remoteNextWeapon(%this);
					
							}
						}

						%fireThis++;
					}
					%delay = $WorseDelay[%this];
					schedule("$VehicleCanFire["@%this@"] = True;", %delay, %this);
				//Decrease BombBay Count.
				if($VehicleCurWeapon[%this] >= $VehiclePrimaryGuns[%name] && $BombBay[%name] == 1)
				{
					$VehicleBB[%this] = $VehicleBB[%this] - $VmoduleBB[$WeaponToNumber[%weapName]];
					if(%name == Hercules)
						%this.openSeats++;
				

				}				

				%weapName = %oldWeap;

				if($VehicleWeaponAmmoMax[%name,%weapName] != -1)
				{
					%enerLevel = $VehicleWeaponAmmo[%this, %weapName] / $VehicleWeaponAmmoMax[%name, %weapName] * 100;
					GameBase::setEnergy(%this, %enerLevel);
 				}

			} else {
				Bottomprint(%player, "<jc>" @ $weapPName[%this] @ " is out of ammo", 3);
			}
		}
	} 
}

// For Kiowa targeting laser.
function Vehicle::FireTargetingLaser(%this,%player)
{
	if($Vehicle::TargetingLaserOn[%this])
	{
		Vehicle::disableTargetingLaser(%this);
		Client::sendMessage(Gamebase::getcontrolClient(%this),0,"Targeting Laser Lock Disengaged");
	}
	else
	{

		if(GameBase::getLOSInfo(%this, 10000)) 
		{ 	
			
			$Vehicle::TargetingLaserOn[%this] = true;
			%pos = $LOS::Position;
			%marker = newObject("",Item,TargetItem,1,true, true, false);
			$Vehicle::TargetingLaser[%this] = %marker;
			GameBase::setIsTarget(%marker,true);
			gamebase::setteam(%marker, gamebase::GetTeam(%player)); 
			gamebase::setposition(%marker, %pos); 
				
			Client::sendMessage(Gamebase::getcontrolClient(%this),0,"Targeting Laser Position Locked");
		
			Vehicle::UpdateTargetingLaser(%this);
		} 
	}
}

$Vehicle::TargetingLaserCheckTime = 0.1;

function Vehicle::UpdateTargetingLaser(%this)
{
	if($Vehicle::TargetingLaserOn[%this])
	{
		%mask = (~0 ^ $BitMask::Vehicle) ^ $BitMask::Player;
		getLOSInfo(gamebase::Getposition(%this),gamebase::Getposition($Vehicle::TargetingLaser[%this]),%mask);
		%pos = $LOS::Position;
		%obj = $LOS::Object;
  
		if(Vector::getDistance(gamebase::Getposition($Vehicle::TargetingLaser[%this]),%pos) < 1) 
		{ 	
			// Keep going
			schedule("Vehicle::UpdateTargetingLaser("@%this@");",$Vehicle::TargetingLaserCheckTime);
		} else
		{
			// Blockage; End it.
			Vehicle::DisableTargetingLaser(%this);
			Client::sendMessage(Gamebase::getcontrolClient(%this),0,"Targeting Laser Lock Lost");
		}
	}
}

function Vehicle::DisableTargetingLaser(%this)
{
	$Vehicle::TargetingLaserOn[%this] = false;
	deleteObject($Vehicle::TargetingLaser[%this]);
}


function Vehicle::FireSensorPulse(%this,%player)
{
	Client::sendMessage(Gamebase::getcontrolClient(%this),0,"Scanning for enemy presence. Ready to scan again in 5 seconds.");
	SensorPulse::Ping(%this,%player);
}

function Vehicle::FireRadarPulse(%this,%player)
{
echo("Fire Radar Pulse!");
}

function RemoteselectFireGroup(%client,%value)
{
//echo(%value);
	%player = Client::getOwnedObject(%client);
	if(%player.isgrappling)
	{
		Swing(%player, %value);
		return;
	}
	%this = %player.vehicle;
	%name =  Vehicle::getDataName(%this);
//echo(%this@" "@ %name);
	if(%client.hflink != 2)
 	{
		Bottomprint(%client,"<jc>You must be set to selected firelinking.",5);
		return;	
	}
	if(%this == "" || %name == Linebacker || %name == Blackhawk || %name == MoveBlackhawkExtraction || %name == Bomber || %name == Gunship || %name == Hercules || %name == Sentry 
		|| %name == Abrams || %name == TOWMissile || %name == Bradley || %name == MineLayer || %name == Humvee || %name == MLRS)
	{
		Bottomprint(%client,"<jc>You must be in a vehicle with hard points to select firelinking.",5);
		return;	
	}

	if(%value == "Clear")
	{
		for(%x = -1;%x < 11;%x++)
			$HPToFire[%this,%x] = "";	
		Bottomprint(%client,"<jc>Fire-linked selections cleared.",5);
			GameBase::setEnergy(%this, 0);
			$LastOn[%this] = "";

	} else if(%value != -1 && $VehicleHPList[%this,%value] == ""){
		Bottomprint(%client,"<jc>There is no weapon loaded at that hardpoint.",5);
		return;	
		
	} else if(%value == -1){
		
		if($Vehicle::PrimeSelected[%this] == "")
			$Vehicle::PrimeSelected[%this] = 0;


		if($VehicleWeaponAmmo[%this, $VehicleWeapon[%name,$Vehicle::PrimeSelected[%this]]] <= 0)
		{
			$HPToFire[%this,%value] = "";
			Bottomprint(%client,"<jc>"@$WeaponDesc[$VehicleWeapon[%name,$Vehicle::PrimeSelected[%this]]]@" out of ammo. Selection refused.",5);
		} else if($HPToFire[%this,%value] && (%name != Kiowa || $Vehicle::PrimeSelected[%this] == 1)) {
			$HPToFire[%this,%value] = "";
			Bottomprint(%client,"<jc>"@$WeaponDesc[$VehicleWeapon[%name,$Vehicle::PrimeSelected[%this]]]@" deselected.",5);
			GameBase::setEnergy(%this, 0);
			$LastOn[%this] = "";
		} else {
			
			if(%name != Kiowa || (!$HPToFire[%this,%value]))
			{
				$Vehicle::PrimeSelected[%this] = 0;
			} else if(%name == Kiowa)
			{
				$Vehicle::PrimeSelected[%this] = 1;
			}
			
			$HPToFire[%this,%value] = true;
			Bottomprint(%client,"<jc>"@$WeaponDesc[$VehicleWeapon[%name,$Vehicle::PrimeSelected[%this]]]@" selected to fire.",5);
			$LastOn[%this] = $VehicleWeapon[%name,$Vehicle::PrimeSelected[%this]];

			if($VehicleWeaponAmmoMax[%name,$VehicleWeapon[%name,$Vehicle::PrimeSelected[%this]]] != -1)
			{
				%enerLevel = $VehicleWeaponAmmo[%this, $VehicleWeapon[%name,$Vehicle::PrimeSelected[%this]]] 
						/ $VehicleWeaponAmmoMax[%name, $VehicleWeapon[%name,$Vehicle::PrimeSelected[%this]]] * 100;
			} else
			{
				%enerLevel = 100;
			}
			GameBase::setEnergy(%this, %enerLevel);

		}
	} else {
		if($HPToFire[%this,%value]) {
			$HPToFire[%this,%value] = "";
			Bottomprint(%client,"<jc>"@$WeaponDesc[$VehicleHPList[%this,%value]]@" deselected.",5);
			GameBase::setEnergy(%this, 0);
			$LastOn[%this] = "";
		} else {
			$HPToFire[%this,%value] = true;
			Bottomprint(%client,"<jc>"@$WeaponDesc[$VehicleHPList[%this,%value]]@" selected to fire.",5);
			$LastOn[%this] = $VehicleHPList[%this,%value];
			%enerLevel = $VehicleWeaponAmmo[%this, $VehicleHPList[%this,%value]] / $VehicleWeaponAmmoMax[%name, $VehicleHPList[%this,%value]] * 100;
			GameBase::setEnergy(%this, %enerLevel);
			Locking::CheckToStartLoop(%this,$VehicleHPList[%this,%value]);
		}
	}
}

// Should keep the vehicles relatively close to the ground...hopefully
function hugGround(%this) 
{
	echo("*****THIS HAS BEEN DISABLED. USE NORMAL GROUND CODE.");
	return;

	GameBase::getLOSInfo(%this, 500, "-1.57 0 0");
	%posZ = getWord($los::position, 2) + 2.0;
	%curPos = GameBase::getPosition(%this);
	%posX = getWord(%curPos, 0);
	%posY = getWord(%curPos, 1);
	%curPos = ""@%posX@" "@%posY@" "@%posZ@"";
		if(GameBase::testPosition(%this, %curPos)) GameBase::setPosition(%this, %curPos);
	schedule("hugGround("@%this@");", 2, %this);
}

//-How often to have this loop.
$LG::TimeSkip = 0.02;
//-The buffer for how much our rot can be off from the terrain's.
// Should smooth the ride out a little.
$LG::RotOffset = 0.001;
$LG::RefHeight = 2.51;
$LG::OffHeight = 10;
function landingGear(%veh,%client)
{
	//Make sure client exists and is the guy controling the car.
	if(%client < 1 || %client == "")
		%client = GameBase::getControlClient(%veh);
	
	//If we got a driver, arn't being carried and have something under us.
	if(GameBase::getControlClient(%veh) == %client && GameBase::getLOSInfo(%veh,20,"-1.570796327 0 0")) {
		//Get the position and rotation of the ground
		%groundRot = $los::normal;
		%groundPos = $los::position;
		%groundObj = $los::object;

		//get the position and rotation of the vehicle.
		%rot0 = GameBase::getRotation(%veh);
		%pos0 = GameBase::getPosition(%veh);

		
		// Only run this if we're going fast enough.
		%speedI = Vector::getdistance("0 0 0", Item::getVelocity(%veh));
		%Vheight = getword(%pos0,2) - getword(%groundPos,2);

		if(Vehicle::IsBigJet(%veh) && getObjectType(%groundObj) == "InteriorShape")
		{
			%mul = 10;
		} else
		{
			%mul = 5;
		}
		%curHeight = $LG::RefHeight + (%speedI/(Vehicle::getDataName(%veh).maxspeed))*%mul;
		//Take care of ground. If were higher, then fall and such.
		%NewPos = getWord(%pos0,0)@" "@getWord(%pos0,1)@" "@getWord(%groundPos,2)+%curHeight;
		
		%maxspeed = Vehicle::getDataName(%veh).maxspeed;
		%factor = 0.9;
		if(Vehicle::IsTomcat(%veh))
			%factor = 0.8;
		if(%Vheight <= $LG::OffHeight && %speedI < %maxspeed *%factor )
		{
			//Set all our things.
			Vehicle::SwapSeekingMissiles::P(%veh);
			//****** Blocking in this whole section***
				GameBase::setPosition(%veh,%newPos);
				// If we're on the grass, and our normal is ugly, we should damage them.
				%speedDif = %SpeedI-%maxspeed*0.25;
				if(%groundObj == 8 && %speedDif > 0 && Vector::getdistance(%groundRot,"0 0 1") > 0.05)
				{
					GameBase::applyDamage(%veh, $ImpactDamageType, %speedDif*%speedDif*Vector::getdistance(%groundRot,"0 0 1")/10000, %newPos, "0 0 0", "0 0 0", %client);
				}
			// ******POS HERE
				%veh.lastPos = %newPos;	

				// We might be trying to land, so swap out our vehicle
				if(FALSE && String::findSubStr(Vehicle::GetDataName(%veh),Gamebase::getDataName(%veh)) == -1)
				{
					%newVeh = newObject("","Flier",Vehicle::getDataName(%veh), true);
		
					Vehicle::SwapData(%veh, %newVeh);
					deleteObject(%veh);
					%veh = %newVeh;
				}
				
				// Only set rot if its to much.
				//Smooth out the rotation settings a tad.
				%RotDifference0 = (getword(%groundRot, 0) - getword(%rot0, 0));
				if((gamebase::getdataName(%groundObj) == False || gamebase::getdataName(%groundObj) == "") &&  (%rotDifference0 > $LG::RotOffset || %rotDifference0 < -1*$LG::RotOffset)) {
					%RotDifference0 = getword(%groundRot, 0);
					
					// only for going forwards.
					if(getword(%veh.lastRot, 0) > %RotDifference0)
						%RotDifference0 = -1*%RotDifference0;
					%NewRot = %rotDifference0@" "@getWord(GameBase::getRotation(%veh),1)@" "@getWord(GameBase::getRotation(%veh),2);
					
						GameBase::setRotation(%veh,%NewRot); 
			// ******ROT HERE
	
					%veh.lastRot = %newRot;
			
				} else			
					%veh.lastRot = %rot0;
			//****** Blocking in this whole section***
			Vehicle::SwapSeekingMissiles::V(%veh);
		} 
		// Otherwise, we're in the air.
		else if( FALSE && %speedI >= %maxspeed *0.9 && String::findSubStr(Gamebase::getDataName(%veh),"IF") == -1 && String::findSubStr(Gamebase::getDataName(%veh),"AB") == -1)
		{
//			preSwap(%veh);
			echo("Airborn");
			// Swap out our vehicle, and set up a "no swap timer" for about a second.
			%newVeh = newObject("","Flier",Vehicle::getDataName(%veh)@"IF", true);

			Vehicle::SwapData(%veh, %newVeh);
			deleteObject(%veh);
			%veh = %newVeh;
	
			// Timer
			$Vehicle::NoSwapOut[%veh] = true;
			schedule("$Vehicle::NoSwapOut["@%veh@"] = false;",5,%veh);
		}	

	} 
	// Force them to nose dive if they go too slow.
	else if(GameBase::getControlClient(%veh) == %client)
	{
		noseDown(%veh,false);
	}
	
	if(GameBase::getControlClient(%veh) == %client)
		schedule("landingGear("@%veh@","@%client@");",$LG::TimeSkip,%veh);
}

function noseDown(%veh,%repeat)
{
	if(%veh == "" || %veh <= 0 || $plummeting[%veh] == 1)
		return;
	
	// If we're a chopper, we need to have this called as a repeat (i.e. if the pilot bailed)
	if(Vehicle::isChopper(%veh) && !%repeat)
		return;

	if(!Vehicle::isChopper(%veh))
	{
		%rot0 = GameBase::getRotation(%veh);
		%speedI = Vector::getdistance("0 0 0", Item::getVelocity(%veh));
		%maxspeed = Vehicle::getDataName(%veh).maxspeed;

		%factor = 0.9;
		if(Vehicle::IsTomcat(%veh))
			%factor = 0.8;

		if( %speedI < %maxspeed *%factor )
		{
			if(getword(%rot0,0) > -1.4){
				%newRot = vector::Add(%rot0,"-0.005 0 0");
				Vehicle::SwapSeekingMissiles::P(%veh);
					gamebase::SetRotation(%veh,%newRot);
				Vehicle::SwapSeekingMissiles::V(%veh);
			}else if(getword(%rot0,0) < -1.8){
				%newRot = vector::Add(%rot0,"0.005 0 0");
				Vehicle::SwapSeekingMissiles::P(%veh);
					gamebase::SetRotation(%veh,%newRot);
				Vehicle::SwapSeekingMissiles::V(%veh);			
			}
		}
	} else
	{
		%OldRot = GameBase::getRotation(%veh);
		%NewXRot = getword(%OldRot, 0);
		%NewYRot = getword(%OldRot, 1);
		%NewZRot = getword(%OldRot, 2) + getRandom()*-1*(vector::getdistance("0 0 0",Item::getVelocity(%veh))/(Vehicle::getDataName(%veh).maxSpeed*3));
		if(%NewXRot > -1.4){
			%NewXRot = %NewXRot - 0.01;
		}else if(%NewXRot < -1.8){
			%NewXRot = %NewXRot + 0.01;
		}
		%NewRot = %NewXRot @ " " @ %NewYRot @ " " @ %NewZRot;

		Vehicle::SwapSeekingMissiles::P(%veh);
			GameBase::setRotation(%veh,%NewRot);
		Vehicle::SwapSeekingMissiles::V(%veh);
				

	}
	if(%repeat)
	{
		schedule("noseDown("@%veh@","@%repeat@");",$LG::TimeSkip,%veh);
	}
}


function Vehicle::SwapData(%oldVeh, %newVeh,%noPerson)
{
echo("Swapping!!! " @ %oldVeh @ " " @%newVeh);
	%oldVeh.swap = %newVeh;

	// For missiles locked onto the vehicle.
	// Doesn't have to happen immediately. Lets make sure the missile (if it was a missile) that takes the jet down
	// gets removed before we swap these.

	// *only* swap if the vehicle is unmanned. A fraction of the time if it is manned, an aTan domain error is thrown which effectivly
	// freezes servers.
	if(GameBase::getControlClient(%oldVeh) == -1)
		schedule("Vehicle::SwapSeekingMissiles("@%oldVeh@","@%newVeh@");",0.5);

	// For people obtaining a lock on the vehicle.
	Locking::SwapOut(%this, %newVeh);

	// If we're swapping this one out, it shouldn't be radarable anymore.
	Radar::Remove(%oldVeh);
	Radar::Detectable::Remove(%oldVeh);
	%newVeh.boughtTeam = %oldVeh.boughtTeam;

	%rot = gamebase::GetRotation(%oldVeh);
	%pos = gamebase::getPosition(%oldVeh);
	
	gamebase::SetPosition(%newVeh,%pos);
	gamebase::SetRotation(%newVeh,%rot);
	
	// Switch Driver.
	%cl = GameBase::getControlClient(%oldVeh);
	if(%cl && !%noPerson)
	{
		%pl = Client::getOwnedObject(%cl);
		player::SetMountObject(%pl, %oldVeh, 0);
		player::SetMountObject(%pl, -1, 0);
		Player::setMountObject(%pl, %newVeh, 1);
		Client::setControlObject(%cl, %newVeh);
	       	%pl.vehicle = %this;
		%newVeh.clLastMount = %cl;
	} else
	{
		%newVeh.clLastMount = %oldVeh.clLastMount;
	}
	// Switch passengers.
	for(%i = 0 ; %i < 4 ; %i++)
	{
		if(%oldVeh.Seat[%i] != "") 
		{
			%pl = Client::getOwnedObject(%oldVeh.Seat[%i]);
		   	Player::setMountObject(%pl, %newVeh, %i+2);
		   	%pl.vehicle= %newVeh;
			$PassengerSlot[%newVeh, %i+2] = gamebase::getControlClient(%pl);
			%newVeh.Seat[%i] = %oldVeh.Seat[%i];
		}
	}


	gamebase::setPosition(%oldVeh,"0 0 -123141"); // Somewhere safe.

	gamebase::setTeam(%newVeh,gamebase::GetTeam(%oldVeh));
	%newVeh.dead = %oldVeh.dead;
	%newVeh.shieldStrength = %oldVeh.shieldStrength;
	gamebase::setDamageLevel(%newVeh,GameBase::getDamageLevel(%oldVeh));
	gamebase::setEnergy(%newVeh,gamebase::GetEnergy(%oldVeh));
	
	%name = Vehicle::getDataName(%oldVeh);
	GameBase::setRechargeRate(%newVeh, Gamebase::getRechargeRate(%oldVeh));
	GameBase::setMapName (%newVeh, Gamebase::getMapName(%oldVeh));
	if (%name == Abrams || %name == Bradley || %name == Humvee || %name == LineBacker || %name == MLRS || %name == MineLayer) {
		if($Server::FuzzyPhysics)
			schedule("hugGround("@%this@");", 2, %this);
	}
	
	
	if(%name == Apache)
		$VehicleSWHP[%newVeh] = $VehicleSWHP[%oldVeh]; // Used only for apache.
	if($BombBay[%name] == 1)
		$VehicleBB[%newVeh] = $VehicleBB[%oldVeh];
	
	if(%name == Hercules)
		%newVeh.openSeats = %oldVeh.openSeats;

	$VehicleGuns[%newVeh] = $VehicleGuns[%oldVeh];
	$VehicleHP[%newVeh] = $VehicleHP[%oldVeh];
	$VehicleCurWeapon[%newVeh] = $VehicleCurWeapon[%oldVeh];
	for(%i = 0; %i < $VehicleGuns[%oldVeh]; %i++)
	{
		%weapName = $VehicleOwnedWeapon[%newVeh, %i] = $VehicleOwnedWeapon[%oldVeh, %i];	
		$VehicleWeaponAmmo[%newVeh, %weapName] = $VehicleWeaponAmmo[%oldVeh, %weapName];
		$VehicleWeapToFire[%newVeh,%weapName] = $VehicleWeapToFire[%oldVeh,%weapName];
	}
	for(%i = 0; %i < $VehicleHP[%oldVeh]; %i++)
	{
		$VehicleHPList[%newVeh,%i] = $VehicleHPList[%oldVeh,%i];
		$VehicleHPAmmoLeft[%newVeh,%i] = $VehicleHPAmmoLeft[%oldVeh,%i];	
	}

	$VehicleCanFire[%newVeh] = $VehicleCanFire[%oldVeh];
	$VehicleCounterMeasuresCur[%newVeh] = $VehicleCounterMeasuresCur[%oldVeh];
	$Smoking[%newVeh] = $Smoking[%oldVeh];
	$Flamming[%newVeh] = $Flamming[%oldVeh];
	$Plummeting[%newVeh] = $Plummeting[%oldVeh];

	// Don't have to worry about plummeting, since if we're in here,
	// it's either a result of plummeting, or of jumping (which would mean no plummeting)
	if($Smoking[%newVeh] == 1){
		smokeEffects(%newVeh);
	}
	if($Flamming[%newVeh] == 1){
		fireEffects(%newVeh);
	}

	
	$VehicleAmmo[%newVeh, TwentyFivemmgun] = $VehicleAmmo[%oldVeh, TwentyFivemmgun];
	$VehicleAmmo[%newVeh, LowMountTwentyFivemmgun] = $VehicleAmmo[%oldVeh, LowMountTwentyFivemmgun];
	$VehicleAmmo[%newVeh, AbramsGun] = $VehicleAmmo[%oldVeh, AbramsGun];
	$VehicleAmmo[%newVeh, LowMountAbramsGun] = $VehicleAmmo[%oldVeh, LowMountAbramsGun];
	$VehicleAmmo[%newVeh, Fortymmgun] = $VehicleAmmo[%oldVeh, Fortymmgun];
	$VehicleAmmo[%newVeh, Minigun] = $VehicleAmmo[%oldVeh, Minigun];
	$VehicleAmmo[%newVeh, LowMountMinigun] = $VehicleAmmo[%oldVeh, LowMountMinigun];
	$VehicleAmmo[%newVeh, TOW] = $VehicleAmmo[%oldVeh, TOW];
	$VehicleAmmo[%newVeh, AutoGrenLauncher] = $VehicleAmmo[%oldVeh, AutoGrenLauncher];
	$VehicleAmmo[%newVeh, StingerLauncherGun] = $VehicleAmmo[%oldVeh, StingerLauncherGun];
	$VehicleAmmo[%newVeh, MLRSLauncher] = $VehicleAmmo[%oldVeh, MLRSLauncher];
	$PassengerSlot[%newVeh, 2] = $PassengerSlot[%oldVeh, 2];
	$PassengerSlot[%newVeh, 3] = $PassengerSlot[%oldVeh, 3];
	$PassengerSlot[%newVeh, 4] = $PassengerSlot[%oldVeh, 4];
	$PassengerSlot[%newVeh, 5] = $PassengerSlot[%oldVeh, 5];

	
}

// To keap planes "bouncing" themselves to death on the runway.
function landingGearOld(%vehicle, %clientId, %changeZRot, %changeYRot)
{
	%refHeight = "-1.575 0 0";
	%vehicleData = Vehicle::getDataName(%vehicle);
	
	// Get the current speed of the vehicle from the velocity vectors
	%velocI = Item::getVelocity(%vehicle); 
	%xvelocI = getword(%velocI, 0);
	%yvelocI = getword(%velocI, 1);
	%zvelocI = getword(%velocI, 2);
	%speedI = sqrt(%xvelocI*%xvelocI + %yvelocI*%yvelocI + %zvelocI*%zvelocI);
	
	if($SFdrivingAPC[%clientId])  
	{
		
		if(GameBase::getLOSInfo(%vehicle,20,%refHeight))
		{
			%VgroundPos = $los::position;
			%VvehiclePos = GameBase::getPosition(%vehicle);
			%VvehicleZ = getword(%VvehiclePos, 2);
			%Vgroundz = getword(%VgroundPos, 2);
			%Vheight = %VvehicleZ - %VgroundZ;
		}
	
		if(%Vheight <= 2.51 && %speedI < %vehicleData.maxspeed *0.9 ) // if they are off the ground, or they are going more then half speed, remove landing gear
		{
			
			%refX1 = "-0.393 0 0";
			%refX2 = "-0.393 0 1.571";
			%refX3 = "-0.786 0 0";
			%refX4 = "-0.786 0 1.571";
	
			%refY2 = "-0.393 0 0.786";
			%refY1 = "-0.393 0 -0.786";
			%refY4 = "-0.786 0 0.786";
			%refY3 = "-0.786 0 -0.786";
			
			%refHeight = "-1.575 0 0";			

			//Temp set Rotations
			%OldRot = GameBase::getRotation(%vehicle);
			%NewXRot = getword(%OldRot, 0);
			%NewYRot = getword(%OldRot, 1);
			%changeInZ = %changeYRot - %NewYRot;
			%changeInZ = %changeInZ * 3;
			//if(($modVal % 5) == 0) 
			//	echo(%changeInZ);
			//$modVal++;
			%NewZRot = %changeZRot + %changeInZ;
			
			// Front Middle Position
			//----------------------
			if(GameBase::getLOSInfo(%vehicle,20,%refX1))
				%frontMiddlePos = $los::position;
			else
				if(GameBase::getLOSInfo(%vehicle,1000,%refX3))
					%frontMiddlePos = $los::position;
				else
					%frontMiddlePos = "0 0 0";
			
			// Rear Middle Position
			//-----------------------
			if(GameBase::getLOSInfo(%vehicle,20,%refX2))
				%rearMiddlePos = $los::position;
			else
				if(GameBase::getLOSInfo(%vehicle,1000,%refX4))
					%rearMiddlePos = $los::position;
				else
					%rearMiddlePos = "0 0 0";			

			// Left Middle Position
			//------------------------
			if(GameBase::getLOSInfo(%vehicle,20,%refY1))
				%leftMiddlePos = $los::position;
			else
				if(GameBase::getLOSInfo(%vehicle,1000,%refY3))
					%leftMiddlePos = $los::position;
				else
					%leftMiddlePos = "0 0 0";			

			// Right Middle Position
			//------------------------
			if(GameBase::getLOSInfo(%vehicle,20,%refY2))
				%rightMiddlePos = $los::position;
			else
				if(GameBase::getLOSInfo(%vehicle,1000,%refY4))
					%rightMiddlePos = $los::position;
				else
					%rightMiddlePos = "0 0 0";		

			//-------------------
			// X Rotation Stuff
			//-------------------
			// Rear Position
			%rMidX = getword(%rearMiddlePos, 0);
			%rMidY = getword(%rearMiddlePos, 1);
			%rMidZ = getword(%rearMiddlePos, 2);
			// Front Position
			%fMidX = getword(%frontMiddlePos , 0);
			%fMidY = getword(%frontMiddlePos , 1);
			%fMidZ = getword(%frontMiddlePos , 2);
			// X Distance
			%rpos = %rMidX@" "@%rMidY@" 0";
			%fpos = %fMidX@" "@%fMidY@" 0";
			// Find average of both rotations
			// Total Distance
			%totDist = Vector::getDistance(%rpos, %fpos);
			%zDistance = %fMidZ - %rMidZ;
			if(%totDist != 0)
		    	if( %zDistance != 0 )
				{
					%OppAdd = %zDistance/%totDist;
					%NewXRot = inverseTan(%OppAdd);
				}		

			//-------------------
			// Y Rotation Stuff
			//-------------------
			// Right Side Position
			%rsMidX = getword(%rightMiddlePos, 0);
			%rsMidY = getword(%rightMiddlePos, 1);
			%rsMidZ = getword(%rightMiddlePos, 2);
			// Left Side Position
			%lsMidX = getword(%leftMiddlePos , 0);
			%lsMidY = getword(%leftMiddlePos , 1);
			%lsMidZ = getword(%leftMiddlePos , 2);
			// Y Distance
			%rsPos = %rsMidX@" "@%rsMidY@" 0";
			%lsPos = %lsMidX@" "@%lsMidY@" 0";
			// Total Distance
			%totDist = Vector::getDistance(%rsPos, %lsPos);
			%zDistance = %lsMidZ - %rsMidZ;
			if(%totDist != 0)
				if( %zDistance != 0 )
				{
					%OppAdd = %zDistance/%totDist;
					%NewYRot = inverseTan(%OppAdd);
				}		

			//-------------------
			// Height Stuff
			//-------------------
			if(GameBase::getLOSInfo(%vehicle,20,%refHeight))
			{
				%groundPos = $los::position;
				%vehiclePos = GameBase::getPosition(%vehicle);
				%vehicleX = getword(%vehiclePos, 0);
				%vehicleY = getword(%vehiclePos, 1);
				%vehicleZ = getword(%vehiclePos, 2);
				%groundz = getword(%groundPos, 2);
				%height = %vehicleZ - %groundZ;
				if(%height <= 2.51)
				{
					%newpos = %vehicleX @ " " @ %vehicleY @ " " @ (%groundZ + 2.5);
					GameBase::setPosition(%vehicle,%newpos);
				}
			}	

			//-------------------
			// Set Rotation Stuff
			//-------------------
			// New Rotation
			%NewRot = %NewXRot@" "@%NewYRot@" "@%NewZRot;
			//GameBase::setRotation(%vehicle,%NewRot);
		
			schedule("landingGear("@%vehicle@","@%clientId@","@%NewZRot@","@%NewYRot@");",0.02, %vehicle);
		} else 	
		{
			schedule("landingGear("@%vehicle@","@%clientId@","@%changeZRot@","@%changeYRot@");",0.02, %vehicle);
			
		}

	} 
}

function Vehicle::onAdd(%this)
{
	%this.dead = false;
	%this.swap = "";
	%this.shieldStrength = 0.0;
	%name = Vehicle::getDataName(%this);
	echo("ADD: "@%this@" "@%name);
	GameBase::setRechargeRate(%this, 0);
	GameBase::setMapName (%this, "Vehicle");

	if (%name == Abrams || %name == Bradley || %name == Humvee || %name == LineBacker || %name == MLRS || %name == MineLayer) {
		if($Server::FuzzyPhysics)
			schedule("hugGround("@%this@");", 2, %this);
	}
	
	// 11 is the max hardpoints available for vehicles right now.
	for(%x=-1;%x<11;%x++)
	{
		$VehicleHPList[%this,%x] = "";
		$VehicleOwnedWeapon[%this,%x] = "";
	}
	
	$VehicleGuns[%this] = 0;
	$VehicleHP[%this] = 0;
	if(%name == Apache)
		$VehicleSWHP[%this] = 0; // Used only for apache.
	if($BombBay[%name] == 1)
		$VehicleBB[%this] = 0;
	
	if(%name == Hercules)
		%this.openSeats = 4;

	// B-52s have lots of electronic warfare devices, so we'll just make them have the ECM
	if(%name == Bomber)
		%this.ECM = true;

	$VehicleCurWeapon[%this] = 0;
	for(%i = 0; %i < $VehiclePrimaryGuns[%name]; %i++)
	{
		%weapName = $VehicleWeapon[%name, %i];
		if($VehicleWeaponAmmoMax[%name, %weapName] == -1)
		{

			$VehicleWeaponAmmo[%this, %weapName] = 1;
		} else
		{
			$VehicleWeaponAmmo[%this, %weapName] = $VehicleWeaponAmmoMax[%name, %weapName];
		}
		$VehicleOwnedWeapon[%this, %i] = %weapName;
		$VehicleGuns[%this]++;
	
	}
	$VehicleCanFire[%this] = True;
	$VehicleCounterMeasuresCur[%this] = $VehicleCounterMeasures[%name];
	$Smoking[%this] = 0;
	$Flamming[%this] = 0;
	$Plummeting[%this] = 0;

	Locking::AddToList(%this);

	Radar::Add(%this);
	Radar::Detectable::Add(%this);
	Radar::ActivateRadar(%this);
}

function LoadModule(%this, %object)
{

}


//Adds whitespace to the end of a message. The total message length returned will be equal to %number

function AddWhiteSpaceBefore(%message,%number)
{
	%num = 0;
	for(%x = 0; %x < 100; %x++)
	{
		if(string::getsubstr(%message,%x,1) == "")
		{
			%num = %x;			
			break;
		}
	}
	for(%x = %number - %num ;%x > 0 ; %x--)
	{
		%message = " "@ %message;
	
	}
	return %message;	
}


//Adds whitespace to the end of a message. The total message length returned will be equal to %number

function AddWhiteSpaceAfter(%message,%number)
{
	%num = 0;
	for(%x = 0; %x < 100; %x++)
	{
		if(string::getsubstr(%message,%x,1) == "")
		{
			%num = %x;			
			break;
		}
	}
	for(%x = %number - %num ;%x > 0 ; %x--)
	{
		%message = %message @ " ";
	
	}
	return %message;	
}

function CheckHardpoints(%client)
{
	%vehicle = client::getcontrolobject(%client);
	%name = Vehicle::getDataName(%vehicle);
	echo(%Vehicle);
	echo(%name);
	%buff = "";
	for(%i = 0; %i < $VehiclePrimaryGuns[%name]; %i++)
		%buff = %buff @ $VehicleWeapon[%name,%i] @ " ";
	echo("Primary: " @%buff);
	%cur = 0;
	if($vehicleMaxHardPoints[%name]%2 == 0)
		echo(AddWhiteSpaceBefore($VehicleHPList[%vehicle,%cur]@AddWhiteSpaceBefore($VehicleHPList[%vehicle,%cur++],14),52));
	else
		echo(AddWhiteSpaceBefore($VehicleHPList[%vehicle,%cur],52));

	echo(AddWhiteSpaceBefore($VehicleHPList[%vehicle,%cur++]@AddWhiteSpaceBefore($VehicleHPList[%vehicle,%cur++],30),60));
	echo(AddWhiteSpaceBefore($VehicleHPList[%vehicle,%cur++]@AddWhiteSpaceBefore($VehicleHPList[%vehicle,%cur++],46),70));
	echo(AddWhiteSpaceBefore($VehicleHPList[%vehicle,%cur++]@AddWhiteSpaceBefore($VehicleHPList[%vehicle,%cur++],30),60));
	echo(AddWhiteSpaceBefore($VehicleHPList[%vehicle,%cur++]@AddWhiteSpaceBefore($VehicleHPList[%vehicle,%cur++],30),60));
	echo(AddWhiteSpaceBefore($VehicleHPList[%vehicle,%cur++]@AddWhiteSpaceBefore($VehicleHPList[%vehicle,%cur++],30),60));

	%cur = 0;
	if($vehicleMaxHardPoints[%name]%2 == 0)
		echo(AddWhiteSpaceBefore($VehicleHPAmmoLeft[%vehicle,%cur]@AddWhiteSpaceBefore($VehicleHPAmmoLeft[%vehicle,%cur++],14),52));
	else
		echo(AddWhiteSpaceBefore($VehicleHPAmmoLeft[%vehicle,%cur],52));

	echo(AddWhiteSpaceBefore($VehicleHPAmmoLeft[%vehicle,%cur++]@AddWhiteSpaceBefore($VehicleHPAmmoLeft[%vehicle,%cur++],30),60));
	echo(AddWhiteSpaceBefore($VehicleHPAmmoLeft[%vehicle,%cur++]@AddWhiteSpaceBefore($VehicleHPAmmoLeft[%vehicle,%cur++],46),68));
	echo(AddWhiteSpaceBefore($VehicleHPAmmoLeft[%vehicle,%cur++]@AddWhiteSpaceBefore($VehicleHPAmmoLeft[%vehicle,%cur++],30),60));
	echo(AddWhiteSpaceBefore($VehicleHPAmmoLeft[%vehicle,%cur++]@AddWhiteSpaceBefore($VehicleHPAmmoLeft[%vehicle,%cur++],30),60));
	echo(AddWhiteSpaceBefore($VehicleHPAmmoLeft[%vehicle,%cur++]@AddWhiteSpaceBefore($VehicleHPAmmoLeft[%vehicle,%cur++],30),60));
}

//====================================================================
//:::::::::::::::::::::Vehicle::OnCollision:::::::::::::::::::::::::::
//:::::::::::::::::::::REWRITTEN ON 3/22/02:::::::::::::::::::::::::::
//====================================================================


function Vehicle::onCollision (%this, %object)
{
	// Preventative measure to curtail any possible crash bugs that may result..
	// If a vehicle is crashing, there's no reason to allow them to do anything 
	// with it besides allow it to die.
	if(Vehicle::isCrashVehicle(%this))
	{
		return;
	}


//======================================Variables==========================================

	%client = Player::getClient(%object);
	%objType = getObjectType(%object);
	%armor = Player::getArmor(%object);
	%vname = Vehicle::getDataName(%this);
	%module = $Vmodule[%this.module];
	%NextAvailableHP = 0;

//======================================BooleanChecks======================================
	
	%isPlayer = %objType == "Player";
	%isEngineer = %armor == "earmor" || %armor == "efemale" || %armor == "earmor2" || %armor == "efemale2" || %armor == "earmor3" || %armor == "efemale3";
	%isArtillery = %armor == "aarmor" || %armor == "afemale" || %armor == "aarmor2" || %armor == "afemale2" || %armor == "aarmor3" || %armor == "afemale3"|| %armor == "comarmor" || %armor == "comfemale" || %armor == "comarmor2" || %armor == "comfemale2" || %armor == "comarmor3" || %armor == "comfemale3" ;
	%isPilot = %armor == "larmor" || %armor == "lfemale" || %armor == "larmor2" || %armor == "lfemale2" || %armor == "larmor3" || %armor == "lfemale3"|| %armor == "comarmor" || %armor == "comfemale" || %armor == "comarmor2" || %armor == "comfemale2" || %armor == "comarmor3" || %armor == "comfemale3" ;
	%isOnePersonCraft = Vehicle::isOnePersonCraft(%this);
	%isJet = Vehicle::isJet(%this);
	%isTank = Vehicle::isTank(%this);
	%isAirStrikeVehicle = %this.isAirstrikeVehicle;
	%hasPilotWeapon = Vehicle::hasPilotWeapon(%this);
	%canLoad = %isPlayer && %isEngineer;


	// Prevents pilots from getting in a vehicle, but not being able to control it.
	// Using this method, they could also get multiple pilots in a vehicle, or more than the max passengers in a passenger vehicle.
	if(%client.observerMode == "commander")
	{
		return;
	}

//======================================TOWHandling========================================

	
	if(%vname == TOWMissile)
	{
		Vehicle::onDismount(%this, "0 0 0");
		return;
	}

//======================================Airstrike Kill==============================================

	if(%isAirStrikeVehicle)
	{
		return;

	}


//======================================ModuleLoading======================================

	if(%canLoad)
	{

		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Loading Falcon

		if (%vname == "Falcon")
		{
			if (Player::getItemCount(%object, SideWinderModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[1])))
			{
				Client::sendMessage(%client,0,"SideWinder Missile Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,SideWinderModule, 0);
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[1];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == SidewinderRocket){
						%weaponFound = %i;	
					}	

				}
				%NotDone = $VmoduleHP[1];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = SidewinderRocket;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				}else{
					%weapName = SidewinderRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
				}
				
				return;
			}
			else if (Player::getItemCount(%object, MaverickModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[4])))
			{
				Client::sendMessage(%client,0,"Maverick Missile Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,MaverickModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[4];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == MavRocket){
						%weaponFound = %i;	
					}			

				}
				%NotDone = $VmoduleHP[4];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = MavRocket;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = MavRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, HARMModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[5])))
			{
				Client::sendMessage(%client,0,"HARM Missile Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,HARMModule, 0);	
			
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[5];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == HARMRocket){
						%weaponFound = %i;	
					}
			
				}
				%NotDone = $VmoduleHP[5];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = HARMRocket;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = HARMRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
				
				}
				
				return;
			}
			else if (Player::getItemCount(%object, Mk82Module) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[6])))
			{
				Client::sendMessage(%client,0,"Mk82 Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,Mk82Module, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[6];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BigBomb){
						%weaponFound = %i;	
					}	
	
				}
				%NotDone = $VmoduleHP[6];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = BigBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = BigBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}		
			else if (Player::getItemCount(%object, Mk84Module) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[7])))
			{
				Client::sendMessage(%client,0,"Mk84 Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,Mk84Module, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[7];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BombShell){
						%weaponFound = %i;	
					}	

				}
				%NotDone = $VmoduleHP[7];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = BombShell;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = BombShell;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, APClusterModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[8])))
			{
				Client::sendMessage(%client,0,"APAM Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,APClusterModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[8];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == APClusterBomb){
						%weaponFound = %i;	
					}		

				}
				%NotDone = $VmoduleHP[8];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = APClusterBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = APClusterBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, MineClusterModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[9])))
			{
				Client::sendMessage(%client,0,"Gater Mine Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client, MineClusterModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[9];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == MineClusterBomb){
						%weaponFound = %i;	
					}	
	
				}
				%NotDone = $VmoduleHP[9];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = MineClusterBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = MineClusterBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, BombletClusterModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[10])))
			{
				Client::sendMessage(%client,0,"Cluster Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,BombletClusterModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[10];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BombletClusterBomb){
						%weaponFound = %i;	
					}
	
				}
				%NotDone = $VmoduleHP[10];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = BombletClusterBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = BombletClusterBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, BunkerBusterModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[11])))
			{
				Client::sendMessage(%client,0,"Penetrator Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,BunkerBusterModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[11];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BunkerBusterBomb){
						%weaponFound = %i;	
					}		

				}
				%NotDone = $VmoduleHP[11];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = BunkerBusterBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = BunkerBusterBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, TankSmokeModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[12])))
			{
				Client::sendMessage(%client,0,"Smoke Tank Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,TankSmokeModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[12];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == TankSmoke){
						%weaponFound = %i;	
					}		

				}
				%NotDone = $VmoduleHP[12];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = TankSmoke;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 50;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]= $VehicleWeaponAmmo[%this, %weapName] + 50;
				
				}else{
					%weapName = TankSmoke;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 50;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, TankNerveGasModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[13])))
			{
				Client::sendMessage(%client,0,"Nerve Gas Tank Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,TankNerveGasModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[13];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == TankNerveGas){
						%weaponFound = %i;	
					}		
	
				}
				%NotDone = $VmoduleHP[13];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = TankNerveGas;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 50;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]= $VehicleWeaponAmmo[%this, %weapName] + 50;
				
				}else{
					%weapName = TankNerveGas;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 50;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}		
			else if (Player::getItemCount(%object, IncendiaryNapamModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[14])))
			{
				Client::sendMessage(%client,0,"Napalm Fire Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,IncendiaryNapamModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[14];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == NapalmBomb){
						%weaponFound = %i;	
					}

				}
				%NotDone = $VmoduleHP[14];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = NapalmBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = NapalmBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, EMCModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[16])))
			{
				
				
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == EMCContainer){
						%weaponFound = %i;	
					}		

				}
				if(%weaponFound != -1){
					Client::SendMessage(%client,0,"Erm, two EMCs are not gonna help you. So lets not bother.");
				}else{
					%NotDone = $VmoduleHP[16];
					for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
					{
						if($VehicleHPList[%this,%i] == "") {
							$VehicleHPList[%this,%i] = EMCContainer;
							%NotDone--;
							$VehicleHPAmmoLeft[%this,%i] = 1;
						}
					}
					Client::sendMessage(%client,0,"EMC Pod Loaded.");
					playSound(SoundDryFire,GameBase::getPosition(%this));
					Player::setItemCount(%client,EMCModule, 0);	
					$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[16];
					Player::setSensorSupression(%this,20);
					%weapName = EMCContainer;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					%this.ECM = true;
				}
				
				return;
			}
		}

		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Loading Tomcat

		else if (%vname == "Tomcat")
		{
			if (Player::getItemCount(%object, SideWinderModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[1])))
			{
				Client::sendMessage(%client,0,"SideWinder Missile Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,SideWinderModule, 0);
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[1];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == SidewinderRocket){
						%weaponFound = %i;	
					}		

				}
				%NotDone = $VmoduleHP[1];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = SidewinderRocket;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = SidewinderRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, PhoenixModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[2])))
			{
				Client::sendMessage(%client,0,"Phoenix Missile Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,PhoenixModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[2];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == PhoenixRocket){
						%weaponFound = %i;	
					}
	
				}
				%NotDone = $VmoduleHP[2];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = PhoenixRocket;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName] = $VehicleWeaponAmmo[%this, %weapName] + 1;
				
				}else{
					%weapName = PhoenixRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, Mk82Module) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[6])))
			{
				Client::sendMessage(%client,0,"Mk82 Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,Mk82Module, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[6];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BigBomb){
						%weaponFound = %i;	
					}		
	
				}
				%NotDone = $VmoduleHP[6];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = BigBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = BigBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}		
			else if (Player::getItemCount(%object, Mk84Module) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[7])))
			{
				Client::sendMessage(%client,0,"Mk84 Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,Mk84Module, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[7];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BombShell){
						%weaponFound = %i;	
					}	

				}
				%NotDone = $VmoduleHP[7];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = BombShell;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = BombShell;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, BombletClusterModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[10])))
			{
				Client::sendMessage(%client,0,"Cluster Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,BombletClusterModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[10];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BombletClusterBomb){
						%weaponFound = %i;	
					}	
	
				}
				%NotDone = $VmoduleHP[10];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = BombletClusterBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = BombletClusterBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, EMCModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[16])))
			{
				
				
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == EMCContainer){
						%weaponFound = %i;	
					}	
	
				}
				if(%weaponFound != -1){
					Client::SendMessage(%client,0,"Erm, two EMCs are not gonna help you. So lets not bother.");
				}else{
					%NotDone = $VmoduleHP[16];
					for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
					{
						if($VehicleHPList[%this,%i] == "") {
							$VehicleHPList[%this,%i] = EMCContainer;
							%NotDone--;
							$VehicleHPAmmoLeft[%this,%i] = 1;
						}
					}
					Client::sendMessage(%client,0,"EMC Pod Loaded.");
					playSound(SoundDryFire,GameBase::getPosition(%this));
					Player::setItemCount(%client,EMCModule, 0);	
					$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[16];
					Player::setSensorSupression(%this,20);
					%weapName = EMCContainer;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					%this.ECM = true;
				}
				
				return;
			}
		}	
	
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Loading Warthog		

		else if (%vname == "Warthog")
		{
			if (Player::getItemCount(%object, SideWinderModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[1])))
			{
				Client::sendMessage(%client,0,"SideWinder Missile Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,SideWinderModule, 0);
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[1];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == SidewinderRocket){
						%weaponFound = %i;	
					}
	
				}
				%NotDone = $VmoduleHP[1];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = SidewinderRocket;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = SidewinderRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, HellfireModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[3])))
			{
				Client::sendMessage(%client,0,"Hellfire Missile Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,HellfireModule, 0);
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[3];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == ApacheRocket){
						%weaponFound = %i;	
					}
	
				}
				%NotDone = $VmoduleHP[3];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = ApacheRocket;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 4;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName] = $VehicleWeaponAmmo[%this, %weapName] + 4;
				
				}else{
					%weapName = ApacheRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 4;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, HydraModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[21])))
			{
				Client::sendMessage(%client,0,"Hydra Rockets Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,HydraModule, 0);
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[21];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == HydraRocket){
						%weaponFound = %i;	
					}
	
				}
				%NotDone = $VmoduleHP[21];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = HydraRocket;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 19;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName] = $VehicleWeaponAmmo[%this, %weapName] + 19;
				
				}else{
					%weapName = HydraRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 19;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, MaverickModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[4])))
			{
				Client::sendMessage(%client,0,"Maverick Missile Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,MaverickModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[4];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == MavRocket){
						%weaponFound = %i;	
					}			

				}
				%NotDone = $VmoduleHP[4];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = MavRocket;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = MavRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, Mk82Module) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[6])))
			{
				Client::sendMessage(%client,0,"Mk82 Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,Mk82Module, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[6];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BigBomb){
						%weaponFound = %i;	
					}		

				}	
				%NotDone = $VmoduleHP[6];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = BigBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = BigBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}		
			else if (Player::getItemCount(%object, Mk84Module) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[7])))
			{
				Client::sendMessage(%client,0,"Mk84 Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,Mk84Module, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[7];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BombShell){
						%weaponFound = %i;	
					}			

				}
				%NotDone = $VmoduleHP[7];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = BombShell;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = BombShell;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, APClusterModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[8])))
			{
				Client::sendMessage(%client,0,"APAM Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,APClusterModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[8];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == APClusterBomb){
						%weaponFound = %i;	
					}		

				}
				%NotDone = $VmoduleHP[8];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = APClusterBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = APClusterBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, MineClusterModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[9])))
			{
				Client::sendMessage(%client,0,"Gater Mine Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client, MineClusterModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[9];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == MineClusterBomb){
						%weaponFound = %i;	
					}		

				}
				%NotDone = $VmoduleHP[9];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = MineClusterBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = MineClusterBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, BombletClusterModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[10])))	
			{
				Client::sendMessage(%client,0,"Cluster Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,BombletClusterModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[10];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BombletClusterBomb){
						%weaponFound = %i;	
					}			

				}
				%NotDone = $VmoduleHP[10];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = BombletClusterBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = BombletClusterBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, BunkerBusterModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[11])))
			{
				Client::sendMessage(%client,0,"Penetrator Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,BunkerBusterModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[11];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BunkerBusterBomb){
						%weaponFound = %i;	
					}

				}
				%NotDone = $VmoduleHP[11];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = BunkerBusterBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = BunkerBusterBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, TankSmokeModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[12])))
			{
				Client::sendMessage(%client,0,"Smoke Tank Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,TankSmokeModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[12];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == TankSmoke){
						%weaponFound = %i;	
					}		

				}
				%NotDone = $VmoduleHP[12];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = TankSmoke;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 50;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]= $VehicleWeaponAmmo[%this, %weapName] + 50;
				
				}else{
					%weapName = TankSmoke;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 50;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, TankNerveGasModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[13])))
			{
				Client::sendMessage(%client,0,"Nerve Gas Tank Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,TankNerveGasModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[13];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == TankNerveGas){
						%weaponFound = %i;	
					}		
	
				}
				%NotDone = $VmoduleHP[13];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = TankNerveGas;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 50;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]= $VehicleWeaponAmmo[%this, %weapName] + 50;
				
				}else{
					%weapName = TankNerveGas;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 50;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}		
			else if (Player::getItemCount(%object, IncendiaryNapamModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[14])))
			{
				Client::sendMessage(%client,0,"Napalm Fire Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,IncendiaryNapamModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[14];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == NapalmBomb){
						%weaponFound = %i;	
					}		

				}
				%NotDone = $VmoduleHP[14];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = NapalmBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = NapalmBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, EMCModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[16])))
			{
				
				
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == EMCContainer){
						%weaponFound = %i;	
					}		
	
				}
				if(%weaponFound != -1){
					Client::SendMessage(%client,0,"Erm, two EMCs are not gonna help you. So lets not bother.");
				}else{
					%NotDone = $VmoduleHP[16];
					for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
					{
						if($VehicleHPList[%this,%i] == "") {
							$VehicleHPList[%this,%i] = EMCContainer;
							%NotDone--;
							$VehicleHPAmmoLeft[%this,%i] = 1;
						}
					}
					Client::sendMessage(%client,0,"EMC Pod Loaded.");
					playSound(SoundDryFire,GameBase::getPosition(%this));
					Player::setItemCount(%client,EMCModule, 0);	
					$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[16];
					Player::setSensorSupression(%this,20);
					%weapName = EMCContainer;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					%this.ECM = true;
				}
				
				return;
			}
		}
		
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Loading Hind		

		else if (%vname == "Hind")
		{

			if (Player::getItemCount(%object, SideWinderModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[1])))
			{
				Client::sendMessage(%client,0,"SideWinder Missile Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,SideWinderModule, 0);
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[1];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == SidewinderRocket){
						%weaponFound = %i;	
					}
	
				}
				%NotDone = $VmoduleHP[1];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = SidewinderRocket;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = SidewinderRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, HellfireModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[3])))
			{
				Client::sendMessage(%client,0,"Hellfire Missile Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,HellfireModule, 0);
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[3];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == ApacheRocket){
						%weaponFound = %i;	
					}
	
				}
				%NotDone = $VmoduleHP[3];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = ApacheRocket;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 4;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName] = $VehicleWeaponAmmo[%this, %weapName] + 4;
				
				}else{
					%weapName = ApacheRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 4;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, UPKGunPodModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[22])))
			{
				Client::sendMessage(%client,0,"UPK Gun Pod Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,UPKGunPodModule, 0);
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[22];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == TwentyFivemmBullet){
						%weaponFound = %i;	
					}
	
				}
				%NotDone = $VmoduleHP[22];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = TwentyFivemmBullet;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 250;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName] = $VehicleWeaponAmmo[%this, %weapName] + 250;
				
				}else{
					%weapName = TwentyFivemmBullet;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 250;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, GUVGunPodModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[23])))
			{
				Client::sendMessage(%client,0,"GUV Gun Pod Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,GUVGunPodModule, 0);
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[23];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == SAWBullet){
						%weaponFound = %i;	
					}
	
				}
				%NotDone = $VmoduleHP[23];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = SAWBullet;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 750;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName] = $VehicleWeaponAmmo[%this, %weapName] + 750;
				
				}else{
					%weapName = SAWBullet;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 750;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, Mk82Module) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[6])))
			{
				Client::sendMessage(%client,0,"Mk82 Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,Mk82Module, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[6];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BigBomb){
						%weaponFound = %i;	
					}			

				}
				%NotDone = $VmoduleHP[6];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = BigBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = BigBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}		
			else if (Player::getItemCount(%object, APClusterModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[8])))
			{
				Client::sendMessage(%client,0,"APAM Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,APClusterModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[8];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == APClusterBomb){
						%weaponFound = %i;	
					}		

				}
				%NotDone = $VmoduleHP[8];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = APClusterBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = APClusterBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, MineClusterModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[9])))
			{
				Client::sendMessage(%client,0,"Gater Mine Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client, MineClusterModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[9];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == MineClusterBomb){
						%weaponFound = %i;	
					}		

				}
				%NotDone = $VmoduleHP[9];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = MineClusterBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = MineClusterBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, BombletClusterModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[10])))
			{
				Client::sendMessage(%client,0,"Cluster Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,BombletClusterModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[10];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BombletClusterBomb){
						%weaponFound = %i;	
					}		

				}
				%NotDone = $VmoduleHP[10];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = BombletClusterBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = BombletClusterBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, BunkerBusterModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[11])))
			{
				Client::sendMessage(%client,0,"Penetrator Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,BunkerBusterModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[11];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BunkerBusterBomb){
						%weaponFound = %i;	
					}
	
				}
				%NotDone = $VmoduleHP[11];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = BunkerBusterBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = BunkerBusterBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, TankSmokeModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[12])))
			{
				Client::sendMessage(%client,0,"Smoke Tank Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,TankSmokeModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[12];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == TankSmoke){
						%weaponFound = %i;	
					}	
	
				}
				%NotDone = $VmoduleHP[12];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = TankSmoke;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 50;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]= $VehicleWeaponAmmo[%this, %weapName] + 50;
				
				}else{
					%weapName = TankSmoke;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 50;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, TankNerveGasModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[13])))
			{
				Client::sendMessage(%client,0,"Nerve Gas Tank Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,TankNerveGasModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[13];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == TankNerveGas){
						%weaponFound = %i;	
					}		
	
				}
				%NotDone = $VmoduleHP[13];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = TankNerveGas;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 50;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]= $VehicleWeaponAmmo[%this, %weapName] + 50;
				
				}else{
					%weapName = TankNerveGas;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 50;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}		
			else if (Player::getItemCount(%object, IncendiaryNapamModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[14])))
			{
				Client::sendMessage(%client,0,"Napalm Fire Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,IncendiaryNapamModule, 0);	
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[14];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == NapalmBomb){
						%weaponFound = %i;	
					}			

				}
				%NotDone = $VmoduleHP[14];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = NapalmBomb;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = NapalmBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, EMCModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[16])))
			{
				
				
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == EMCContainer){
						%weaponFound = %i;	
					}
	
				}
				if(%weaponFound != -1){
					Client::SendMessage(%client,0,"Erm, two EMCs are not gonna help you. So lets not bother.");
				}else{
					%NotDone = $VmoduleHP[16];
					for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
					{
						if($VehicleHPList[%this,%i] == "") {
							$VehicleHPList[%this,%i] = EMCContainer;
							%NotDone--;
							$VehicleHPAmmoLeft[%this,%i] = 1;
						}
					}
					Client::sendMessage(%client,0,"EMC Pod Loaded.");
					playSound(SoundDryFire,GameBase::getPosition(%this));
					Player::setItemCount(%client,EMCModule, 0);	
					$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[16];
					Player::setSensorSupression(%this,20);
					%weapName = EMCContainer;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					%this.ECM = true;
				}
				
				return;
			}
		}	
	
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Loading Apache				

		else if (%vname == "Apache")
		{
			//Only 2 slots for sidewinders on apache!
//			if (Player::getItemCount(%object, SideWinderModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[1])))
			if (Player::getItemCount(%object, SideWinderModule) && (2 >= ($VehicleSWHP[%this] + $VmoduleHP[1])))
			{
				Client::sendMessage(%client,0,"SideWinder Missile Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,SideWinderModule, 0);
				
				$VehicleSWHP[%this] = $VehicleSWHP[%this] + $VmoduleHP[1];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == SidewinderRocket){
						%weaponFound = %i;	
					}
	
				}
				if($VehicleHPList[%this,4] == "") {
					$VehicleHPList[%this,4] = SidewinderRocket;
					$VehicleHPAmmoLeft[%this,4] = 1;
				} else {
					$VehicleHPList[%this,5] = SidewinderRocket;
					$VehicleHPAmmoLeft[%this,5] = 1;
				}

				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = SidewinderRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, HellfireModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[3])))
			{
				Client::sendMessage(%client,0,"Hellfire Rockets Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,HellfireModule, 0);
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[3];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == ApacheRocket){
						%weaponFound = %i;	
					}
	
				}
				%NotDone = $VmoduleHP[3];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = ApacheRocket;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 4;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName] = $VehicleWeaponAmmo[%this, %weapName] + 4;
				
				}else{
					%weapName = ApacheRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 4;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, HydraModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[21])))
			{
				Client::sendMessage(%client,0,"Hydra Rockets Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,HydraModule, 0);
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[21];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == HydraRocket){
						%weaponFound = %i;	
					}
	
				}
				%NotDone = $VmoduleHP[21];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = HydraRocket;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 19;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName] = $VehicleWeaponAmmo[%this, %weapName] + 19;
				
				}else{
					%weapName = HydraRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 19;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, EMCModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[16])))
			{
				
				
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == EMCContainer){
						%weaponFound = %i;	
					}
	
				}
				if(%weaponFound != -1){
					Client::SendMessage(%client,0,"Erm, two EMCs are not gonna help you. So lets not bother.");
				}else{
					%NotDone = $VmoduleHP[16];
					for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
					{
						if($VehicleHPList[%this,%i] == "") {
							$VehicleHPList[%this,%i] = EMCContainer;
							%NotDone--;
							$VehicleHPAmmoLeft[%this,%i] = 1;
						}
					}
					Client::sendMessage(%client,0,"EMC Pod Loaded.");
					playSound(SoundDryFire,GameBase::getPosition(%this));
					Player::setItemCount(%client,EMCModule, 0);	
					$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[16];
					Player::setSensorSupression(%this,20);
					%weapName = EMCContainer;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					%this.ECM = true;
				}
				
				return;
			}
		}	
	
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Loading Kiowa				

		else if (%vname == "Kiowa")
		{
			if (Player::getItemCount(%object, SideWinderModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[1])))
			{
				Client::sendMessage(%client,0,"SideWinder Missile Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,SideWinderModule, 0);
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[1];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == SidewinderRocket){
						%weaponFound = %i;	
					}
	
				}
				%NotDone = $VmoduleHP[1];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = SidewinderRocket;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 1;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = SidewinderRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, HellfireModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[3])))
			{
				Client::sendMessage(%client,0,"Hellfire Rockets Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,HellfireModule, 0);
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[3];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == ApacheRocket){
						%weaponFound = %i;	
					}
	
				}
				%NotDone = $VmoduleHP[3];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = ApacheRocket;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 4;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName] = $VehicleWeaponAmmo[%this, %weapName] + 4;
				
				}else{
					%weapName = ApacheRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 4;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, HydraModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[21])))
			{
				Client::sendMessage(%client,0,"Hydra Rockets Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,HydraModule, 0);
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[21];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == HydraRocket){
						%weaponFound = %i;	
					}
	
				}
				%NotDone = $VmoduleHP[21];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = HydraRocket;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 19;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName] = $VehicleWeaponAmmo[%this, %weapName] + 19;
				
				}else{
					%weapName = HydraRocket;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 19;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, FiftyCalModule) && ($VehicleMaxHardPoints[%vname] >= ($VehicleHP[%this] + $VmoduleHP[24])))
			{
				Client::sendMessage(%client,0,"M296 Gun Pod Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,FiftyCalModule, 0);
				
				$VehicleHP[%this] = $VehicleHP[%this] + $VmoduleHP[24];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == FiftyCalPodBullet){
						%weaponFound = %i;	
					}
	
				}
				%NotDone = $VmoduleHP[24];
				for(%i = 0; %i < $vehicleMaxHardPoints[%vname] && %NotDone;%i++)
				{
					if($VehicleHPList[%this,%i] == "") {
						$VehicleHPList[%this,%i] = FiftyCalPodBullet;
						%NotDone--;
						$VehicleHPAmmoLeft[%this,%i] = 500;
					}
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName] = $VehicleWeaponAmmo[%this, %weapName] + 500;
				
				}else{
					%weapName = FiftyCalPodBullet;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 500;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					$VehicleWeapToFire[%this,%weapname] = -1;
					
				}
				
				return;
			}
		}	
	
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Loading Bomber

		else if (%vname == "Bomber")
		{
			if (Player::getItemCount(%object, Mk82Module) && ($BombBayMax[%vname] >= ($VehicleBB[%this] + $VmoduleBB[6])))
			{
				Client::sendMessage(%client,0,"Mk82 Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,Mk82Module, 0);	
				
				$VehicleBB[%this] = $VehicleBB[%this] + $VmoduleBB[6];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BigBomb){
						%weaponFound = %i;	
					}	
	
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = BigBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					
				}
				
				return;
			}		
			else if (Player::getItemCount(%object, Mk84Module) && ($BombBayMax[%vname] >= ($VehicleBB[%this] + $VmoduleBB[7])))
			{
				Client::sendMessage(%client,0,"Mk84 Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,Mk84Module, 0);	
				
				$VehicleBB[%this] = $VehicleBB[%this] + $VmoduleBB[7];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BombShell){
						%weaponFound = %i;	
					}		

				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = BombShell;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					
				}
			
				return;
			}
			else if (Player::getItemCount(%object, Mk82PackageModule) && ($BombBayMax[%vname] >= ($VehicleBB[%this] + $VmoduleBB[17])))
			{
				Client::sendMessage(%client,0,"Mk82 Bombs Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,Mk82PackageModule, 0);	
				
				$VehicleBB[%this] = $VehicleBB[%this] + $VmoduleBB[17];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BigBomb){
						%weaponFound = %i;	
					}

				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]= $VehicleWeaponAmmo[%this, %weapName] + 4;
				
				}else{
					%weapName = BigBomb;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 4;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, Mk84PackageModule) && ($BombBayMax[%vname] >= ($VehicleBB[%this] + $VmoduleBB[18])))
			{
				Client::sendMessage(%client,0,"Mk84 Bombs Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,Mk84PackageModule, 0);	
				
				$VehicleBB[%this] = $VehicleBB[%this] + $VmoduleBB[18];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == BombShell){
						%weaponFound = %i;	
					}		

				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]= $VehicleWeaponAmmo[%this, %weapName] + 2;
				
				}else{
					%weapName = BombShell;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 2;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					
				}
				
				return;
			}
			else if (Player::getItemCount(%object, NuclearModule) && ($BombBayMax[%vname] >= ($VehicleBB[%this] + $VmoduleBB[15])))
			{
				Client::sendMessage(%client,0,"Hydrogen Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,NuclearModule, 0);	
				
				$VehicleBB[%this] = $VehicleBB[%this] + $VmoduleBB[15];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == NukeShell){
						%weaponFound = %i;	
					}	
	
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = NukeShell;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					
				}
			
				return;
			}		
			
		}

		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Loading Hercules

		else if (%vname == "Hercules")
		{
			if (Player::getItemCount(%object, DaisyCutterModule) && ($BombBayMax[%vname] >= ($VehicleBB[%this] + $VmoduleBB[19])) && %this.openSeats > 0)
			{
				Client::sendMessage(%client,0,"Daisy Cutter Bomb Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,DaisyCutterModule, 0);	
				
				$VehicleBB[%this] = $VehicleBB[%this] + $VmoduleBB[19];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == DaisyShell){
						%weaponFound = %i;	
					}	
	
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = DaisyShell;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					
				}
				%this.openSeats--;
				return;
			}
			else if (Player::getItemCount(%object, SupplyCrateModule) && ($BombBayMax[%vname] >= ($VehicleBB[%this] + $VmoduleBB[20])) && %this.openSeats > 0)
			{
				Client::sendMessage(%client,0,"Supply Crate Loaded.");
				playSound(SoundDryFire,GameBase::getPosition(%this));
				Player::setItemCount(%client,SupplyCrateModule, 0);	
				
				$VehicleBB[%this] = $VehicleBB[%this] + $VmoduleBB[20];
				%weaponFound = -1;
				for(%i = 0; %i < $VehicleGuns[%this] && %weaponFound == -1; %i++)
				{
					if($VehicleOwnedWeapon[%this, %i] == SupplyDrop){
						%weaponFound = %i;	
					}	
	
				}
				if(%weaponFound != -1){
					%weapName = $VehicleOwnedWeapon[%this, %weaponFound];
					$VehicleWeaponAmmo[%this, %weapName]++;
				
				}else{
					%weapName = SupplyDrop;
					$VehicleOwnedWeapon[%this, $VehicleGuns[%this]] = %weapName;
					$VehicleWeaponAmmo[%this, %weapName] = 1;
					$VehicleGuns[%this] = $VehicleGuns[%this] + 1;
					
				}
				%this.openSeats--;
				return;
			}		
		}
	}

//======================================DamageCheck========================================

	if(GameBase::getDamageLevel(%this) > (Vehicle::getDataName(%this)).maxDamage || %this.dead)
	{
		return;
	}
	
//======================================PlayerCheck========================================

	// if we're not a player or we already are in a vehicle.
	if(!%isPlayer || %object.vehicle != "") 
		return;
	
//======================================RemountDelayCheck==================================

	if(getSimTime() <= %object.newMountTime && %object.lastMount == %this)
		return;

//======================================FadingCheck========================================
	if(%this.fading != "")
		return;

//======================================AICheck============================================
		
//	if(Player::isAiControlled(%object))
//        	return;
               

//======================================OnePersonCraft=====================================
	if(%isOnePersonCraft)
	{
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Is Pilot?
		if(!%isPilot)
		{
			Client::sendMessage(%client,0,"You must be a pilot to control the vehicles.~wError_Message.wav");
			return;
		}
				
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Is Piloted?
		if(GameBase::getControlClient(%this) != -1)
		{
			Client::sendMessage(%client,0,"This Vehicle is already occupied.~wError_Message.wav");
			return;
		}	

		if(!Vehicle::canMount(%this, %object))
		{
			Client::sendMessage(%client,0,"This Vehicle is already occupied.~wError_Message.wav");
			return;
		}


		//*************************************************************** Yay! Give our client the boat!

		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Remember the client's weapon
		%weapon = Player::getMountedItem(%object,$WeaponSlot);
		if(%weapon != -1) {
			%object.lastWeapon = %weapon;
			Player::unMountItem(%object,$WeaponSlot);
		}

		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Set our client in control
		Player::setMountObject(%object, %this, 1);
		Client::setControlObject(%client, %this);
		%object.driver = 1;
        	%object.vehicle = %this;
		%this.clLastMount = %client;
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Tell the client that they're flying a vehicle, and to activate jets.
		remoteEval(%client,ActivateJets);
	
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Play fun mounting sound!
		playSound (Vehicle::getDataName(%this).mountSound, GameBase::getPosition(%this));
		
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ EMC?
		if(%this.ECM == true)
			Player::setSensorSupression(%client,20);
		
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Donno what or why but... what will it hurt...
		$SFdrivingAPC[%client] = 1;


		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If were a jet, give it landing gear
		if (%isJet) 
		{
			%tRot = GameBase::getRotation(%this);
			landingGear(%this, %client, getWord(%tRot, 2), getWord(%tRot, 1));
		}

		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If were a tank, and we got our REAL tank code on, stick it to the ground (If were a jet, we cant be a tank so why bother checking?)
		else if(%isTank && !$Server::FuzzyPhysics)
		{
			%tRot = GameBase::getRotation(%this);
			vehicleHover(%this, %client, getWord(%tRot, 2), getWord(%tRot, 1));
		}
		
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If our vehicle has a pilot weapon, hand it over.
		if(%hasPilotWeapon)
		{
			%weapName = $VehicleWeapon[%vName, $VehicleCurWeapon[%this]];
			%newEner = $VehicleWeaponAmmo[%this, %weapName] / $VehicleWeaponAmmoMax[%vName, %weapName] * 100;
			GameBase::setEnergy(%this, %newEner);
		}
		
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If we got here, just break out for safty reasons.
		return;
	}

//======================================NotAOnePersonCraft=================================

	else if(!%isOnePersonCraft)
	{
	
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Is Pilot?
		if(%isPilot && GameBase::getControlClient(%this) == -1 && Vehicle::canMount(%this, %object))
		{
			//*************************************************************** Yay! Give our client the boat!

			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Remember the client's weapon
			%weapon = Player::getMountedItem(%object,$WeaponSlot);
			if(%weapon != -1) {
				%object.lastWeapon = %weapon;
				Player::unMountItem(%object,$WeaponSlot);
			}		

			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Set our client in control
			Player::setMountObject(%object, %this, 1);
			Client::setControlObject(%client, %this);
			%object.driver = 1;
       		 	%object.vehicle = %this;
			%this.clLastMount = %client;
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Tell the client that they're flying a vehicle, and to activate jets.
			remoteEval(%client,ActivateJets);
	
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Play fun mounting sound!
			playSound (Vehicle::getDataName(%this).mountSound, GameBase::getPosition(%this));
			
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ EMC?
			if(%this.ECM == true)
				Player::setSensorSupression(%client,20);
		
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Donno what or why but... what will it hurt...
			$SFdrivingAPC[%client] = 1;

			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If were a jet, give it landing gear
			if (%isJet) 
			{
				%tRot = GameBase::getRotation(%this);
				landingGear(%this, %client, getWord(%tRot, 2), getWord(%tRot, 1));
			}

			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If were a tank, and we got our REAL tank code on, stick it to the ground (If were a jet, we cant be a tank so why bother checking?)
			else if(%isTank && !$Server::FuzzyPhysics)
			{
				%tRot = GameBase::getRotation(%this);
				vehicleHover(%this, %client, getWord(%tRot, 2), getWord(%tRot, 1));
			}
		
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If our vehicle has a pilot weapon, hand it over.
			if(%hasPilotWeapon)
			{
				%weapName = $VehicleWeapon[%vName, $VehicleCurWeapon[%this]];
				%newEner = $VehicleWeaponAmmo[%this, %weapName] / $VehicleWeaponAmmoMax[%vName, %weapName] * 100;
				GameBase::setEnergy(%this, %newEner);
			}
			
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If we got here, just break out for safty reasons.
			return;
		}

		//*********************************************************************** If were here, we can't pilot it. Check to see if we can ride.

		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If theres no driver, dont go in!
		// People have been complaining about not being able to enter the AC-130U and C-130 while piloted, because
		// of the aggressive landing gear code kicking in. They end up dying. This is a problem with the tank code
		// as well, but not nearly as bad. And this restriction was originally put in to prevent people from
		// getting into unmanned *tanks* in the first place so..
		if(GameBase::getControlClient(%this) == -1
			&& %vname != Hercules && %vname != Gunship)
		{
			Client::sendMessage(Player::getClient(%object),0,"Vehicle must be piloted to enter!~wError_Message.wav");
			return;		
		
		}
		
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If the driver is an enemy, you dont go in!	
		if(GameBase::getControlClient(%this) != -1
			&& GameBase::getTeam(GameBase::getControlClient(%this)) != gamebase::GetTeam(%object))
		{
			Client::sendMessage(Player::getClient(%object),0,"You can't enter a vehicle piloted by an enemy! They won't let you in!~wError_Message.wav");
			return;		
		
		}
		



		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Get a position to ride in.		
		%mountSlot = Vehicle::findEmptySeat(%this,%client, %isArtillery, %isEngineer);

		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If we have a position, put em in their position
		if(%mountSlot)
		{
			
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Take away their weapon while riding
			%weapon = Player::getMountedItem(%object,$WeaponSlot);

			if(%weapon != -1) {
				%object.lastWeapon = %weapon;
				Player::unMountItem(%object,$WeaponSlot);
			}		

			
			//*************************************************************** Assign proper weapons to the rider.

			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If were in a blackhawk,
			if(%vname == Blackhawk || %vname == MoveBlackhawkExtraction)
			{
				Player::setItemCount(%client,LowMountMinigunAmmo,$VehicleAmmo[%this, LowMountMinigun]);
				Player::setItemCount(%client,LowMountMinigun,1);
				Player::useItem(%client,LowMountMinigun);
			}
			
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If were in an abrams,
			else if(%vname == Abrams)
			{
				if (%mountSlot == 2) {
					Player::setItemCount(%client,AbramsAmmo,$VehicleAmmo[%this, AbramsGun]);
					Player::setItemCount(%client,AbramsGun,1);
					Player::useItem(%client,AbramsGun);
				} else if(%mountSlot == 3){
					Player::setItemCount(%client,MinigunAmmo,$VehicleAmmo[%this, Minigun]);
					Player::setItemCount(%client,Minigun,1);
					Player::useItem(%client,Minigun);
				} 
			}
			
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If were in a gunship,
			else if(%vname == Gunship)
			{
				if (%mountSlot == 4) {
					Player::setItemCount(%client,LowMountAbramsAmmo,$VehicleAmmo[%this, LowMountAbramsGun]);
					Player::setItemCount(%client,LowMountAbramsGun,1);
					Player::useItem(%client,LowMountAbramsGun);
				} else if (%mountSlot == 5) {
					Player::setItemCount(%client,FortymmAmmo,$VehicleAmmo[%this, Fortymmgun]);
					Player::setItemCount(%client,FortymmGun,1);
					Player::useItem(%client,FortymmGun);
				} else if (%mountSlot == 2 || %mountSlot == 3){
					Player::setItemCount(%client,LowMountTwentyFivemmAmmo,$VehicleAmmo[%this, LowMountTwentyFivemmgun]);
					Player::setItemCount(%client,LowMountTwentyFivemmgun,1);
					Player::useItem(%client,LowMountTwentyFivemmgun);
				}
			}
			
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If were in a humvee,
			else if(%vname == Humvee)
			{
				if (%mountSlot == 2) {
					Player::setItemCount(%client,TOWAmmo,$VehicleAmmo[%this, TOW]);
					Player::setItemCount(%client,TOW,1);
					Player::useItem(%client,TOW);
				} else if (%mountSlot == 3){
					Player::setItemCount(%client,AutoGrenAmmo,$VehicleAmmo[%this, AutoGrenLauncher]);
					Player::setItemCount(%client,AutoGrenLauncher,1);
					Player::useItem(%client,AutoGrenLauncher);
				}
			}
			
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If were in a bradley,
			else if(%vname == Bradley)
			{
				if (%mountSlot == 2) {
					Player::setItemCount(%client,TOWAmmo,$VehicleAmmo[%this, TOW]);
					Player::setItemCount(%client,TOW,1);
					Player::useItem(%client,TOW);
				} else if (%mountSlot == 3){
					Player::setItemCount(%client,TwentyFivemmAmmo,$VehicleAmmo[%this, TwentyFivemmGun]);
					Player::setItemCount(%client,TwentyFivemmGun,1);
					Player::useItem(%client,TwentyFivemmGun);
				} else if (%mountSlot == 4){
					Player::setItemCount(%client,MinigunAmmo,$VehicleAmmo[%this, Minigun]);
					Player::setItemCount(%client,Minigun,1);
					Player::useItem(%client,Minigun);
				}
			}
			
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If were in a linebacker,
			else if(%vname == LineBacker)
			{
				if (%mountSlot == 2) {
					Player::setItemCount(%client,StingerLauncherAmmo,$VehicleAmmo[%this, StingerLauncherGun]);
					Player::setItemCount(%client,StingerLauncherGun,1);
					Player::useItem(%client,StingerLauncherGun);
				} else if (%mountSlot == 3){
					Player::setItemCount(%client,TwentyFivemmAmmo,$VehicleAmmo[%this, TwentyFivemmGun]);
					Player::setItemCount(%client,TwentyFivemmGun,1);
					Player::useItem(%client,TwentyFivemmGun);
				} else if (%mountSlot == 4){
					Player::setItemCount(%client,MinigunAmmo,$VehicleAmmo[%this, Minigun]);
					Player::setItemCount(%client,Minigun,1);
					Player::useItem(%client,Minigun);
				}
			}
			
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If were in an mlrs,
			else if(%vname == MLRS)
			{
				if (%mountSlot == 2) {
					Player::setItemCount(%client,MLRSAmmo,$VehicleAmmo[%this, MLRSLauncher]);
					Player::setItemCount(%client,MLRSLauncher,1);
					Player::useItem(%client,MLRSLauncher);
				}
			}
			else if(%vname == Hercules)
				%this.openSeats--;
			
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ So the client knows where they are sitting...
			%object.vehicleSlot = %mountSlot;
	
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ So the client knows where they are sitting...
			%client.inVehicle = true;
			

			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ So the client knows WHICH vehicle they are in...
			%object.vehicle = %this;

			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Put our client in the boat.
			Player::setMountObject(%object, %this, %mountSlot);
		
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Play fun sound!
			playSound (%vname.mountSound, GameBase::getPosition(%this));
			
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Remember which slot has who.
			$PassengerSlot[%this, %mountSlot] = %client;
			
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ To be on the safe side.	
			return;
		}
		
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ If we didn't find a mount slot, and arn't in pilot, and there is no pilot, then assume they want to pilot, and need the armor.	
		else if(!%isPilot && GameBase::getControlClient(%this) == -1)
			Client::sendMessage(Player::getClient(%object),0,"You must be a pilot to control the vehicles.~wError_Message.wav");
	}
}



//====================================================================
//:::::::::::::::::::::Vehicle::findEmptySeat:::::::::::::::::::::::::
//:::::::::::::::::::::MODIFIED ON 3/22/02::::::::::::::::::::::::::::
//====================================================================

function Vehicle::findEmptySeat(%this,%client, %isArtillery, %isEngineer)
{
	%dataName = Vehicle::getDataName(%this);

	if(%dataName == Bradley || %dataName == Gunship)
		%numSlots = 4;
	else if(%dataName == Warthog || %dataName == MoveWarthog || %dataName == Bomber || %dataName == Sentry || %dataName == MineLayer)
		%numSlots = 0;
	else if(%dataName == LineBacker)
		%numSlots = 3;
	else if(%dataName == Hercules)
	{
		// Number of slots should not include slots taken by passengers
		%pass = 0;
		for(%i=0;%i < 4;%i++)
		{
			if(%this.Seat[%i] != "")
				%pass++;
		}
		%numSlots = %this.openSeats + %pass;
	}
	else
		%numSlots = 2;
	
	%checkCount = 0;
	%count = 0;
	%guard = 0;
	

	for(%i=0;%i<%numSlots && %i < 4;%i++){
		%guard = %i;
		%cansit = true;
		if(!%isArtillery)
		{
			if(%dataName == Abrams || %dataName == Gunship)
			{
				%cansit = false;
			}
			else if(%dataName == Bradley || %dataName == LineBacker)
			{
				if(%guard == 0 || %guard == 1)
					%cansit = false;
			}
			else if(%dataName == Humvee)
			{
				if(%guard == 0)
					%cansit = false;	
			}
			else if(%dataName == MLRS)
			{
				if(%guard == 0)
					%cansit = false;
				else if(%guard == 1 && !%isEngineer)
					%cansit = false;
			}
		}
		if(%this.Seat[%i] == "")
		{
			%checkCount++;
			if(%canSit)
			{
				%slotPos[%count] = Vehicle::getMountPoint(%this,%i+2);
				%slotVal[%count] = %i+2;
				%lastEmpty = %i+2;
				%count++;


			}
		}
	}
	if(%count == 1) {
		%this.Seat[%lastEmpty-2] = %client;
		return %lastEmpty;
	}
	else if (%count > 1)	{
		%freeSlot = %slotVal[getClosestPosition(%count,GameBase::getPosition(%client),%slotPos[0],%slotPos[1],%slotPos[2],%slotPos[3])];
		%this.Seat[%freeSlot-2] = %client;
		return %freeSlot;
	}
	else
	{
		if(%checkCount != %count)
			Client::sendMessage(%client,0,"Cannot ride in that armor.~wError_Message.wav");	
		return "False";
	}
}

function getClosestPosition(%num,%playerPos,%slotPos0,%slotPos1,%slotPos2,%slotPos3)
{
	%playerX = getWord(%playerPos,0);
	%playerY = getWord(%playerPos,1);
	for(%i = 0 ;%i<%num;%i++) {
		%x = (getWord(%slotPos[%i],0)) - %playerX;
		%y = (getWord(%slotPos[%i],1)) - %playerY;
		if(%x < 0)
			%x *= -1;
		if(%y < 0)
			%y *= -1;
		%newDistance = sqrt((%x*%x)+(%y*%y));
		if(%newDistance < %distance || %distance == "") {
	  		%distance = %newDistance;			
			%closePos = %i;	
		}
	}		
	return %closePos;
}

function Vehicle::passengerJump(%this,%passenger,%mom)
{
	%armor = Player::getArmor(%passenger);
	if(Vehicle::getDataName(%this) == Hercules && (%armor == "larmor" || %armor == "lfemale" || %armor == "sarmor" || %armor == "sfemale" || %armor == "carmor" || %armor == "cfemale"  || %armor == "comarmor" || %armor == "comfemale" || %armor == "comarmor2" || %armor == "comfemale2" || %armor == "comarmor3" || %armor == "comfemale3" || %armor == "parmor" || %armor == "pfemale" || %armor == "larmor2" || %armor == "lfemale2" || %armor == "sarmor2" || %armor == "sfemale2" || %armor == "carmor2" || %armor == "cfemale2" || %armor == "parmor2" || %armor == "pfemale2" || %armor == "larmor3" || %armor == "lfemale3" || %armor == "sarmor3" || %armor == "sfemale3" || %armor == "carmor3" || %armor == "cfemale3" || %armor == "parmor3" || %armor == "pfemale3" || %armor == "aarmor" || %armor == "afemale" || %armor == "aarmor2" || %armor == "afemale2" || %armor == "aarmor3" || %armor == "afemale3")) {
		%height = 5;
		%velocity = 100;
		%zVec = 100;
	}
	else if(Vehicle::getDataName(%this) == Hercules && (%armor == "marmor" || %armor == "mfemale" || %armor == "iarmor" || %armor == "ifemale"  || %armor == "garmor" || %armor == "gfemale" || %armor == "earmor" || %armor == "efemale" || %armor == "marmor2" || %armor == "mfemale2" || %armor == "iarmor2" || %armor == "ifemale2"  || %armor == "garmor2" || %armor == "gfemale2" || %armor == "earmor2" || %armor == "efemale2" || %armor == "marmor3" || %armor == "mfemale3" || %armor == "iarmor3" || %armor == "ifemale3"  || %armor == "garmor3" || %armor == "gfemale3" || %armor == "earmor3" || %armor == "efemale3")) {
		%height = 5;
		%velocity = 140;
		%zVec = 110;
	}
	else if(Vehicle::getDataName(%this) == Hercules && (%armor == "harmor" || %armor == "aarmor")) {
		%height = 5;
		%velocity = 190;
		%zVec = 113;
	}
	else if((%armor == "larmor" || %armor == "lfemale" || %armor == "comarmor" || %armor == "comfemale" || %armor == "comarmor2" || %armor == "comfemale2" || %armor == "comarmor3" || %armor == "comfemale3" || %armor == "sarmor" || %armor == "sfemale" || %armor == "carmor" || %armor == "cfemale" || %armor == "parmor" || %armor == "pfemale" || %armor == "larmor2" || %armor == "lfemale2" || %armor == "sarmor2" || %armor == "sfemale2" || %armor == "carmor2" || %armor == "cfemale2" || %armor == "parmor2" || %armor == "pfemale2" || %armor == "larmor3" || %armor == "lfemale3" || %armor == "sarmor3" || %armor == "sfemale3" || %armor == "carmor3" || %armor == "cfemale3" || %armor == "parmor3" || %armor == "pfemale3"|| %armor == "aarmor" || %armor == "afemale" || %armor == "aarmor2" || %armor == "afemale2" || %armor == "aarmor3" || %armor == "afemale3")) {
		%height = 5;
		%velocity = 70;
		%zVec = 70;
	}
	else if((%armor == "marmor" || %armor == "mfemale" || %armor == "iarmor" || %armor == "ifemale"  || %armor == "garmor" || %armor == "gfemale" || %armor == "earmor" || %armor == "efemale" || %armor == "marmor2" || %armor == "mfemale2" || %armor == "iarmor2" || %armor == "ifemale2"  || %armor == "garmor2" || %armor == "gfemale2" || %armor == "earmor2" || %armor == "efemale2" || %armor == "marmor3" || %armor == "mfemale3" || %armor == "iarmor3" || %armor == "ifemale3"  || %armor == "garmor3" || %armor == "gfemale3" || %armor == "earmor3" || %armor == "efemale3")) {
		%height = 5;
		%velocity = 100;
		%zVec = 100;
	}
	else if((%armor == "harmor" || %armor == "aarmor")) {
		%height = 5;
		%velocity = 140;
		%zVec = 110;
	}

	%pos = GameBase::getPosition(%passenger);
	%posX = getWord(%pos,0);
	%posY	= getWord(%pos,1);
	%posZ	= getWord(%pos,2);
	%off = vector::getrotation(vector::sub(%pos, gamebase::getposition(%this)));

	if(GameBase::testPosition(%passenger,%posX @ " " @ %posY @ " " @ (%posZ + %height))) {	
		%client = Player::getClient(%passenger);
		%passenger.nolanddam=true;
                schedule(%passenger@".nolanddam=false;",2);
		//DELTAFORCE
		if(%mom=="Grapple")
		{
			if(Vehicle::getDataName(%this) == BlackHawk || Vehicle::getDataName(%this) == MoveBlackhawkExtraction)
				if(vector::getdistance("0 0 0", getword(item::getvelocity(%this), 0)@" "@getword(item::getvelocity(%this), 1)@" 0")<=2)	
					if(GameBase::testPosition(%passenger,%posX @ " " @ %posY @ " " @ (%posZ - %height))&&!gamebase::getlosinfo(%this, 3, "-1.5707 0 0")) 
						%grappling=1;
					else
						Client::sendMessage(Player::getClient(%passenger),0,"Can not grapple - Vehicle too close to the ground.~wError_Message.wav");
				else
					Client::sendMessage(Player::getClient(%passenger),0,"Can not grapple - Vehicle moveing to fast.~wError_Message.wav");
			else
				Client::sendMessage(Player::getClient(%passenger),0,"Can not grapple - Vehicle does not allow it.~wError_Message.wav");
			if(!%grappling)
				return;
		}
		if(Vehicle::getDataName(%this) == Humvee) {
			if(%passenger.vehicleSlot == 2) {
				$VehicleAmmo[%this, TOW] = Player::getItemCount(%client, TOWAmmo);
			} else if(%passenger.vehicleSlot == 3) {
				$VehicleAmmo[%this, AutoGrenLauncher] = Player::getItemCount(%client, AutoGrenAmmo);
			}
		} else if(Vehicle::getDataName(%this) == Abrams) {
			if(%passenger.vehicleSlot == 2) {
				$VehicleAmmo[%this, AbramsGun] = Player::getItemCount(%client, AbramsAmmo);
			} else if(%passenger.vehicleSlot == 3) {
				$VehicleAmmo[%this, Minigun] = Player::getItemCount(%client, MinigunAmmo);
			}
		} else if(Vehicle::getDataName(%this) == Gunship) {
			if(%passenger.vehicleSlot == 2 || %passenger.vehicleSlot == 3) {
				$VehicleAmmo[%this, LowMountTwentyFivemmgun] = Player::getItemCount(%client, LowMountTwentyFivemmAmmo);
			} else if(%passenger.vehicleSlot == 4) {
				$VehicleAmmo[%this, LowMountAbramsGun] = Player::getItemCount(%client, LowMountAbramsAmmo);
			} else if(%passenger.vehicleSlot == 5) {
				$VehicleAmmo[%this, Fortymmgun] = Player::getItemCount(%client, FortymmAmmo);
			}
		} else if(Vehicle::getDataName(%this) == BlackHawk || Vehicle::getDataName(%this) == MoveBlackhawkExtraction) {
			if(%passenger.vehicleSlot == 2 || %passenger.vehicleSlot == 3)
				$VehicleAmmo[%this, LowMountMinigun] = Player::getItemCount(%client, LowMountMinigunAmmo);
		} else if(Vehicle::getDataName(%this) == Bradley) {
			if(%passenger.vehicleSlot == 3) {
				$VehicleAmmo[%this, TwentyFivemmgun] = Player::getItemCount(%client, TwentyFivemmAmmo);
			} else if(%passenger.vehicleSlot == 2) {
				$VehicleAmmo[%this, TOW] = Player::getItemCount(%client, TOWAmmo);
			} else if(%passenger.vehicleSlot == 4) {
				$VehicleAmmo[%this, Minigun] = Player::getItemCount(%client, MinigunAmmo);
			}
		
		} else if(Vehicle::getDataName(%this) == LineBacker) {
			if(%passenger.vehicleSlot == 3) {
				$VehicleAmmo[%this, TwentyFivemmgun] = Player::getItemCount(%client, TwentyFivemmAmmo);
			} else if(%passenger.vehicleSlot == 2) {
				$VehicleAmmo[%this, StingerLauncherGun] = Player::getItemCount(%client, StingerLauncherAmmo);
			} else if(%passenger.vehicleSlot == 4) {
				$VehicleAmmo[%this, Minigun] = Player::getItemCount(%client, MinigunAmmo);
			}
		
		} else if(Vehicle::getDataName(%this) == MLRS) {
			if(%passenger.vehicleSlot == 2) {
				$VehicleAmmo[%this, MLRSLauncher] = Player::getItemCount(%client, MLRSAmmo);
			}
		} else if (Vehicle::getDataName(%this) == Hercules)
			%this.openSeats++;
	
		//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Tell the client that they aren't flying a vehicle, and to deactivate jets.
		remoteEval(%client,DeactivateJets);
		$PassengerSlot[%this, %passenger.vehicleSlot] = 0;
		// END DELTAFORCE
		%this.Seat[%passenger.vehicleSlot-2] = "";
		%passenger.vehicleSlot = "";
	 	%passenger.vehicle= "";
		%client.inVehicle = false;
		Player::setMountObject(%passenger, -1, 0);
		%rotZ = getWord(GameBase::getRotation(%passenger),2);
		GameBase::setRotation(%passenger, "0 0 " @ %rotZ);
		GameBase::setPosition(%passenger,%posX @ " " @ %posY @ " " @ (%posZ + %height));
		%jumpDir = Vector::getFromRot(GameBase::getRotation(%passenger),%velocity,%zVec);
		Player::applyImpulse(%passenger,%jumpDir);
		schedule("Player::applyimpulse("@%passenger@",\"0 0 50\");",1.8);
		if(%passenger.lastWeapon != "") {
				Player::useItem(%passenger,%passenger.lastWeapon);		 	
				%passenger.lastWeapon = "";
      		}
			
	}
	else
		Client::sendMessage(Player::getClient(%passenger),0,"Can not dismount - Obstacle in the way.~wError_Message.wav");
	
	// DELTA FORCE
	Player::setItemCount(%passenger,Minigun,0);
	Player::setItemCount(%passenger,MinigunAmmo,0);
	Player::setItemCount(%passenger,LowMountMinigun,0);
	Player::setItemCount(%passenger,LowMountMinigunAmmo,0);
	Player::setItemCount(%passenger,TwentyFivemmgun,0);
	Player::setItemCount(%passenger,TwentyFivemmAmmo,0);
	Player::setItemCount(%passenger,LowMountTwentyFivemmgun,0);
	Player::setItemCount(%passenger,LowMountTwentyFivemmAmmo,0);
	Player::setItemCount(%passenger,Fortymmgun,0);
	Player::setItemCount(%passenger,FortymmAmmo,0);
	Player::setItemCount(%passenger,AbramsGun,0);
	Player::setItemCount(%passenger,AbramsAmmo,0);
	Player::setItemCount(%passenger,LowMountAbramsGun,0);
	Player::setItemCount(%passenger,LowMountAbramsAmmo,0);
	Player::setItemCount(%passenger,TOW,0);
	Player::setItemCount(%passenger,TOWAmmo,0);
	Player::setItemCount(%passenger,AutoGrenLauncher,0);
	Player::setItemCount(%passenger,AutoGrenAmmo,0);
	Player::setItemCount(%passenger,MLRSLauncher,0);
	Player::setItemCount(%passenger,MLRSAmmo,0);
	Player::setItemCount(%passenger,StingerLauncherGun,0);
	Player::setItemCount(%passenger,StingerLauncherAmmo,0);
	Player::useItem(%passenger, %passenger.lastWeapon);
	if(%grappling)
		StartGrappleFromChopper(%passenger, %this, %off);
	// END DELTA FORCE
}

function Vehicle::jump(%this,%mom)
{
   if(Vehicle::getDataName(%this) == TOWMissile) 
   {
	%cl = GameBase::getControlClient(%this);
	//remoteEval(%cl, BP, "<jc><f0>TOW Missile Remotely Detonated", 4);
	bottomprint(%cl, "<jc><f0>TOW Missile Remotely Detonated", 4);
   }
   Vehicle::dismount(%this,%mom);
}

function Vehicle::dismount(%this,%mom)
{
   %cl = GameBase::getControlClient(%this);
   if(Vehicle::getDataName(%this) == TOWMissile) {
	if(%cl != -1) Client::setControlObject(%cl, Client::getOwnedObject(%cl));
	GameBase::setDamageLevel(%this, 0.1);
	return;
   }
   if(%cl != -1)
   {
      %pl = Client::getOwnedObject(%cl);
      if(getObjectType(%pl) == "Player")
      {
	   // dismount the player	  
		if(GameBase::testPosition(%pl, Vehicle::getMountPoint(%this,0))) 
		{
			$SFdrivingAPC[%cl] = 0;
			%pl.lastMount = %this;
			%pl.newMountTime = getSimTime() + 3.0;
			//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Tell the client that they aren't flying a vehicle, and to deactivate jets.
			remoteEval(%cl,DeactivateJets);
		
			Player::setMountObject(%pl, %this, 0);
        		Player::setMountObject(%pl, -1, 0);
			%rot = GameBase::getRotation(%this);
			%rotZ = getWord(%rot,2);
			GameBase::setRotation(%pl, "0 0 " @ %rotZ);
			Player::applyImpulse(%pl,%mom);
			
	
        		Client::setControlObject(%cl, %pl);
			
			%speed = vector::getDistance("0 0 0",item::getvelocity(%this));

			%ejection = false;
			// Check if we should swap out the vehicle.
			// If ground isn't below us.
			if(%speed > 3 && String::findsubstr(Gamebase::getdataName(%this),"Crash") == -1 && Vehicle::isAircraft(%this) && GameBase::getLOSInfo(%this,5,"-1.570796327 0 0"))
			{
				%belowObj = $LOS::object;
				if(gamebase::getdataName(%belowObj) != JetPad && gamebase::getdataName(%belowObj) != ChopperPad && gamebase::getdataName(%belowObj) != "" && gamebase::getdataName(%belowObj) != False)
				{
					%ejection = true;
					// Swap out our vehicle
					%newVeh = newObject("","Flier",Vehicle::getDataName(%this)@"Crash", true);
					Vehicle::SwapData(%this, %newVeh,true);

				// On a schedule because deleting immediate causes crash 
				// (something further up the call stack has to refer back to the object evidently. Probably an engine call.)
					schedule("deleteObject("@%this@");",1,%this);
					%this = %newVeh;
					noseDown(%this,true);
				}	
			} else if(%speed > 3 && String::findsubstr(Gamebase::getdataName(%this),"Crash") == -1 && Vehicle::isAircraft(%this))
			{

				%ejection = true;
				// Swap out our vehicle
				%newVeh = newObject("","Flier",Vehicle::getDataName(%this)@"Crash", true);
		
				Vehicle::SwapData(%this, %newVeh,true);
				// On a schedule because deleting immediate causes crash 
				// (something further up the call stack has to refer back to the object evidently. Probably an engine call.)
				schedule("deleteObject("@%this@");",1,%this);
				%this = %newVeh;
				noseDown(%this,true);
			}

			// Check if this is an ejection, or just getting out.
			if(%ejection)
			{
				schedule("Player::applyimpulse("@%pl@",\"0 0 200\");",0.0);
			} else
			{
				schedule("Player::applyimpulse("@%pl@",\"0 0 50\");",0.8);
			}


			//if(Vehicle::getDataName(%this) == Warthog) {
			//	%this.minSpeed = 0;
			//}
			playSound (Vehicle::getDataName(%this).dismountSound, GameBase::getPosition(%this));
			if(%this.ECM == true)
				Player::setSensorSupression(%cl,0);
			if(%pl.lastWeapon != "") {
				Player::useItem(%pl,%pl.lastWeapon);		 	
				%pl.lastWeapon = "";
      			}
			%pl.driver = "";
			%pl.vehicle = "";
			// DELTAFORCE
			//if(Vehicle::getDataName(%this) == MoveWarthog) {
			//	%pos = GameBase::getPosition(%this);
			//	%rot = GameBase::getRotation(%this);
			//	%dam = GameBase::getDamageLevel(%this);
			//	%hTeam = GameBase::getTeam(%this);
			//	for(%i = 0; %i < $VehiclePrimaryGuns[MoveWarthog]; %i++)
			//	{
			//		%weapName = $VehicleWeapon[MoveWarthog, %i];
			//		$ammoTemp[%i] = $VehicleWeaponAmmo[%this, %weapName];
			//	}
			//	%zPos = getWord(%pos, 2);
			//	%zPos -= 1000;
			//	GameBase::setPosition(%this, getWord(%pos, 0) @ " " @ getWord(%pos, 1) @ " " @ %zPos);
			//	schedule("deleteObject("@%this@");", 0.05);
			//	%hog = newObject("","Flier","Warthog", true);
			//	addToSet("MissionCleanup", %hog);
			//	GameBase::setPosition(%hog, %pos);
			//	GameBase::setRotation(%hog, %rot);
			//	GameBase::setDamageLevel(%hog, %dam);
			//	GameBase::setTeam(%hog, %hTeam);
			//	for(%i = 0; %i < $VehiclePrimaryGuns[Warthog]; %i++)
			//	{
			//		%weapName = $VehicleWeapon[Warthog, %i];
			//		$VehicleWeaponAmmo[%hog, %weapName] = $ammoTemp[%i];
			//		$ammoTemp[%i] = 0;
			//	}
			//}
			// END DELTAFORCE
			Player::setItemCount(%pl,Minigun,0);
			Player::setItemCount(%pl,MinigunAmmo,0);
			Player::setItemCount(%pl,LowMountMinigun,0);
			Player::setItemCount(%pl,LowMountMinigunAmmo,0);
			Player::setItemCount(%pl,TwentyFivemmgun,0);
			Player::setItemCount(%pl,TwentyFivemmAmmo,0);
			Player::setItemCount(%pl,LowMountTwentyFivemmgun,0);
			Player::setItemCount(%pl,LowMountTwentyFivemmAmmo,0);
			Player::setItemCount(%pl,Fortymmgun,0);
			Player::setItemCount(%pl,FortymmAmmo,0);
			Player::setItemCount(%pl,AbramsGun,0);
			Player::setItemCount(%pl,AbramsAmmo,0);
			Player::setItemCount(%pl,LowMountAbramsGun,0);
			Player::setItemCount(%pl,LowMountAbramsAmmo,0);
			Player::setItemCount(%pl,TOW,0);
			Player::setItemCount(%pl,TOWAmmo,0);
			Player::setItemCount(%pl,AutoGrenLauncher,0);
			Player::setItemCount(%pl,AutoGrenAmmo,0);
			Player::setItemCount(%pl,MLRSLauncher,0);
			Player::setItemCount(%pl,MLRSAmmo,0);
			Player::setItemCount(%pl,StingerLauncherGun,0);
			Player::setItemCount(%pl,StingerLauncherAmmo,0);
			
		} else Client::sendMessage(%cl,0,"Can not dismount - Obstacle in the way.~wError_Message.wav");
	}	
   }
}

function Vehicle::onDestroyed (%this,%mom)
{
	if(!isObject(%this) || %this.dead)
	{
		return;
	}
	%this.dead = true;

	Radar::Remove(%this);
	Radar::Detectable::Remove(%this);

//	if($testcheats || $servercheats)
	$TeamItemCount[%this.boughtTeam @ $VehicleToItem[Vehicle::getDataName(%this)]]--;
	%this.isAirstrikeVehicle = 0;
 	%cl = GameBase::getControlClient(%this);
	%pl = Client::getOwnedObject(%cl);
	if(Vehicle::getDataName(%this) == TOWMissile) {
		Client::setControlObject(%cl, %pl);
		calcRadiusDamage(%this, $MissileDamageType, 100, 0.05, 25, 13, 2, 2, 0.1, 250, 100);
		return;
	}
	if(%this.ECM == true)
		Player::setSensorSupression(%pl,0);
	%this.ECM = false;
	if(%pl != -1) {
	   Player::setMountObject(%pl, -1, 0);
   	Client::setControlObject(%cl, %pl);
	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Tell the client that they aren't flying a vehicle, and to deactivate jets.
	remoteEval(%cl,DeactivateJets);
	distributePoints(%this, %this.clLastMount, %this.LastDamageObject);
	$SFdrivingAPC[%cl] = 0;
		if(%pl.lastWeapon != "") {
			Player::useItem(%pl,%pl.lastWeapon);		 	
			%pl.lastWeapon = "";
		}
		%pl.driver = "";
	   %pl.vehicle= "";
	}
echo("DESTROYED! " @ %this @  " " @ gamebase::Getdataname(%this));
	for(%i = 0 ; %i < 4 ; %i++)
	{
		if(%this.Seat[%i] != "") {
			%pl = Client::getOwnedObject(%this.Seat[%i]);
		   Player::setMountObject(%pl, -1, 0);
	  	 	Client::setControlObject(%this.Seat[%i], %pl);
			%pl.vehicleSlot = "";
			%pl.inVehicle = false;
		   %pl.vehicle= "";
			// DELTA FORCE
			Player::setItemCount(%pl,Minigun,0);
			Player::setItemCount(%pl,MinigunAmmo,0);
			Player::setItemCount(%pl,LowMountMinigun,0);
			Player::setItemCount(%pl,LowMountMinigunAmmo,0);
			Player::setItemCount(%pl,TwentyFivemmgun,0);
			Player::setItemCount(%pl,TwentyFivemmAmmo,0);
			Player::setItemCount(%pl,LowMountTwentyFivemmgun,0);
			Player::setItemCount(%pl,LowMountTwentyFivemmAmmo,0);
			Player::setItemCount(%pl,Fortymmgun,0);
			Player::setItemCount(%pl,FortymmAmmo,0);
			Player::setItemCount(%pl,AbramsGun,0);
			Player::setItemCount(%pl,AbramsAmmo,0);
			Player::setItemCount(%pl,LowMountAbramsGun,0);
			Player::setItemCount(%pl,LowMountAbramsAmmo,0);
			Player::setItemCount(%pl,TOW,0);
			Player::setItemCount(%pl,TOWAmmo,0);
			Player::setItemCount(%pl,AutoGrenLauncher,0);
			Player::setItemCount(%pl,AutoGrenAmmo,0);
			Player::setItemCount(%pl,MLRSLauncher,0);
			Player::setItemCount(%pl,MLRSAmmo,0);
			Player::setItemCount(%pl,StingerLauncherGun,0);
			Player::setItemCount(%pl,StingerLauncherAmmo,0);
			Player::useItem(%pl, %pl.lastWeapon);
		
			// END DELTA FORCE			
		}
	}
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 2, 1.55, 
		0.1, 225, 100); 
	$Smoking[%this] = 0;
	$Flamming[%this] = 0;
	$Plummeting[%this] = 0;
	
	if($Tournymode) {
		%vname = Vehicle::getDataName(%this);
		%isJet = Vehicle::isJet(%this);
		%isTank = Vehicle::isTank(%this);
		if( %isjet )
			$TeamOwnedJet[%team]--;
		else if( %istank )
			$TeamOwnedTank[%team]--;
		else 
			$TeamOwnedChopper[%team]--;
		Export( "TeamOwned*", "config\\VehicleLeft.cs", False );
	
			

	}
	
	//For airstrike cleanup
	if(%this.group && %this.group != "" && %this.group != -1)
	{
		echo("AIRSTRIKE CLEANUP RUNNING");
		deleteobject(%this.group);
	}	
}

function distributePoints(%this, %pilot, %killer)
{
	if(%pilot == -1 || !%pilot || %killer == -1 || !%killer || %pilot == %killer)
		return;
	if($NoVehicleTK && GameBase::getTeam(%pilot) == GameBase::getTeam(%killer))
		return;
	%vehicleType = Vehicle::getDataName(%this);
	if(!String::ICompare(Client::getGender(%pilot), "Male"))
 	{
 		%pilotGender = "his";
	}	
	else
	{
		%pilotGender = "her";
	}
	if(!String::ICompare(Client::getGender(%killer), "Male"))
 	{
 		%killerGender = "his";
	}	
	else
	{
		%killerGender = "her";
	}
	%ridx = floor(getRandom() * ($numDeathMsgs - 0.01));
	%victimName = Client::getName(%pilot);
	%obitMsg = sprintf($crashMsg[%vehicleType, %ridx], Client::getName(%killer),
		%victimName, %killerGender, %pilotGender);
        messageAll(0, %obitMsg, $DeathMessageMask);
	%pilot.score--;
	%killer.score++;
	Game::refreshClientScore(%killer);
        Game::refreshClientScore(%pilot);
	
}


function getTargetDown(%player)
{
	%cl = GameBase::getControlClient(%player);
	%pl = Client::getOwnedObject(%cl);
	if(GameBase::getLOSInfo(%pl,2.5,"-1.570796327 0 0")){
	echo($los::object);
	echo(Vehicle::getDataName($los::object));
	echo(Vehicle::getDataName($los::object) != "False");
	}

}


function Vehicle::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
	if(!isObject(%this) || %this.dead)
	{
		return;
	}

	%type = Veteran::getRealDamageType(%type);
	%value *= $damageScale[Vehicle::getDataName(%this), %type];
	%vname = Vehicle::getDataName(%this);
	%isJet = Vehicle::isJet(%this);

//	%value = %vName.maxDamage * 0.95; 

	if(%isJet && %type == $ImpactDamageType)
	{
		
		%dist = 3.0;
		if(Vehicle::largeVehicle(%this))
			%dist = 10;
		if(GameBase::getLOSInfo(%this,%dist,"-1.570796327 0 0")){

		if(Vehicle::getDataName($los::object) == "False"){


			%rotX = getword(GameBase::getRotation(%vehicle),0);
			if(%rotX < 0.2 && %rotX > -0.02)
			{
				%velocI = Item::getVelocity(%this); 
				%xvelocI = getword(%velocI, 0);
				%yvelocI = getword(%velocI, 1);
				%zvelocI = getword(%velocI, 2);
				%speedI = sqrt(%xvelocI*%xvelocI + %yvelocI*%yvelocI + %zvelocI*%zvelocI);
				if( %speedI < %vname.maxspeed *0.75){
					return;
				}
			}
		}
		}
	}
	
		
	StaticShape::onDamage(%this,%type,%value,%pos,%vec,%mom,%object);
	
}

function Vehicle::getHeatFactor(%this)
{
	// Not getting called right now because turrets don't track
	// vehicles.  A hack has been placed in Player::getHeatFactor.
   return 1.0;
}

//-Height to float off ground
$GroundFloat = 2.1;
//-Our gravity constant for how fast out vehicles fall.
$GravConst = -21;
//-How often to have this loop.
$TimeSkip = 0.01;
//-The buffer for how much our rot can be off from the terrain's.
// Should smooth the ride out a little.
$RotOffset = 0.01;

$NoDamageDropSpeed = 20;
$DamageOnDropMult = 0.0015;
$DamageRadiusOnDropMult = 2.5;
$DamageKickOnDropMult = 50;

$SlipMessage = "Your treads spin helplessly in the mud...";
$MinSlopeDot=0.85; //Set this high for DF_Extraction.
$VehicleStiffness = 0.1; //Higher means it's tighter.

function VehicleHover(%veh,%client)
{
    //Make sure client exists and is the guy controling the car.
    if(%client < 1 || %client == "")
        %client = GameBase::getControlClient(%veh);
    %rot0 = GameBase::getRotation(%veh);

    //If we got a driver, arn't being carried and have something under us.
    if(GameBase::getControlClient(%veh) == %client && GameBase::getLOSInfo(%veh,5000,(-$pi/2 - getword(%rot0, 0))@" 0 0")) 
    {
        //Get the position and rotation of the ground
        %groundRot = $los::normal;
        %groundPos = $los::position;

        //get the position and rotation of the vehicle.
        %rot0 = GameBase::getRotation(%veh);
        %pos0 = GameBase::getPosition(%veh);
        
        %ZDist = getWord(%pos0,2)-getWord(%groundPos,2);

        //Take care of ground. If were higher, then fall and such.
        %NewPos = getWord(%pos0,0)@" "@getWord(%pos0,1)@" "@getWord(%groundPos,2)+$GroundFloat;

        
        if(%ZDist > $GroundFloat + 0.9) {
            %displacement = %veh.lastVel*$TimeSkip + 0.5*$GravConst*($TimeSkip*$TimeSkip);
            %veh.lastVel = sqrt( %veh.lastVel*%veh.lastVel + 2*$GravConst*%displacement);
            if(%displacement < 0 )
                %veh.lastVel = %veh.lastVel*-1;
                
            if( (%ZDist-%displacement) > $GroundFloat ){
                %NewPos = getWord(%NewPos,0)@" "@getWord(%NewPos,1)@" "@getword(%veh.lastPos, 2)+%displacement;
            }
        } else {
            if(-1*%veh.lastVel > $NoDamageDropSpeed)
            {
                // Ouch! Cause damage!

                %value = pow(%veh.lastVel,2)*$DamageOnDropMult;
                if(%value > 10)
                    %value = 10;
                %radius = %value*$DamageRadiusOnDropMult;
                %kick = %value*$DamageKickOnDropMult;

 		GameBase::applyRadiusDamage($ImpactDamageType,gamebase::getposition(%veh),%radius,%value,%kick,2048);
            }
            %veh.lastVel = getword(Item::getVelocity(%veh),2);
        }

        //Keep rotation constant if were not in the "air"


        //if(%ZDist >  $GroundFloat + 0.9)
        //    %NewRot = %veh.lastRot;
        
        //Set all our things.

        
        GameBase::setPosition(%veh,%newPos);

        
        %rot = 0;
        %dir = vector::getfromrot(%rot0);

        if(vector::getdistance("0 0 1", %groundrot) > 0.05) //If this is close to "0 0 1", we'll get asin and atan2 errors. The %dir check should NEVER be "0 0 1", but just to be safe...
        {	
	        %fdir = vector::normalize(getword(%dir, 0)@" "@getword(%dir, 1)@" "@0); //Flattened
	      
		%fgr = vector::normalize(getword(%groundrot, 0)@" "@getword(%groundrot, 1)@" "@0); //Flattened
	        //Multiply the x rotation of the ground by the cosine of the each z rotation multipled together.
	        %rot = getword(vector::getrotation(%groundrot), 0) * vector::dot(%fdir, %fgr)*0.5; //Shallower to help ease it over rapid changes
	        if(%rot>0.3||%rot<-0.3)
	            %rot = %rot *2;
	}
        
	%RD = %rot - getword(%rot0, 0);
        
	%templastrot = %veh.lastRot;

	if(%ZDist >  $GroundFloat + 0.9)
		GameBase::setRotation(%veh,%veh.lastRot);
	if(%RD > $RotOffset||%RD<-$RotOffset)
	{
		%NewRot = vector::add(%rot0, $VehicleStiffness*%RD@" 0 0");
		GameBase::setRotation(%veh,%NewRot);
		%veh.lastRot = %newRot;
		%templastrot = %newRot;
        } else
		%veh.lastRot = %rot0;
        

	// Before we set the lastpos, we need to make sure we're not climbing a hill.
	// If we are, we need to reset them to the last pos to prevent that climbing.
        
        if(vector::dot(%groundrot, "0 0 1")<$MinSlopeDot)
        {
            //if(item::Getvelocity(%veh)!="0 0 0")
            //    messageall(0, item::Getvelocity(%veh));
            
        	if(getword(%veh.lastPos,2) <= getword(%newPos,2))
               	{
                
               		%newpos = %veh.lastpos;
             		if($SlipMessage!="")
              			bottomprint(%client, $SlipMessage, 1);
               		gamebase::Setposition(%veh, %newpos);
               
               	}
       	}
        %veh.lastPos = %newPos;
        schedule("VehicleHover("@%veh@","@%client@");",$TimeSkip,%veh);

    }

}

function VehicleHover1(%veh,%client)
{
	//Make sure client exists and is the guy controling the car.
	if(%client < 1 || %client == "")
		%client = GameBase::getControlClient(%veh);

	//If we got a driver, arn't being carried and have something under us.
	if(GameBase::getControlClient(%veh) == %client && GameBase::getLOSInfo(%veh,5000,"-1.570796327 0 0")) {
		//Get the position and rotation of the ground
		%groundRot = $los::normal;
		%groundPos = $los::position;

		//get the position and rotation of the vehicle.
		%rot0 = GameBase::getRotation(%veh);
		%pos0 = GameBase::getPosition(%veh);

		%ZDist = getWord(%pos0,2)-getWord(%groundPos,2);

		//Take care of ground. If were higher, then fall and such.
		%NewPos = getWord(%pos0,0)@" "@getWord(%pos0,1)@" "@getWord(%groundPos,2)+$GroundFloat;
		if(%ZDist > $GroundFloat + 0.9) {
			%displacement = %veh.lastVel*$TimeSkip + 0.5*$GravConst*($TimeSkip*$TimeSkip);
			%veh.lastVel = sqrt( %veh.lastVel*%veh.lastVel + 2*$GravConst*%displacement);
			if(%displacement < 0 )
				%veh.lastVel = %veh.lastVel*-1;
				
			if( (%ZDist-%displacement) > $GroundFloat ){
				%NewPos = getWord(%NewPos,0)@" "@getWord(%NewPos,1)@" "@getWord(%veh.lastPos,2)+%displacement;
			}
		} else {
			if(-1*%veh.lastVel > $NoDamageDropSpeed)
			{
				// Ouch! Cause damage!

				%value = pow(%veh.lastVel,2)*$DamageOnDropMult;
				if(%value > 10)
					%value = 10;
				%radius = %value*$DamageRadiusOnDropMult;
				%kick = %value*$DamageKickOnDropMult;

				GameBase::applyRadiusDamage($ImpactDamageType,gamebase::getposition(%veh),%radius,%value,%kick,2048);
			}
			%veh.lastVel = getword(Item::getVelocity(%veh),2);
		}

		//Keep rotation constant if were not in the "air"


		//if(%ZDist >  $GroundFloat + 0.9)
		//	%NewRot = %veh.lastRot;
		
		//Set all our things.


		GameBase::setPosition(%veh,%newPos);

		// Only set rot if its to much.
		//Smooth out the rotation settings a tad.
		
		// %optimal is our "perfect" angle
		%optimal = -1*getword(%groundRot, 1)*cos(getword(%rot0, 2))
			 + getword(%groundRot, 0)*sin(getword(%rot0, 2));
		%RotDifference0 = (%optimal - getword(%rot0, 0));		
		if(%optimal < getWord(%rot0,0))
			%xchange = getWord(%rot0,0) - 0.05;
		else if(%optimal > getWord(%rot0,0))
			%xchange = getWord(%rot0,0) + 0.05;
		else
			%xchange = %optimal;
		
		if(%ZDist >  $GroundFloat + 0.9)
			GameBase::setRotation(%veh,%veh.lastRot);
		else if( %rotDifference0 > $RotOffset || %rotDifference0 < -1*$RotOffset) {
			
			%NewRot = %xchange@" "@getWord(GameBase::getRotation(%veh),1)@" 							 		"@getWord(GameBase::getRotation(%veh),2);
			GameBase::setRotation(%veh,%NewRot);
			%veh.lastRot = %newRot;
		
		} else			
			%veh.lastRot = %rot0;

		// Before we set the lastpos, we need to make sure we're not climbing a hill.
		// If we are, we need to reset them to the last pos to prevent that climbing.
		if(getword(%groundrot,0) > 0.2 || getword(%groundrot,0) < -0.2)//0.6
		{
			if(getword(%veh.lastPos,2) <= getword(%newPos,2))
				gamebase::Setposition(%veh,%veh.lastPos);
		}
		%veh.lastPos = %newPos;

		schedule("VehicleHover("@%veh@","@%client@");",$TimeSkip,%veh);
	}

}


// Thanks to Hosed for use of this code...
function vehicleHoverOLD(%vehicle, %clientId, %changeZRot, %changeYRot)
{
	// Global var. True if driving vehicle. False if not. 
	if($SFdrivingAPC[%clientId])  
	{
		%refX1 = "-0.393 0 0";
		%refX2 = "-0.393 0 1.571";
		%refX3 = "-0.786 0 0";
		%refX4 = "-0.786 0 1.571";

		%refY2 = "-0.393 0 0.786";
		%refY1 = "-0.393 0 -0.786";
		%refY4 = "-0.786 0 0.786";
		%refY3 = "-0.786 0 -0.786";
		
		%refHeight = "-1.575 0 0";

		//Temp set Rotations
		%OldRot = GameBase::getRotation(%vehicle);
		%NewXRot = getword(%OldRot, 0);
		%NewYRot = getword(%OldRot, 1);
		%changeInZ = %changeYRot - %NewYRot;
		%changeInZ = %changeInZ * 3;
		//if(($modVal % 5) == 0) 
		//	echo(%changeInZ);
		//$modVal++;
		%NewZRot = %changeZRot + %changeInZ;
		
		// Front Middle Position
		//----------------------
		if(GameBase::getLOSInfo(%vehicle,20,%refX1))
			%frontMiddlePos = $los::position;
		else
			if(GameBase::getLOSInfo(%vehicle,1000,%refX3))
				%frontMiddlePos = $los::position;
			else
				%frontMiddlePos = "0 0 0";
		
		// Rear Middle Position
		//-----------------------
		if(GameBase::getLOSInfo(%vehicle,20,%refX2))
			%rearMiddlePos = $los::position;
		else
			if(GameBase::getLOSInfo(%vehicle,1000,%refX4))
				%rearMiddlePos = $los::position;
			else
				%rearMiddlePos = "0 0 0";

		// Left Middle Position
		//------------------------
		if(GameBase::getLOSInfo(%vehicle,20,%refY1))
			%leftMiddlePos = $los::position;
		else
			if(GameBase::getLOSInfo(%vehicle,1000,%refY3))
				%leftMiddlePos = $los::position;
			else
				%leftMiddlePos = "0 0 0";

		// Right Middle Position
		//------------------------
		if(GameBase::getLOSInfo(%vehicle,20,%refY2))
			%rightMiddlePos = $los::position;
		else
			if(GameBase::getLOSInfo(%vehicle,1000,%refY4))
				%rightMiddlePos = $los::position;
			else
				%rightMiddlePos = "0 0 0";

		//-------------------
		// X Rotation Stuff
		//-------------------
		// Rear Position
		%rMidX = getword(%rearMiddlePos, 0);
		%rMidY = getword(%rearMiddlePos, 1);
		%rMidZ = getword(%rearMiddlePos, 2);
		// Front Position
		%fMidX = getword(%frontMiddlePos , 0);
		%fMidY = getword(%frontMiddlePos , 1);
		%fMidZ = getword(%frontMiddlePos , 2);
		// X Distance
		%rpos = %rMidX@" "@%rMidY@" 0";
		%fpos = %fMidX@" "@%fMidY@" 0";
		// Find average of both rotations
		// Total Distance
		%totDist = Vector::getDistance(%rpos, %fpos);
		%zDistance = %fMidZ - %rMidZ;
		if(%totDist != 0)
	    	if( %zDistance != 0 )
			{
				%OppAdd = %zDistance/%totDist;
				%NewXRot = inverseTan(%OppAdd);
			}

		//-------------------
		// Y Rotation Stuff
		//-------------------
		// Right Side Position
		%rsMidX = getword(%rightMiddlePos, 0);
		%rsMidY = getword(%rightMiddlePos, 1);
		%rsMidZ = getword(%rightMiddlePos, 2);
		// Left Side Position
		%lsMidX = getword(%leftMiddlePos , 0);
		%lsMidY = getword(%leftMiddlePos , 1);
		%lsMidZ = getword(%leftMiddlePos , 2);
		// Y Distance
		%rsPos = %rsMidX@" "@%rsMidY@" 0";
		%lsPos = %lsMidX@" "@%lsMidY@" 0";
		// Total Distance
		%totDist = Vector::getDistance(%rsPos, %lsPos);
		%zDistance = %lsMidZ - %rsMidZ;
		if(%totDist != 0)
			if( %zDistance != 0 )
			{
				%OppAdd = %zDistance/%totDist;
				%NewYRot = inverseTan(%OppAdd);
			}

		//-------------------
		// Height Stuff
		//-------------------
		if(GameBase::getLOSInfo(%vehicle,20,%refHeight))
		{
			%groundPos = $los::position;
			%vehiclePos = GameBase::getPosition(%vehicle);
			%vehicleX = getword(%vehiclePos, 0);
			%vehicleY = getword(%vehiclePos, 1);
			%vehicleZ = getword(%vehiclePos, 2);
			%groundz = getword(%groundPos, 2);
			%height = %vehicleZ - %groundZ;
			if(%height >= 1.99 || %height <= 2.01)
			{
				%newpos = %vehicleX @ " " @ %vehicleY @ " " @ (%groundZ + 2.0);
				GameBase::setPosition(%vehicle,%newpos);
			}
		}

		//-------------------
		// Set Rotation Stuff
		//-------------------
		// New Rotation
		%NewRot = %NewXRot@" "@%NewYRot@" "@%NewZRot;
		GameBase::setRotation(%vehicle,%NewRot);

		schedule("vehicleHover("@%vehicle@","@%clientId@","@%NewZRot@","@%NewYRot@");",0.05, %vehicle);
	}
}

function inverseTan(%x)
{
	%theta = %x - ((%x*%x*%x)/3) + ((%x*%x*%x*%x*%x)/5);
	return %theta;
}

//$Roll = 0.196349540875; //- 1/32 Roll
$Roll = 0.008; //- 1/48 Roll
//$Roll = 0.0981747704375; //- 1/64 Roll
function Vehicle::BarrelRoll(%this)
{
	%client = GameBase::getControlClient(%this);
	%player = Client::getOwnedObject(%client);
	%data = Vehicle::getDataName(%this);
	%speed = sqrt(pow(getword(Item::getVelocity(%this),0),2) + pow(getword(Item::getVelocity(%this),1),2) + pow(getword(Item::getVelocity(%this),2),2));
	if(%data != Falcon && %data != Tomcat && %data != Warthog && %data != MoveWarthog)
		return;
	if(%speed <= %data.maxSpeed*4/5) {
		Client::sendMessage(%client,0,"You must Accelerate more before you can Barrel Roll~wError_Message.wav");
		return;
	}
	if(getWord(GameBase::getRotation(%this),1) >= 0)
		Vehicle::RollLeft(%this);
	else
		Vehicle::RollRight(%this);
	%this.lastRoll = getSimTime();
}

function Vehicle::RollLeft(%this)
{
	%rot = GameBase::getRotation(%this);
	%NewRot = Vector::Add(%rot,"0 "@$Roll@" 0");
	Vehicle::SwapSeekingMissiles::P(%veh);
		GameBase::setRotation(%this,%NewRot);
	Vehicle::SwapSeekingMissiles::V(%veh);

	if(%this.rolling == 1)
		schedule("Vehicle::RollLeft("@%this@");",0.001,%this);
}

function Vehicle::RollRight(%this)
{
	%rot = GameBase::getRotation(%this);
	%NewRot = Vector::Sub(%rot,"0 "@$Roll@" 0");
	Vehicle::SwapSeekingMissiles::P(%veh);
		GameBase::setRotation(%this,%NewRot);
	Vehicle::SwapSeekingMissiles::V(%veh);

	if(%this.rolling == 1)
		schedule("Vehicle::RollRight("@%this@");",0.001,%this);
}

function Vehicle::EndRoll(%this)
{
	%this.rolling = "";
}

function GetOffSetRot2(%offset,%rot,%pos)
{
	%x = getWord(%offset,0);
	%y = getWord(%offset,1);
	%z = getWord(%offset,2);
	%posA = Vector::add(%pos,Vector::getFromRot(Vector::Add(%rot,"0 0 -1.570796327"),%x));
	%posB = Vector::add(%posA,Vector::getFromRot(%rot,%y));
	%posC = Vector::add(%posB,Vector::getFromRot(Vector::Add(%rot,"1.570796327 0 0"),%z));
}

function GetOffSetRot(%offset,%rot,%pos)
{
	%x = getWord(%offset,0);
	%y = getWord(%offset,1);
	%z = getWord(%offset,2);
	%posA = Vector::add(%pos,Vector::getFromRot(Vector::Add("0 "@getword(%rot,1)@" "@getword(%rot,2),"0 0 -1.570796327"),%x));
	%posB = Vector::add(%posA,Vector::getFromRot(getword(%rot,0)@" 0 "@getword(%rot,2),%y));
	%posC = Vector::add(%posB,Vector::getFromRot(Vector::Add(getword(%rot,0)@" "@getword(%rot,1)@" 0","1.570796327 0 0"),%z));
	return %posC;
}

function GetOffSetRot3(%offset,%rot,%pos)
{
	%k = Vector::getFromRot(%rot);
	%padd = getword (%k, 0) @ " -10 " @ getword (%k, 1);
	%pos = Vector::add(%pos, %padd);
	


}

function RemoteGetAltitude(%client)
{
	if(%client.justCalledGetAlt)
		return;
	%client.justCalledGetAlt = true;
	schedule(%client@".justcalledGetAlt = false;",0.5);
	%toReturn = 0;
	%vehicle = client::getcontrolobject(%client);

	%pos = gamebase::Getposition(%vehicle);
	%tarPos = vector::Add(%pos,"0 0 -5000");
	%mask = (~0 ^ $BitMask::Vehicle) ^ $BitMask::Player;
	if(getLOSInfo(%pos,%tarpos,%mask))
	{
		%LOSpos = $LOS::Position;
		%toReturn = getword(%pos,2) - getWord(%LOSpos,2);
	}
	remoteeval(%client,returnAltitude,floor(%toReturn));
}

function Vehicle::getDataName(%this)
{
	if(Vehicle::isTomcat(%this))
		return Tomcat;
	else if(Vehicle::isFalcon(%this))
		return Falcon;
	else if(Vehicle::isBomber(%this))
		return Bomber;
	else if(Vehicle::isWarthog(%this))
		return Warthog;
	else if(Vehicle::isHercules(%this))
		return Hercules;
	else if(Vehicle::isSentry(%this))
		return Sentry;
	else if(Vehicle::isGunship(%this))
		return Gunship;
	else if(Vehicle::isApache(%this))
		return Apache;
	else if(Vehicle::isKiowa(%this))
		return Kiowa;
	else if(Vehicle::isBlackhawk(%this))
		return Blackhawk;
	else if(Vehicle::isHind(%this))
		return Hind;
	else
		return Gamebase::GetDataName(%this);
}

function Vehicle::isCrashVehicle(%this)
{
	%vname = GameBase::getDataName(%this);
	return (%vname == TomcatCrash || %vname == FalconCrash || %vname == BomberCrash 
		|| %vname == WarthogCrash || %vname == HerculesCrash || %vname == SentryCrash
		|| %vname == GunshipCrash || %vname == ApacheCrash || %vname == KiowaCrash 
		|| %vname == HindCrash || %vname == BlackHawkCrash);
}

function Vehicle::isTomcat(%this)
{
	%vname = GameBase::getDataName(%this);
	return (%vname == Tomcat || %vname == TomcatCrash || %vname == TomcatMove);
}
function Vehicle::isFalcon(%this)
{
	%vname = GameBase::getDataName(%this);
	return (%vname == Falcon || %vname == FalconCrash || %vname == FalconMove);
}
function Vehicle::isBomber(%this)
{
	%vname = GameBase::getDataName(%this);
	return (%vname == Bomber|| %vname == BomberCrash || %vname == BomberMove);
}
function Vehicle::isWarthog(%this)
{
	%vname = GameBase::getDataName(%this);
	return (%vname == Warthog || %vname == MoveWarthog || %vname == WarthogCrash);
}
function Vehicle::isHercules(%this)
{
	%vname = GameBase::getDataName(%this);
	return (%vname == Hercules || %vname == HerculesCrash);
}
function Vehicle::isSentry(%this)
{
	%vname = GameBase::getDataName(%this);
	return (%vname == Sentry || %vname == SentryCrash);
}
function Vehicle::isGunship(%this)
{
	%vname = GameBase::getDataName(%this);
	return (%vname == Gunship || %vname == GunshipCrash);
}
function Vehicle::isApache(%this)
{
	%vname = GameBase::getDataName(%this);
	return (%vname == Apache || %vname == ApacheCrash);
}
function Vehicle::isKiowa(%this)
{
	%vname = GameBase::getDataName(%this);
	return (%vname == Kiowa || %vname == KiowaCrash);
}
function Vehicle::isBlackhawk(%this)
{
	%vname = GameBase::getDataName(%this);
	return (%vname == Blackhawk || %vname == MoveBlackhawkExtraction || %vname == BlackhawkCrash);
}
function Vehicle::isHind(%this)
{
	%vname = GameBase::getDataName(%this);
	return (%vname == Hind || %vname == HindCrash);
}

function Vehicle::isVehicle(%this)
{
	return (Vehicle::isAircraft(%this) || Vehicle::isTank(%this));
}

function Vehicle::isAircraft(%this)
{
	return (Vehicle::isJet(%this) || Vehicle::isChopper(%this));
}

function Vehicle::isJet(%this)
{
	return (Vehicle::isFalcon(%this) || Vehicle::isTomcat(%this) || Vehicle::isBomber(%this) 
		|| Vehicle::isWarthog(%this) || Vehicle::isGunship(%this) || Vehicle::isHercules(%this)
		|| Vehicle::isSentry(%this));
}

function Vehicle::isChopper(%this)
{
	return (Vehicle::isApache(%this) || Vehicle::isKiowa(%this) || Vehicle::isBlackhawk(%this) || Vehicle::isHind(%this));
}

function Vehicle::GetSize(%this)
{
%model = Gamebase::GetDataName(%this).shapeFile;
if(%model == "flyer")
	return "small";
if(%model == "hover_apc_sml")
	return "medium";
if(%model == "hover_apc")
	return "large";
return "unknown";
}

function Vehicle::isTank(%this)
{
	%vname = GameBase::getDataName(%this);

	return (%vname == Humvee || %vname == Abrams || %vname == Bradley || %vname == LineBacker || %vname == MLRS || %vname == MineLayer);
}

function Vehicle::hasTwoPassengerGuns(%this)
{
	%vname = Gamebase::GetDataName(%this);
	return (%vname == Abrams || Vehicle::isBlackhawk(%this) ||  %vname== Humvee 
		|| %vname == LineBacker  || %vname == Bradley || %vname == MLRS);
}

function Vehicle::hasFourPassengerGuns(%this)
{
	return (Vehicle::isGunship(%this));
}

function Vehicle::smallVehicle(%this)
{
	%vname = Gamebase::GetDataName(%this);
	return (Vehicle::isApache(%this) || Vehicle::isKiowa(%this) 
		|| Vehicle::isFalcon(%this) || Vehicle::isTomcat(%this) 
		|| %vname == Humvee  || %vname == MineLayer);
}

function Vehicle::largeVehicle(%this)
{
	return (Vehicle::isBomber(%this) || Vehicle::isHercules(%this) 
		|| Vehicle::isGunship(%this) || Vehicle::isSentry(%this));
}

function Vehicle::hasPilotWeapon(%this)
{
	%vname = Gamebase::GetDataName(%this);
	return (Vehicle::isWarthog(%this) || Vehicle::isApache(%this) || Vehicle::isKiowa(%this) || Vehicle::isFalcon(%this) 
		|| Vehicle::isTomcat(%this) || Vehicle::isHind(%this) ||Vehicle::isBomber(%this) || Vehicle::isHercules(%this) 
		|| %vname == MineLayer);
}

function Vehicle::isSmallJet(%this)
{
	return (Vehicle::isFalcon(%this) || Vehicle::isTomcat(%this));
}

function Vehicle::isMediumJet(%this)
{
	return (Vehicle::isWarthog(%this));
}

function Vehicle::isBigJet(%this)
{
	return (Vehicle::isBomber(%this) || Vehicle::isGunship(%this) || Vehicle::isHercules(%this) || Vehicle::isSentry(%this));
}

function Vehicle::isSmallChopper(%this)
{
	return (Vehicle::isApache(%this) || Vehicle::isKiowa(%this));
}

function Vehicle::isMediumChopper(%this)
{
	return (Vehicle::isBlackhawk(%this) || Vehicle::isHind(%this));
}

function Vehicle::isOnePersonCraft(%this)
{
	return (Vehicle::isFalcon(%this) || Vehicle::isTomcat(%this) || Vehicle::isWarthog(%this) 
		|| Vehicle::isBomber(%this) || Vehicle::isSentry(%this) || Vehicle::isApache(%this)
		|| Vehicle::isKiowa(%this));
}

// Turns out these functions are completely unnecessary.
// Call whenever you change the rotation or position of a vehicle.
// **P Has to be called before the rotation/position change**
function Vehicle::SwapSeekingMissiles::P(%vehicle)
{
//	
//	if(!$Vehicle::MissileGroup[%vehicle] || $Vehicle::MissileGroup[%vehicle] == "" 
//	 || $Vehicle::MissileGroup[%vehicle] == -1 || $Vehicle::MissileGroup[%vehicle] == 0)
//	{
//		// No group? Then no missiles to swap.
//		return;
//	}
//
//	%MCount = Group::objectCount($Vehicle::MissileGroup[%vehicle]);
//	for(%x=%MCount-1;%x<0;%x--)
//	{
//		// For each Missile
//		%missile = Group::getObject(%group,%x);
//
//		// Potential crash
//		%rotation = GameBase::getRotation(%missile); // get rotation of object...
//		%velocity = Item::getVelocity(%missile); // get velocity of object...
//		%position = Gamebase::Getposition(%missile);
//		%transform = "0 0 0 0 0 0 "@ %rotation @" "@ %position; // make the transform for the new object...
//
//		$Vehicle::MissileInfo[%vehicle,%x] = %transform@":"@ %missile.owner@":"@%missile.name;
//		deleteObject(%missile);
//	}
//	$Vehicle::MissileCount[%Vehicle] = %MCount;
}

// **V Has to be called after the rotation/position change**
function Vehicle::SwapSeekingMissiles::V(%vehicle)
{
//	%MCount = $Vehicle::MissileCount[%vehicle];
//	$Vehicle::MissileCount[%vehicle] = "";
//	
//	for(%x=0;%x<%MCount;%x++)
//	{
//		%info = $Vehicle::MissileInfo[%vehicle,%x];
//		%transform = String::getSubStr(%info,0,String::findSubStr(%info,":"));
//		%info = String::getSubStr(%info,String::length(%transform)+1,String::length(%info));
//		%owner = String::getSubStr(%info,0,String::findSubStr(%info,":"));
//		%name = String::getSubStr(%info,String::length(%transform)+1,String::length(%info));
//
//		%proj = Projectile::spawnProjectile(%name, %transform, %owner, "0 0 0", %vehicle); // spawn new seeking projectile
//		Vehicle::AddSeekingMissile(%Vehicle,%proj);
//	}
}

function Vehicle::SwapSeekingMissiles(%oldVeh,%newVeh)
{
	// Abort if we're plummeting.
//	if($plummeting[%oldVeh] == 1)
//	{
//		return;
//	}

	for(%x=%oldVeh.missileCount-1;%x>=0;%x--)
	{
		// For each Missile
		%missile = %oldVeh.missiles[%x];

		if(isObject(%missile) && getObjectType(%missile) == SeekingMissile && gamebase::Getposition(%missile) != "0 0 0")
		{
			// Potential crash

			// When we face a certain direction and straight up, or straight down,
			// this simple gamebase::getrotation call can cause an asin error.
			// As a result, we'll have to grab our rotation from our velocity.
			%rotation = Vector::add(Vector::getRotation(item::getVelocity(%missile)),"1.570796327 0 0");
			//%rotation = GameBase::getRotation(%missile); // get rotation of object...
			%velocity = Item::getVelocity(%missile); // get velocity of object...
			%position = Gamebase::Getposition(%missile);
			%transform = "0 0 0 0 0 0 "@ %rotation @" "@ %position; // make the transform for the new object...
echo("Missile Swap:   " @ %transform);	

// If there are *any* "NAN" in here, we need to replace them
			if(String::findSubStr(%transform, "+NAN") != -1)
			{
				%transform = String::ReplaceAll(%transform, "+NAN","0");
echo("Missile Swaped: " @ %transform);	
			}
			if(String::findSubStr(%transform, "-NAN") != -1)
			{
				%transform = String::ReplaceAll(%transform, "-NAN","0");
echo("Missile Swaped: " @ %transform);	
			}

			%proj = Projectile::spawnProjectile(%missile.name, %transform, %missile.owner, %velocity, %newVeh); // spawn new seeking projectile
			%proj.owner = %missile.owner;
			%proj.name = %missile.name;

			Vehicle::AddSeekingMissile(%newVeh,%proj);
	
			deleteObject(%missile);
			%oldVeh.missiles[%x] = "";
			%oldVeh.missileCount--;
		}
	}
}


// VEHICLE NEEDS TO BE VEHICLE OBJ, NOT CLIENT OBJ
function Vehicle::AddSeekingMissile(%Vehicle,%Missile)
{
	if(%vehicle.missileCount == "")
		%vehicle.missileCount = 0;
	%vehicle.missiles[%vehicle.missileCount] = %missile;
	%vehicle.missileCount++;

}

function Vehicle::RemoveSeekingMissile(%Vehicle,%missile)
{
	%done = false;
	for(%x=%vehicle.missileCount;%x>=0 && !%done;%x--)
	{
		if(%vehicle.missiles[%x] == %missile)
		{
			for(%pack = %x;%pack <= %vehicle.missileCount; %pack++)
			{
				%vehicle.missiles[%pack] = %vehicle.missiles[(%pack)+1];
			}
			%vehicle.missileCount--;
			%done = true;
		}
	}
}

function String::replaceAll(%string, %search, %replace)
{
	
	%loc = String::findSubStr(%string, %search);

	while(%loc != -1)
	{
		%ls = String::QuickLen(%search);

		%part1 = String::getSubStr(%string, 0, %loc);
		%part2 = String::getSubStr(%string, %loc + %ls, 99999);

		%string = %part1 @ %replace @ %part2;
		%loc = String::findSubStr(%string, %search);
	}

	return %string;
}

function String::quickLen(%string)
{
	%len = 0;
	for(%k = 0; String::getSubStr(%string, %k, 1) != ""; %k++)
		%len++;
	return %len;
}