// NewClockHud.acs.cs
// Well erm - it's just a clockHUD. That's it.
// weee.

$ClockHud::DefaultPosition = "-1%+5 88%";
$ClockHud::DefaultSize = "70 16";

include("presto\\event.cs");

function remoteSetTime(%s, %t) {
	if (%s == 2048) {
		setHudTimer(%t);
		
		Event::Trigger(eventUpdateTime, Time::GetMinutes((%t+1) * -1), Time::GetSeconds((%t+1) * -1));
	}	
}

function ClockHud::Update(%min, %sec) {
	$ClockHud::Hour = floor(%min / 60);
	$ClockHud::Min = %min % 60;
	$clockHud::Sec = %sec;

	$ClockHud::CountingDown = true;

	schedule::add("ClockHud::Iterate();", 1);
	Hud::Update(ClockHud);
}
Event::Attach(eventUpdateTime, ClockHud::Update);

function ClockHud::SetReverse(%client, %msg) {
	if ((!%client) && (%msg == "Match started.")) {
		$ClockHud::Hour = $ClockHud::Min = $clockHud::Sec = 0;
		$ClockHud::CountingDown = false;
	}
}
Event::Attach(eventClientMessage, ClockHud::SetReverse);

function LZero(%number) {
	if (%number < 10) return "0" @ %number;
	else return %number;
}

function ClockHud::Display(%hud) {
	Hud::AddText(%hud, "<f2>" @ LZero($ClockHud::Hour) @ ":" @ LZero($ClockHud::Min) @ ":" @ LZero($ClockHud::Sec));
	return 0;	
}

function ClockHud::Iterate() {
	if ($ClockHud::CountingDown) {
		if ($ClockHud::Sec > 0) {
			$ClockHud::Sec--;
		}
		else {
			$ClockHud::Sec = 59;
		
			if ($ClockHud::Min > 0) {
				$ClockHud::Min--;
			}
			else {
				$ClockHud::Min = 59;
				$ClockHud::Hour--;
			}
		}
	} else {
		if ($ClockHud::Sec < 59) {
			$ClockHud::Sec++;
		}
		else {
			$ClockHud::Sec = 0;
		
			if ($ClockHud::Min < 59) {
				$ClockHud::Min++;
			}
			else {
				$ClockHud::Min = 0;
				$ClockHud::Hour++;
			}
		}
	}
	schedule::add("ClockHud::Iterate();", 1);
	Hud::Update(ClockHud);
}

function ClockHud::Init() {
	$ClockHud::Hour = $ClockHud::Min = $clockHud::Sec = 0;
	schedule::add("ClockHud::Iterate();", 1);
}
event::attach(eventConnected, ClockHud::Init);

Hud::New(ClockHud, ClockHud::Display, $ClockHud::DefaultPosition @ " " @ $ClockHud::DefaultSize);
Hud::Display(ClockHud);