//=======================================================================================
// Power down announcement - by Mental Trousers as part of the Tribes scripting documents
// at http://planetstarsiege.com/mt/
//=======================================================================================
//
// This is just a single, automated message, activated when you walk up to an inventory,
// command, ammo station when the power is down. There is no other way to know if the
// generators are up, at least not from the client side.
//=======================================================================================

//=======================================================================================
// Power down announcement. Repeats after 5 seconds
//=======================================================================================
function powerDown::powerMessage ()
{
//	echo ("function powerDown::powerMessage ()");

	if ($powerDown)
		say (1, "** Our power is down **~wneedrep");
	return;
}

//=======================================================================================
// Tell the team the power is down. 5 second delay before it is announced again, just in
// case they didn't get it the first time
//=======================================================================================
function powerDown::powerDown ()
{
//	echo ("function powerDown::powerDown ()");

	$powerDown=True;
	powerDown::powerMessage ();
	schedule ("powerDown::powerMessage ();",5);
	schedule ("$powerDown=False;",5);	
	return;
}

//=======================================================================================
// This is where everything is caught :)
//=======================================================================================
function powerDown::clientMessage (%client, %msg)
{
	if (String::findSubStr(%msg, "Unit is not powered")!=-1&&!$powerDown)
		powerDown::powerDown ();
	return;
}

$powerDown=false;
event::attach (eventClientMessage, powerDown::clientMessage, %client, %msg);