$TeamItemMax[SatPack] = 1;
$TeamItemMax[SatTurret] = 1;
$InvList[SatPack] = 1;

$ItemMax[larmor, SatPack] = 0;
$ItemMax[qarmor, SatPack] = 0;
$ItemMax[srarmor, SatPack] = 0;
$ItemMax[sarmor, SatPack] = 0;
$ItemMax[marmor, SatPack] = 1;
$ItemMax[parmor, SatPack] = 0;
$ItemMax[harmor, SatPack] = 0;
$ItemMax[tarmor, SatPack] = 0;
$ItemMax[lfemale, SatPack] = 0;
$ItemMax[qfemale, SatPack] = 0;
$ItemMax[srfemale, SatPack] = 0;
$ItemMax[sfemale, SatPack] = 0;
$ItemMax[mfemale, SatPack] = 1;
$ItemMax[pfemale, SatPack] = 0;
$ItemMax[psarmor, SatPack] = 0;

ItemImageData SatPackImage
{
	shapeFile = "magCargo";
	mountPoint = 2;
	mountOffset = { 0, -0.1, -0.06 };
	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData SatPack
{
	description = "Satelite";
	shapeFile = "magCargo";
	className = "Backpack";
	heading = "yDevastator";
	imageType = SatPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 90000;
	hudIcon = "EnergyPack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

ItemData SatTurret
{
	shapeFile = "sat_big";
	maxDamage = 0.65;
	maxEnergy = 60;
	mass = 0.0;
	visibleToSensor = true;
	shadowDetailMask = 4;
	castLOS = true;
	mapFilter = 2;
	mapIcon = "M_turret";
	debrisId = flashDebrisMedium;
	explosionId = flashExpMedium;
	description = "Devastator";
};

function SatTurret::onAdd(%this)
{
	GameBase::setRechargeRate(%this,0.005);
	%this.shieldStrength = 1.0;
}

function SatTurret::onDestroyed(%this)
{
  	$TeamItemCount[GameBase::getTeam(%this) @ "SatPack"]--;
}

function SatPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
		Player::mountItem(%player,%item,$BackpackSlot);
	else
		Player::deployItem(%player,%item);
}

function SatPack::onMount(%player,%item)
{
	%client = Player::getClient(%player);
	Bottomprint(%client, "<jc> The Devastator Satelite is the deadliest mobile weapons sattelite on the planet.");
}

function SatPack::onDeploy(%player,%item)
{
	if(SatPack::deployShape(%player,%item))
		Player::decItemCount(%player,%item);
}

function SatPack::DeployShape(%player,%item)
{
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if(GameBase::getLOSInfo(%player,3)) {
			%obj = getObjectType($los::object);
			if(%obj == "SimTerrain") {
				%rot = "1.570796 0 0";
				if(LOSCheck(%player, 10000, %rot) == FALSE) {
					if(checkDeployArea(%client,$los::position)) {
						Player::decItemCount(%player,%item);
						%obj = newObject("Devastator","Item","SatTurret",1,false);
						addToSet("MissionCleanup", %obj);
						%client = Player::getClient(%player);
						GameBase::throw(%obj,%player,15,false);
						%position = GameBase::getPosition(%obj);
						%NewZ = Vector::add(%position,"0 0 200");
						GameBase::setPosition(%obj, %NewZ);
					}
				}
				else
					Client::sendMessage(%client,0,"You can only deploy outdoors.");
			}
			else
				Client::sendMessage(%client,0,"You can only deploy outdoors.");
		}
		else
			Client::sendMessage(%client,0,"You can only deploy one " @ %item.description @ "s");
	}
	return false;
}