// DELTA FORCE ADDED TURRETS
// --------------------------------------------------------

TurretData DeployableSAM
{
	maxDamage = 0.75;
	maxEnergy = 100;
	minGunEnergy = 60;
	maxGunEnergy = 60;
	range = 150;
	gunRange = 300;
	visibleToSensor = true;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	debrisId = defaultDebrisLarge;
	className = "Turret";
	shapeFile = "missileturret";
	shieldShapeName = "shield_medium";
	speed = 2.0;
	speedModifier = 2.0;
	projectileType = TurretMissile;
	reloadDelay = 3.5;
	fireSound = SoundMissileTurretFire;
	activationSound = SoundMissileTurretOn;
	deactivateSound = SoundMissileTurretOff;
	whirSound = SoundMissileTurretTurn;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
   targetableFovRatio = 0.5;
	explosionId = LargeShockwave;
	description = "SAM Launcher";
};

function DeployableSAM::verifyTarget(%this,%target)
{
   if (GameBase::virtual(%target, "getHeatFactor") >= 0.5)
      return "True";
   else
      return "False";
}

function DeployableSAM::onAdd(%this)
{
	schedule("DeployableSAM::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,5);
	%this.shieldStrength = 0;
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "SAM Launcher");
	}
}

function DeployableSAM::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function DeployableSAM::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function DeployableSAM::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "SAMPack"]--;
}

// Override base class just in case.
function DeployableSAM::onPower(%this,%power,%generator) 
{
	if (%power) {
		%this.shieldStrength = 0.03;
		GameBase::setRechargeRate(%this,14);
	}
	else {
		%this.shieldStrength = 0;
		GameBase::setRechargeRate(%this,0);
		Turret::checkOperator(%this);
	}
	GameBase::setActive(%this,%power);
}

function DeployableSAM::onEnabled(%this) 
{
	GameBase::setRechargeRate(%this,5);
	GameBase::setActive(%this,true);
}

// ---------------------------------------------------

TurretData DeployablePlasma { 
	className = "Turret"; 
	shapeFile = "hellfiregun"; 
	projectileType = NATOBullet; 
	maxDamage = 1.0; 
	maxEnergy = 125; 
	minGunEnergy = 75; 
	maxGunEnergy = 6; 
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor }; 
	reloadDelay = 0.2; 
	speed = 2.0; 
	speedModifier = 1.5; 
	range = 100; 
	visibleToSensor = true; 
	shadowDetailMask = 4; 
	dopplerVelocity = 0; 
	castLOS = true; 
	supression = false; 
	mapFilter = 2; 
	mapIcon = "M_turret"; 
	debrisId = flashDebrisMedium; 
	shieldShapeName = "shield"; 
	fireSound = SoundMortarTurretFire; 
	activationSound = SoundPlasmaTurretOn; 
	deactivateSound = SoundPlasmaTurretOff; 
	whirSound = SoundPlasmaTurretTurn; 
	explosionId = flashExpMedium; 
	description = "20mm Cannon Turret"; 
	damageSkinData = "objectDamageSkins"; 
}; 

function DeployablePlasma::onAdd(%this) { 
	schedule("DeployablePlasma::deploy(" @ %this @ ");",1,%this); 
	GameBase::setRechargeRate(%this,5); 
	%this.shieldStrength = 0.010; 
	if (GameBase::getMapName(%this) == "") { 
	GameBase::setMapName (%this, "20mm Cannon Turret"); 
} 
} 

function DeployablePlasma::deploy(%this) { 
	GameBase::playSequence(%this,1,"deploy"); 
} 

function DeployablePlasma::onEndSequence(%this,%thread) { 
	// GameBase::setActive(%this,true); 
} 

function DeployablePlasma::onDestroyed(%this) { 
	StaticShape::objectiveDestroyed(%this); 
	%this.shieldStrength = 0; 
	GameBase::setRechargeRate(%this,0); 
	Turret::onDeactivate(%this); 
	Turret::objectiveDestroyed(%this); 
	CalcRadiusDamage(%this,$DebrisDamageType,20,0.2,25,20,20,2.5,1.1,200,100); 
	$TeamItemCount[GameBase::getTeam(%this) @ "TwentyPack"]--; 
} 

function DeployablePlasma::onPower(%this,%power,%generator) {
	Turret::checkOperator(%this);
} 

function DeployablePlasma::onEnabled(%this) { 
	%this.shieldStrength = 0.03;
	GameBase::setRechargeRate(%this,5); 
	// GameBase::setActive(%this,true); 
} 

//TurretData DeployablePlasmaTurret
//{
//	maxDamage = 1.0;
//	maxEnergy = 100;
//	minGunEnergy = 75;
//	maxGunEnergy = 6;
//	reloadDelay = 0.2;
//	fireSound = SoundChaingunFire;
//	activationSound = SoundPlasmaTurretOn;
//	deactivateSound = SoundPlasmaTurretOff;
//	whirSound = SoundPlasmaTurretTurn;
//	range = 50;
//	dopplerVelocity = 0;
//	castLOS = true;
//	supression = false;
//	mapFilter = 2;
//	mapIcon = "M_turret";
//	visibleToSensor = true;
//	debrisId = defaultDebrisMedium;
//	className = "Turret";
//	shapeFile = "hellfiregun";
//	shieldShapeName = "shield_medium";
///	speed = 2.0;
///	speedModifier = 2.0;
//	projectileType = NATOBullet;
//	damageSkinData = "objectDamageSkins";
//	shadowDetailMask = 8;
//	explosionId = LargeShockwave;
//	description = "20mm Cannon Turret";
//};

//function DeployablePlasmaTurret::onAdd(%this)
//{
//	schedule("DeployablePlasmaTurret::deploy(" @ %this @ ");",1,%this);
//	GameBase::setRechargeRate(%this,5);
//	%this.shieldStrength = 0;
//	if (GameBase::getMapName(%this) == "") {
//		GameBase::setMapName (%this, "20mm Cannon");
//	}
//}

//function DeployablePlasmaTurret::deploy(%this)
//{
//	GameBase::playSequence(%this,1,"deploy");
//}

//function DeployablePlasmaTurret::onEndSequence(%this,%thread)
//{
//	GameBase::setActive(%this,true);
//}

//function DeployablePlasmaTurret::onDestroyed(%this)
//{
//	Turret::onDestroyed(%this);
 // 	$TeamItemCount[GameBase::getTeam(%this) @ "TwentyPack"]--;
//}

// Override base class just in case.
//function DeployablePlasmaTurret::onPower(%this,%power,%generator) 
//{
//	if (%power) {
//		%this.shieldStrength = 0.03;
//		GameBase::setRechargeRate(%this,14);
//	}
//	else {
//		%this.shieldStrength = 0;
//		GameBase::setRechargeRate(%this,0);
//		Turret::checkOperator(%this);
//	}
//	GameBase::setActive(%this,%power);
//}

//function DeployablePlasmaTurret::onEnabled(%this) 
//{
//	GameBase::setRechargeRate(%this,5);
//	GameBase::setActive(%this,true);
//}
	
// ---------------------------------------------------------------------

TurretData DeployableMortar { 
      className = "Turret"; 
      shapeFile = "mortar_turret"; 
      projectileType = HowitzerShell; 
      maxDamage = 1.0; 
      maxEnergy = 45; 
      minGunEnergy = 45; 
	maxGunEnergy = 100; 
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor }; 
	reloadDelay = 2.0; 
	speed = 2.0; 
	speedModifier = 1.5; 
	range = 0; 
	visibleToSensor = true; 
	shadowDetailMask = 4; 
	dopplerVelocity = 0; 
	castLOS = true; 
	supression = false; 
	mapFilter = 2; 
	mapIcon = "M_turret"; 
	debrisId = flashDebrisMedium; 
	shieldShapeName = "shield"; 
	fireSound = SoundMortarTurretFire; 
	activationSound = SoundMortarTurretOn; 
	deactivateSound = SoundMortarTurretOff; 
	whirSound = SoundMortarTurretTurn; 
	explosionId = LargeShockwave; 
	description = "Howitzer"; 
	damageSkinData = "objectDamageSkins"; 
}; 

function DeployableMortar::onAdd(%this) { 
	schedule("DeployableMortar::deploy(" @ %this @ ");",1, this); 
	GameBase::setRechargeRate(%this,7); 
	%this.shieldStrength = 0.005; 
	if (GameBase::getMapName(%this) == "") { 
		GameBase::setMapName (%this, "Howitzer"); 
	} 
} 

function DeployableMortar::deploy(%this) { 
	GameBase::playSequence(%this,1,"deploy"); 
} 

function DeployableMortar::onEndSequence(%this,%thread) { 	
	GameBase::setActive(%this,true);
} 

function DeployableMortar::onDestroyed(%this) { 
	Turret::onDestroyed(%this); 
	$TeamItemCount[GameBase::getTeam(%this) @ "HowitzerPack"]--; 
} 

function DeployableMortar::onPower(%this,%power,%generator) {
	Turret::checkOperator(%this);
} 

function DeployableMortar::onEnabled(%this) { 
	GameBase::setRechargeRate(%this,7);
	GameBase::setActive(%this,true); 
} 

// END DELTA FORCE ADDED TURRETS
// -----------------------------------------------------

//----------------------------------------------------------------------------
// TURRET DYNAMIC DATA

TurretData PlasmaTurret
{
	maxDamage = 1.0;
	maxEnergy = 125;
	minGunEnergy = 75;
	maxGunEnergy = 6;
	reloadDelay = 0.2;
	fireSound = SoundMortarTurretFire;
	activationSound = SoundPlasmaTurretOn;
	deactivateSound = SoundPlasmaTurretOff;
	whirSound = SoundPlasmaTurretTurn;
	range = 100;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	visibleToSensor = true;
	debrisId = defaultDebrisMedium;
	className = "Turret";
	shapeFile = "hellfiregun";
	shieldShapeName = "shield_medium";
	speed = 2.0;
	speedModifier = 2.0;
	projectileType = NATOBullet;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	explosionId = LargeShockwave;
	description = "20mm Cannon";
};

// DELTA FORCE

function PlasmaTurret::onPower(%this,%power,%generator)
{
	if (%power) {
		%this.shieldStrength = 0.03;
		GameBase::setRechargeRate(%this,10);
	}
	else {
		%this.shieldStrength = 0;
		GameBase::setRechargeRate(%this,0);
		Turret::checkOperator(%this);
	}
	// GameBase::setActive(%this,%power);
}

function PlasmaTurret::onEnabled(%this)
{
	if (GameBase::isPowered(%this)) {
		%this.shieldStrength = 0.03;
		GameBase::setRechargeRate(%this,10);
		// GameBase::setActive(%this,true);
	}
}

// END DELTA FORCE
																						 
TurretData ELFTurret	   
{			 
	maxDamage = 1.0;
	maxEnergy = 150;
	minGunEnergy = 50;
	maxGunEnergy = 5;
	range = 40;
	visibleToSensor = true;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	debrisId = defaultDebrisMedium;
	className = "ELF Turret";
	shapeFile = "chainturret";
	shieldShapeName = "shield";
	speed = 5.0;
	speedModifier = 1.5;
	projectileType = turretCharge;
	reloadDelay = 0.3;
	explosionId = LargeShockwave;
	description = "ELF Turret";

	fireSound        = SoundGeneratorPower;
	activationSound  = SoundChainTurretOn;
	deactivateSound  = SoundChainTurretOff;
	damageSkinData   = "objectDamageSkins";
	shadowDetailMask = 8;

   isSustained     = true;
   firingTimeMS    = 750;
   energyRate      = 30.0;
};

TurretData RocketTurret
{
	maxDamage = 0.75;
	maxEnergy = 100;
	minGunEnergy = 60;
	maxGunEnergy = 60;
	range = 150;
	gunRange = 300;
	visibleToSensor = true;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	debrisId = defaultDebrisLarge;
	className = "Turret";
	shapeFile = "missileturret";
	shieldShapeName = "shield_medium";
	speed = 2.0;
	speedModifier = 2.0;
	projectileType = TurretMissile;
//	reloadDelay = 3.5;
	fireSound = SoundMissileTurretFire;
	activationSound = SoundMissileTurretOn;
	deactivateSound = SoundMissileTurretOff;
//	whirSound = SoundMissileTurretTurn;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
   targetableFovRatio = 0.5;
	explosionId = LargeShockwave;
	description = "SAM Emplacement";
};

function RocketTurret::onPower(%this,%power,%generator)
{
	if (%power) {
		%this.shieldStrength = 0.03;
		GameBase::setRechargeRate(%this,14);
	}
	else {
		%this.shieldStrength = 0;
		GameBase::setRechargeRate(%this,0);
		Turret::checkOperator(%this);
	}
	GameBase::setActive(%this,%power);
}

function RocketTurret::verifyTarget(%this,%target)
{
   if (GameBase::virtual(%target, "getHeatFactor") >= 0.5)
      return "True";
   else
      return "False";
}

//--------------------------------------------

TurretData MortarTurret
{
	maxDamage = 1.0;
	maxEnergy = 45;
	minGunEnergy = 45;
	maxGunEnergy = 100;
	reloadDelay = 2.0;
	fireSound = SoundMortarTurretFire;
	activationSound = SoundMortarTurretOn;
	deactivateSound = SoundMortarTurretOff;
	whirSound = SoundMortarTurretTurn;
	range = 0;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	visibleToSensor = true;
	debrisId = defaultDebrisMedium;
	className = "Turret";
	shapeFile = "mortar_turret";
	shieldShapeName = "shield_medium";
	speed = 2.0;
	speedModifier = 2.0;
	projectileType = HowitzerShell;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	explosionId = LargeShockwave;
	description = "Howitzer";
};
																						 
//--------------------------------------------

TurretData IndoorTurret
{
	className = "Turret";
	shapeFile = "indoorgun";
	projectileType = SAWBullet;
	maxDamage = 2.5;
	maxEnergy = 60;
	minGunEnergy = 20;
	maxGunEnergy = 6;
	reloadDelay = 0.4;
	speed = 5.0;
	speedModifier = 1.0;
	range = 25;
	visibleToSensor = true;
	dopplerVelocity = 2;
	castLOS = true;
	supression = false;
	supressable = false;
	pinger = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	debrisId = defaultDebrisMedium;
	shieldShapeName = "shield";
	fireSound = SoundMortarTurretFire;
	activationSound = SoundEnergyTurretOn;
	deactivateSound = SoundEnergyTurretOff;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	explosionId = debrisExpMedium;
	description = "Indoor Machine Gun";

};


//--------------------------------------------

TurretData DeployableTurret
{
	className = "Turret";
	shapeFile = "remoteturret";
	projectileType = SAWBullet;
	maxDamage = 0.65;
	maxEnergy = 60;
	minGunEnergy = 6;
	maxGunEnergy = 5;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	reloadDelay = 0.4;
	speed = 4.0;
	speedModifier = 1.5;
	range = 30;
	visibleToSensor = true;
	shadowDetailMask = 4;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	debrisId = flashDebrisMedium;
	shieldShapeName = "shield";
	fireSound = SoundMortarTurretFire;
	activationSound = SoundRemoteTurretOn;
	deactivateSound = SoundRemoteTurretOff;
	explosionId = flashExpMedium;
	description = "Remote Machine Gun";
	damageSkinData = "objectDamageSkins";
};

function DeployableTurret::onAdd(%this)
{
	schedule("DeployableTurret::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,5);
	%this.shieldStrength = 0;
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "Remote Machine Gun");
	}
}

function DeployableTurret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function DeployableTurret::onEndSequence(%this,%thread)
{
	//GameBase::setActive(%this,true);
}

function DeployableTurret::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "TurretPack"]--;
}

// Override base class just in case.
function DeployableTurret::onPower(%this,%power,%generator) {}
function DeployableTurret::onEnabled(%this) 
{
	GameBase::setRechargeRate(%this,5);
	//GameBase::setActive(%this,true);
}	


//--------------------------------------------

TurretData CameraTurret
{
	className = "Turret";
	shapeFile = "camera";
	maxDamage = 0.25;
	maxEnergy = 10;
	speed = 20;
	speedModifier = 1.0;
	range = 50;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	visibleToSensor = true;
	shadowDetailMask = 4;
	castLOS = true;
	supression = false;
	supressable = false;
	mapFilter = 2;
	mapIcon = "M_camera";
	debrisId = defaultDebrisSmall;
	FOV = 0.707;
	pinger = false;
	explosionId = debrisExpMedium;
	description = "Camera";
};

function CameraTurret::onAdd(%this)
{
	schedule("CameraTurret::deploy(" @ %this @ ");",1,%this);
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "Camera");
	}
}

function CameraTurret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function CameraTurret::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function CameraTurret::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "CameraPack"]--;
}	


//---------------------------------------------------

function Turret::onAdd(%this)
{
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "Turret");
	}
}

function Turret::onActivate(%this)
{
	GameBase::playSequence(%this,0,power);
}

function Turret::onDeactivate(%this)
{
	GameBase::stopSequence(%this,0);
	Turret::checkOperator(%this);
}

function Turret::onSetTeam(%this,%oldTeam)
{
	if(GameBase::getTeam(%this) != Client::getTeam(GameBase::getControlClient(%this))) 
		Turret::checkOperator(%this);

}

function Turret::checkOperator(%this)
{
	%cl = GameBase::getControlClient(%this);
	if(%cl != -1) {
		%pl = Client::getOwnedObject(%cl);
		Player::setMountObject(%pl, -1,0);
		Client::setControlObject(%cl, %pl);
   	}
   	Client::setGuiMode(%cl,2);
}

function Turret::onPower(%this,%power,%generator)
{
	if (%power) {
		%this.shieldStrength = 0.03;
		GameBase::setRechargeRate(%this,10);
	}
	else {
		%this.shieldStrength = 0;
		GameBase::setRechargeRate(%this,0);
		Turret::checkOperator(%this);
	}
	GameBase::setActive(%this,%power);
}

function Turret::onEnabled(%this)
{
	if (GameBase::isPowered(%this)) {
		%this.shieldStrength = 0.03;
		GameBase::setRechargeRate(%this,10);
		GameBase::setActive(%this,true);
	}
}

function Turret::onDisabled(%this)
{
	%this.shieldStrength = 0;
	GameBase::setRechargeRate(%this,0);
	Turret::onDeactivate(%this);
}

function Turret::onDestroyed(%this)
{
	StaticShape::objectiveDestroyed(%this);
	%this.shieldStrength = 0;
	GameBase::setRechargeRate(%this,0);
	Turret::onDeactivate(%this);
	Turret::objectiveDestroyed(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 9, 3, 0.40, 
		0.1, 200, 100); 
}

function Turret::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
   if(%this.objectiveLine)
		%this.lastDamageTeam = GameBase::getTeam(%object);
	%TDS= 1;
	if(GameBase::getTeam(%this) == GameBase::getTeam(%object)) {
		%name = GameBase::getDataName(%this);
		if(%name != DeployableTurret && %name != CameraTurret )	
			%TDS = $Server::TeamDamageScale;
	}
	StaticShape::shieldDamage(%this,%type,%value * %TDS,%pos,%vec,%mom,%object);
}

function Turret::onControl (%this, %object)
{
	%client = Player::getClient(%object);
	Client::sendMessage(%client,0,"Controlling turret " @ %this);
	$turretTime[%this] = 1;
}

function Turret::onDismount (%this, %object)
{
	%name = Gamebase::getDataName(%this);
	%client = Player::getClient(%object);
	Client::sendMessage(%client,0,"Leaving turret " @ %this);
	if (%name == DeployableMortar || %name == MortarTurret) Gamebase::startFadeIn(%object);
	$turretTime[%this] = 0;
	startGracePeriod(%clientId, %player);
}

function Turret::onCollision (%this, %object) { 
	//if(getObjectType (%object) == "Player") { 
	//	%armor = Player::getArmor(%object); 
	//	if ( (Player::getMountedItem(%object,$BackpackSlot) == Laptop) ) { 
	//		%name = GameBase::getDataName(%this); 
	//		if(%name == DeployableMortar || %name == DeployablePlasma || %name == DeployableSAM || %name == MortarTurret) { 
	//			%client = Player::getClient(%object); 
	//			if($gracePeriod[%client] == 0) { 
	//				if(GameBase::GetPosition(%this) != GameBase::GetPosition(%object)) { 
	//					Client::getOwnedObject(%client).CommandTag = 1; 
	//					Client::sendMessage(%client,0,"Re-programming turret"); 
	//					GameBase::setTeam (%this,GameBase::getTeam (%client));
	//					Client::takeControl(%client, %this); 
	//					if(%name == DeployablePlasma || %name == DeployableVulcan || %name == DeployableRail ) GameBase::SetPosition(%object,GameBase::GetPosition(%this)); 
	//					return; 
	//				} 
	//			} else Client::sendMessage(%client,0,"Turret is cooling down."); 
	//		} 
	//	} 
	//} 
	if(getObjectType (%object) == "Player") { 
		%armor = Player::getArmor(%object); 
		if (%armor != "aarmor") { 
			if(GameBase::getTeam(%object) == GameBase::getTeam(%this)) {
				//if(GameBase::isPowered(%this)) { 
					%client = Player::getClient(%object); 
					if($gracePeriod[%client] == 0) { 
						%name = GameBase::getDataName(%this); 
						if(%name == DeployablePlasma || %name == DeployableMortar || %name == MortarTurret || %name == PlasmaTurret) { 
							if(GameBase::GetPosition(%this) != GameBase::GetPosition(%object)) { 
								Client::getOwnedObject(%client).CommandTag = 1; 
								Client::sendMessage(%client,0,"Manually controlling turret"); 
								Client::takeControl(%client, %this); 
								GameBase::SetPosition(%object,GameBase::GetPosition(%this));
								if(%name == DeployableMortar || %name == MortarTurret) Gamebase::startFadeOut(%object);
								return; 
							} 
						} 
					} else Client::sendMessage(%client,0,"Turret is cooling down.");
				//} else Client::sendMessage(%client,0,"Turret is not powered."); 
			} else Client::sendMessage(%client,0,"--ACCESS DENIED-- Wrong Team ~waccess_denied.wav"); 
		} else Client::sendMessage(%client,0,"Can not manually command turrets in this class."); 
	}
}

function startGracePeriod(%clientId, %player) { 
	Player::unmountItem(%player,$WeaponSlot); 
	if($gracePeriod[%clientId] == 0) {
		Client::getOwnedObject(%clientId).CommandTag = ""; 
		$gracePeriod[%clientId] = 14; 
		checkGracePeriod(%clientId, %player); 
	} else $gracePeriod[%clientId] = 14; 
}

function checkGracePeriod(%clientId, %player) { 
	if($gracePeriod[%clientId] > 0) { 
		$gracePeriod[%clientId] -= 2; 
		schedule("checkGracePeriod(" @ %clientId @ ", " @ %player @ ");",2,%player); 
	}
}