//---------------------------------------------------------
// VR terrain file
//---------------------------------------------------------

// the terrain types for this world
function Terrain::VR::setTypes()
{
	LS::flushTypes();

   LS::addTerrainType(G, "1 - Green Floor" );
}

// default rules for this world type
function Terrain::VR::setRules()
{
   LS::flushRules();

   LS::addRule(G,  0.0, 600.0,   50.0, 0.50,0.25,0,0.00, 3.00, 0.05, 0.50,0.50,  0); 
}

// create the grid file and dml for this world
function Terrain::VR::createGridFile()
{
   LS::flushTextures();
   Terrain::VR::setTypes();

   LS::addTerrainTexture("vr.gggg.BMP",         GGGG, $FP|$FR|$FXY|$FXYR, 90, $TERRAIN_VR | $TS3_PackedEarthType, 0.5, 1.0);
   LS::addTerrainTexture("vr.gggg2.BMP",        GGGG, $FP|$FR|$FXY|$FXYR, 10, $TERRAIN_VR | $TS3_PackedEarthType, 0.5, 1.0);
   LS::addTerrainTexture("vr.paved1.BMP",       GGGG, $FP|$FR|$FXY|$FXYR,  0, $TERRAIN_VR | $TS3_PackedEarthType, 0.5, 1.0);
   LS::addTerrainTexture("vr.paved2.BMP",       GGGG, $FP|$FR|$FXY|$FXYR,  0, $TERRAIN_VR | $TS3_PackedEarthType, 0.5, 1.0);
   LS::addTerrainTexture("vr.paved3.BMP",       GGGG, $FP|$FR|$FXY|$FXYR,  0, $TERRAIN_VR | $TS3_PackedEarthType, 0.5, 1.0);
   LS::addTerrainTexture("vr.bbbb.BMP",         GGGG, $FP|$FR|$FXY|$FXYR,  0, $TERRAIN_VR | $TS3_PackedEarthType, 0.5, 1.0);
   LS::addTerrainTexture("vr.pppp.BMP",         GGGG, $FP|$FR|$FXY|$FXYR,  0, $TERRAIN_VR | $TS3_PackedEarthType, 0.5, 1.0);
   LS::addTerrainTexture("vr.rrrr.BMP",         GGGG, $FP|$FR|$FXY|$FXYR,  0, $TERRAIN_VR | $TS3_PackedEarthType, 0.5, 1.0);
   LS::addTerrainTexture("vr.yyyy.BMP",         GGGG, $FP|$FR|$FXY|$FXYR,  0, $TERRAIN_VR | $TS3_PackedEarthType, 0.5, 1.0);

   // create the dat and dml for this world
   LS::createGridFile("VR.grid.dat", "VR.terrain.dml");
}
