//--------------------------------------------------------------------------------------------------------------------------------------------
  
     //+++++++++++++++++++++++++++++++++++++++
     //                                      \
     // /`````````````````````````````````\  \
     // \   TRIBES ARRAY FUNCTION LIBRARY /  \
     // /   By: WorstAim                  \  \
     // \                                 /  \        <--- Man did I go overboard :\
     // /   Developed Feburary 15th, 2007 \  \
     // \                                 /  \
     //  `````````````````````````````````   \
     //+++++++++++++++++++++++++++++++++++++++
     //
     //
     //
     //
     //
     //
     //
     //
     //
     //
     //
     //
     // 
     //
     //
     //
     //
    //\\
   //||\\
  // || \\
 //__||__\\
//________\\


//---------------------------------------------------------------------------------------------------------------------------------------------

#Defines the max size of an array that you have
#I figure 500 should be enough, but if for some reason you 
#have an array that exceeds this, just change it


$Array::maxSize = 5000;


//---------------------------------------------------------------------------------------------------------------------------------------------










//Do not alter below here unless you know what you're doing, in which case, feel free to alter below here :)

/////////////////////////////////////////////////////////////////////////////////
//
//                   Array Manipulation Functions
//


#...........................................
#        Array Length
#        
# Returns the number of FILLED spots in the array passed as a parameter
# Remember that arrays have zero-indexing, so if you have
# 
# $myArray[0] = "hi";
# $myArray[1] = "bye";
#
# Array::Length("myArray") will return '2'
#
# Note that if you have "gaps" in your array, you need to cleanup the array
# with Array::clean(%array), before this function will be accurate
#
# ex: Array::Length("myArray");
#...........................................


function Array::Length(%array)
{  
   for(%i = 0; (eval("%t = $"@%array@"["@%i@"];")) != ""; %i++)
   { 
   }
   return %i;
   
}


#...........................................
#        Array Delete
#        
# Deletes the array passed as a parameter
#
# ex: Array::delete("myArray");
#
# WARNING: calling Array::delete(%array);
# will also delete any variables you have that
# start with %array.
#
# ex: Array::delete("myArray"); will also
# delete $myArray::maxSize;
# 
# BE CAREFUL
#...........................................

		
function Array::delete(%array)
{
	deleteVariables("$"@%array@"*");
}


#...........................................
#        Array Copy
#        
# Copies the first parameter (%array) into a new
# array with the name of the second parameter (%toArray)
#
# Returns the length of the new array, as well
#
# ex: Array::copy("myArray", "copyOfMyNewArray");
# 
# The following code would now pass
#
# ( $myArray[*] == $copyOfMyNewArray[*] )
#...........................................

function Array::copy(%array, %toArray)
{

	for(%i = 0; (eval("$"@%toArray@"["@%i@"] = $"@%array@"["@%i@"];")) != ""; %i++)
	{
	}

	if(%array == "Temp")
	{
		Array::delete("Temp");
	}

	return %i;
}


#...........................................
#        Array Clean
#        
# Removes all "gaps" from the array passed as a parameter
#
# ex: Array::clean("myArray");
#
# if your array looked like this:
#
# $myArray[0] = 34; $myArray[1] = 53; $myArray[2] = ""; $myArray[3] = ""; $myArray[4] = 25; $myArray[5] = ""; $myArray[6] = 17;
#
# it would look like this after you called Array::clean("myArray");
#
# $myArray[0] = 34; $myArray[1] = 53; $myArray[2] = 25; $myArray[3] = 17;
#
#...........................................


function Array::clean(%array)
{
	%max = 0;

	for(%i = 0; %i < $Array::maxSize; %i++)
	{
		if(eval("%temp = $"@%array@"["@%i@"];") != "")
		{
			eval("$Temp["@%max@"] = $"@%array@"["@%i@"];");
			%max++;
		}
	}
	
	Array::delete(%array);
	Array::copy("Temp", %array);
	Array::delete("Temp");
}




////////////////////////////////////////////////////////////////////////////////////////
//
//                  Array Sorting Functions
//

#...................................
#          Array findSmallest
#
# Finds the smallest element in the Temp Array
# between %j and %n
# 
# Not for use with any array other than $Temp
#...................................

function Array::findSmallest(%j, %n)
{
	%smallest = %j;
	for(%i = %j+1; %i < %n; %i++)
	{
		if(String::compare($Temp[%i], $Temp[%smallest]) == -1)
		{
			%smallest = %i;
		}
	}
	return $Temp[%smallest];
}



#............................................
#              Array swap
# 
# Swaps two elements in the Temp Array
#
# Not for use with any array other than $Temp
#............................................

function Array::swap(%a, %b)
{
	%temp = $Temp[%a];
	$Temp[%a] = $Temp[%b];
	$Temp[%b] = %temp;
}



#.........................................................
#        Bubble Sort - runs @ O(n^2)
#
# Sorts the array given as a parameter, in ascending order (lowest to highest)
# Not recommended for sorting arrays when Array::length(%array) > 10
#
# Actually, I can't recommend it at all because it's a terrible algorithm
# but it's here just for completion of the array library
#
# Returns the length of the array, as well
#.........................................................


function Array::bubbleSort(%array)
{
	%i = Array::copy(%array, "Temp");
	
	for(%j = 0; %j < %i; %j++)
	{
		for(%k = 1; %k < %i; %k++)
		{
			if(String::Compare($Temp[%k], $Temp[%k-1]) == -1)
			{
				Array::swap(%k-1, %k);
			}
		}
		
	}
	return Array::copy("Temp", %array);
}



#.........................................................
#        Selection Sort - runs @ O(n^2)
#
# Sorts the array given as a parameter, in ascending order (lowest to highest)
#
# Selection sort is MUCH faster than bubble sort
#
# Not recommended for sorting arrays when Array::Length(%array) > 150
#
# Returns the length of the array, as well
#.........................................................


function Array::selectionSort(%array)
{
	%i = Array::copy(%array, "Temp");

	for(%j = 0; %j < %i-1; %j++)
	{
		%small = %j;
		for(%k = %j+1; %k < %i; %k++)
		{
			if(String::compare($Temp[%k], $Temp[%small]) == -1)
			{
				%small = %k;
			}
		}
		Array::swap(%j, %small);
	}
	return Array::copy("Temp", %array);
}



#.........................................................
#        Insertion Sort - runs @ O(n^2)
#
# Sorts the array given as a parameter, in ascending order (lowest to highest)
#
# Insertion sort is usually a decent amount faster than selection sort
#
# Not recommended for sorting arrays when Array::Length(%array) > 300
#
# Returns the length of the array, as well
#.........................................................


function Array::insertionSort(%array)
{
	%i = Array::copy(%array, "Temp");

    	for(%j = 1; %j < %i; %j++)
        {
        	%toInsert = $Temp[%j];

            	%k = %j;
      	    	while (%k > 0 && (String::compare(%toInsert, $Temp[%k-1]) == -1) )
      		{
        		$Temp[%k] = $Temp[%k-1];
        		%k--;
      		}
      		$Temp[%k] = %toInsert;
    	}

	return Array::copy("Temp", %array);
}


#.........................................................
#        Heap Sort - runs @ O(n log n)
#
# Sorts the array given as a parameter, in ascending order (lowest to highest)
#
# Heap sort is faster than insertionSort, selectionSort, and bubbleSort
# and you can sort an array of 5000 elements in about 1 second
# note that I have a shitty dell laptop, and it probably goes faster on other computers
#
# Returns the length of the array, as well
#
# Note: This particular algorithm isn't designed to be used with strings (the others are), as all strings evaluate
# to 0 when they're compared with the < and > operaters.  If you want to use it with strings
# Modify the two if() lines in the fixHeap() function, so they look like this:
#
# if(%child < %end && (String::compare($Temp[%child], $Temp[%child + 1]) == -1))
#  
# if(%child <= %end && (String::compare(%key, $Temp[%child]) == -1))
#.........................................................


function Array::heapSort(%array)
{
	%i = Array::copy(%array, "Temp")-1;

	$Temp[0] = Array::findSmallest(0, %i);

	for(%j = floor(%i/2); %j >= 1; %j--)
	{
		heapSort::fixHeap(%j, %i, $Temp[%j]);
	}

	for(%j = %i; %j > 1; %j--)
	{
		Array::swap(1, %j);
		heapSort::fixHeap(1, %j - 1, $Temp[1]);
	}
	
	return Array::copy("Temp", %array);
}

function heapSort::fixHeap(%root, %end, %key)
{
	%child = 2 * %root;

	if(%child < %end && $Temp[%child] < $Temp[%child + 1])
	{
		%child++;
	}

	if(%child <= %end && %key < $Temp[%child])
	{
		$Temp[%root] = $Temp[%child];
		heapSort::fixHeap(%child, %end, %key);
	}

	else
	{
		$Temp[%root] = %key;
	}
}




////////////////////////////////////////////////////////////////////////
//
//                  Array Searching Functions
//



#.........................................................
#        Linear Search - runs @ O(N)
#
# Searches %array for %toFind, and returns the index 
# at which %toFind is located
#
# if %toFind cannot be found, -1 is returned
#
# example of use: 
#     
#     if(Array::linearSearch("kickNameDatabase", client::getName(%clientId)) != -1)
#     {
#          kick(%id);
#     }
#.........................................................


function Array::linearSearch(%array, %toFind)
{
	%n = Array::copy(%array, "Temp");

	for(%i = 0; %i < %n; %i++)
	{
		if($Temp[%i] == %toFind)
		{
			Array::delete("Temp");
			return %i;
		}
	}
	Array::delete("Temp");
	return -1;
}



#.........................................................
#        Binary Search - runs @ O(log n)
#
# Searches %array for %toFind, and returns the index 
# at which %toFind is located
#
# if %toFind cannot be found, -1 is returned
#
# example of use: 
#     
#     if(Array::binarySearch("adminIPDatabase", client::getTransportAddress(%clientId) != -1)
#     {
#          admin(%%clientId);
#     }
#
# Note: Binary Searching ONLY works if the array is sorted
# However, it is considerably faster than linear searching
#.........................................................


function Array::binarySearch(%array, %toFind)
{
	%low = 0;
	%high = Array::copy(%array, "Temp")-1;
	
	while( %low <= %high )
	{
		%middle = floor((%low  + %high) / 2);
		
		if(%toFind == $Temp[%middle])
		{
			Array::delete("Temp");
			return %middle;
		}
		else if(%toFind < $Temp[%middle])
		{
			%high = %middle - 1;
		}
		else
		{
			%low = %middle + 1;
		}
	}
	Array::delete("Temp");
	return -1;
}

echo("Array Library - Loaded");

