#!/usr/bin/perl -T
use POSIX qw(strftime);
use Net::hostent;
use Socket;

################################################################################
# tribesserverstatindex.pl - Index page generator for tribesserverstat.        #
################################################################################
# http://www.augustknights.com/tribesserverstat                                #
# Version 1.1                                                                  #
################################################################################

################################################################################
# Adapted for Tribes 2 from csserverstat.pl version 1.05                       #
# A server info and log parser for Half-Life Counter-Strike servers.           #
################################################################################
# http://server.counter-strike.net/csserverstat                                #
################################################################################


# Set the path to your configuration file here. Make sure you use forward slashes, even if you are running Windows (i.e. c:/wwwroot/cgi-bin/tribesserverstat.conf).

$settings{configfile}	= "/www/apache/conf/tribesserverstatindex.conf";


################################################################################
# Do not modify anything below this line!                                      #
################################################################################

$settings{tssversion} = "1.1";

#### BEG MSS Qui9 - Counter Variable

$tik = 1;

#### END MSS

# This subroutine will replace any occurance of "<" or ">" with their web tag codes of "&#60;" and "&#62;", respectively.
sub TagFilter {
  $_[0] =~ s/</&#60;/g;
  $_[0] =~ s/>/&#62;/g;
}

# Get configuration pairs and place them in %settings.
if (!-f $settings{configfile}) {
  print "Content-type: text/html\n\n<h3>Unable to open configuration file \"$settings{configfile}\".<p>Check your server's file and directory permissions, as well as your\$configfile setting in tribesserverstat.pl.</h3>";
  exit;
}

open(CONFIG,"$settings{configfile}");

foreach $_ (<CONFIG>) {
  chop;
  s/^\s+//;
  s/\s+$//;
  next if /^$/;
  next if /^#/;
  s/\s*#.*//;
  (my $setting,my $value) = split(/=/);
  $setting =~ s/^\s+//;
  $setting =~ s/\s+$//;
  $value =~ s/^\s+//;
  $value =~ s/\s+$//;
  $settings{$setting} = $value;
}

close CONFIG;

# Check to see if all our path settings are ok.
if (!-f $settings{template}) {
  print "Content-type: text/html\n\n<h3>Unable to open template \"$settings{template}\".<p>Check your server's file and directory permissions, as well as your \"template\" setting in $settings{configfile}.</h3>";
  exit;
}

if (!-e $settings{qstatpath} or !-d $settings{qstatpath}) {
  print "Content-type: text/html\n\n<h3>Unable to locate the QStat directory, or \"$settings{qstatpath}\" is not a directory.<p>Check your server's file and directory permissions, as well as your \"qstatpath\" in $settings{configfile}.</h3>";
  exit;
}

# Get configuration settings that were entered into the URL, if any.
$ENV{'REQUEST_METHOD'} =~ tr/a-z/A-Z/;

if ($ENV{'REQUEST_METHOD'} eq "POST") {
  read(STDIN, $in, $ENV{'CONTENT_LENGTH'});
  } else {
  $in = $ENV{'QUERY_STRING'};
}

my @settings = split(/&/, $in);

foreach my $settings (@settings) {
  (my $setting, my $value) = split(/=/, $settings);
  $setting =~ tr/+/ /;
  $setting =~ s/%(..)/pack("C", hex($1))/eg;
  $value =~ tr/+/ /;
  $value =~ s/%(..)/pack("C", hex($1))/eg;
  TagFilter($setting);
  TagFilter($value);

  if ($setting eq "refresh") {
    $settings{refresh} = $value;
  }

}

# Set up META tag timestamp
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime;
$dayofweek = (Sun,Mon,Tue,Wed,Thu,Fri,Sat)[(localtime)[6]];
$month = (Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec)[(localtime)[4]];
$year = $year + 1900;

if ($sec < 10) {
  $sec = "0".$sec;
}

if ($min < 10) {
  $min = "0".$min;
}

if ($hour < 10) {
  $hour = "0".$hour;
}

if ($mday < 10) {
  $mday = "0".$mday;
}

if ($isdst == "0") {
  $timezone = $settings{timezone};
} else {
  $timezone = $settings{dsttimezone};
}

$datestring = "$dayofweek".', '. "$mday $month $year $hour". ':'. "$min". "$sec "."$timezone";

# Get the local time.
$now = localtime;

#### BEG MSS Qui9 - Begin master loop. Assign variables from .conf file via counter and get shortened description and IP address for html links used in .template.

$newip = "serverip". $tik."";
$newport = "serverport". $tik."";
$newver = "version". $tik."";


while($settings{$newip} ne "") {

  $settings{serverip} = $settings{$newip};
  $settings{serverport} = $settings{$newport};
  $settings{version} = $settings{$newver};
  $fulldisp = $settings{serverip}.":".$settings{serverport}."&version=".$settings{version};

#### END MSS

  $tmp = gethost($settings{serverip});

  if ($tmp) {
	$settings{serverip} = inet_ntoa($tmp->addr);
  }

# Don't go outside our allowable range for refresh.
  if ($settings{defrefresh} < $settings{minrefresh}) {
	$settings{refresh} = $settings{minrefresh};
  } else {
	$settings{refresh} = $settings{defrefresh} unless $settings{refresh};
  }

# The majority of the URL for each event setting change link is the same and is defined here for convenience.
  $cgiurl = "refresh=$settings{refresh}&server=$settings{serverip}:$settings{serverport}";

# Get game server, player, and rule information from QStat.
  if ($settings{version} eq "Tribes2") {
	if ($^O eq "MSWin32") {
	  my($qstat) = open(QSTAT,"-|", "$settings{qstatpath}/qstat ".
	  ' -R -P -cn -htmlnames -raw !@#@! -t2s '."$settings{serverip}:$settings{serverport}");
	  die "Couldn't open pipe to subprocess" unless defined($qstat);
	  @qstat = <QSTAT>;
	  close QSTAT;
	} else {
	  @qstatoptions = ("-R","-P","-cn","-htmlnames","-raw","!@#@!","-t2s");
	  my($qstat) = open(QSTAT,"-|");
	  die "Couldn't open pipe to subprocess" unless defined($qstat);
	  exec("$settings{qstatpath}/qstat",@qstatoptions,"$settings{serverip}:$settings{serverport}") or die "Couldn't exec qstat" if $qstat == 0;
	  @qstat = <QSTAT>;
	  close QSTAT;
	}

	chomp(@qstat);
	$serverstat = shift(@qstat);
	$ruleslist = shift(@qstat);
	@playerlines = @qstat;
	($type,$ip,$servername,$map,$maxplayers,$curplayers,$ping,$timeout) = split(/!@#@!/,$serverstat);

  } elsif ($settings{version} eq "Tribes") {
        if ($^O eq "MSWin32") {
          my($qstat) = open(QSTAT,"-|", "$settings{qstatpath}/qstat ".
          ' -R -P -raw !@#@! -tbs '."$settings{serverip}:$settings{serverport}");
	  die "Couldn't open pipe to subprocess" unless defined($qstat);
	  @qstat = <QSTAT>;
	  close QSTAT;
	} else {
	  @qstatoptions = ("-R","-P","-raw","!@#@!","-tbs");
	  my($qstat) = open(QSTAT,"-|");
	  die "Couldn't open pipe to subprocess" unless defined($qstat);
	  exec("$settings{qstatpath}/qstat",@qstatoptions,"$settings{serverip}:$settings{serverport}") or die "Couldn't exec qstat" if $qstat == 0;
	  @qstat = <QSTAT>;
	  close QSTAT;
	}

	chomp(@qstat);
	$serverstat = shift(@qstat);
	$ruleslist = shift(@qstat);
	@playerlines = @qstat;
	($type,$ip,$servername,$map,$curplayers,$maxplayers) = split(/!@#@!/,$serverstat);

  }

# If debug mode is on, place the %settings hash in $debug.
  if ($settings{debug} == 1) {
	$debug .= "<table cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">\n";

	foreach $setting (sort (keys %settings)) {
	  $debug .= "<tr><td nowrap><font size=\"1\" color=\"#808080\">$setting</font></td><td><font size=\"1\" color=\"#E0E0E0\">&nbsp;=&nbsp;</font></td><td width=\"100%\"><font size=\"1\" color=\"#E0E0E0\">$settings{$setting}</font></td></tr>\n";
	}

	$debug .= "</table>\n<hr size=\"1\" width=\"100%\">";
  }

  $mapname = $map;

#### BEG MSS Qui9 - An offline status for offline servers.

  if (($servername eq "TIMEOUT") || ($servername eq "DOWN")) {
	$mapname = "OFFLINE";
	$maxplayers = 0;
	$curplayers = 0;
  }

#### END MSS

# Output to the web browser
  if ($tik == 1) {
	print "Content-type: text/html\n\n";
	print "<!-- generated by tribesserverstat - http://www.augustknights.com/tribesserverstat -->\n\n";
	print "<html>\n";
	print "<head>\n";
	print "<title>Tribes Server Live Status Index</title>\n";
	print "<meta http-equiv=\"refresh\" content=\"$settings{refresh}\">\n";
	print "<meta http-equiv=\"pragma\" content=\"no-cache\">\n";
	print "<meta name=\"expires\" content=\"$datestring\">\n";
	print "<meta http-equiv=\"expires\" content=\"$datestring\">\n";
	print "</head>\n\n";
	print "<style>\n";
	print "body\t\t\{ background-color: \#404040\; padding\: 0 0 0 0\; margin\: 2 2 2 2 \}\n";
	print "a\:link\t\t\{ text-decoration\: none\; color\: \#404040 \}\n";
	print "a\:visited\t\{ text-decoration\: none\; color\: \#404040 \}\n";
	print "a\:active\t\{ text-decoration\: none\; color\: \#E0E0E0 \}\n";
	print "a\:hover\t\t\{ text-decoration\: none\; color\: \#E0E0E0 \}\n";
	print ".serverinfo\t\{ background-color\: \#707070 \}\n";
	print "</style>\n\n";
	print "<body text\=\"\#000000\">\n";
	print "<font face\=\"Verdana\,Arial\,Helvetica\" size\=\"2\" color\=\"\#000000\">\n\n";
	print "<!-- Begin Debug Section -->\n";
	print "$debug\n";
	print "<!-- End Debug Section -->\n\n";
	print "<table border\=0 cellspacing\=0 width\=100\%>\n";
	print "<tr><td bgcolor\=\"\#606060\" colspan\=2><img src\=\"$settings{imageurl}/trans.gif\" height\=3></td></tr>\n";
	print "<tr><td class\=\"serverinfo\" nowrap><b><font size\=4>\&nbsp\;Tribes Server Status Index Page</b></td>\n";
	print "<td class\=\"serverinfo\" align\=\"right\"><font size\=2\>$now\&nbsp\;</font></td></tr>\n";
	print "<tr><td bgcolor\=\"\#606060\" colspan\=2><img src\=\"$settings{imageurl}/trans.gif\" height\=3></td></tr>\n";
	print "</table>\n\n";
	print "<br>\n\n";
	print "<table border\=0 cellspacing\=0 cellpadding\=1 align\=\"center\">\n";
	print "<tr>\n";
	print "<td nowrap><font size\=\"2\" color\=\"\#E0E0E0\"><b>Server Name\&nbsp\;\&nbsp\;</b></font></td>\n";
	print "<td align\=\"middle\" nowrap><font size\=\"2\" color\=\"\#E0E0E0\"><b>\&nbsp\;Version\&nbsp\;\&nbsp\;</b></font></td>\n";
	print "<td align\=\"right\" nowrap><font size\=\"2\" color\=\"\#E0E0E0\"><b>\&nbsp\;Players\&nbsp\;</b></font></td>\n";
	print "<td align\=\"right\" nowrap><font size\=\"2\" color\=\"\#E0E0E0\"><b>\&nbsp\;\&nbsp\;Map\&nbsp\;</b></font></td>\n";
	print "</tr>\n";
	print "<tr><td bgcolor\=\"\#606060\" colspan\=4><img src\=\"$settings{imageurl}/trans.gif\" height\=3></td></tr>\n";

  }
	
  if ($settings{version} eq "Tribes2") {
	$settings{version} = "<img src\=\"$settings{imageurl}/t2icon.gif\" border\=0>";
  } elsif ($settings{version} eq "Tribes") {
	$settings{version} = "<img src\=\"$settings{imageurl}/t1icon.gif\" border\=0>";
  }

  open(TEMPLATE,"$settings{template}");

  foreach $_ (<TEMPLATE>) {
	$_ =~ s/(\$\w+\{\w+\})/$1/eeg;
	$_ =~ s/(\$\w+)/$1/eeg;
	print $_;
  }

  close(TEMPLATE);

#### BEG MSS Qui9 - End master loop and set up next server to ping by grabbing next variable from .conf file.

  $tik++;
  $newip = "serverip". $tik."";
  $newport = "serverport". $tik."";
  $newver = "version". $tik."";

}

print "<tr><td bgcolor\=\"\#606060\" colspan\=4><img src\=\"$settings{imageurl}/trans.gif\" height\=3></td></tr>\n";
print "</table>\n\n";
print "<br>\n\n";
print "<table border\=0 cellspacing\=0 cellpadding\=0 width\=\"100\%\">\n";
print "<tr><td bgcolor\=\"\#606060\" colspan\=4><img src\=\"$settings{imageurl}/trans.gif\" height\=3></td>\n";
print "<tr>\n";
print "<td colspan\=4 bgcolor\=\"\#606060\" width\=\"100\%\"><img src\=\"$settings{imageurl}/trans.gif\" height\=3></td></tr>\n";
print "<tr>\n";
print "<td colspan\=4 width\=\"100\%\" align\=\"right\"><font size\=1 color\=\"\#D0D0D0\"><a href\=\"http://www.augustknights.com/tribesserverstat/\" target\=\"_blank\"><font color\=\"\#C0C0C0\">tribesserverstat $settings{tssversion}</font></a></font></td>\n";
print "</tr>\n";
print "</table>\n\n";
print "</body>\n";
print "</html>";

# End script.
exit;
