#!/usr/bin/perl -T
use POSIX qw(strftime);
use Net::hostent;
use Socket;

################################################################################
# tribesserverstat.pl - A server info script for Tribes servers.               #
################################################################################
# http://www.augustknights.com/tribesserverstat                                #
# Version 1.1                                                                  #
################################################################################

################################################################################
# Adapted for Tribes 2 from csserverstat.pl version 1.05                       #
# A server info and log parser for Half-Life Counter-Strike servers.           #
################################################################################
# http://server.counter-strike.net/csserverstat                                #
################################################################################


# Set the path to your configuration file here. Make sure you use forward slashes, even if you are running Windows (i.e. c:/wwwroot/cgi-bin/tribesserverstat.conf).

$settings{configfile}	= "/www/apache/conf/tribesserverstat.conf";

################################################################################
# Do not modify anything below this line!                                      #
################################################################################

$settings{tssversion} = "1.1";

# This subroutine will replace any occurance of "<" or ">" with their web tag codes of "&#60;" and "&#62;", respectively.
sub TagFilter {
  $_[0] =~ s/</&#60;/g;
  $_[0] =~ s/>/&#62;/g;
}

# Get configuration pairs and place them in %settings.
if (!-f $settings{configfile}) {
  print "Content-type: text/html\n\n<h3>Unable to open configuration file \"$settings{configfile}\".<p>Check your server's file and directory permissions, as well as your\$configfile setting in tribesserverstat.pl.</h3>";
  exit;
}

open(CONFIG,"$settings{configfile}");

foreach $_ (<CONFIG>) {
  chop;
  s/^\s+//;
  s/\s+$//;
  next if /^$/;
  next if /^#/;
  s/\s*#.*//;
  (my $setting,my $value) = split(/=/);
  $setting =~ s/^\s+//;
  $setting =~ s/\s+$//;
  $value =~ s/^\s+//;
  $value =~ s/\s+$//;
  $settings{$setting} = $value;
}

close CONFIG;

# Check to see if all our path settings are ok.
if (!-f $settings{template}) {
  print "Content-type: text/html\n\n<h3>Unable to open template \"$settings{template}\".<p>Check your server's file and directory permissions, as well as your \"template\" setting in $settings{configfile}.</h3>";
  exit;
}

if (!-e $settings{qstatpath} or !-d $settings{qstatpath}) {
  print "Content-type: text/html\n\n<h3>Unable to locate the QStat directory, or \"$settings{qstatpath}\" is not a directory.<p>Check your server's file and directory permissions, as well as your \"qstatpath\" in $settings{configfile}.</h3>";
  exit;
}

# Get configuration settings that were entered into the URL, if any.
$ENV{'REQUEST_METHOD'} =~ tr/a-z/A-Z/;

if ($ENV{'REQUEST_METHOD'} eq "POST") {
  read(STDIN, $in, $ENV{'CONTENT_LENGTH'});
  } else {
  $in = $ENV{'QUERY_STRING'};
}

my @settings = split(/&/, $in);

foreach my $settings (@settings) {
  (my $setting, my $value) = split(/=/, $settings);
  $setting =~ tr/+/ /;
  $setting =~ s/%(..)/pack("C", hex($1))/eg;
  $value =~ tr/+/ /;
  $value =~ s/%(..)/pack("C", hex($1))/eg;
  TagFilter($setting);
  TagFilter($value);

  if ($setting eq "server") {
    ($settings{serverip},$settings{serverport}) = split(/:/,$value);
  }

  if ($setting eq "version") {
    $settings{version} = $value;
  }

  if ($setting eq "refresh") {
    $settings{refresh} = $value;
  }

}

# Set up META tag timestamp
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime;
$dayofweek = (Sun,Mon,Tue,Wed,Thu,Fri,Sat)[(localtime)[6]];
$month = (Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec)[(localtime)[4]];
$year = $year + 1900;

if ($sec < 10) {
  $sec = "0".$sec;
}

if ($min < 10) {
  $min = "0".$min;
}

if ($hour < 10) {
  $hour = "0".$hour;
}

if ($mday < 10) {
  $mday = "0".$mday;
}

if ($isdst == "0") {
  $timezone = $settings{timezone};
} else {
  $timezone = $settings{dsttimezone};
}

$datestring = "$dayofweek".', '. "$mday $month $year $hour". ':'. "$min". "$sec "."$timezone";

# Get the local time.
$now = localtime;

$tmp = gethost($settings{serverip});

if ($tmp) {
  $settings{serverip} = inet_ntoa($tmp->addr);
}

# Don't go outside our allowable range for refresh.
if ($settings{defrefresh} < $settings{minrefresh}) {
  $settings{refresh} = $settings{minrefresh};
} else {
  $settings{refresh} = $settings{defrefresh} unless $settings{refresh};
}

# The majority of the URL for each event setting change link is the same and is defined here for convenience.
$cgiurl = "refresh=$settings{refresh}&server=$settings{serverip}:$settings{serverport}";

# Get game server, player, and rule information from QStat.
if ($settings{version} eq "Tribes2") {
  if ($^O eq "MSWin32") {
	my($qstat) = open(QSTAT,"-|", "$settings{qstatpath}/qstat ".
	' -R -P -htmlnames -raw !@#@! -t2s '."$settings{serverip}:$settings{serverport}");
	die "Couldn't open pipe to subprocess" unless defined($qstat);
	@qstat = <QSTAT>;
	close QSTAT;
  } else {
	@qstatoptions = ("-R","-P","-htmlnames","-raw","!@#@!","-t2s");
	my($qstat) = open(QSTAT,"-|");
	die "Couldn't open pipe to subprocess" unless defined($qstat);
	exec("$settings{qstatpath}/qstat",@qstatoptions,"$settings{serverip}:$ settings{serverport}") or die "Couldn't exec qstat" if $qstat == 0;
	@qstat = <QSTAT>;
	close QSTAT;
  }

  chomp(@qstat);
  $serverstat = shift(@qstat);
  $ruleslist = shift(@qstat);
  @playerlines = @qstat;
  ($type,$ip,$servername,$map,$maxplayers,$curplayers,$ping,$timeout) = split(/!@#@!/,$serverstat);

} elsif ($settings{version} eq "Tribes") {
  if ($^O eq "MSWin32") {
	my($qstat) = open(QSTAT,"-|", "$settings{qstatpath}/qstat ".
	' -R -P -raw !@#@! -tbs '."$settings{serverip}:$settings{serverport}");
	die "Couldn't open pipe to subprocess" unless defined($qstat);
	@qstat = <QSTAT>;
	close QSTAT;
  } else {
	@qstatoptions = ("-R","-P","-raw","!@#@!","-tbs");
	my($qstat) = open(QSTAT,"-|");
	die "Couldn't open pipe to subprocess" unless defined($qstat);
	exec("$settings{qstatpath}/qstat",@qstatoptions,"$settings{serverip}:$ settings{serverport}") or die "Couldn't exec qstat" if $qstat == 0;
	@qstat = <QSTAT>;
	close QSTAT;
  }

  chomp(@qstat);
  $serverstat = shift(@qstat);
  $ruleslist = shift(@qstat);
  @playerlines = @qstat;
  ($type,$ip,$servername,$map,$curplayers,$maxplayers) = split(/!@#@!/,$serverstat);

}

#Work some magic to make the appropriate map image appear.
if (!-e "$settings{imagepath}\/$map.jpg") {
  if ($settings{version} eq "Tribes2") {
	$mapimage = "default.jpg";
  } elsif ($settings{version} eq "Tribes") {
	$mapimage = "t1default.gif";
  }
} else {
  $mapimage = "$map.jpg";
}

# If debug mode is on, place the %settings hash in $debug.
if ($settings{debug} == 1) {
  $debug .= "<table cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">\n";

  foreach $setting (sort (keys %settings)) {
	$debug .= "<tr><td nowrap><font size=\"1\" color=\"#808080\">$setting</font></td><td><font size=\"1\" color=\"#E0E0E0\">&nbsp;=&nbsp;</font></td><td width=\"100%\"><font size=\"1\" color=\"#E0E0E0\">$settings{$setting}</font></td></tr>\n";
  }

  $debug .= "</table>\n<hr size=\"1\" width=\"100%\">";
}

$mapname = $map;

$mapimage = "<img class=\"map\" src=\"$settings{imageurl}/$mapimage\" alt=\"Current map is $map.\">";

# Build the players list.
# Get the player list.
if (@playerlines) {

  while ($_ = shift @playerlines) {

        ++$count1;

	if ($settings{version} eq "Tribes2") {

	  ($playername,$frags,$teamnumber,$teamname,$playertype,$tribe) = split(/!@#@!/);

	  $playername =~ s/<font color=\"white\"/<font color=\"$settings{playercolor}\"/g;
	  $playername =~ s/<font color=\"blue\"/<font color=\"$settings{aliascolor}\"/g;
	  $playername =~ s/<font color=\"green\"/<font color=\"$settings{botcolor}\"/g;
	  $playername =~ s/<font color=\"yellow\"/<font color=\"$settings{tribecolor}\"/g;

	  %playerlist = (
		frags    	=> $frags,
		teamnumber	=> $teamnumber,
		teamname	=> $teamname,
		playertype	=> $playertype,
		tribe		=> $tribe
	  );

	  %teamlist = (
		frags    	=> $frags,
		teamnumber	=> $teamnumber,
		teamname	=> $teamname,
		playertype	=> $playertype,
		tribe		=> $tribe
	  );
	} elsif ($settings{version} eq "Tribes") {

	  ($playername,$frags,$ping,$teamnumber,$packetloss) = split(/!@#@!/);

	  %playerlist = (
		frags		=> $frags,
		ping		=> $ping,
		teamnumber	=> $teamnumber,
		packetloss	=> $packetloss
	  );

	  %teamlist = (
		frags		=> $frags,
		ping		=> $ping,
		teamnumber	=> $teamnumber,
		packetloss	=> $packetloss
	  );

	}

        for my $what (keys %playerlist) {
          $player{$playername}{$what} = $playerlist{$what};
        }
  		  
	for my $what (keys %teamlist) {
          $team{$playername}{$what} = $teamlist{$what};
        }
  }

  if ($settings{version} eq "Tribes2") {

	foreach $keys (keys %player) {
	  if ($player{$keys}{teamname} eq 'TEAM') {
		delete $player{$keys};
	  }
	}

	foreach $keys (keys %team) {
	  if ($team{$keys}{teamname} ne 'TEAM') {
		delete $team{$keys};
	  }
	}

  } elsif ($settings{version} eq "Tribes") {

	foreach $keys (keys %player) {
	  if ($player{$keys}{ping} == 0) {
		delete $player{$keys};
	  }
	}

	foreach $keys (keys %team) {
	  if ($team{$keys}{ping} != 0) {
		delete $team{$keys};
	  }
	}
  }

  @playernamelist = keys %player;

  @teamnamelist = keys %team;
  
}

sub byfrag {
  $player{$b}{frags} <=> $player{$a}{frags};
}

$u = 0;

foreach $teamname (@teamnamelist) {
  $teamscore = $team{$teamname}{frags};
  $playerinfo .="<tr><td class=\"teamlist\" nowrap><font size=\"1\">";
  $playerinfo .="<b>$teamname</b></font></td>";
  $playerinfo .="<td class=\"teamlist\" align=\"right\" nowrap><font size=\"1\"><b>&nbsp;$teamscore&nbsp;</b></font></td>";

# Sort the player list by frags.
  foreach $playername (sort byfrag @playernamelist) {
	if ($settings{version} eq "Tribes2") {
	  if (($u == 0) && ($player{$playername}{teamname} eq "Unassigned")) {
		push @teamnamelist, "Unassigned";
		%teamlist2 = (
		  frags		=> "",
		  teamnumber	=> "-1",
		  teamname	=> "(null)"
	  	);

		for my $what (keys %teamlist2) {
		  $team{Unassigned}{$what} = $teamlist2{$what};
		}
		++$u;
	  }
	} elsif ($settings{version} eq "Tribes") {
	  if (($u == 0) && ($player{$playername}{teamnumber} == 255)) {
		push @teamnamelist, "Unassigned";
		%teamlist2 = (
		  frags		=> "",
		  teamnumber	=> "255"
		);

		for my $what (keys %teamlist2) {
		  $team{Unassigned}{$what} = $teamlist2{$what};
		}
		++$u;
	  }
	}

	if ($player{$playername}{teamnumber} eq $team{$teamname}{teamnumber}) {
	  $frags = $player{$playername}{frags};

# Limit displayed player names to the maxplayername setting.
	  $playername =~ s/(^.{$settings{maxplayername}}(?!$))(.*$)/$1.../g;

	  $playerinfo .= "<tr><td class=\"playerlist\" nowrap><font size=\"1\">&nbsp;";

# If any admins are present indicate them.
	  foreach my $admin (split/,/,$settings{admins}) {
		$admin =~ s/^\s+//;
		$admin =~ s/\s+$//;
		TagFilter($admin);
		if ($playername eq $admin) {
		  $playername = "$playername<font class=\"admin\">&#149;</font>";
		}
	  }

# Print the players' names  
	  $playerinfo .= "$playername</font></td>";

	  $playerinfo .= "<td class=\"playerlist\" align=\"right\" nowrap><font size=\"1\">&nbsp;$frags&nbsp;</font></td>";

	}
  }

}
# Show blank lines up to the server's curplayer setting. Looks nice.
while ($count1 < $curplayers) {
  ++$count1;
  $playerinfo .= "<tr><td class=\"playerlist\" colspan=\"3\"><font size=\"1\">&nbsp;</td></tr>\n";
}

# Build the rules list.
# Get and format the rules list.
foreach (sort(split /!@#@!/, $ruleslist)) {
  ($rule,$value) = split(/=/);
  TagFilter($rule);
  TagFilter($value);

  if (($value == 0) && (($rule eq "dedicated") || ($rule eq "linux") || ($rule eq "needpass") || ($rule eq "tournament") || ($rule eq "password") || ($rule eq "tournament_mode") || ($rule eq "teamdamage") || ($rule eq "no_aliases"))) {
	$value = "<font color=\"#303030\">&#149;</font>";
  } elsif (($value == 1) && (($rule eq "dedicated") || ($rule eq "linux") || ($rule eq "needpass") || ($rule eq "tournament") || ($rule eq "password") || ($rule eq "tournament_mode") || ($rule eq "teamdamage") || ($rule eq "no_aliases"))) {
	$value = "<font color=\"#009900\">&#149;</font>";
  }

# Defines which rules to show.
  if (	/game/ or
		/mission/ or
		/build_version/ or
		/cpu_speed/ or
		/numteams/ or
		/status/ or
		/dedicated/ or
		/bot_count/ or
		/queryversion/ or
		/tournament_mode/ or
		/tournament/ or
		/no_aliases/ or
		/password/ or
		/minimum_net_protocol/ or
		/net_protocol/ or
		/linux/ or
		/gamename/ or
		/version/ or
		/cpu/ or
		/mods/ or
		/teamdamage/ or
		/needpass/ ) {
	++$count2;
	$rulesinfo .= "<tr><td class=\"ruleslist\"><font size=\"1\">&nbsp;$rule</font></td>";
	$rulesinfo .= "<td class=\"ruleslist\" align=\"right\" nowrap><font size=\"1\">$value&nbsp;</font></td></tr>\n";
  }

}

# Make the rules list at least as big as the player list if it isn't already. Looks nice.
if ($u != 0) {
  ++$count1;
}

while ($count2 < $count1) {
  ++$count2;
  $rulesinfo .= "<tr><td class=\"ruleslist\" colspan=\"2\"><font size=\"1\">&nbsp;</td></tr>\n";
}

# Make the player list at least as big as the rule list if it isn't already.  Looks nice.
while ($count1 < $count2) {
  ++$count1;
  $playerinfo .= "<tr><td class=\"playerlist\" colspan=\"2\"><font size =\"1\">&nbsp;</td></tr>\n";
}

# Output to the web browser
if ($settings{version} eq "Tribes2") {
  $settings{version} = "<img src\=\"$settings{imageurl}/t2icon.gif\" align\=\"absmiddle\" border\=0>";
} elsif ($settings{version} eq "Tribes") {
  $settings{version} = "<img src\=\"$settings{imageurl}/t1icon.gif\" align\=\"absmiddle\" border\=0>";
}

print "Content-type: text/html\n\n";
print "<!-- generated by tribesserverstat - http://www.augustknights.com/tribesserverstat -->\n\n";

open(TEMPLATE,"$settings{template}");

foreach $_ (<TEMPLATE>) {
  $_ =~ s/(\$\w+\{\w+\})/$1/eeg;
  $_ =~ s/(\$\w+)/$1/eeg;
  print $_;
}

close(TEMPLATE);

# End script.
exit;
