// DELTA FORCE VEHICLES
// ---------------------------------------------

FlierData Apache
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "flyer";
   shieldShapeName = "shield_medium";
   mass = 9.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.5;
   maxPitch = 0.5;
   maxSpeed = 50;
   minSpeed = -2;
	lift = 0.75;
	maxAlt = 25;
	maxVertical = 10;
	maxDamage = 1.0;
	damageLevel = {1.0, 1.0};
	maxEnergy = 100;
	accel = 0.4;

	groundDamageScale = 1.0;

	projectileType = ApacheRocket;
	reloadDelay = 0.5;
	repairRate = 0;
	fireSound = SoundFireFlierRocket;
	damageSound = SoundFlierCrash;
	ramDamage = 1.5;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundFlyerIdle;
	moveSound = SoundFlyerActive;

	visibleDriver = true;
	driverPose = 22;
	description = "Apache";
};

FlierData Warthog
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc_sml";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.25;
   maxSpeed = 30;
   minSpeed = 0;
	lift = 0.5;
	maxAlt = 15;
	maxVertical = 6;
	maxDamage = 1.5;
	damageLevel = {1.0, 1.0};
	destroyDamage = 1.0;
	maxEnergy = 100;
	accel = 0.25;

	groundDamageScale = 0.75;

	projectileType = WarthogBullet;
	reloadRate = 0;
	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	fireSound = SoundFireMortar;
	reloadDelay = 0.3;
	damageSound = SoundTankCrash;
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundFlyerIdle;
	moveSound = SoundFlyerActive;

	visibleDriver = true;
	driverPose = 23;
	description = "A-10 Warthog";
};

FlierData TOWMissile
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "rocket";
   shieldShapeName = "shield_medium";
   mass = 9.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.5;
   maxPitch = 0.5;
   maxSpeed = 40;
   minSpeed = 40;
	lift = 0.75;
	maxAlt = 25;
	maxVertical = 10;
	maxDamage = 0.001;
	damageLevel = {1.0, 1.0};
	maxEnergy = 100;
	accel = 0.8;

	groundDamageScale = 5.0;

	reloadDelay = 0.0;
	repairRate = 0;
	damageSound = SoundFlierCrash;
	ramDamage = 1.5;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	visibleToSensor = true;
	shadowDetailMask = 2;

	moveSound = SoundJetHeavy;

	visibleDriver = false;
	driverPose = 22;
	description = "TOW";
};

function OutOfCable(%this) 
{
	%cl = GameBase::getControlClient(%this);
	Vehicle::dismount(%this, "0 0 0");
	remoteEval(%cl, BP, "<jc><f0>TOW Missile is out of cable", 4);
}

function TOWMissile::onAdd(%this) 
{
	GameBase::setRechargeRate(%this, -25); // TOW lives for 4 seconds
	schedule("OutOfCable("@%this@");", 4, %this);
	schedule("$TOWDetEnable["@%this@"] = 1;", 0.5, %this);
}

function TOWMissile::onFire(%this)
{
	if ($TOWDetEnable[%this] == 1) {
		%cl = GameBase::getControlClient(%this);
		Vehicle::dismount(%this, "0 0 0");
		remoteEval(%cl, BP, "<jc><f0>TOW Missile Remotely Detonated", 4);
		$TOWDetEnable[%this] = 0;
	}
}

FlierData Blackhawk
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc_sml";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.175;
   maxSpeed = 25;
   minSpeed = -1;
	lift = 0.5;
	maxAlt = 15;
	maxVertical = 6;
	maxDamage = 1.5;
	damageLevel = {1.0, 1.0};
	destroyDamage = 1.0;
	maxEnergy = 100;
	accel = 0.25;

	groundDamageScale = 0.50;

	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	fireSound = SoundFireFlierRocket;
	reloadDelay = 3.0;
	damageSound = SoundTankCrash;
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundFlyerIdle;
	moveSound = SoundFlyerActive;

	visibleDriver = true;
	driverPose = 23;
	description = "Blackhawk";
};

function Blackhawk::onAdd(%this) 
{
	$VehicleAmmo[%this, Minigun] = 400;
	Vehicle::onAdd(%this);
}

FlierData Humvee
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc_sml";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.3;
   maxSpeed = 25;
   minSpeed = -10;
	//lift = 26.0;
	lift = 2.0;
	maxAlt = 10;
	maxVertical = 6;
	maxDamage = 1.0;
	damageLevel = {1.0, 1.0};
	destroyDamage = 1.0;
	maxEnergy = 100;
	accel = 0.25;

	groundDamageScale = 0.50;

	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	fireSound = SoundFireFlierRocket;
	reloadDelay = 3.0;
	damageSound = SoundTankCrash;
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundFlyerIdle;
	moveSound = SoundFlyerActive;

	visibleDriver = false;
	driverPose = 23;
	description = "HMMWV";
};

function Humvee::onAdd(%this) 
{
	$VehicleAmmo[%this, TOW] = 8;
	$VehicleAmmo[%this, AutoGrenLauncher] = 50;
	Vehicle::onAdd(%this);
}

FlierData Abrams
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc_sml";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.3;
   maxSpeed = 15;
   minSpeed = -10;
	//lift = 26.0;
	lift = 2.0;
	maxAlt = 10;
	maxVertical = 6;
	maxDamage = 1.5;
	damageLevel = {1.0, 1.0};
	destroyDamage = 1.0;
	maxEnergy = 100;
	accel = 0.25;

	groundDamageScale = 0.50;

	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	fireSound = SoundFireFlierRocket;
	reloadDelay = 3.0;
	damageSound = SoundTankCrash;
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundFlyerIdle;
	moveSound = SoundFlyerActive;

	visibleDriver = false;
	driverPose = 23;
	description = "M1A1 Abrams";
};

function Abrams::onAdd(%this) 
{
	$VehicleAmmo[%this, AbramsGun] = 30;
	$VehicleAmmo[%this, Minigun] = 400;
	Vehicle::onAdd(%this);
}

FlierData Bradley
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.175;
   maxSpeed = 15;								   
   minSpeed = -10;
	//lift = 26.0;
	lift = 2.0;
	maxAlt = 10;
	maxVertical = 6;
	maxDamage = 2.0;
	damageLevel = {1.0, 1.0};
	maxEnergy = 100;
	accel = 0.25;

	groundDamageScale = 0.125;

	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	fireSound = SoundFireFlierRocket;
	reloadDelay = 3.0;
	damageSound = SoundTankCrash;
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundFlyerIdle;
	moveSound = SoundFlyerActive;

	visibleDriver = false;
	driverPose = 23;
	description = "M113";
};

$DamageScale[Apache, $ImpactDamageType] = 1.0;
$DamageScale[Apache, $BulletDamageType] = 0.6;
$DamageScale[Apache, $PlasmaDamageType] = 1.0;
$DamageScale[Apache, $EnergyDamageType] = 1.0;
$DamageScale[Apache, $ExplosionDamageType] = 1.0;
$DamageScale[Apache, $ShrapnelDamageType] = 1.0;
$DamageScale[Apache, $DebrisDamageType] = 1.0;
$DamageScale[Apache, $MissileDamageType] = 1.0;
$DamageScale[Apache, $LaserDamageType] = 1.0;
$DamageScale[Apache, $MortarDamageType] = 1.0;
$DamageScale[Apache, $BlasterDamageType] = 0.5;
$DamageScale[Apache, $ElectricityDamageType] = 1.0;
$DamageScale[Apache, $MineDamageType]        = 1.0;
$DamageScale[Apache, $ChargeDamageType]      = 1.0;
$DamageScale[Apache, $AirstrikeDamageType]   = 1.0;

$DamageScale[Warthog, $ImpactDamageType] = 1.0;
$DamageScale[Warthog, $BulletDamageType] = 0.2;
$DamageScale[Warthog, $PlasmaDamageType] = 1.0;
$DamageScale[Warthog, $EnergyDamageType] = 1.0;
$DamageScale[Warthog, $ExplosionDamageType] = 0.7;
$DamageScale[Warthog, $ShrapnelDamageType] = 0.6;
$DamageScale[Warthog, $DebrisDamageType] = 0.7;
$DamageScale[Warthog, $MissileDamageType] = 1.0;
$DamageScale[Warthog, $LaserDamageType] = 0.3;
$DamageScale[Warthog, $MortarDamageType] = 1.0;
$DamageScale[Warthog, $BlasterDamageType] = 0.5;
$DamageScale[Warthog, $ElectricityDamageType] = 1.0;
$DamageScale[Warthog, $MineDamageType]        = 1.0;
$DamageScale[Warthog, $ChargeDamageType] = 1.0;
$DamageScale[Warthog, $AirstrikeDamageType]   = 1.0;

$DamageScale[TOWMissile, $ImpactDamageType] = 1.0;
$DamageScale[TOWMissile, $BulletDamageType] = 0.6;
$DamageScale[TOWMissile, $PlasmaDamageType] = 1.0;
$DamageScale[TOWMissile, $EnergyDamageType] = 1.0;
$DamageScale[TOWMissile, $ExplosionDamageType] = 1.0;
$DamageScale[TOWMissile, $ShrapnelDamageType] = 1.0;
$DamageScale[TOWMissile, $DebrisDamageType] = 1.0;
$DamageScale[TOWMissile, $MissileDamageType] = 1.0;
$DamageScale[TOWMissile, $LaserDamageType] = 1.0;
$DamageScale[TOWMissile, $MortarDamageType] = 1.0;
$DamageScale[TOWMissile, $BlasterDamageType] = 0.5;
$DamageScale[TOWMissile, $ElectricityDamageType] = 1.0;
$DamageScale[TOWMissile, $MineDamageType]        = 1.0;
$DamageScale[TOWMissile, $ChargeDamageType]      = 1.0;
$DamageScale[TOWMissile, $AirstrikeDamageType]   = 1.0;

$DamageScale[Blackhawk, $ImpactDamageType] = 1.0;
$DamageScale[Blackhawk, $BulletDamageType] = 0.9;
$DamageScale[Blackhawk, $PlasmaDamageType] = 1.0;
$DamageScale[Blackhawk, $EnergyDamageType] = 1.0;
$DamageScale[Blackhawk, $ExplosionDamageType] = 1.0;
$DamageScale[Blackhawk, $ShrapnelDamageType] = 1.0;
$DamageScale[Blackhawk, $DebrisDamageType] = 1.0;
$DamageScale[Blackhawk, $MissileDamageType] = 1.0;
$DamageScale[Blackhawk, $LaserDamageType] = 0.5;
$DamageScale[Blackhawk, $MortarDamageType] = 1.0;
$DamageScale[Blackhawk, $BlasterDamageType] = 0.5;
$DamageScale[Blackhawk, $ElectricityDamageType] = 1.0;
$DamageScale[Blackhawk, $MineDamageType]        = 1.0;
$DamageScale[Blackhawk, $ChargeDamageType] = 1.0;
$DamageScale[Blackhawk, $AirstrikeDamageType]   = 1.0;

$DamageScale[Humvee, $ImpactDamageType] = 0.0;
$DamageScale[Humvee, $BulletDamageType] = 0.1;
$DamageScale[Humvee, $PlasmaDamageType] = 1.0;
$DamageScale[Humvee, $EnergyDamageType] = 1.0;
$DamageScale[Humvee, $ExplosionDamageType] = 0.8;
$DamageScale[Humvee, $ShrapnelDamageType] = 0.8;
$DamageScale[Humvee, $DebrisDamageType] = 0.7;
$DamageScale[Humvee, $MissileDamageType] = 0.9;
$DamageScale[Humvee, $LaserDamageType] = 0.0;
$DamageScale[Humvee, $MortarDamageType] = 0.8;
$DamageScale[Humvee, $BlasterDamageType] = 0.5;
$DamageScale[Humvee, $ElectricityDamageType] = 1.0;
$DamageScale[Humvee, $MineDamageType]        = 0.8;
$DamageScale[Humvee, $ChargeDamageType]       = 1.0;
$DamageScale[Humvee, $AirstrikeDamageType]   = 1.0;

$DamageScale[Abrams, $ImpactDamageType] = 0.0;
$DamageScale[Abrams, $BulletDamageType] = 0.0;
$DamageScale[Abrams, $PlasmaDamageType] = 1.0;
$DamageScale[Abrams, $EnergyDamageType] = 1.0;
$DamageScale[Abrams, $ExplosionDamageType] = 0.8;
$DamageScale[Abrams, $ShrapnelDamageType] = 0.8;
$DamageScale[Abrams, $DebrisDamageType] = 0.7;
$DamageScale[Abrams, $MissileDamageType] = 0.5;
$DamageScale[Abrams, $LaserDamageType] = 0.0;
$DamageScale[Abrams, $MortarDamageType] = 0.8;
$DamageScale[Abrams, $BlasterDamageType] = 0.5;
$DamageScale[Abrams, $ElectricityDamageType] = 1.0;
$DamageScale[Abrams, $MineDamageType]        = 0.7;
$DamageScale[Abrams, $ChargeDamageType]       = 0.8;
$DamageScale[Abrams, $AirstrikeDamageType]   = 0.5;

$DamageScale[Bradley, $ImpactDamageType] = 0.0;
$DamageScale[Bradley, $BulletDamageType] = 0.0;
$DamageScale[Bradley, $PlasmaDamageType] = 1.0;
$DamageScale[Bradley, $EnergyDamageType] = 1.0;
$DamageScale[Bradley, $ExplosionDamageType] = 0.8;
$DamageScale[Bradley, $ShrapnelDamageType] = 0.8;
$DamageScale[Bradley, $DebrisDamageType] = 0.7;
$DamageScale[Bradley, $MissileDamageType] = 0.5;
$DamageScale[Bradley, $LaserDamageType] = 0.0;
$DamageScale[Bradley, $MortarDamageType] = 0.8;
$DamageScale[Bradley, $BlasterDamageType] = 0.5;
$DamageScale[Bradley, $ElectricityDamageType] = 1.0;
$DamageScale[Bradley, $MineDamageType]        = 0.7;
$DamageScale[Bradley, $ChargeDamageType]      = 0.8;
$DamageScale[Bradley, $AirstrikeDamageType]   = 0.25;

$VehicleAmmoType[Humvee, 2] = TOWAmmo;
$VehicleAmmoType[Humvee, 3] = AutoGrenAmmo;

$VehicleAmmoType[Abrams, 2] = AbramsAmmo;
$VehicleAmmoType[Abrams, 3] = MinigunAmmo;

$VehicleAmmoType[Blackhawk, 2] = MinigunAmmo;
$VehicleAmmoType[Blackhawk, 3] = MinigunAmmo;

$VehicleReloadRate[TOWAmmo] = 2;
$VehicleReloadRate[AutoGrenAmmo] = 10;
$VehicleReloadRate[AbramsAmmo] = 8;
$VehicleReloadRate[MinigunAmmo] = 80;

$VehicleAmmoMax[Humvee, TOWAmmo] = 8;
$VehicleAmmoMax[Humvee, AutoGrenAmmo] = 50;

$VehicleAmmoMax[Abrams, AbramsAmmo] = 30;
$VehicleAmmoMax[Abrams, MinigunAmmo] = 400;

$VehicleAmmoMax[Blackhawk, MinigunAmmo] = 400;

// END DELTA FORCE VEHICLES
// --------------------------------------------------

//----------------------------------------------------------------------------
//

FlierData Scout
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "flyer";
   shieldShapeName = "shield_medium";
   mass = 9.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.5;
   maxPitch = 0.5;
   maxSpeed = 50;
   minSpeed = -2;
	lift = 0.75;
	maxAlt = 25;
	maxVertical = 10;
	maxDamage = 0.6;
	damageLevel = {1.0, 1.0};
	maxEnergy = 100;
	accel = 0.4;

	groundDamageScale = 1.0;

	projectileType = FlierRocket;
	reloadDelay = 2.0;
	repairRate = 0;
	fireSound = SoundFireFlierRocket;
	damageSound = SoundFlierCrash;
	ramDamage = 1.5;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundFlyerIdle;
	moveSound = SoundFlyerActive;

	visibleDriver = true;
	driverPose = 22;
	description = "Scout";
};

FlierData LAPC
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc_sml";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.175;
   maxSpeed = 25;
   minSpeed = -1;
	lift = 0.5;
	maxAlt = 15;
	maxVertical = 6;
	maxDamage = 1.5;
	damageLevel = {1.0, 1.0};
	destroyDamage = 1.0;
	maxEnergy = 100;
	accel = 0.25;

	groundDamageScale = 0.50;

	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	fireSound = SoundFireFlierRocket;
	reloadDelay = 3.0;
	damageSound = SoundTankCrash;
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundFlyerIdle;
	moveSound = SoundFlyerActive;

	visibleDriver = true;
	driverPose = 23;
	description = "LPC";
};

FlierData HAPC
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.175;
   maxSpeed = 25;								   
   minSpeed = -1;
	lift = 0.35;
	maxAlt = 15;
	maxVertical = 6;
	maxDamage = 2.0;
	damageLevel = {1.0, 1.0};
	maxEnergy = 100;
	accel = 0.25;

	groundDamageScale = 0.125;

	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	fireSound = SoundFireFlierRocket;
	reloadDelay = 3.0;
	damageSound = SoundTankCrash;
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundFlyerIdle;
	moveSound = SoundFlyerActive;

	visibleDriver = true;
	driverPose = 23;
	description = "HPC";
};


//----------------------------------------------------------------------------

$DamageScale[Scout, $ImpactDamageType] = 1.0;
$DamageScale[Scout, $BulletDamageType] = 1.0;
$DamageScale[Scout, $PlasmaDamageType] = 1.0;
$DamageScale[Scout, $EnergyDamageType] = 1.0;
$DamageScale[Scout, $ExplosionDamageType] = 1.0;
$DamageScale[Scout, $ShrapnelDamageType] = 1.0;
$DamageScale[Scout, $DebrisDamageType] = 1.0;
$DamageScale[Scout, $MissileDamageType] = 1.0;
$DamageScale[Scout, $LaserDamageType] = 1.0;
$DamageScale[Scout, $MortarDamageType] = 1.0;
$DamageScale[Scout, $BlasterDamageType] = 0.5;
$DamageScale[Scout, $ElectricityDamageType] = 1.0;
$DamageScale[Scout, $MineDamageType]        = 1.0;

$DamageScale[LAPC, $ImpactDamageType] = 1.0;
$DamageScale[LAPC, $BulletDamageType] = 1.0;
$DamageScale[LAPC, $PlasmaDamageType] = 1.0;
$DamageScale[LAPC, $EnergyDamageType] = 1.0;
$DamageScale[LAPC, $ExplosionDamageType] = 1.0;
$DamageScale[LAPC, $ShrapnelDamageType] = 1.0;
$DamageScale[LAPC, $DebrisDamageType] = 1.0;
$DamageScale[LAPC, $MissileDamageType] = 1.0;
$DamageScale[LAPC, $LaserDamageType] = 0.5;
$DamageScale[LAPC, $MortarDamageType] = 1.0;
$DamageScale[LAPC, $BlasterDamageType] = 0.5;
$DamageScale[LAPC, $ElectricityDamageType] = 1.0;
$DamageScale[LAPC, $MineDamageType]        = 1.0;

$DamageScale[HAPC, $ImpactDamageType] = 1.0;
$DamageScale[HAPC, $BulletDamageType] = 1.0;
$DamageScale[HAPC, $PlasmaDamageType] = 1.0;
$DamageScale[HAPC, $EnergyDamageType] = 1.0;
$DamageScale[HAPC, $ExplosionDamageType] = 1.0;
$DamageScale[HAPC, $ShrapnelDamageType] = 1.0;
$DamageScale[HAPC, $DebrisDamageType] = 1.0;
$DamageScale[HAPC, $MissileDamageType] = 1.0;
$DamageScale[HAPC, $LaserDamageType] = 0.5;
$DamageScale[HAPC, $MortarDamageType] = 1.0;
$DamageScale[HAPC, $BlasterDamageType] = 0.5;
$DamageScale[HAPC, $ElectricityDamageType] = 1.0;
$DamageScale[HAPC, $MineDamageType]        = 1.0;


//----------------------------------------------------------------------------

// Should keep the vehicles relatively close to the ground...hopefully
function hugGround(%this) 
{
	GameBase::getLOSInfo(%this, 500, "-1.57 0 0");
	%posZ = getWord($los::position, 2) + 2.0;
	%curPos = GameBase::getPosition(%this);
	%posX = getWord(%curPos, 0);
	%posY = getWord(%curPos, 1);
	%curPos = ""@%posX@" "@%posY@" "@%posZ@"";	
	GameBase::setPosition(%this, %curPos);
	schedule("hugGround("@%this@");", 2, %this);
}

function Vehicle::onAdd(%this)
{
	%this.shieldStrength = 0.0;
	GameBase::setRechargeRate (%this, 10);
	GameBase::setMapName (%this, "Vehicle");
	if (GameBase::getDataName(%this) == Abrams || GameBase::getDataName(%this) == Bradley || GameBase::getDataName(%this) == Humvee) {
		schedule("hugGround("@%this@");", 2, %this);
	}
}

function Vehicle::onCollision (%this, %object)
{
	%client = Player::getClient(%object);
	if(GameBase::getDataName(%this) == TOWMissile) {
		Vehicle::dismount(%this, "0 0 0");
		return;
	}
	if(GameBase::getDamageLevel(%this) < (GameBase::getDataName(%this)).maxDamage) {
		if (getObjectType (%object) == "Player" && %object.vehicle == "" && (getSimTime() > %object.newMountTime || %object.lastMount != %this) && %this.fading == "")
			{
            if( Player::isAiControlled(%object) )
               return;
               
				%armor = Player::getArmor(%object);
				// PATCH
				if ((%armor != "larmor" && %armor != "lfemale") && (GameBase::getDataName(%this) == Apache || GameBase::getDataName(%this) == Warthog)) {
					Client::sendMessage(Player::getClient(%object),0,"You must be a pilot to control the vehicles.~wError_Message.wav");
					return;
				}
				// END PATCH
				if ((%armor == "larmor" || %armor == "lfemale") && Vehicle::canMount (%this, %object))
					{
						%weapon = Player::getMountedItem(%object,$WeaponSlot);
						if(%weapon != -1) {
							%object.lastWeapon = %weapon;
							Player::unMountItem(%object,$WeaponSlot);
						}
						Player::setMountObject(%object, %this, 1);
				      Client::setControlObject(%client, %this);
						if(GameBase::getDataName(%this) == Warthog) {
							%this.minSpeed = 10;
						}
						playSound (GameBase::getDataName(%this).mountSound, GameBase::getPosition(%this));
						%object.driver= 1;
		            %object.vehicle = %this;
						%this.clLastMount = %client;
					}
				else if((GameBase::getDataName(%this) != Scout) || (GameBase::getDataName(%this) != Apache)) 
					{
						if (%armor == "aarmor") {
							Client::sendMessage(Player::getClient(%object),0,"Artillery cannot ride in vehicles.~wError_Message.wav");
							return;
						}
					 	%mountSlot= Vehicle::findEmptySeat(%this,%client); 
						if(%mountSlot) 
							{
								%object.vehicleSlot = %mountSlot;
								//FOR DEBUGGING PURPOSES
								//echo("MSG: You have entered mountSlot ",%mountSlot,".");
								// END DEBUG
								%object.vehicle = %this;
								Player::setMountObject(%object, %this, %mountSlot);
								playSound (GameBase::getDataName(%this).mountSound, GameBase::getPosition(%this));
								// DELTA FORCE
								if(Gamebase::getDataName(%this) == Blackhawk) {
									Player::setItemCount(%client,Minigun,1);
									Player::useItem(%client,Minigun);
									Player::setItemCount(%client,MinigunAmmo,$VehicleAmmo[%this, Minigun]);
								} else if(Gamebase::getDataName(%this) == Abrams) {
									if (%mountSlot == 2) {
										Player::setItemCount(%client,AbramsAmmo,$VehicleAmmo[%this, AbramsGun]);
										Player::setItemCount(%client,AbramsGun,1);
										Player::useItem(%client,AbramsGun);
									} else {
										Player::setItemCount(%client,MinigunAmmo,$VehicleAmmo[%this, Minigun]);
										Player::setItemCount(%client,Minigun,1);
										Player::useItem(%client,Minigun);
									}
								} else if (Gamebase::getDataName(%this) == Humvee) {
									if (%mountSlot == 2) {
										Player::setItemCount(%client,TOWAmmo,$VehicleAmmo[%this, TOW]);
										Player::setItemCount(%client,TOW,1);
										Player::useItem(%client,TOW);
									} else {
										Player::setItemCount(%client,AutoGrenAmmo,$VehicleAmmo[%this, AutoGrenLauncher]);
										Player::setItemCount(%client,AutoGrenLauncher,1);
										Player::useItem(%client,AutoGrenLauncher);
									}
								}							
								// END DELTA FORCE
							}
					}
				else if (GameBase::getControlClient(%this) == -1)
					Client::sendMessage(Player::getClient(%object),0,"You must be a pilot to control the vehicles.~wError_Message.wav");
			}
	}
}

function Vehicle::findEmptySeat(%this,%client)
{
	if(GameBase::getDataName(%this) == HAPC)
		%numSlots = 4;
	else
		%numSlots = 2;
	%count=0;
	for(%i=0;%i<%numSlots;%i++)  
		if(%this.Seat[%i] == "") {
			%slotPos[%count] = Vehicle::getMountPoint(%this,%i+2);
			%slotVal[%count] = %i+2;
			%lastEmpty = %i+2;
			%count++;
		}
	if(%count == 1) {
		%this.Seat[%lastEmpty-2] = %client;
		return %lastEmpty;
	}
	else if (%count > 1)	{
		%freeSlot = %slotVal[getClosestPosition(%count,GameBase::getPosition(%client),%slotPos[0],%slotPos[1],%slotPos[2],%slotPos[3])];
		%this.Seat[%freeSlot-2] = %client;
		return %freeSlot;
	}
	else
		return "False";
}

function getClosestPosition(%num,%playerPos,%slotPos0,%slotPos1,%slotPos2,%slotPos3)
{
	%playerX = getWord(%playerPos,0);
	%playerY = getWord(%playerPos,1);
	for(%i = 0 ;%i<%num;%i++) {
		%x = (getWord(%slotPos[%i],0)) - %playerX;
		%y = (getWord(%slotPos[%i],1)) - %playerY;
		if(%x < 0)
			%x *= -1;
		if(%y < 0)
			%y *= -1;
		%newDistance = sqrt((%x*%x)+(%y*%y));
		if(%newDistance < %distance || %distance == "") {
	  		%distance = %newDistance;			
			%closePos = %i;	
		}
	}		
	return %closePos;
}

function Vehicle::passengerJump(%this,%passenger,%mom)
{
	%armor = Player::getArmor(%passenger);
	if(%armor == "larmor" || %armor == "lfemale" || %armor == "sarmor" || %armor == "sfemale" || %armor == "carmor" || %armor == "cfemale" || %armor == "parmor" || %armor == "pfemale") {
		%height = 2;
		%velocity = 70;
		%zVec = 70;
	}
	else if(%armor == "marmor" || %armor == "mfemale" || %armor == "iarmor" || %armor == "ifemale" || %armor == "earmor" || %armor == "efemale") {
		%height = 2;
		%velocity = 100;
		%zVec = 100;
	}
	else if(%armor == "harmor" || %armor == "aarmor") {
		%height = 2;
		%velocity = 140;
		%zVec = 110;
	}

	%pos = GameBase::getPosition(%passenger);
	%posX = getWord(%pos,0);
	%posY	= getWord(%pos,1);
	%posZ	= getWord(%pos,2);

	if(GameBase::testPosition(%passenger,%posX @ " " @ %posY @ " " @ (%posZ + %height))) {	
		%client = Player::getClient(%passenger);
		//DELTAFORCE
		if(GameBase::getDataName(%this) == Humvee) {
			if(%passenger.vehicleSlot == 2) {
				$VehicleAmmo[%this, TOW] = Player::getItemCount(%client, TOWAmmo);
			} else if(%passenger.vehicleSlot == 3) {
				$VehicleAmmo[%this, AutoGrenLauncher] = Player::getItemCount(%client, AutoGrenAmmo);
			}
		} else if(GameBase::getDataName(%this) == Abrams) {
			if(%passenger.vehicleSlot == 2) {
				$VehicleAmmo[%this, AbramsGun] = Player::getItemCount(%client, AbramsAmmo);
			} else if(%passenger.vehicleSlot == 3) {
				$VehicleAmmo[%this, Minigun] = Player::getItemCount(%client, MinigunAmmo);
			}
		} else if(GameBase::getDataName(%this) == BlackHawk) {
			if(%passenger.vehicleSlot == 2 || %passenger.vehicleSlot == 3)
				$VehicleAmmo[%this, Minigun] = Player::getItemCount(%client, MinigunAmmo);
		}
		// END DELTAFORCE
		%this.Seat[%passenger.vehicleSlot-2] = "";
		%passenger.vehicleSlot = "";
	   %passenger.vehicle= "";
		Player::setMountObject(%passenger, -1, 0);
		%rotZ = getWord(GameBase::getRotation(%passenger),2);
		GameBase::setRotation(%passenger, "0 0 " @ %rotZ);
		GameBase::setPosition(%passenger,%posX @ " " @ %posY @ " " @ (%posZ + %height));
		%jumpDir = Vector::getFromRot(GameBase::getRotation(%passenger),%velocity,%zVec);
		Player::applyImpulse(%passenger,%jumpDir);
	}
	else
		Client::sendMessage(Player::getClient(%passenger),0,"Can not dismount - Obstacle in the way.~wError_Message.wav");
	
	// DELTA FORCE
	Player::setItemCount(%passenger,Minigun,0);
	Player::setItemCount(%passenger,AbramsGun,0);
	Player::setItemCount(%passenger,TOW,0);
	Player::setItemCount(%passenger,AutoGrenLauncher,0);
	Player::useItem(%passenger, %passenger.lastWeapon);
	// END DELTA FORCE
}

function Vehicle::jump(%this,%mom)
{
   Vehicle::dismount(%this,%mom);
}

function Vehicle::dismount(%this,%mom)
{
   %cl = GameBase::getControlClient(%this);
   if(%cl != -1)
   {
      %pl = Client::getOwnedObject(%cl);
	if(GameBase::getDataName(%this) == TOWMissile) {
		Client::setControlObject(%cl, %pl);
		GameBase::setDamageLevel(%this, 0.1);
		return;
	}
      if(getObjectType(%pl) == "Player")
      {
		   // dismount the player	  
			if(GameBase::testPosition(%pl, Vehicle::getMountPoint(%this,0))) {
				%pl.lastMount = %this;
				%pl.newMountTime = getSimTime() + 3.0;
				Player::setMountObject(%pl, %this, 0);
        	 	Player::setMountObject(%pl, -1, 0);
				%rot = GameBase::getRotation(%this);
				%rotZ = getWord(%rot,2);
				GameBase::setRotation(%pl, "0 0 " @ %rotZ);
				Player::applyImpulse(%pl,%mom);
        	 	Client::setControlObject(%cl, %pl);
				if(GameBase::getDataName(%this) == Warthog) {
					%this.minSpeed = 0;
				}
				playSound (GameBase::getDataName(%this).dismountSound, GameBase::getPosition(%this));
				if(%pl.lastWeapon != "") {
					Player::useItem(%pl,%pl.lastWeapon);		 	
					%pl.lastWeapon = "";
      		}
				%pl.driver = "";
				%pl.vehicle = "";
			}
			else
				Client::sendMessage(%cl,0,"Can not dismount - Obstacle in the way.~wError_Message.wav");
		}
   }
}

function Vehicle::onDestroyed (%this,%mom)
{
//	if($testcheats || $servercheats)
	$TeamItemCount[GameBase::getTeam(%this) @ $VehicleToItem[GameBase::getDataName(%this)]]--;
   %cl = GameBase::getControlClient(%this);
	%pl = Client::getOwnedObject(%cl);
	if(%pl != -1) {
	   Player::setMountObject(%pl, -1, 0);
   	Client::setControlObject(%cl, %pl);
		if(%pl.lastWeapon != "") {
			Player::useItem(%pl,%pl.lastWeapon);		 	
			%pl.lastWeapon = "";
		}
		%pl.driver = "";
	   %pl.vehicle= "";
	}
	for(%i = 0 ; %i < 4 ; %i++)
		if(%this.Seat[%i] != "") {
			%pl = Client::getOwnedObject(%this.Seat[%i]);
		   Player::setMountObject(%pl, -1, 0);
	  	 	Client::setControlObject(%this.Seat[%i], %pl);
			%pl.vehicleSlot = "";
		   %pl.vehicle= "";
			// DELTA FORCE
			Player::setItemCount(%pl,Minigun,0);
			Player::setItemCount(%pl,AbramsGun,0);
			Player::setItemCount(%pl,AutoGrenLauncher,0);
			Player::setItemCount(%pl,TOW,0);
			Player::useItem(%pl, %pl.lastWeapon);
			// END DELTA FORCE			
		}
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 2, 0.55, 
		0.1, 225, 100); 
}

function Vehicle::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
	%value *= $damageScale[GameBase::getDataName(%this), %type];
	StaticShape::onDamage(%this,%type,%value,%pos,%vec,%mom,%object);
}

function Vehicle::getHeatFactor(%this)
{
	// Not getting called right now because turrets don't track
	// vehicles.  A hack has been placed in Player::getHeatFactor.
   return 1.0;
}