#include "Console.h"

// #define __CONSOLE_DISABLE_OUTPUT__

#if defined(__WIN32__)
HANDLE Console::mOutputHandle = NULL;
#endif

bool Console::mHasColor = true;

void Console::Close( ) {
}

void Console::Error( char *fmt, ... ) {
#if !defined(__CONSOLE_DISABLE_OUTPUT__)
	va_list args;

	Console::SetColor( CONSOLE_RED );
	
	va_start( args, fmt );
	Console::PrintVarArg( fmt, args );
	va_end( args );

	Console::SetColor( CONSOLE_COLOR_DEFAULT );
#endif
}

void Console::Init( ) {
#if defined(__WIN32__)
	Console::mOutputHandle = GetStdHandle( STD_OUTPUT_HANDLE );
#endif

	Console::SetColor( CONSOLE_COLOR_DEFAULT );
}

void Console::PrintVarArg( char *fmt, va_list args ) {
#if !defined(__CONSOLE_DISABLE_OUTPUT__)
	vprintf( fmt, args );
#endif
}

void Console::Print( char *fmt, ... ) {
#if !defined(__CONSOLE_DISABLE_OUTPUT__)
	va_list args;

	va_start( args, fmt );
	Console::PrintVarArg( fmt, args );
	va_end( args );
#endif
}

void Console::PrintColorVarArg( int color, char *fmt, va_list args ) {
#if !defined(__CONSOLE_DISABLE_OUTPUT__)
	Console::SetColor( color );
	vprintf( fmt, args );
	Console::SetColor( CONSOLE_COLOR_DEFAULT );
#endif
}

void Console::PrintColor( int color, char *fmt, ... ) {
#if !defined(__CONSOLE_DISABLE_OUTPUT__)
	va_list args;

	va_start( args, fmt );
	Console::PrintColorVarArg( color, fmt, args );
	va_end( args );
#endif
}

void Console::SetColor( int color ) {
#if defined(__COLOR__)

#if !defined(__CONSOLE_DISABLE_OUTPUT__)
	if ( !Console::mHasColor )
			return;

#if defined(__WIN32__)
	if ( Console::mOutputHandle )
		SetConsoleTextAttribute( Console::mOutputHandle, color );
#elif defined(__NIX__)
	int bold = 1;
	if ( color == CONSOLE_COLOR_DEFAULT ) {
		color = CONSOLE_WHITE;
		bold = 0;
	}

	printf( "%c[%d;%d;%dm", 0x1b, bold, color + 30, CONSOLE_BLACK + 40 );
#endif

#endif // __CONSOLE_DISABLE_OUTPUT__

#endif // __COLOR__
}
