#ifndef __T1DEMO_H__
#define __T1DEMO_H__

/*
    - T1NetStream derived class to source packets from a demo recording
*/


#include "T1.h"
#include "T1NetStream.h"
#include "T1EventManager.h"
#include "bitStream.h"

struct Move {
    float forward, backward, left, right;
    char jet, dummy, jump, shoot;
	int dummy2;
	float yaw, pitch;
};

class T1Demo : public T1NetStream {
public:
	T1Demo( T1Game *game );
	~T1Demo( ) { Close( ); }

	virtual void Close( );
	virtual bool GetIsDemo( );
	virtual int GetTicks( );
	virtual void Open( char *source );
	virtual bool Poll( );
	virtual bool Start( );
	
	virtual void SetFullspeed( bool flag ) { mFullSpeed = flag; }
	virtual void SetTimeScale( float t ) { if ( t < 0 ) t = 0; mTimeScale = t; }

private:
	// demo data
	char *mData;
	int mSize;

	// bitstream wrappers and dest structs
	BitStream mDemo, mPacket;
	Move mMove;
	char mChunk[ 1500 ];	

protected:
	bool mFullSpeed, mReplaying;
	unsigned int mStartTicks, mNextEventTicks, mTicks;
	float mTime;
	float mTimeScale;
};


#endif // __T1DEMO_H__
