#ifndef __CONSOLE_H__
#define __CONSOLE_H__

#include "T1.h"

#if defined(__WIN32__)
	#define CONSOLE_BLACK    (     0 )
	#define CONSOLE_BLUE     ( 1 | 8 )
	#define CONSOLE_GREEN    ( 2 | 8 )
	#define CONSOLE_CYAN     ( 3 | 8 )
	#define CONSOLE_RED      ( 4 | 8 )
	#define CONSOLE_MAGENTA  ( 5 | 8 )
	#define CONSOLE_YELLOW   ( 6 | 8 )
	#define CONSOLE_WHITE    ( 7 | 8 )

	#define CONSOLE_COLOR_DEFAULT ( 7 )
#elif defined(__NIX__)
	#define CONSOLE_BLACK    ( 0 )
	#define CONSOLE_BLUE     ( 4 )
	#define CONSOLE_GREEN    ( 2 )
	#define CONSOLE_CYAN     ( 6 )
	#define CONSOLE_RED      ( 1 )
	#define CONSOLE_MAGENTA  ( 5 )
	#define CONSOLE_YELLOW   ( 3 )
	#define CONSOLE_WHITE    ( 7 )

	#define CONSOLE_COLOR_DEFAULT ( 8 )
#endif


class Console {
public:
	static void Close( );
	static void Error( char *fmt, ... );
	static void Init( );
	static void PrintVarArg( char *fmt, va_list args );
	static void Print( char *fmt, ... );
	static void PrintColorVarArg( int color, char *fmt, va_list args );
	static void PrintColor( int color, char *fmt, ... );
	static void SetColor( int color );

private:
#if defined(__WIN32__)
	static HANDLE mOutputHandle;
#endif
	static bool mHasColor;
};


#endif // __CONSOLE_H__
