#include "T1Game.h"
#include "T1Demo.h"
// #include "T1NetLayer.h"
#include "Console.h"

T1Game::T1Game( ) {
	mNetStream = NULL;
	mConnected = false;
	mCGAFlag = true;
	mManagerId = 0;
	mServerId = 0;
	
	T1::Strncpy( mLastServer, "", 254 );
	T1::Strncpy( mLastDemo, "", 254 );

	SetPlayerName( __OS__ );
	SetPlayerGender( "MALE" );
	SetPlayerVoice( "male1" );
	SetPlayerSkin( "base" );
	SetServerPassword( "" );
	SetTribesVersion( "1.11" );
}

T1Game::~T1Game( ) {
	Close( ); 
}

void T1Game::Close( ) {
	if ( mNetStream )
		delete mNetStream;
	mNetStream = NULL;
}

bool T1Game::GetIsDemo( ) {
	return ( mNetStream ) ?
		mNetStream->GetIsDemo( ) : false;
}

bool T1Game::GetOk( ) {
	return ( mNetStream ) ? 
		mNetStream->GetOk( ) : false;
}

int T1Game::GetGameTicks( ) {
	return ( mNetStream ) ? 
		mNetStream->GetTicks( ) : 0;
}

void T1Game::OnConnectionAccepted( int manager_id, int server_id ) {
	mManagerId = manager_id; 
	mServerId = server_id;
	mConnected = true;
}

void T1Game::OnConnectionRejected( const char *reason ) {
	mConnected = false;
}

void T1Game::OnConnectionTimedOut( ) {
	mConnected = false;
}

void T1Game::OnDisconnected( const char *reason ) {
	mConnected = false;
}

void T1Game::OnDataFinished( ) {
	mNetStream->RemoteEval( "dataFinished", 0 );
	mNetStream->RemoteEval( "CGADone", 0 );
	mCGAFlag = true; // Allow a CGA flag just in case
}

void T1Game::OnMissionReset( ) {
	mCGAFlag = true; // Allow a fake CGA on next TeamAdd
}

void T1Game::OnTeamAdd( int id_team, char *name ) {
	if ( mCGAFlag && ( id_team != -1 ) ) {
		mNetStream->RemoteEval( "CGADone", 0 );
		mCGAFlag = false;
	}
}


void T1Game::OpenDemo( char *file ) {
	Close( );

	mNetStream = new T1Demo( this );
	mNetStream->Open( file );
}

void T1Game::OpenServer( char *server, char *demo_name ) {
	Close( );	

	// mNetStream = new T1NetLayer( this );
	// mNetStream->SetDemoName( demo_name );
	// mNetStream->Open( server );

	// T1::Strncpy( mLastServer, server, 254 );
	// T1::Strncpy( mLastDemo, demo_name, 254 );
}

void T1Game::OpenLastServer( char *demo_name ) {
	// Keep the old setting if there isn't a demo name
	if ( demo_name )
		T1::Strncpy( mLastDemo, demo_name, 254 );
	
	OpenServer( mLastServer, mLastDemo );
}

bool T1Game::Poll( ) {
	return ( mNetStream ) ? 
		mNetStream->Poll( ) : false;
}

void T1Game::SetFullspeed( bool flag ) {
	if ( mNetStream )
		mNetStream->SetFullspeed( flag ); 
}

void T1Game::SetTimeScale( float t ) { 
	if ( mNetStream )
		mNetStream->SetTimeScale( t ); 
}

bool T1Game::Start( ) {
	mConnected = ( mNetStream ) ? 
		mNetStream->Start( ) : false;

	return ( mConnected );
}

void T1Game::SetPlayerName( char *name ) {
	T1::Strncpy( mPlayerName, name, 31 );
}

void T1Game::SetPlayerVoice( char *voice ) {
	T1::Strncpy( mPlayerVoice, voice, 31 );
}

void T1Game::SetPlayerGender( char *gender ) {
	T1::Strncpy( mPlayerGender, gender, 31 );
}

void T1Game::SetPlayerSkin( char *skin ) {
	T1::Strncpy( mPlayerSkin, skin, 31 );
}

void T1Game::SetTribesVersion( char *version ) {
	T1::Strncpy( mTribesVersion, version, 31 );
}

void T1Game::SetServerPassword( char *password ) {
	T1::Strncpy( mServerPassword, password, 31 );
}

