#ifndef __T1GAME_H__
#define __T1GAME_H__

/*
    - Main T1 class to provide an outlet for events.
    - Empty stubs provided for all events except some hacky stuff with the
      ?_Chain( ) methods.
*/

#include "T1.h"
#include "T1NetStream.h"

class T1NetStream;

class T1Game {
public:
	T1Game( );
	virtual ~T1Game( ); // make derived destructors chain	

	// listenable events
	virtual void OnConnectionAccepted( int manager_id, int server_id );
	virtual void OnConnectionRejected( const char *reason );
	virtual void OnConnectionTimedOut( );
	virtual void OnDataFinished( );
	virtual void OnDisconnected( const char *reason );
	virtual void OnDataBlock( int type, int index, int index_max ) { };
	virtual void OnMissionReset( );
	virtual void OnPacket( int size ) { };
	virtual void OnPlayerSay( int id_player, int type, char *msg ) { };
	virtual void OnPlayerChangeTeam( int id_player, int id_team ) { };
	virtual void OnPlayerDrop( int id_player ) { };
	virtual void OnPlayerJoin( int id_player, int id_team, char *name ) { };
	virtual void OnPlayerPingPL( int id_player, int ping, float pl ) { };
	virtual void OnRemoteEval( char *function, int argc, char *argv[] ) { };
	virtual void OnTeamAdd( int id_team, char *name );

	/*
		If you override these in your class, make sure to call T1Game::Poll
		or T1Game::Start, etc, at the beginning of your overridden function.
	*/
	void Close( );
	bool GetIsDemo( );
	bool GetOk( );
	int GetGameTicks( );
	void OpenDemo( char *file );
	void OpenServer( char *server, char *demo_name = NULL );
	void OpenLastServer( char *demo_name = NULL );
	bool Poll( );
	void SetFullspeed( bool flag );
	void SetTimeScale( float t );
	bool Start( );


	/*
		Player to server items
	*/
	const char *GetPlayerName( ) { return ( mPlayerName ); }
	const char *GetPlayerVoice( ) { return ( mPlayerVoice ); }
	const char *GetPlayerGender( ) { return ( mPlayerGender ); }
	const char *GetPlayerSkin( ) { return ( mPlayerSkin ); }
	const char *GetTribesVersion( ) { return ( mTribesVersion ); }
	const char *GetServerPassword( ) { return ( mServerPassword ); }

	void SetPlayerName( char *name );
	void SetPlayerVoice( char *voice );
	void SetPlayerGender( char *gender );
	void SetPlayerSkin( char *skin );
	void SetTribesVersion( char *version );
	void SetServerPassword( char *password );

protected:
	T1NetStream *mNetStream;
	bool mConnected, mCGAFlag;
	int mManagerId, mServerId;
	char mLastServer[ 255 ], mLastDemo[ 255 ];

	// player to server settings
	char mPlayerName[ 32 ];
	char mPlayerVoice[ 32 ];
	char mPlayerGender[ 32 ];
	char mPlayerSkin[ 32 ];
	char mTribesVersion[ 32 ];
	char mServerPassword[ 32 ];
};








#endif // __T1GAME_H__
