#include "T1.h"

unsigned int T1::start_ticks = 0;
bool T1::set_start = false;

int T1::GetSystemTicks( ) {
	unsigned int ticks;

#if defined(__WIN32__)
	ticks = GetTickCount( );
#else
	timeval t;
	gettimeofday( &t, NULL );
	ticks = ( (unsigned long)t.tv_sec * 1000 + (unsigned long)t.tv_usec / 1000 );
#endif

	if ( !T1::set_start ) {
		T1::set_start = true;
		T1::start_ticks = ticks;
	}

	return ( ticks - T1::start_ticks );
}

int T1::Net_GetLastError( ) {
#if defined(__WIN32__)
	return ( WSAGetLastError() );
#elif defined(__NIX__)
	return ( errno );
#endif
}

// Copies up to max_len bytes and zero terminates the string
// Treats NULL for src as an empty blank string
char *T1::Strncpy( char *dst, const char *src, size_t max_len ) {
	size_t len = 0;

	if ( src ) {
		len = strlen( src );
		if ( len >= max_len )
			len = max_len;

		if ( len > 0 )
			memcpy( dst, src, len );
	}

	dst[ len ] = '\x0';
	return ( dst );
}

bool T1::Net_Startup( ) {
#if defined(__WIN32__)
    WSADATA wsadata;	
    
	if ( WSAStartup( MAKEWORD(2,0), &wsadata ) != 0 )
		return ( false );
#endif

	return ( true );
}

void T1::Net_Shutdown( ) {
#if defined(__WIN32__)
	WSACleanup( );
#endif
}

void T1::Sleep( unsigned int ms ) {
#if defined(__WIN32__)
	::Sleep( ms );
#else
	usleep( ms * 1000 );
#endif
}
