#ifndef __T1_H__
#define __T1_H__

// This still needs to be enabled/disabled by hand
// #define __USE_BIG_ENDIAN__

#define __COLOR__

/*
	T1 utility & cross platform header. You still need to edit the define
	if you want to switch to big endian

	Quick build with gcc:
	g++  T1*.cpp bitStream.cpp Console.cpp main.cpp -O3 -fomit-frame-pointer -o t1netcode

	Add -lsocket -lnsl on Solaris
*/

#undef __WIN32__
#undef __NIX__
#undef __LINUX__
#undef __BSD__
#undef __OSX__
#undef __SOLARIS__

#undef __OS__

// Autodetect what we're compiling on
#if defined(_WIN32)	
	// vs2005 secure crt whining
	#define _CRT_SECURE_NO_DEPRECATE

	// dont let windows include winsock.h
	#if !defined(_WINSOCKAPI_)
		#define _WINSOCKAPI_
	#endif 
	#include <windows.h>
	#include <sys/types.h>
	#include <sys/stat.h>


	#define __WIN32__
	#define __OS__ "win32"

	#define vsnprintf _vsnprintf
	#define snprintf _snprintf
#else	
	#include <sys/param.h> // need this to define BSD
	#include <unistd.h>
	#include <stdlib.h>

	#define __NIX__
	#if defined(__linux__)
		#define __LINUX__
		#define __OS__ "linux"
	#elif defined(BSD)
		#define __BSD__
		#define __OS__ "bsd"

		#if defined(MACOS_X) || defined(__APPLE__)	
			#define __OSX__
			#undef __OS__
			#define __OS__ "bsd/osx"
		#endif		
	#elif defined(__SVR4) && defined(__sun)
		#include <sys/filio.h>

		#define __SOLARIS__ 1
		#define __OS__ "solaris"
	#endif

	// windows #1
	#define O_BINARY ( 0 )
#endif

// Just in case
#if !defined( NULL )
	#define NULL ( 0 )
#endif


// Handle file and networking setup
#if defined(__WIN32__)
	#include <winsock2.h>
	#include <ws2tcpip.h>
	#include <string.h>
	#include <fcntl.h>	
	#include <io.h>
	#include <conio.h>

	// Cast Win32 net messags to *nix
	#define EWOULDBLOCK		WSAEWOULDBLOCK
	#define EINPROGRESS		WSAEINPROGRESS
	#define EALREADY		WSAEALREADY
	#define ENOTSOCK		WSAENOTSOCK
	#define EDESTADDRREQ	WSAEDESTADDRREQ
	#define EMSGSIZE		WSAEMSGSIZE
	#define EPROTOTYPE		WSAEPROTOTYPE
	#define ENOPROTOOPT		WSAENOPROTOOPT
	#define EPROTONOSUPPORT	WSAEPROTONOSUPPORT
	#define ESOCKTNOSUPPORT	WSAESOCKTNOSUPPORT
	#define EOPNOTSUPP		WSAEOPNOTSUPP
	#define EPFNOSUPPORT	WSAEPFNOSUPPORT
	#define EAFNOSUPPORT	WSAEAFNOSUPPORT
	#define EADDRINUSE		WSAEADDRINUSE
	#define EADDRNOTAVAIL	WSAEADDRNOTAVAIL
	#define ENETDOWN		WSAENETDOWN
	#define ENETUNREACH		WSAENETUNREACH
	#define ENETRESET		WSAENETRESET
	#define ECONNABORTED	WSAECONNABORTED
	#define ECONNRESET		WSAECONNRESET
	#define ENOBUFS			WSAENOBUFS
	#define EISCONN			WSAEISCONN
	#define ENOTCONN		WSAENOTCONN
	#define ESHUTDOWN		WSAESHUTDOWN
	#define ETOOMANYREFS	WSAETOOMANYREFS
	#define ETIMEDOUT		WSAETIMEDOUT
	#define ECONNREFUSED	WSAECONNREFUSED
	#define ELOOP			WSAELOOP
	#define ENAMETOOLONG	WSAENAMETOOLONG
	#define EHOSTDOWN		WSAEHOSTDOWN
	#define EHOSTUNREACH	WSAEHOSTUNREACH
	#define ENOTEMPTY		WSAENOTEMPTY
	#define EPROCLIM		WSAEPROCLIM
	#define EUSERS			WSAEUSERS
	#define EDQUOT			WSAEDQUOT
	#define ESTALE			WSAESTALE
	#define EREMOTE			WSAEREMOTE

	typedef int socklen_t;

	#define open _open
	#define close _close
	#define lseek _lseek
	#define read _read
	#define write _write
#else	
	#include <sys/types.h>
	#include <sys/time.h>
	#include <sys/stat.h>
	#include <sys/ioctl.h>

	#if defined(__OSX__)
		#define _BSD_SOCKLEN_T_ // for socklen_t in sys/socket.h
	#endif

	#include <sys/socket.h>
	#include <arpa/inet.h>
	#include <netdb.h>
	#include <fcntl.h>
	#include <errno.h>

	#if defined(__BSD__)
		#include <netinet/in.h>
	#endif

	#define closesocket close
	#define ioctlsocket ioctl		

	typedef int SOCKET;
#endif

#include <stdio.h>
#include <string.h>
#include <stdarg.h> // for va_list / va_start / etc


// Types
typedef signed char S8;
typedef unsigned char U8;
typedef signed short S16;
typedef unsigned short U16;
typedef signed int S32;
typedef unsigned int U32;
typedef float F32;


// A few generic systems functions
class T1 {
public:
	static int GetSystemTicks( );
	static char *Strncpy( char *dst, const char *src, size_t max_len );
	static bool Net_Startup( );
	static void Net_Shutdown( );
	static int Net_GetLastError( );
	static void Sleep( unsigned int ms );

private:
	static unsigned int start_ticks;
	static bool set_start;
};


#endif // __T1_H__
