#include "T1.h"
#include "T1Demo.h"
#include "Console.h"

T1Demo::T1Demo( T1Game *game ) : T1NetStream( game ) {	
	mData = NULL;	
	mFullSpeed = false;	
	mTimeScale = 1.0f;

	Close( );
}

void T1Demo::Close( ) {
	if ( mData )
		delete mData;	

	mNextEventTicks = 0;
	mOk = false;
	mData = NULL;
	mDemo.setBuffer( NULL, 0 );
}

bool T1Demo::GetIsDemo( ) {
	return ( true );
}

int T1Demo::GetTicks( ) {
	return ( mNextEventTicks );
}

void T1Demo::Open( char *source ) {
	Close( );

	Console::PrintColor( CONSOLE_GREEN,  "Attempting to read %s\n", source );

	int f = open( source, O_RDONLY );
	if ( f == -1 )
		return;

	mSize = lseek( f, 0, SEEK_END );
	lseek( f, 0, SEEK_SET );
	mData = new char[ mSize ];
	read( f, mData, mSize );
	close( f );

	mDemo.setBuffer( mData, mSize );
	mOk = true;
}



bool T1Demo::Start( ) {
	if ( !mOk )
		return ( false );

	mStartTicks = T1::GetSystemTicks( );
	mTicks = mStartTicks;
	mTime = 0.0f;

	int manager_id = mDemo.readInt( 32 );
	int server_id = mDemo.readInt( 32 );
	mNextEventTicks = mDemo.readInt( 32 );

	if ( manager_id <= 2048 || manager_id >= 2303 )  {
		Console::Error( "Don't feed me crap demos (check system endianness?), mgr id = %d, sv id = %d\n", manager_id, server_id );
		Close( );
		return ( false );
	}

	// Fake OnConnectionAccepted
	mGame->OnConnectionAccepted( manager_id, server_id );

	mReplaying = true;
	return ( true );
}

bool T1Demo::Poll( ) {
	if ( !mOk || !mReplaying || !mDemo.getOk( ) || mDemo.getIsFull( ) )
		return ( false );

	while ( true ) {
		if ( !mFullSpeed ) {
			int elapsed = ( T1::GetSystemTicks( ) - mTicks );
			mTicks = T1::GetSystemTicks( );
			mTime += ( elapsed * mTimeScale );
			if ( mTime < mNextEventTicks )
				break;
		}

		int flag = mDemo.readInt( 8 );
			
		if ( flag == 0xff ) {
			int chunk_size = mDemo.readInt( 16 );
			mDemo.readAligned( mChunk, chunk_size );

			mGame->OnPacket( chunk_size );
			mPacket.setBuffer( mChunk, chunk_size );
 			ReadPacket( mPacket );
		} else if ( flag == 1 ) {
			if ( mDemo.readInt( 8 ) ) {
				// player generated a move
				mDemo.readAligned( (char *)&mMove, 32 );
				// display_move( elapsed, move );
			} else {
				// idaction, used for zooming
				float param;
				int action;
				mDemo.readBits( 32, &param );
				action = mDemo.readInt( 32 );
			}
		}

		if ( !mDemo.getOk( ) || mDemo.getIsFull( ) )
			break;
		mNextEventTicks = mDemo.readInt( 32 );
	}

	// Need to make sure mTime has a chance to advance
	if ( !mFullSpeed )
		T1::Sleep( 1 );

	mReplaying = ( mDemo.getOk( ) && ( mNextEventTicks != 0xffffffff ) );
	return ( mReplaying );
}
