#ifndef __T1NETSTREAM_H__
#define __T1NETSTREAM_H__

/*
    - T1 NetStream base class for processing packets
    
	- Open, Start, Poll, and Close must be provided by derived class
      to handle external sources for managing packets & sources
    
	- RemoteEval and Say are stubbed here so T1Game doesn't need
      to know about connections. Stub them out if you don't want to handle
      them in your class
*/

#include "T1Game.h"
#include "T1EventManager.h"
#include "bitStream.h"

class T1Game;
class T1EventManager;

class T1NetStream {
public:
	T1NetStream( T1Game *game );
	virtual ~T1NetStream( ); // make derived destructors chain

	// Pure virtual functions
	virtual void Close( ) = 0;
	virtual bool GetIsDemo( ) = 0;
	virtual void Open( char *source ) = 0;
	virtual bool Poll( ) = 0;
	virtual bool Start( ) = 0;	

	virtual bool GetOk( );
	virtual int GetTicks( );
	virtual void OnConnectionAccepted( BitStream &stream );
	virtual void OnConnectionRejected( const char *reason );
	virtual void OnConnectionDisconnected( const char *reason );
	virtual void OnConnectionTimedOut( );
	virtual void OnReadPacket( BitStream &stream );
	virtual void OnPacketNotify( bool recvd );
	        void ReadPacket( BitStream &packet );
	virtual void RemoteEval( char *function, int argc, ... );
	        void SetDemoName( char *name );
	virtual void SetFullspeed( bool flag ) { }
	virtual void SetTimeScale( float t ) { }
	        bool WritePacket( BitStream &packet );

protected:
	T1EventManager *mEventManager;
	T1Game *mGame;
	char mDemoName[ 255 ];
	int mLastUpdate;
	int mStartTicks;
	bool mOk;

	bool mRateChanged, mMaxRateChanged;
	int mPacketRate, mPacketSize, mMaxPacketRate, mMaxPacketSize;
	int mPacketFrame;
};


#endif // __T1NETSTREAM_H__
