////////////////////////////////////////////////////////////
// File:	ChainZoom.acs.cs
// Version:	1.0
// Author:	Zlex w/ credit to Poop
// Credits:	This is basically just a modification of 
//		Poops ChainZoom script
// Info:	Zoom you in when you are chaining
//		Requires use of AdvancedFire
//
////////////////////////////////////////////////////////////
//ChainZoom.
//Zooms you into 2x when chaining to get that little bit o' accuracy
//Revised back to the original state - no more smooth zooming. Less bugs.

Event::Attach(EventYouFired, CZ::CheckFire);
Event::Attach(EventYouReleased, CZ::Release);

function CZ::OptionAdd() 
	before OptionsGui::onOpen
{
	CGUI::Options:Add("OptionsGui::ChainZoomText","OptionsGui::Game.extras");
	CGUI::Options:Add("OptionsGui::ChainZoom","OptionsGui::Game.extras");
	Control::setValue( $options::ChainZoom, $pref::ChainZoom);
}

function CZ::CheckFire(%wep) {
	if ($pref::ChainZoom != "TRUE")
		return;

	if(!$CZ::DefaultZoom) { $CZ::DefaultZoom = $pref::PlayerFOV; }
	if(%wep == GetItemType("ChainGun") || %wep == GetItemType("Vulcan")) {
		$pref::playerFOV = $pref::playerFOV/1.2;
		$CZ::Zoomed = "TRUE";
		Event::Trigger(EventChainZoomOn);
	}
}

function CZ::Release(%wep) {
	if ($pref::ChainZoom != "TRUE")
		return;

	if($CZ::Zoomed == "TRUE") {
		$CZ::Zoomed = "";
		$pref::playerFOV = $CZ::DefaultZoom;
		Event::Trigger(EventChainZoomOff);
	}
}

