////////////////////////////////////////////////////////////
// File:	Sense.acs.cs
// Version:	1.0
// Author:	Zlex w/ credit to Poop
// Credits:	This is basically just a modification of 
//		Poops Pilot Sense script
// Info:	Sets your mouse sensitivity to high
//		for piloting scouts
//
////////////////////////////////////////////////////////////

function Sense::On() {
	if($Sense::High != "TRUE") { Sense::Toggle(); }
}

function Sense::Off() {
	if($Sense::High == "TRUE") { Sense::Toggle(); }
}

function Sense::SetVals() {
	$Sense::Reset = "";
	$SensePref::Default = Client::getMouseSensitivity("playMap.sae");
}

function Sense::Toggle() {
	if($Sense::Init != "TRUE") {
		$Sense::Init = "TRUE";
		NewActionMap("SenseMap.sae");
		editActionMap("SenseMap.sae");
		bindCommand(keyboard0, MAKE, "space", TO, "Sense::Off();");
		if(isfile($Sense::Reset != "")) { 
			Sense::SetVals();
		}
	}
	if($Sense::High != "TRUE") {
		Sense::SetVals();
		EditActionMap("playMap.sae");
		if(Client::getMouseXaxisFlip("playMap.sae")) { bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Scale, 0.2); }
		else { bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Flip, Scale, 0.02); }

		if(Client::getMouseYaxisFlip("playMap.sae")) { bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Scale, 0.02); }
		else { bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Flip, Scale, 0.02); }
		
		$Sense::High = "TRUE";
		PushActionMap("SenseMap.sae");
		remoteBP(2048, "<JC><F2>Pilot Mode", 2);
	}
	else {
		EditActionMap("playMap.sae");
		if(Client::getMouseXaxisFlip("playMap.sae")) { bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Scale, $SensePref::Default); }
		else { bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Flip, Scale, $SensePref::Default); }

		if(Client::getMouseYaxisFlip("playMap.sae")) { bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Scale, $SensePref::Default); }
		else { bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Flip, Scale, $SensePref::Default); }
		
		$Sense::High = "";
		PopActionMap("SenseMap.sae");
		postAction(2048, IDACTION_MOVEUP, 1);
		Schedule::Add("postAction(2048, IDACTION_MOVEUP, 0.000000);",0.05);
		remoteBP(2048, "<JC><F2>Normal Mode", 2);
	}
}

function Sense::GameBinds::Init()
  after GameBinds::Init
{
	$GameBinds::CurrentMapHandle = GameBinds::GetActionMap2( "playMap.sae");
	$GameBinds::CurrentMap = "playMap.sae";
	GameBinds::addBindCommand( "Pilot Mode", "Sense::Toggle();");
}