////////////////////////////////////////////////////////////
// File:	SmartAmmo.acs.cs
// Version:	1.0 Standalone
// Author:	Zlex w/ credit to Poop
// Credits:	This is basically just a modification of some
//		of Poops Stripped ammo functions
// Info:	Performs some ammo based functions
//		Requires use of AdvancedFire
//
////////////////////////////////////////////////////////////


event::Attach(EventYouFired, SA::Check);
event::Attach(EventNextWeapon, SA::Check);
event::Attach(EventPrevWeapon, SA::Check);
event::Attach(EventUseItem, SA::Check);
event::Attach(EventDropItem, SA::Check);
Event::Attach(eventConnected, "SA::Init();");

$SA::AmmoWarn = 5;
function SA::Check(%wep) {

	if($Item::AmmoName[%wep] != "") {
		%ammo = GetItemCount($Item::AmmoName[%wep]);
		%num = $SA::FireNum++;
		schedule::add("SA::Recheck("@%num@", "@%wep@");", 0.3);
	}
}

function SA::Recheck(%num, %wep) {

	if(%num == $SA::FireNum) {
		%ammo = GetItemCount($Item::AmmoName[%wep]);
		if(%ammo > 1) { %plural = "s"; }
		if(%ammo <= $SA::AmmoWarn && %ammo != 0) {
			remoteBP(2048, "<JC><F2>Warning!!!\n"@$Item::Name[%wep]@"<F1> only has <F2>"@%ammo@"<F1> round"@%plural@" remaining..", 2);
		}
		else if(%ammo == 0) { nextWeapon(); $SA::FireNum++;}
		if($AF::Firing == "TRUE") {
			schedule::add("SA::Recheck("@%num@", "@%wep@");", 0.4);
		}
	}
}


function SA::AddItem(%item, %ammo) {
	if(getItemType(%item) != -1) {
		//echo("Added "@%item);
		%num = getItemType(%item);
		$Item::Num[%item] = %num;
		$Item::Name[%num] = %item;
		if(getItemType(%ammo) != -1) {
			//echo(%ammo@" has been added to parent: "@%item);
			%ammoNum = getItemType(%ammo);
			$Item::AmmoNum[%item] = %ammoNum;
			$Item::AmmoName[%num] = %ammo;
			$Item::Num[%ammo] = %ammoNum;
			$Item::Name[%ammoNum] = %ammo;
		}
		return true;
	}
	return false;
}

function SA::Init() {
	//Clear out current variables
	DeleteVariables("$Item::*");
	
	//Base Items
	SA::AddItem("Light Armor");
	SA::AddItem("Medium Armor");
	SA::AddItem("Heavy Armor");
	SA::AddItem("Scout");
	SA::AddItem("LPC");
	SA::AddItem("HPC");
	SA::AddItem("Blaster");
	SA::AddItem("ChainGun", "Bullet");
	SA::AddItem("Plasma Gun", "Plasma Bolt");
	SA::AddItem("Grenade Launcher", "Grenade Ammo");
	SA::AddItem("Mortar", "Mortar Ammo");
	SA::AddItem("Disc Launcher", "Disc");
	SA::AddItem("Laser Rifle");
	SA::AddItem("Targeting Laser");
	SA::AddItem("Elf Gun");
	SA::AddItem("Repair Gun");
	SA::AddItem("Inventory Station");
	SA::AddItem("Ammo Station");
	SA::AddItem("Energy Pack");
	SA::AddItem("Repair Pack");
	SA::AddItem("Shield Pack");
	SA::AddItem("Ammo Pack");
	SA::AddItem("Sensor Jammer Pack");
	SA::AddItem("Motion Sensor");
	SA::AddItem("Pulse Sensor");
	SA::AddItem("Sensor Jammer");
	SA::AddItem("Camera");
	SA::AddItem("Turret");
	SA::AddItem("Repair Kit");
	SA::AddItem("Mine");
	SA::AddItem("Grenade");
	SA::AddItem("Beacon");

	//Insomniax Mod Items
	SA::AddItem("Firestorm Bomber");
	SA::AddItem("Stealth LPC");
	SA::AddItem("MAG Gun");
	SA::AddItem("Pyro-Torch", "", "Pyro Charge");
	SA::AddItem("IX-2000 Sniper Rifle", "", "Rifle Ammo");
	SA::AddItem("Shotgun", "", "Shotgun Shells");
	SA::AddItem("Phalanxx Cannon", "", "Phalanxx Ammo");
	SA::AddItem("Rocket Launcher", "", "RocketAmmo");
	SA::AddItem("EMP Grenade Launcher", "", "EMPGrenadeAmmo");
	SA::AddItem("Heavy Thruster"); 
	SA::AddItem("Medium Thruster");
	SA::AddItem("Small Force Field");
	SA::AddItem("Sentry");
	SA::AddItem("Avenger");
	SA::AddItem("Flak Cannon");
	SA::AddItem("Cloaking Device");
	SA::AddItem("Vengeance Missile Pack");
	SA::AddItem("Rocket Booster"); 
	SA::AddItem("Heat Sink");
	
	//Renegades Classic Stuff
	SA::AddItem("Scout");
	SA::AddItem("Spy");
	SA::AddItem("Sniper");
	SA::AddItem("Mercenary");
	SA::AddItem("Burster");
	SA::AddItem("Engineer");
	SA::AddItem("Alien");
	SA::AddItem("Cyborg");
	SA::AddItem("Wraith");
	SA::AddItem("Interceptor");
	SA::AddItem("BomberLPC");
	SA::AddItem("StealthHPC");
	SA::AddItem("Hyper Blaster");
	SA::AddItem("Rocket Launcher", "Rockets");
	SA::AddItem("Sniper Rifle", "Sniper Bullet");
	SA::AddItem("Dart Rifle", "Poison Dart");
	SA::AddItem("Magnum", "Magnum Bullets");
	SA::AddItem("Shockwave Cannon");
	SA::AddItem("Railgun", "Railgun Bolt");
	SA::AddItem("Vulcan", "Vulcan Bullet");
	SA::AddItem("Flame Thrower");
	SA::AddItem("Ion Rifle");
	SA::AddItem("Omega Cannon");
	SA::AddItem("Thunderbolt");
	SA::AddItem("Targeting Laser");
	SA::AddItem("Engineer Repair-Gun");
	SA::AddItem("Cloaking Device");
	SA::AddItem("StealthShield Pack");
	SA::AddItem("Regeneration Pack");
	SA::AddItem("Lightning Pack");
	SA::AddItem("Cybernetic Laser");
	SA::AddItem("Auto-Rocket Cannon");
	SA::AddItem("Command Laptop");
	SA::AddItem("Suicide DetPack");
	SA::AddItem("Command Station");
	SA::AddItem("Ion Turret");
	SA::AddItem("Laser Turret");
	SA::AddItem("Shock Turret");
	SA::AddItem("Mortar Turret");
	SA::AddItem("Plasma Turret");
	SA::AddItem("Vulcan Turret");
	SA::AddItem("Rail Turret");
	SA::AddItem("Missile Turret");
	SA::AddItem("Force Field");
	SA::AddItem("Large Force Field");
	SA::AddItem("Blast Wall");
	SA::AddItem("Hologram");
	SA::AddItem("Mechanical Tree");
	SA::AddItem("Springboard");
	SA::AddItem("Deployable Platform");
	SA::AddItem("Teleport Pad");
	SA::AddItem("Interceptor Pack");
	SA::AddItem("StealthHPC Pack");
	SA::AddItem("Repair Kit");
	SA::AddItem("Mine");
	SA::AddItem("Grenade");
	SA::AddItem("Beacon");
}