// 1.40 stuff hud
// built on andrews ctf hud

$CtfHUD::Image[0, home] = "friendly.home.png";
$CtfHUD::Image[0, player] = "friendly.player.png";
$CtfHUD::Image[0, field] = "friendly.empty.png";

$CtfHUD::Image[1, home] = "enemy.home.png";
$CtfHUD::Image[1, player] = "enemy.player.png";
$CtfHUD::Image[1, field] = "enemy.empty.png";

function CtfHUD::Init() {
	
	HUD::New("CtfHUD::Container", 0, 0, 512, 128, CtfHUD::Wake, CtfHUD::Sleep);
	
	newObject("FlagHUD::BG_IMG", FearGuiFormattedText, 0, 2, 512, 128);
	
	newObject("CtfHUD::Image0", FearGuiFormattedText, 25, 30, 40, 20); 
	newObject("CtfHUD::Image1", FearGuiFormattedText, 25, 60, 40, 20);
	
	newObject("CtfHUD::StuffString", FearGuiFormattedText, 25, 90, 50, 20);
	
	newObject("CtfHUD::Status0", FearGuiFormattedText, 55, 30, 50, 20); 
	newObject("CtfHUD::Status1", FearGuiFormattedText, 55, 60, 50, 20);
		
	newObject("Time", FearGuiFormattedText, 220, 30, 80, 20);
	newObject("ClockHUD::Text", FearGuiFormattedText, 220, 60, 80, 20);
	newObject("FPS", FearGuiFormattedText, 220, 90, 80, 20);
	
	newObject("Health", FearGuiFormattedText, 330, 30, 80, 20);
	newObject("Energy", FearGuiFormattedText, 330, 60, 80, 20);
	newObject("Speed", FearGuiFormattedText, 330, 90, 80, 20);

	HUD::Add("CtfHUD::Container", "FlagHUD::BG_IMG");
	
	HUD::Add("CtfHUD::Container", "CtfHUD::Image0");
	HUD::Add("CtfHUD::Container", "CtfHUD::Image1");
	HUD::Add("CtfHUD::Container", "CtfHUD::StuffString");
	
	HUD::Add("CtfHUD::Container", "CtfHUD::Status0");
	HUD::Add("CtfHUD::Container", "CtfHUD::Status1");
	
	HUD::Add("CtfHUD::Container", "FPS");
	HUD::Add("CtfHUD::Container", "Time");
	HUD::Add("CtfHUD::Container", "ClockHUD::Text");
	
	HUD::Add("CtfHUD::Container", "Health");
	HUD::Add("CtfHUD::Container", "Energy");
	HUD::Add("CtfHUD::Container", "Speed");
		
	CtfHUD::Reset();
}

function CtfHUD::Wake() { CtfHUD::Update(); }
function CtfHUD::Sleep() { }

function CtfHUD::Reset() {
	Control::SetValue("FlagHUD::BG_IMG", "<B0,2:Modules/StuffHud/FlagHUD.png>");
	Control::SetValue("CtfHUD::Image0", "<b3,3:Modules/StuffHud/friendly.home.png>");
	Control::SetValue("CtfHUD::Image1", "<b3,4:Modules/StuffHud/enemy.home.png>");
	Control::SetValue("CtfHUD::StuffString", "   <F1>G:<F2>0  <F1>M:<F2>0  <F1>B:<F2>0" );
	CtfHUD::Update();
}

function CtfHUD::Update() {
	//friendly team goes in slot 0
	CtfHUD::SetTeamValue( 0, Team::Friendly() );
	//enemy team goes in slot 1
	CtfHUD::SetTeamValue( 1, Team::Enemy() );
}

function CtfHUD::SetTeamValue( %slot, %team ) {
	%score = Team::Score(%team);
	%loc = Team::Flag::Location(%team);
	
	switch ( %loc ) {
		case "home":
			%loc = "<f3>Home";
			%bmp = $CtfHUD::Image[%slot, "home"];
			break;
		case "field":
			%loc = "<f3>Dropped-><f2>" ~ Team::Flag::Timer(%team);
			%bmp = $CtfHUD::Image[%slot, "field"];
			break;
		default:
			%loc = "<f2>" ~ String::escapeFormatting(Client::GetName(%loc));
			%bmp = $CtfHUD::Image[%slot, "player"];
			break;
	}
	
	Control::SetValue( "CtfHUD::Image"~%slot, "<b3,3:Modules/StuffHud/"~%bmp~">" );
	Control::SetValue( "CtfHUD::Status"~%slot, "<f3>(<f2>"~%score~"<f3>)  "~%loc );

}

// if we change teams, the sides may need to be updated
function CtfHUD::SelfUpdate( %client, %team ) {
	if ( %client == getManagerId() )
		CtfHUD::Update();
}

// stuff

function StuffHud::Wake( ) {
	Schedule::Add("StuffHud::Update();", 3);
}

function StuffHud::Update() {
	if( ( %kit = getItemCount('Repair Kit' ) ) == true ) 
		%kit = "<b3,3:Modules/StuffHud/kitdot.png>";
	else
		%kit = "";
		
	Control::SetValue("CtfHUD::StuffString", 
	"   <F1>G: <F2>" 	 ~ GetItemCount(Grenade) ~ 
	"   <F1>M: <F2>" ~ GetItemCount(Mine) ~ 
	"   <F1>B: <F2>" ~ getItemCount(Beacon) ~ 
	"   " ~ %kit );
	
	Control::SetValue("Health", "<F1>Health: <F2>  " ~ $health);
	Control::SetValue("Energy", "<F1>Energy: <F2> " ~ $energy);
	Control::SetValue("Speed", "<F1>Speed:<F2>   " ~ $speed);
	Schedule::Add("StuffHud::Update();", 0.5);
}

// time
function timestamp::time() {
	timestamp::array();
	%time = timestamp::zeropad( $time["hr"] ) @ ":" @ timestamp::zeropad( $time["mn"] ) @ ":" @ timestamp::zeropad( $time["sc"] );
	return ( %time );
}

function Time::Wake() {
	Time::Update();
}

function Time::Sleep() {
	Schedule::Cancel("Time::Update();");
}

function Time::Update() {
	%time=timestamp::time();
	Control::SetValue( "Time", "<F2>" @ %time );
	%fps ="<f2>" @ floor($ConsoleWorld::FrameRate) @ "<f1> FPS";
	Control::SetValue("FPS", %fps);
	Schedule::Add("Time::Update();", 1);
}

// mission clock
function ClockHUD::Reset() {
	$ClockHud::Hour = 0;
	$ClockHud::Min = 0;
	$clockHud::Sec = 0;
	$ClockHud::CountingDown = false;
	Schedule::Add("ClockHUD::Iterate();", 1);
}

function ClockHUD::Update() {
	Control::setValue("ClockHUD::Text", "<f2>" @ ( ( $ClockHud::Min < 10 ) ? "0" @ $ClockHud::Min : $ClockHud::Min ) @ ":" @ ( ( $clockHud::Sec < 10 ) ? "0" @ $clockHud::Sec : $clockHud::Sec ) );
}

function ClockHud::UpdateTime(%min, %sec) {
	$ClockHud::Hour = floor(%min / 60);
	$ClockHud::Min = %min % 60;
	$clockHud::Sec = %sec;
	$ClockHud::CountingDown = true;
	Schedule::Add("ClockHUD::Iterate();", 1);
}

function ClockHud::SetReverse() {
	$ClockHud::Hour = $ClockHud::Min = $clockHud::Sec = 0;
	$ClockHud::CountingDown = false;
	
	Schedule::Add("ClockHUD::Iterate();", 1);
	ClockHUD::Update();
}

function ClockHud::Iterate() {
	if ($ClockHud::CountingDown)
	{
		if ($ClockHud::Sec > 0)
			$ClockHud::Sec--;
		else
		{
			$ClockHud::Sec = 59;
		
			if ($ClockHud::Min > 0)
				$ClockHud::Min--;
			else
			{
				$ClockHud::Min = 59;
				$ClockHud::Hour--;
			}
		}
	}
	else
	{
		if ($ClockHud::Sec < 59)
			$ClockHud::Sec++;
		else
		{
			$ClockHud::Sec = 0;
		
			if ($ClockHud::Min < 59)
				$ClockHud::Min++;
			else
			{
				$ClockHud::Min = 0;
				$ClockHud::Hour++;
			}
		}
	}
	ClockHUD::Update();
	Schedule::Add("ClockHUD::Iterate();", 1);
}

Event::Attach( EventFlagUpdate, CtfHUD::Update );
Event::Attach( EventFlagTimerUpdate, CtfHUD::Update );
Event::Attach( EventClientChangeTeam, CtfHUD::SelfUpdate );
Event::Attach(eventGuiOpen, Time::Wake);
Event::Attach(eventConnected, ClockHUD::Reset);
Event::Attach(eventUpdateTime, ClockHud::UpdateTime);
Event::Attach(eventMatchStarted, ClockHud::SetReverse);
Event::Attach(eventGuiOpen, StuffHud::Wake);

CtfHUD::Init();