// ----------------------------------------------------------------------------
// MySQL Clone Database
// ----------------------------------------------------------------------------
// Based on code by KingTomato
// Modified by Lemon

exec(MySQL_Functions);

//connection properties
$MySQL::Connection[Clones]      				= ""; 	// connection/table name
$MySQL::Host[Clones] 							= ""; 	// host address
$MySQL::User[Clones] 							= "";	// user name
$MySQL::Pass[Clones] 							= "";	// user pass
$MySQL::Database[Clones] 						= "";	// database name
$MySQL::Connected[$MySQL::Connection[Clones]]   = false;// Tells us we're connected
$MySQL::Debug[Clones]							= false;// debug?
$MySQL::Clones									= true;

$Clones::Head				= "<jc><f2>Clone Scanner v.2.0 MySQL\n";
$Clones::Head[Err]			= $Clones::Head @ "<f0>Error:<f1> %1";
$Clones::Head[Found]		= $Clones::Head @ "<f0>Client:<f1> %1 <f0>- IP:<f1> %2\n\n<f0>Clones:<f1> %3";
$Clones::Head[First]    	= $Clones::Head @ "<jc>Client:<f1> %1 <f0>- IP:<f1> %2\n\n<f0>Clones:<f1> [none]";

// max # of clones to display
$Clones::MaxClones = 5;

Event::Attach(Server_onClientConnect, Clones::OnConnect);

function Clones::OnConnect(%clientId)
{
	Connection::Logging(%clientId, 0);
	
	Database::Connect("Clones");
	
	%name   = Client::GetName(%clientId);
	%ip     = Client::getTransportAddress(%clientId);
	
	// chop .1 off name if present
	for (%len = 0; String::getSubStr(%name, %len, 1) != ""; %len++){}
	if (String::FindSubStr(%name, ".1") == (%len - 2))
		%name = String::getSubStr(0, %len - 2);
		
	if ($MySQL::Connected[$MySQL::Connection[Clones]])
	{
		%clone_count = Clones::FindIP(%ip);
		
		Clones::Add(%name,%ip);
		
		if (%clone_count)
		{
			%clientId.clones=Clones::GetIP(%ip, %clientId);
			Clones::AdminBP(sprintf($Clones::Head[Found],%name,%ip,%clientId.clones),12,%clientId.clones);
			if($MySQL::Debug[Clones])
				echo("Clones found : "@%clientId.clones);
		}
		else
		{
			Clones::AdminBP(sprintf($Clones::Head[First],%name,%ip),12,"");
			if($MySQL::Debug[Clones])
				echo("Clones not found");
		}
	}
}

function Clones::onDisconnect(%clientId)
{
	Connection::Logging(%clientId, 1);
}

// ----------------------------------------------------------------------------
// Database Queries
// ----------------------------------------------------------------------------

function Clones::FindIP(%ip,%name)
{
	if($MySQL::Debug[Clones])
	echo(sprintf("Clones::FindIP(%1,%2);",%ip,%name));
	%wildcard = false;
	
	// is it "IP:x.x.x.x:x", "x.x.x.x:x" or "x.x.x.x" format?
	%ip = MySQL::ParseIP(%ip);
	
	// Replace unwanted characters, and detect wildcard.
	%_ip = "";
	for (%a = 0; (%ch = String::getSubStr(%ip,%a,1)) != ""; %a++)
	{
		if (String::findSubStr("0123456789*.%",%ch) == -1)
			continue;
		else if (%ch == "*" || %ch == "%")
		{
			%wildcard = true;
			%ch = "%";
		}
		%_ip = %_ip @ %ch;
	}
	%ip = %_ip;
	
	// Build Query
	if (%wildcard)
		%query = sprintf("clone_ip LIKE '%1'",%ip);
	else
		%query = sprintf("clone_ip='%1'",%ip);
	if (%name != "")
		%query = sprintf("%1 AND clone_name='%2'",%query,MySQL::Escape($MySQL::Connection[Clones],%name));
	
	return Clones::Find(%query,0);
}

function Clones::FindName(%name,%wildcard)
{
	if($MySQL::Debug[Clones])
	echo(sprintf("Clones::FindName(%1,%2);",%name,%wildcard));
	
	%name = String::getSubStr(%name,0,16); // max length (as spec. by tribes)
	
	// Build Query
	if (%wildcard)
		%query = sprintf("clone_name LIKE '%1'",MySQL::Escape($MySQL::Connection[Clones],%name));
		
	else
		%query = sprintf("clone_name='%1'",MySQL::Escape($MySQL::Connection[Clones],%name));
		
	
	return Clones::Find(%query, 0);
}

// Inside function, try not to call it unless you know what you're doing.
function Clones::Find(%query, %tries)
{
	if($MySQL::Debug[Clones])
	echo(sprintf("Clones::Find(%1, %2);",%query, %tries));
	
	%c = $MySQL::Connection[Clones];
	%query_=%query; // copy the query in case we need to retry
	%select = "*,FROM_UNIXTIME(last_date,'%d/%m/%Y %H:%i:%s') as last_fdate"; // change date format here (mysql.com,FROM_UNIXTIME)
	%query = sprintf("SELECT %1 FROM clone_log WHERE %2 ORDER BY last_date",%select,%query);
	
	deleteVariables("$Clones::Count*");
	deleteVariables("$Clones::List*");
	
	// Now, look in the database
	if (MySQL::Query(%c,%query))
	{
		$Clones::Count = MySQL::Rows(%c);
		for (%a = 0; %a < $Clones::Count; %a++)
		{
			MySQL::FetchRow(%c);
			$Clones::List[%a,Name]   = MySQL::Fetch(%c,"clone_name");
			$Clones::List[%a,IP]     = MySQL::Fetch(%c,"clone_ip");
			$Clones::List[%a,Server] = MySQL::Fetch(%c,"last_server");
			$Clones::List[%a,UTime]  = MySQL::Fetch(%c,"last_date");
			$Clones::List[%a,Time]   = MySQL::Fetch(%c,"last_fdate");
		}
	}
	else
	{
		// lets give it a few tries
		%tries++;
		if (%tries<=4)
			Clones::Find(%query_, %tries);
		else
		{
			// lets log the failed query
			echo("Clones Query: " @ $MySQL::Error);
			$Query::Error=format($MySQL::Error, 40)@" - "@timestamp();
			$Query::Export=%query;
			export("$Query::*","config\\data.log",true);
			return 0;
		}
	}
	if($MySQL::Debug[Clones])
	export("$Clones::*","config\\c.cs",false); //debug
	return $Clones::Count;
}

function Clones::GetIP(%ip, %clientId)
{
	if($MySQL::Debug[Clones])
	echo(sprintf("Clones::GetIP(%1, %2);", %ip, %clientId));
	%matches = Clones::FindIP(%ip);
	%names = "";
	
	for (%n = 0; %n < %matches; %n++)
	{
		if (%n > 0)
			%names = %names @ " ~ ";
		
		%names = %names @ $Clones::List[%n,Name];
	}
	if($MySQL::Debug[Clones])
		echo(%names);
	
	return %names;
}

function Clones::GetName(%name)
{
	%matches = Clones::FindName(%name);
	
	if (%matches > $Clones::MaxClones)
		%matches = $Clones::MaxClones; // Only max of N results
		
	%ips = "";
	
	for (%n = 0; %n < %matches; %n++)
	{
		if (%n > 0)
			%ips = %ips @ " ~ ";
		%ips = %ips @ $Clones::List[%n,IP];
	}
	return %ips;
}

// ----------------------------------------------------------------------------
// Add/Update Database
// ----------------------------------------------------------------------------

function Clones::Add(%name,%ip)
{
	%c = $MySQL::Connection[Clones];
	
	%name = String::getSubStr(%name,0,16); // max length (as spec. by tribes)
	%ip = MySQL::ParseIP(%ip);
	
	// Look for previous entry
	if (Clones::FindIP(%ip,%name))
	{
		return Clones::Update(%ip,%name);
	}
	else
	{
		%add = sprintf("INSERT INTO clone_log (clone_id,clone_name,clone_ip,last_date,last_server,last_fdate) "
		@  "VALUES (NULL,'%1','%2',UNIX_TIMESTAMP(),'%3',NOW())",MySQL::Escape(%c,%name),MySQL::Escape(%c,%ip),MySQL::Escape(%c,$Server::HostName));
		echo("SQL: " @ %add);
		if (MySQL::Query(%c,%add))
		{
			return true;
		}
		else
		{
			// lets log the failed query to make updating the db easy
			echo("Clones Add: " @ $MySQL::Error);
			$Query::Error=format($MySQL::Error, 40)@" "@timestamp();
			$Query::Export = %add;
			$Query::Extra = "-----------------------------";
			export("$Query::*","config\\data.log",true);
			return false;
		}
	}
}

function Clones::Update(%ip,%name)
{
	%c = $MySQL::Connection[Clones];
	
	%name = String::getSubStr(%name,0,16); // max length (as spec. by tribes)
	%ip = MySQL::ParseIP(%ip);
	
	// Look for previous entry
	if (Clones::FindIP(%ip,%name))
	{
		%add = sprintf("UPDATE clone_log "
		@  "SET last_date=UNIX_TIMESTAMP(),last_fdate=FROM_UNIXTIME(UNIX_TIMESTAMP()),last_server='%1' "
		@  "WHERE clone_name='%2' AND clone_ip='%3'",MySQL::Escape(%c,$Server::HostName),MySQL::Escape(%c,%name),MySQL::Escape(%c,%ip));
		
		if (MySQL::Query(%c,%add))
		{
			return true;
		}
		else
		{
			// lets log the failed query to make updating the db easy
			echo("Clones Update: " @ $MySQL::Error);
			$Query::Error=format($MySQL::Error, 40)@" "@timestamp();
			$Query::Export=%add;
			export("$Query::*","config\\data.log",true);
			return false;
		}
	}
}

// ----------------------------------------------------------------------------
// Excess Functionality
// ----------------------------------------------------------------------------

function Clones::AdminBP(%msg,%time,%gmsg)
{
	for (%cl = Client::getFirst(); %cl != -1; %cl = Client::GetNext(%cl))
	{
		if (%cl.CanSeePlayerSpecs || %cl.isSuperAdmin)
		{
			bottomPrint(%cl, %msg, 12);

			// If in observer, show obs message again
			if (%cl.observerTarget != "")
			{
				Observer::showStats(%cl,%cl.observerTarget,%cl.observerId++);
			}

			if (%gmsg != "")
				Client::sendMessage(%cl, 1, "Clones: "@%gmsg);
		}
	}
}

function Connection::Logging(%client, %type) 
{
	%name    = Client::GetName(%client);
	
	%ip      = MySQL::ParseIP(Client::GetTransportAddress(%client));
	
	if (%type==0)
		$ClientCJoin =  "JOIN : "@format(%name, 20) @ " : " @ format(%ip, 20) @ " : " @ timestamp();
		
	else
		$ClientCDrop =  "DROP : "@format(%name, 20) @ " : " @ format(%ip, 20) @ " : " @ timestamp();
		
	export("$ClientC*", "config\\join_drop.txt", true);
}
