// ----------------------------------------------------------------------------
// MySQL Database Helper Functions
// ----------------------------------------------------------------------------
// Based on code by KingTomato
// Modified by Lemon

function MySQL::ParseIP(%ip)
{
	if (String::getSubStr(%ip,0,8) == "LOOPBACK")
		return "127.0.0.1";
	
	if (String::getSubStr(%ip,0,3) == "IP:")
	{
		%ip = String::getSubStr(%ip,3,16);
		%ip = String::getSubStr(%ip,0,String::findSubStr(%ip,":"));
	}
	
	else if ((%col = String::findSubStr(%ip,":")) != -1)
		%ip = String::getSubStr(%ip,0,%col);
	
	return String::GetSubStr(%ip,0,15);
}

function Database::Connect(%name)
{
	if ($MySQL::Connected[$MySQL::Connection[%name]])
		return;
	
	if (MySQL::Create($MySQL::Connection[%name]))
	{
		if (MySQL::Connect($MySQL::Connection[%name],$MySQL::Host[%name],$MySQL::User[%name],$MySQL::Pass[%name],$MySQL::Database[%name]))
		{
			echo(%name@": Connection established.");
			return ($MySQL::Connected[$MySQL::Connection[%name]] = true);
		}
		
		else
		{
			echo(%name @ ": Could not login to database. " @ $MySQL::Error);
			$Query::Error=format(%name @ ": " @ $MySQL::Error, 40) @ " " @ timestamp();
			$Query::Extra = "-----------------------------";
			export("$Query::*","config\\data.log",true);
			return false;
		}
	}
	
	else
	{
		echo(%name @ ": Could not create a session." @ $MySQL::Error);
		$Query::Error=format(%name @ ": " @ $MySQL::Error, 40) @ " " @ timestamp();
		$Query::Extra = "-----------------------------";
		export("$Query::*","config\\data.log",true);
		return false;
	}
}

function Database::Disconnect(%name)
{
	if (!$MySQL::Connected[$MySQL::Connection[%name]])
		return;
	
	return ($MySQL::Connected[$MySQL::Connection[%name]] = !MySQL::Destroy($MySQL::Connection[%name]));
}

// in case it's not a zadmin server lets add the format() functions for logging 

function format(%text, %size)
{
	%formattedText = String::getSubStr(%text, 0, %size); //truncate if needed 
	%textLen = getLength(%formattedText);       

	if(%textLen < %size)	//append if needed
		for (%spaces = %textLen; %spaces < %size; %spaces++)
		%formattedText = %formattedText @ " ";
		
	return %formattedText;
}

function getLength(%text)
{
	while (String::getSubStr(%text, %length, 1) != "") 
		%length++;
		
	return %length;
}

