//mouse activated/deactivated
function onMouseActive( %active )
{
	Event::Trigger( eventMouseActive, %active );
}

//mouse move event
function onMouseMove(%x, %y, %dx, %dy)
{
	$mouse[x] = ( %x ); 
	$mouse[y] = ( %y );
	$mouse[dx] = ( %dx ); 
	$mouse[dy] = ( %dy );
	Event::Trigger( eventMouseMove, %x, %y, %dx, %dy );
}

//mousewheel
function onMouseWheel( %up ) { 
	if( %up )
		Event::Trigger( eventMouseWheelUp );
	else
		Event::Trigger( eventMouseWheelDown );
}

//mouse button, currently messing up with the keyboard keys 1-6 or so (both mouse and keyboard trigger those)
function onMouseButton( %button, %is_down, %x, %y )
{
	$Mouse[%button] = %is_down;
	if(%is_down)
	{
		$Mouse[%button, down, x] = %x;
		$Mouse[%button, down, y] = %y;
	} else 
	{
		//release claimed mouse
		Mouse::Release();
		
		//save release info
		$Mouse[%button, up, x] = %x;
		$Mouse[%button, up, y] = %y;
	}
	
	if( %is_down )
		Event::Trigger( eventMouseButtonDown, %button, %x, %y );
	else
		Event::Trigger( eventMouseButtonUp, %button, %x, %y );
}
//is the mouse inside a certain area?
//mx and my is the absolute mouse position ($mouse[x] & $mouse[y])
//x,y is the left lower pos of the retangle to check
//use glgetTranslation() to find %x or %y in complex huds.
//width and height define the size, upwards and to the right of x and y
function Mouse::isInside(%mx, %my, %x, %y, %width, %height)
{
	if(%mx > %x && %mx < %x + %width)
		if(%my > %y && %my < %y + %height)
		{
			return true;
		}
	return false;
}


/*
deprecated, listen to 
onMouseButton( 0, %is_down )
*/
function onMouseRMB( %is_down ) {
}

/*
deprecated, listen to 
onMouseButton( 1, %is_down )
*/
function onMouseLMB( %is_down ) { 
}

//claims the mouse until left MB is released
function Mouse::Claim(%hud)
{
	if(%hud == "")
		return false;
		
	$Mouse[claimed, status] = true;
	$Mouse[claimed, hud] = %hud;
	
	//disable drag and drop behavior
	disableDD();
}

function Mouse::IsClaimed(%hud)
{
	if(%hud == "")
		return $Mouse[claimed, status];
		
	if($Mouse[claimed, hud] == %hud)
		return false;
	else
		return $Mouse[claimed, status];
}

function Mouse::Release()
{
	$Mouse[claimed, status] = false;
	$Mouse[claimed, hud] = "";
	
	//enable default drag and drop behavior
	enableDD();
}