function vhud::ClockHud::create()
{
	if ( $ClockHud::Loaded )
		return;
		
	$ClockHud::Loaded = true;
	
	vhud::create( "ScriptGL::vClockHud", "0% 0%", "0% 0%", vhud::ClockHud::render );
	HUD::New("ScriptGL::vClockHud", 295, 0, 70, 25);
}

function vhud::ClockHud::render()
{
	if(!Control::getVisible("ScriptGL::vClockHud"))
		return;
		
	%pos = Control::getposition("ScriptGL::vClockHud");
	%x = getWord(%pos,0);
	%y = getWord(%pos,1);
	%size = Control::getExtent("ScriptGL::vClockHud");
	%dx = getWord(%size,0);
	%dy = getWord(%size,1);
	

	glDisable($GL_TEXTURE_2D);
	glDisable($GL_SCISSOR_TEST);
	glEnable($GL_ALPHA_TEST);
	glBlendFunc($GL_SRC_ALPHA,$GL_ONE_MINUS_SRC_ALPHA);	
	glAlphaFunc($GL_GREATER,$GL_ZERO);
	glColor4ub( 0, 0, 0, 187 );
	
	glBegin($GL_QUADS);
		glVertex2f(%x,%y);
		glVertex2f(%x + %dx, %y);
		glVertex2f(%x + %dx, %y + %dy);
		glVertex2f(%x, %y + %dy);
	glEnd();
	
	glColor4ub( 255,  255,  255,  255 );
	glSetFont( "verdana", 7, 0, 9 );
	
	%mins = $vClockHud[min];
	%secs = $vClockHud[sec];
	%then = $vClockHud[when];
	%now = getSimtime();
	%dt = %now - %then;
	
	while(%dt > 60)
	{
		%mins--;
		%dt -= 60;
	}
	
	%secs = (%secs - %dt);
	
	if(%secs < 0)
	{
		%mins--;
		%secs  += 60;
	}
	if(%mins < 0)
	{
		%text = "00:00.0";
		glDrawString(%x + 5, %y + 8, %text);
		return;
	}
	
	if(%mins < 10)
		%mins = "0" ~ %mins;
		
	if(%secs < 10)
		%secs = "0" ~ %secs;
		
	%secs = string::getsubstr(%secs, 0, 4); //xx.x
		
	%text = %mins ~ ":" ~ %secs;

	glDrawString(%x + 5, %y + 8, %text);
	
}

function vClockHud::OnSetTime(%minutes, %seconds)
{
	$vClockHud[min] = %minutes;
	$vClockHud[sec] = %seconds+1;
	$vClockHud[when] = getsimtime();
}

vhud::ClockHud::create();
Event::Attach(eventUpdateTime, vClockHud::OnSetTime);