function vhud::Energy::create()
{
	if ( $vhud::hEnergy::Loaded )
		return;
		
	$vhud::Energy::Loaded = true;
	
	vhud::create( "ScriptGL::Energy", "0% 0%", "0% 0%", vhud::Energy::onrender );
	HUD::New("ScriptGL::Energy", 165, 0, 130, 25);
}

function vhud::Energy::onrender()
{
	if($Scriptgl::CurrentGui != "playGui")
		return;
	
	if(!Control::getVisible("ScriptGL::Energy"))
		return;

	%position = Control::GetPosition("ScriptGL::Energy");
	%position[x] = getWord(%position,0);
	%position[y] = getWord(%position,1);
	
	%size = Control::GetExtent("ScriptGL::Energy");
	%size[x] = getWord(%size,0);
	%size[y] = getWord(%size,1);
	
	glEnable($GL_BLEND);
	glDisable($GL_TEXTURE_2D);
	glEnable($GL_ALPHA_TEST);
	glDisable($GL_SCISSOR_TEST);
	
	glLoadIdentity();
	
	glTranslatef(%position[x],%position[y],0);
	
	//health frame
	glColor4ub(0,0,0,187);
	glBegin($GL_QUADS);
		glVertex2f(0,0);		
		glVertex2f(%size[x],0);		
		glVertex2f(%size[x],%size[y]);		
		glVertex2f(0,%size[y]);
	glEnd();
	
	
	//health
	glEnable($GL_TEXTURE_2D);
	glEnable($GL_SCISSOR_TEST);
	glBindTexture($GL_TEXTURE_2D, "energyhud.png");
	glScissor(getword(glgetTranslation(),0), getword(glgetTranslation(),1), $energy*130/100, %size[y]);

	glColor3f(1.0,1.0,1.0,1.0);
	glBegin($GL_QUADS);
		glTexCoord2f(0.0,0.0);
		glVertex2f(0,0);
		glTexCoord2f(1.0,0.0);
		glVertex2f(%size[x],0);
		glTexCoord2f(1.0,1.0);
		glVertex2f(%size[x],%size[y]);
		glTexCoord2f(0.0, 1.0);
		glVertex2f(0,%size[y]);
	glEnd();

	glDisable($GL_SCISSOR_TEST);
}
vhud::Energy::create();