function vhud::RepKitHud::create()
{
	if ( $vRepKitHud::Loaded )
		return;
		
	$vRepKitHud::Loaded = true;

	vhud::create( "ScriptGL::vRepKitHud", "0% 0%", "0% 0%", vhud::RepKitHud::render );
	HUD::New("ScriptGL::vRepKitHud", 0, 0, 35, 25);
}

function vhud::RepKitHud::render()
{
	if($Scriptgl::CurrentGui != "playGui")
		return;
		
	if(!Control::getVisible("ScriptGL::vRepKitHud"))
		return;
		
	glLoadIdentity();
	
	%position = Control::GetPosition("ScriptGL::vRepKitHud");
	%position[x] = getWord(%position,0);
	%position[y] = getWord(%position,1);
	%size = Control::GetExtent("ScriptGL::vRepKitHud");
	%size[x] = getWord(%size,0);
	%size[y] = getWord(%size,1);
	
	glDisable($GL_TEXTURE_2D);
	glDisable($GL_SCISSOR_TEST);
	glEnable($GL_ALPHA_TEST);
	glBlendFunc($GL_SRC_ALPHA,$GL_ONE_MINUS_SRC_ALPHA);	
	glAlphaFunc($GL_GREATER,$GL_ZERO);
	glColor4ub( 0, 0, 0, 187 );
	
	glBegin($GL_QUADS);
		glVertex2f(%position[x] , %position[y]);
		glVertex2f(%position[x] + %size[x], %position[y]);
		glVertex2f(%position[x] + %size[x], %position[y] + %size[y]);
		glVertex2f(%position[x] , %position[y] + %size[y]);
	glEnd();
	
	if(!getItemCount("Repair Kit"))
		return;
	
	glEnable($GL_BLEND);
	glDisable($GL_SCISSOR_TEST);
	glBlendFunc($GL_SRC_ALPHA,$GL_ONE_MINUS_SRC_ALPHA);	
	glAlphaFunc($GL_GREATER,$GL_ZERO);
	glEnable($GL_TEXTURE_2D);
	glColor4ub(255,255,255,255);
	
	glDrawTexture("rkit.png", $GLEX_SCALED, %position[x] + 8, %position[y] + 3, 0.35, 0.35);
	

	
}

vhud::RepKitHud::create();