function vhud::TeamSize::create()
{
	if ( $vTeamSize::Loaded )
		return;
		
	$vTeamSize::Loaded = true;

	vhud::create( "ScriptGL::vTeamSize", "0% 0%", "0% 0%", vhud::TeamSize::render );
	HUD::New("ScriptGL::vTeamSize", 365, 0, 150, 25);
}

function vhud::TeamSize::render()
{
	if($Scriptgl::CurrentGui != "playGui")
		return;
		
	if(!Control::getVisible("ScriptGL::vTeamSize"))
		return;
		
	%pos = Control::getposition("ScriptGL::vTeamSize");
	%position[x] = getWord(%pos,0);
	%position[y] = getWord(%pos,1);
	%size = Control::getExtent("ScriptGL::vTeamSize");
	%size[x] = getWord(%size,0);
	%size[y] = getWord(%size,1);
	
	
	glDisable($GL_TEXTURE_2D);
	glDisable($GL_SCISSOR_TEST);
	glEnable($GL_ALPHA_TEST);
	glBlendFunc($GL_SRC_ALPHA,$GL_ONE_MINUS_SRC_ALPHA);	
	glAlphaFunc($GL_GREATER,$GL_ZERO);
	glColor4ub( 0, 0, 0, 187 );
	
	glLoadIdentity();
	
	glBegin($GL_QUADS);
		glVertex2f(%position[x] , %position[y]);
		glVertex2f(%position[x] + %size[x], %position[y]);
		glVertex2f(%position[x] + %size[x], %position[y] + %size[y]);
		glVertex2f(%position[x] , %position[y] + %size[y]);
	glEnd();
	
	glEnable($GL_BLEND);
	glDisable($GL_SCISSOR_TEST);
	glBlendFunc($GL_SRC_ALPHA,$GL_ONE_MINUS_SRC_ALPHA);	
	glAlphaFunc($GL_GREATER, $GL_ZERO);
	glEnable($GL_TEXTURE_2D);
	glColor4ub(255,255,255,255);
	
	%even = true;
	if(Team::Size(Team::Friendly()) != Team::Size(Team::Enemy()))
		%even = false;
		
	//if(!%even)
		//glColor4ub(200,0,0,255);
	
	glDrawTexture("ts_green.png", $GLEX_SCALED, %position[x] , %position[y] + 2, 0.35, 0.35);
	glDrawTexture("ts_red.png", $GLEX_SCALED, %position[x] + 50 , %position[y] + 2 , 0.35, 0.35);
	
	glDrawTexture("ts_white.png", $GLEX_SCALED, %position[x] + 100, %position[y] + 2, 0.35, 0.35);
	
	glSetFont( "verdana", 7, 0, 9 );
	glColor4ub( 255,  255,  255,  255 );
	glDrawString(%position[x] + 30,%position[y] + 8, Team::Size(Team::Friendly()));
	glDrawString(%position[x] + 80,  %position[y] + 8, Team::Size(Team::Enemy()));
	glDrawString(%position[x] + 130, %position[y] + 8, Team::Size(-1));

}


vhud::TeamSize::create();